/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.stats;

import java.lang.invoke.MethodHandles;
import java.util.List;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.handler.component.ShardResponse;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.stats.LocalStatsSource;
import org.apache.solr.search.stats.StatsCache;
import org.apache.solr.search.stats.StatsSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalStatsCache
extends StatsCache {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    protected StatsSource doGet(SolrQueryRequest req) {
        log.debug("## GET {}", (Object)req);
        return new LocalStatsSource(this.statsCacheMetrics);
    }

    @Override
    protected ShardRequest doRetrieveStatsRequest(ResponseBuilder rb) {
        log.debug("## RSR {}", (Object)rb.req);
        this.statsCacheMetrics.retrieveStats.decrement();
        return null;
    }

    @Override
    protected void doMergeToGlobalStats(SolrQueryRequest req, List<ShardResponse> responses) {
        if (log.isDebugEnabled()) {
            log.debug("## MTGS {}", (Object)req);
            for (ShardResponse r : responses) {
                log.debug(" - {}", (Object)r);
            }
        }
    }

    @Override
    protected void doReturnLocalStats(ResponseBuilder rb, SolrIndexSearcher searcher) {
        log.debug("## RLS {}", (Object)rb.req);
    }

    @Override
    protected void doReceiveGlobalStats(SolrQueryRequest req) {
        log.debug("## RGS {}", (Object)req);
    }

    @Override
    protected void doSendGlobalStats(ResponseBuilder rb, ShardRequest outgoing) {
        log.debug("## SGS {}", (Object)outgoing);
    }
}

