/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess.impl.office;

import com.healthmarketscience.jackcess.impl.ByteUtil;
import com.healthmarketscience.jackcess.impl.PageChannel;
import com.healthmarketscience.jackcess.impl.office.StreamCipherProvider;
import com.healthmarketscience.jackcess.util.StreamCipherCompat;
import com.healthmarketscience.jackcess.util.StreamCipherFactory;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.params.KeyParameter;

public class OfficeBinaryDocRC4Provider
extends StreamCipherProvider {
    private final byte[] _encVerifier = new byte[16];
    private final byte[] _encVerifierHash = new byte[16];
    private final byte[] _baseHash;

    public OfficeBinaryDocRC4Provider(PageChannel channel, byte[] encodingKey, ByteBuffer encProvBuf, byte[] pwdBytes) {
        super(channel, encodingKey);
        byte[] salt = new byte[16];
        encProvBuf.get(salt);
        encProvBuf.get(this._encVerifier);
        encProvBuf.get(this._encVerifierHash);
        byte[] fillHash = ByteUtil.concat((byte[])OfficeBinaryDocRC4Provider.hash(this.getDigest(), pwdBytes, 5), (byte[])salt);
        byte[] intBuf = new byte[336];
        for (int i = 0; i < intBuf.length; i += fillHash.length) {
            System.arraycopy(fillHash, 0, intBuf, i, fillHash.length);
        }
        this._baseHash = OfficeBinaryDocRC4Provider.hash(this.getDigest(), intBuf, 5);
    }

    public boolean canEncodePartialPage() {
        return true;
    }

    @Override
    protected Digest initDigest() {
        return new MD5Digest();
    }

    @Override
    protected StreamCipherCompat initCipher() {
        return StreamCipherFactory.newRC4Engine();
    }

    protected KeyParameter computeCipherParams(int pageNumber) {
        return this.computeEncryptionKey(this.getEncodingKey(pageNumber));
    }

    private KeyParameter computeEncryptionKey(byte[] blockBytes) {
        byte[] encKey = OfficeBinaryDocRC4Provider.hash(this.getDigest(), this._baseHash, blockBytes, OfficeBinaryDocRC4Provider.bits2bytes(128));
        return new KeyParameter(encKey);
    }

    @Override
    protected boolean verifyPassword(byte[] pwdBytes) {
        StreamCipherCompat cipher = OfficeBinaryDocRC4Provider.decryptInit(this.getStreamCipher(), (CipherParameters)this.computeEncryptionKey(this.int2bytes(0)));
        byte[] verifier = OfficeBinaryDocRC4Provider.decryptBytes(cipher, this._encVerifier);
        byte[] verifierHash = OfficeBinaryDocRC4Provider.decryptBytes(cipher, this._encVerifierHash);
        byte[] testHash = OfficeBinaryDocRC4Provider.hash(this.getDigest(), verifier);
        return Arrays.equals(verifierHash, testHash);
    }
}

