/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.bullet;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct b3CameraImageData")
public class B3CameraImageData
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int M_PIXELWIDTH;
    public static final int M_PIXELHEIGHT;
    public static final int M_RGBCOLORDATA;
    public static final int M_DEPTHVALUES;
    public static final int M_SEGMENTATIONMASKVALUES;

    public B3CameraImageData(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), B3CameraImageData.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public int m_pixelWidth() {
        return B3CameraImageData.nm_pixelWidth(this.address());
    }

    public int m_pixelHeight() {
        return B3CameraImageData.nm_pixelHeight(this.address());
    }

    @NativeType(value="unsigned char const *")
    public ByteBuffer m_rgbColorData(int capacity) {
        return B3CameraImageData.nm_rgbColorData(this.address(), capacity);
    }

    @NativeType(value="float const *")
    public FloatBuffer m_depthValues(int capacity) {
        return B3CameraImageData.nm_depthValues(this.address(), capacity);
    }

    @NativeType(value="int const *")
    public IntBuffer m_segmentationMaskValues(int capacity) {
        return B3CameraImageData.nm_segmentationMaskValues(this.address(), capacity);
    }

    public B3CameraImageData m_pixelWidth(int value) {
        B3CameraImageData.nm_pixelWidth(this.address(), value);
        return this;
    }

    public B3CameraImageData m_pixelHeight(int value) {
        B3CameraImageData.nm_pixelHeight(this.address(), value);
        return this;
    }

    public B3CameraImageData m_rgbColorData(@NativeType(value="unsigned char const *") ByteBuffer value) {
        B3CameraImageData.nm_rgbColorData(this.address(), value);
        return this;
    }

    public B3CameraImageData m_depthValues(@NativeType(value="float const *") FloatBuffer value) {
        B3CameraImageData.nm_depthValues(this.address(), value);
        return this;
    }

    public B3CameraImageData m_segmentationMaskValues(@NativeType(value="int const *") IntBuffer value) {
        B3CameraImageData.nm_segmentationMaskValues(this.address(), value);
        return this;
    }

    public B3CameraImageData set(int m_pixelWidth, int m_pixelHeight, ByteBuffer m_rgbColorData, FloatBuffer m_depthValues, IntBuffer m_segmentationMaskValues) {
        this.m_pixelWidth(m_pixelWidth);
        this.m_pixelHeight(m_pixelHeight);
        this.m_rgbColorData(m_rgbColorData);
        this.m_depthValues(m_depthValues);
        this.m_segmentationMaskValues(m_segmentationMaskValues);
        return this;
    }

    public B3CameraImageData set(B3CameraImageData src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static B3CameraImageData malloc() {
        return (B3CameraImageData)B3CameraImageData.wrap(B3CameraImageData.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static B3CameraImageData calloc() {
        return (B3CameraImageData)B3CameraImageData.wrap(B3CameraImageData.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static B3CameraImageData create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (B3CameraImageData)B3CameraImageData.wrap(B3CameraImageData.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static B3CameraImageData create(long address) {
        return (B3CameraImageData)B3CameraImageData.wrap(B3CameraImageData.class, (long)address);
    }

    @Nullable
    public static B3CameraImageData createSafe(long address) {
        return address == 0L ? null : (B3CameraImageData)B3CameraImageData.wrap(B3CameraImageData.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)B3CameraImageData.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)B3CameraImageData.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)B3CameraImageData.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = B3CameraImageData.__create((int)capacity, (int)SIZEOF);
        return (Buffer)B3CameraImageData.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)B3CameraImageData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)B3CameraImageData.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static B3CameraImageData mallocStack() {
        return B3CameraImageData.mallocStack(MemoryStack.stackGet());
    }

    public static B3CameraImageData callocStack() {
        return B3CameraImageData.callocStack(MemoryStack.stackGet());
    }

    public static B3CameraImageData mallocStack(MemoryStack stack) {
        return (B3CameraImageData)B3CameraImageData.wrap(B3CameraImageData.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static B3CameraImageData callocStack(MemoryStack stack) {
        return (B3CameraImageData)B3CameraImageData.wrap(B3CameraImageData.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return B3CameraImageData.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return B3CameraImageData.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3CameraImageData.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)B3CameraImageData.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int nm_pixelWidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_PIXELWIDTH);
    }

    public static int nm_pixelHeight(long struct) {
        return UNSAFE.getInt(null, struct + (long)M_PIXELHEIGHT);
    }

    public static ByteBuffer nm_rgbColorData(long struct, int capacity) {
        return MemoryUtil.memByteBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)M_RGBCOLORDATA)), (int)capacity);
    }

    public static FloatBuffer nm_depthValues(long struct, int capacity) {
        return MemoryUtil.memFloatBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)M_DEPTHVALUES)), (int)capacity);
    }

    public static IntBuffer nm_segmentationMaskValues(long struct, int capacity) {
        return MemoryUtil.memIntBuffer((long)MemoryUtil.memGetAddress((long)(struct + (long)M_SEGMENTATIONMASKVALUES)), (int)capacity);
    }

    public static void nm_pixelWidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_PIXELWIDTH, value);
    }

    public static void nm_pixelHeight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)M_PIXELHEIGHT, value);
    }

    public static void nm_rgbColorData(long struct, ByteBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_RGBCOLORDATA), (long)MemoryUtil.memAddress((ByteBuffer)value));
    }

    public static void nm_depthValues(long struct, FloatBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_DEPTHVALUES), (long)MemoryUtil.memAddress((FloatBuffer)value));
    }

    public static void nm_segmentationMaskValues(long struct, IntBuffer value) {
        MemoryUtil.memPutAddress((long)(struct + (long)M_SEGMENTATIONMASKVALUES), (long)MemoryUtil.memAddress((IntBuffer)value));
    }

    public static void validate(long struct) {
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_RGBCOLORDATA)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_DEPTHVALUES)));
        Checks.check((long)MemoryUtil.memGetAddress((long)(struct + (long)M_SEGMENTATIONMASKVALUES)));
    }

    public static void validate(long array, int count) {
        for (int i = 0; i < count; ++i) {
            B3CameraImageData.validate(array + Integer.toUnsignedLong(i) * (long)SIZEOF);
        }
    }

    static {
        Struct.Layout layout = B3CameraImageData.__struct((Struct.Member[])new Struct.Member[]{B3CameraImageData.__member((int)4), B3CameraImageData.__member((int)4), B3CameraImageData.__member((int)POINTER_SIZE), B3CameraImageData.__member((int)POINTER_SIZE), B3CameraImageData.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        M_PIXELWIDTH = layout.offsetof(0);
        M_PIXELHEIGHT = layout.offsetof(1);
        M_RGBCOLORDATA = layout.offsetof(2);
        M_DEPTHVALUES = layout.offsetof(3);
        M_SEGMENTATIONMASKVALUES = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<B3CameraImageData, Buffer>
    implements NativeResource {
        private static final B3CameraImageData ELEMENT_FACTORY = B3CameraImageData.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected B3CameraImageData getElementFactory() {
            return ELEMENT_FACTORY;
        }

        public int m_pixelWidth() {
            return B3CameraImageData.nm_pixelWidth(this.address());
        }

        public int m_pixelHeight() {
            return B3CameraImageData.nm_pixelHeight(this.address());
        }

        @NativeType(value="unsigned char const *")
        public ByteBuffer m_rgbColorData(int capacity) {
            return B3CameraImageData.nm_rgbColorData(this.address(), capacity);
        }

        @NativeType(value="float const *")
        public FloatBuffer m_depthValues(int capacity) {
            return B3CameraImageData.nm_depthValues(this.address(), capacity);
        }

        @NativeType(value="int const *")
        public IntBuffer m_segmentationMaskValues(int capacity) {
            return B3CameraImageData.nm_segmentationMaskValues(this.address(), capacity);
        }

        public Buffer m_pixelWidth(int value) {
            B3CameraImageData.nm_pixelWidth(this.address(), value);
            return this;
        }

        public Buffer m_pixelHeight(int value) {
            B3CameraImageData.nm_pixelHeight(this.address(), value);
            return this;
        }

        public Buffer m_rgbColorData(@NativeType(value="unsigned char const *") ByteBuffer value) {
            B3CameraImageData.nm_rgbColorData(this.address(), value);
            return this;
        }

        public Buffer m_depthValues(@NativeType(value="float const *") FloatBuffer value) {
            B3CameraImageData.nm_depthValues(this.address(), value);
            return this;
        }

        public Buffer m_segmentationMaskValues(@NativeType(value="int const *") IntBuffer value) {
            B3CameraImageData.nm_segmentationMaskValues(this.address(), value);
            return this;
        }
    }
}

