/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.xmpp;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jitsi.impl.protocol.xmpp.ChatRoom;
import org.jitsi.impl.protocol.xmpp.RegistrationListener;
import org.jitsi.impl.protocol.xmpp.XmppProvider;
import org.jitsi.jicofo.FocusManager;
import org.jitsi.jicofo.TaskPools;
import org.jitsi.jicofo.auth.AuthenticationAuthority;
import org.jitsi.jicofo.auth.ErrorFactory;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.jicofo.xmpp.UtilKt;
import org.jitsi.jicofo.xmpp.XmppConfig;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;
import org.jitsi.xmpp.extensions.jitsimeet.ConferenceIq;
import org.jivesoftware.smack.AbstractXMPPConnection;
import org.jivesoftware.smack.iqrequest.AbstractIqRequestHandler;
import org.jivesoftware.smack.iqrequest.IQRequestHandler;
import org.jivesoftware.smack.packet.ErrorIQ;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.StanzaError;
import org.jivesoftware.smackx.disco.packet.DiscoverInfo;
import org.jxmpp.jid.BareJid;
import org.jxmpp.jid.DomainBareJid;
import org.jxmpp.jid.EntityBareJid;
import org.jxmpp.jid.Jid;
import org.jxmpp.jid.impl.JidCreate;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002B7\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\u0006\u0010\r\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000eJ\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0014\u0010#\u001a\u0004\u0018\u00010 2\b\u0010$\u001a\u0004\u0018\u00010 H\u0016J$\u0010%\u001a\u0004\u0018\u00010 2\u0006\u0010!\u001a\u00020\"2\b\u0010&\u001a\u0004\u0018\u00010\"2\u0006\u0010'\u001a\u00020\nH\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\nH\u0016R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0019R\u0011\u0010\r\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0019R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001e\u00a8\u0006+"}, d2={"Lorg/jitsi/jicofo/xmpp/ConferenceIqHandler;", "Lorg/jitsi/impl/protocol/xmpp/RegistrationListener;", "Lorg/jivesoftware/smack/iqrequest/AbstractIqRequestHandler;", "xmppProvider", "Lorg/jitsi/impl/protocol/xmpp/XmppProvider;", "focusManager", "Lorg/jitsi/jicofo/FocusManager;", "focusAuthJid", "", "isFocusAnonymous", "", "authAuthority", "Lorg/jitsi/jicofo/auth/AuthenticationAuthority;", "jigasiEnabled", "(Lorg/jitsi/impl/protocol/xmpp/XmppProvider;Lorg/jitsi/jicofo/FocusManager;Ljava/lang/String;ZLorg/jitsi/jicofo/auth/AuthenticationAuthority;Z)V", "getAuthAuthority", "()Lorg/jitsi/jicofo/auth/AuthenticationAuthority;", "breakoutAddress", "Lorg/jxmpp/jid/DomainBareJid;", "connection", "Lorg/jivesoftware/smack/AbstractXMPPConnection;", "getFocusAuthJid", "()Ljava/lang/String;", "getFocusManager", "()Lorg/jitsi/jicofo/FocusManager;", "()Z", "getJigasiEnabled", "logger", "Lorg/jitsi/utils/logging2/Logger;", "getXmppProvider", "()Lorg/jitsi/impl/protocol/xmpp/XmppProvider;", "handleConferenceIq", "Lorg/jivesoftware/smack/packet/IQ;", "query", "Lorg/jitsi/xmpp/extensions/jitsimeet/ConferenceIq;", "handleIQRequest", "iqRequest", "processExtensions", "response", "roomExists", "registrationChanged", "", "registered", "jicofo"})
public final class ConferenceIqHandler
extends AbstractIqRequestHandler
implements RegistrationListener {
    @NotNull
    private final XmppProvider xmppProvider;
    @NotNull
    private final FocusManager focusManager;
    @NotNull
    private final String focusAuthJid;
    private final boolean isFocusAnonymous;
    @Nullable
    private final AuthenticationAuthority authAuthority;
    private final boolean jigasiEnabled;
    @NotNull
    private final AbstractXMPPConnection connection;
    @Nullable
    private DomainBareJid breakoutAddress;
    @NotNull
    private final Logger logger;

    public ConferenceIqHandler(@NotNull XmppProvider xmppProvider, @NotNull FocusManager focusManager, @NotNull String focusAuthJid, boolean isFocusAnonymous, @Nullable AuthenticationAuthority authAuthority, boolean jigasiEnabled) {
        Intrinsics.checkNotNullParameter(xmppProvider, "xmppProvider");
        Intrinsics.checkNotNullParameter(focusManager, "focusManager");
        Intrinsics.checkNotNullParameter(focusAuthJid, "focusAuthJid");
        super("conference", "http://jitsi.org/protocol/focus", IQ.Type.set, IQRequestHandler.Mode.sync);
        this.xmppProvider = xmppProvider;
        this.focusManager = focusManager;
        this.focusAuthJid = focusAuthJid;
        this.isFocusAnonymous = isFocusAnonymous;
        this.authAuthority = authAuthority;
        this.jigasiEnabled = jigasiEnabled;
        this.connection = this.xmppProvider.getXmppConnection();
        this.logger = LoggerExtensionsKt.createLogger$default(this, null, null, 3, null);
        this.xmppProvider.addRegistrationListener(this);
        this.registrationChanged(this.xmppProvider.isRegistered());
    }

    @NotNull
    public final XmppProvider getXmppProvider() {
        return this.xmppProvider;
    }

    @NotNull
    public final FocusManager getFocusManager() {
        return this.focusManager;
    }

    @NotNull
    public final String getFocusAuthJid() {
        return this.focusAuthJid;
    }

    public final boolean isFocusAnonymous() {
        return this.isFocusAnonymous;
    }

    @Nullable
    public final AuthenticationAuthority getAuthAuthority() {
        return this.authAuthority;
    }

    public final boolean getJigasiEnabled() {
        return this.jigasiEnabled;
    }

    private final IQ handleConferenceIq(ConferenceIq query) {
        ConferenceIq response = new ConferenceIq();
        EntityBareJid room = query.getRoom();
        this.logger.info("Focus request for room: " + room);
        boolean roomExists = this.focusManager.getConference(room) != null;
        IQ error = this.processExtensions(query, response, roomExists);
        if (error != null) {
            return error;
        }
        boolean ready = this.focusManager.conferenceRequest(room, query.getPropertiesMap());
        if (!this.isFocusAnonymous && this.authAuthority == null) {
            ready = true;
        }
        response.setType(IQ.Type.result);
        response.setStanzaId(query.getStanzaId());
        response.setFrom(query.getTo());
        response.setTo(query.getFrom());
        response.setRoom(query.getRoom());
        response.setReady(ready);
        response.setFocusJid(this.focusAuthJid);
        if (this.authAuthority != null) {
            response.addProperty(new ConferenceIq.Property("authentication", "true"));
            response.addProperty(new ConferenceIq.Property("externalAuth", String.valueOf(this.authAuthority.isExternal())));
        } else {
            response.addProperty(new ConferenceIq.Property("authentication", "false"));
        }
        if (this.jigasiEnabled) {
            response.addProperty(new ConferenceIq.Property("sipGatewayEnabled", "true"));
        }
        return response;
    }

    private final IQ processExtensions(ConferenceIq query, ConferenceIq response, boolean roomExists) {
        boolean isBreakoutRoom;
        EntityBareJid room = query.getRoom();
        boolean bl = isBreakoutRoom = this.breakoutAddress != null && Intrinsics.areEqual(room.getDomain(), this.breakoutAddress);
        if (!isBreakoutRoom && this.authAuthority != null) {
            IQ authErrorOrResponse = this.authAuthority.processAuthentication(query, response);
            if (authErrorOrResponse != null) {
                return authErrorOrResponse;
            }
            if (!roomExists) {
                boolean breakoutRoomExists;
                block9: {
                    boolean bl2;
                    List<JitsiMeetConference> list = this.focusManager.getConferences();
                    Intrinsics.checkNotNullExpressionValue(list, "focusManager.conferences");
                    Iterable $this$any$iv = list;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl2 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            boolean bl3;
                            JitsiMeetConference conference = (JitsiMeetConference)element$iv;
                            boolean bl4 = false;
                            if (conference.getChatRoom() != null) {
                                ChatRoom it;
                                boolean bl5 = false;
                                bl3 = it.isBreakoutRoom() && Intrinsics.areEqual(room.toString(), it.getMainRoom());
                            } else {
                                bl3 = false;
                            }
                            if (!bl3) continue;
                            bl2 = true;
                            break block9;
                        }
                        bl2 = breakoutRoomExists = false;
                    }
                }
                if (!breakoutRoomExists && this.authAuthority.getUserIdentity(query.getFrom()) == null) {
                    return ErrorFactory.createNotAuthorizedError(query, "not authorized user domain");
                }
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IQ handleIQRequest(@Nullable IQ iqRequest) {
        if (!(iqRequest instanceof ConferenceIq)) {
            ErrorIQ errorIQ;
            ErrorIQ it = errorIQ = IQ.createErrorResponse(iqRequest, StanzaError.getBuilder(StanzaError.Condition.internal_server_error).build());
            boolean bl = false;
            this.logger.error("Received an unexpected IQ type: " + iqRequest);
            return errorIQ;
        }
        Jid originalFrom = ((ConferenceIq)iqRequest).getFrom();
        ConferenceIq conferenceIq = (ConferenceIq)iqRequest;
        DomainBareJid domainBareJid = XmppConfig.client.getClientProxy();
        Intrinsics.checkNotNullExpressionValue(originalFrom, "originalFrom");
        conferenceIq.setFrom(UtilKt.parseJidFromClientProxyJid(domainBareJid, originalFrom));
        TaskPools.Companion.getIoPool().execute(() -> ConferenceIqHandler.handleIQRequest$lambda-4(this, iqRequest, originalFrom));
        return null;
    }

    @Override
    public void registrationChanged(boolean registered) {
        if (!registered) {
            this.breakoutAddress = null;
            return;
        }
        try {
            String breakoutAddressStr;
            BareJid bareJid = JidCreate.bareFrom(XmppConfig.client.getXmppDomain());
            Intrinsics.checkNotNullExpressionValue(bareJid, "bareFrom(XmppConfig.client.xmppDomain)");
            DiscoverInfo info = this.xmppProvider.discoverInfo(bareJid);
            Object object = info;
            String string = object != null && (object = ((DiscoverInfo)object).getIdentities("component", "breakout_rooms")) != null && (object = (DiscoverInfo.Identity)CollectionsKt.firstOrNull(object)) != null ? ((DiscoverInfo.Identity)object).getName() : (breakoutAddressStr = null);
            if (breakoutAddressStr == null) {
                this.breakoutAddress = null;
                this.logger.info("No breakout room component address configured.");
            } else {
                this.breakoutAddress = JidCreate.domainBareFrom(breakoutAddressStr);
                this.logger.info("Using breakout room component address: " + this.breakoutAddress);
            }
        }
        catch (Exception e) {
            this.logger.error("Could not discover breakout rooms component address.", e);
        }
    }

    private static final void handleIQRequest$lambda-4(ConferenceIqHandler this$0, IQ $iqRequest, Jid $originalFrom) {
        IQ iQ;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        IQ $this$handleIQRequest_u24lambda_u2d4_u24lambda_u2d3 = iQ = this$0.handleConferenceIq((ConferenceIq)$iqRequest);
        boolean bl = false;
        $this$handleIQRequest_u24lambda_u2d4_u24lambda_u2d3.setTo($originalFrom);
        IQ response = iQ;
        try {
            this$0.connection.sendStanza(response);
        }
        catch (Exception e) {
            this$0.logger.error("Failed to send response", e);
        }
    }
}

