/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.jicofo.rest;

import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jitsi.jicofo.JicofoServices;
import org.jitsi.jicofo.conference.JitsiMeetConference;
import org.jitsi.utils.OrderedJsonObject;
import org.json.simple.JSONArray;

@Path(value="/debug")
public class Debug {
    @NotNull
    private final JicofoServices jicofoServices = Objects.requireNonNull(JicofoServices.jicofoServicesSingleton, "jicofoServices");

    @GET
    @Produces(value={"application/json"})
    @NotNull
    public String getDebug(@DefaultValue(value="false") @QueryParam(value="full") boolean full) {
        return this.jicofoServices.getDebugState(full).toJSONString();
    }

    @GET
    @Path(value="conference/{confId}")
    @Produces(value={"application/json"})
    @NotNull
    public String confDebug(@PathParam(value="confId") String confId) {
        OrderedJsonObject confJson = this.jicofoServices.getConferenceDebugState(confId);
        return confJson.toJSONString();
    }

    @GET
    @Path(value="/conferences")
    @Produces(value={"application/json"})
    @NotNull
    public String conferences(@PathParam(value="confId") String confId) {
        JSONArray conferencesJson = new JSONArray();
        for (JitsiMeetConference c : this.jicofoServices.getFocusManager().getAllConferences()) {
            conferencesJson.add(c.getRoomName().toString());
        }
        return conferencesJson.toJSONString();
    }
}

