/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.protocol.xmpp;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jitsi.impl.protocol.xmpp.RegistrationListener;
import org.jitsi.impl.protocol.xmpp.XmppProvider;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;

public abstract class AbstractXmppProvider
implements XmppProvider {
    private static final Logger logger = new LoggerImpl(AbstractXmppProvider.class.getName());
    private final List<RegistrationListener> registrationListeners = new ArrayList<RegistrationListener>();
    private boolean registered = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addRegistrationListener(@NotNull RegistrationListener listener) {
        List<RegistrationListener> list = this.registrationListeners;
        synchronized (list) {
            if (!this.registrationListeners.contains(listener)) {
                this.registrationListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRegistrationListener(@NotNull RegistrationListener listener) {
        List<RegistrationListener> list = this.registrationListeners;
        synchronized (list) {
            this.registrationListeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireRegistrationStateChanged(boolean registered) {
        RegistrationListener[] registrationListenerArray = this.registrationListeners;
        synchronized (this.registrationListeners) {
            RegistrationListener[] listeners = this.registrationListeners.toArray(new RegistrationListener[this.registrationListeners.size()]);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (RegistrationListener listener : listeners) {
                try {
                    listener.registrationChanged(registered);
                }
                catch (Throwable throwable) {
                    logger.error("An error occurred while executing RegistrationStateChangeListener#registrationStateChanged(RegistrationStateChangeEvent) of " + listener, throwable);
                }
            }
            return;
        }
    }

    @Override
    public boolean isRegistered() {
        return this.registered;
    }

    protected void setRegistered(boolean registered) {
        if (this.registered != registered) {
            this.registered = registered;
            this.fireRegistrationStateChanged(registered);
        }
    }
}

