/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.debugger.cdbg.basic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.DebuggerException;
import sun.jvm.hotspot.debugger.cdbg.LineNumberVisitor;
import sun.jvm.hotspot.debugger.cdbg.basic.BasicLineNumberInfo;
import sun.jvm.hotspot.utilities.AddressOps;

public class BasicLineNumberMapping {
    private List infoList;

    public void addLineNumberInfo(BasicLineNumberInfo info) {
        if (this.infoList == null) {
            this.infoList = new ArrayList();
        }
        this.infoList.add(info);
    }

    public void sort() {
        if (this.infoList == null) {
            return;
        }
        Collections.sort(this.infoList, new Comparator(){

            public int compare(Object o1, Object o2) {
                Address a2;
                BasicLineNumberInfo l1 = (BasicLineNumberInfo)o1;
                BasicLineNumberInfo l2 = (BasicLineNumberInfo)o2;
                Address a1 = l1.getStartPC();
                if (AddressOps.lt(a1, a2 = l2.getStartPC())) {
                    return -1;
                }
                if (AddressOps.gt(a1, a2)) {
                    return 1;
                }
                return 0;
            }
        });
    }

    public void recomputeEndPCs() {
        if (this.infoList == null) {
            return;
        }
        for (int i = 0; i < this.infoList.size() - 1; ++i) {
            BasicLineNumberInfo i1 = this.get(i);
            BasicLineNumberInfo i2 = this.get(i + 1);
            i1.setEndPC(i2.getStartPC());
        }
    }

    public BasicLineNumberInfo lineNumberForPC(Address pc) throws DebuggerException {
        if (this.infoList == null) {
            return null;
        }
        return this.searchLineNumbers(pc, 0, this.infoList.size() - 1);
    }

    public void iterate(LineNumberVisitor v) {
        if (this.infoList == null) {
            return;
        }
        for (int i = 0; i < this.infoList.size(); ++i) {
            v.doLineNumber(this.get(i));
        }
    }

    private BasicLineNumberInfo get(int i) {
        return (BasicLineNumberInfo)this.infoList.get(i);
    }

    private BasicLineNumberInfo searchLineNumbers(Address addr, int lowIdx, int highIdx) {
        if (highIdx < lowIdx) {
            return null;
        }
        if (lowIdx == highIdx) {
            if (this.check(addr, lowIdx)) {
                return this.get(lowIdx);
            }
            return null;
        }
        if (lowIdx == highIdx - 1) {
            if (this.check(addr, lowIdx)) {
                return this.get(lowIdx);
            }
            if (this.check(addr, highIdx)) {
                return this.get(highIdx);
            }
            return null;
        }
        int midIdx = lowIdx + highIdx >> 1;
        BasicLineNumberInfo info = this.get(midIdx);
        if (AddressOps.lt(addr, info.getStartPC())) {
            return this.searchLineNumbers(addr, lowIdx, midIdx);
        }
        if (AddressOps.equal(addr, info.getStartPC())) {
            return info;
        }
        return this.searchLineNumbers(addr, midIdx, highIdx);
    }

    private boolean check(Address addr, int idx) {
        BasicLineNumberInfo info = this.get(idx);
        return AddressOps.lte(info.getStartPC(), addr);
    }
}

