/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.w3c.css.util.NVPair;

public final class Util {
    private static Pattern uri_param = Pattern.compile("[&?][^&?=]+=([^&?]+)");
    public static boolean servlet;
    public static boolean importSecurity;
    public static boolean noErrorTrace;
    public static boolean fromHTMLFile;
    public static boolean onDebug;
    public static long maxEntitySize;

    private Util() {
    }

    private static ArrayList<String> parseURIs(String uri) {
        ArrayList<String> uris = new ArrayList<String>();
        int pos = 0;
        uris.add(uri);
        while (pos < uris.size()) {
            String u = uris.get(pos++);
            Matcher m = uri_param.matcher(u);
            while (m.find()) {
                try {
                    String compound = URLDecoder.decode(m.group(1), "UTF-8");
                    if (!compound.contains("://")) continue;
                    uris.add(compound);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        }
        return uris;
    }

    public static boolean checkURI(String uri) {
        ArrayList<String> uris = Util.parseURIs(uri);
        for (String u : uris) {
            int qm = u.indexOf(63);
            if (qm != -1) {
                u = u.substring(0, qm);
            }
            u.toLowerCase();
            if (!u.startsWith("http://jigsaw.w3.org/css-validator/validator")) continue;
            return false;
        }
        return true;
    }

    public static final NVPair[] resizeArray(NVPair[] src, int new_size) {
        NVPair[] tmp = new NVPair[new_size];
        System.arraycopy(src, 0, tmp, 0, src.length < new_size ? src.length : new_size);
        return tmp;
    }

    public static final int[] compile_search(byte[] search) {
        int[] cmp = new int[]{0, 1, 0, 1, 0, 1};
        for (int idx = 0; idx < search.length; ++idx) {
            int end;
            for (end = idx + 1; end < search.length && search[idx] != search[end]; ++end) {
            }
            if (end >= search.length) continue;
            if (end - idx > cmp[1]) {
                cmp[4] = cmp[2];
                cmp[5] = cmp[3];
                cmp[2] = cmp[0];
                cmp[3] = cmp[1];
                cmp[0] = idx;
                cmp[1] = end - idx;
                continue;
            }
            if (end - idx > cmp[3]) {
                cmp[4] = cmp[2];
                cmp[5] = cmp[3];
                cmp[2] = idx;
                cmp[3] = end - idx;
                continue;
            }
            if (end - idx <= cmp[3]) continue;
            cmp[4] = idx;
            cmp[5] = end - idx;
        }
        cmp[1] = cmp[1] + cmp[0];
        cmp[3] = cmp[3] + cmp[2];
        cmp[5] = cmp[5] + cmp[4];
        return cmp;
    }

    /*
     * Unable to fully structure code
     */
    public static final int findStr(byte[] search, int[] cmp, byte[] str, int beg, int end) {
        c1f = cmp[0];
        c1l = cmp[1];
        d1 = c1l - c1f;
        c2f = cmp[2];
        c2l = cmp[3];
        d2 = c2l - c2f;
        c3f = cmp[4];
        c3l = cmp[5];
        d3 = c3l - c3f;
        block0: while (beg + search.length <= end) {
            block6: {
                if (search[c1l] != str[beg + c1l]) break block6;
                if (search[c1f] != str[beg + c1f]) ** GOTO lbl16
                for (idx = 0; idx < search.length; ++idx) {
                    if (search[idx] == str[beg + idx]) {
                        continue;
                    }
lbl16:
                    // 3 sources

                    beg += d1;
                    continue block0;
                }
                break;
            }
            if (search[c2l] == str[beg + c2l]) {
                beg += d2;
                continue;
            }
            if (search[c3l] == str[beg + c3l]) {
                beg += d3;
                continue;
            }
            ++beg;
        }
        if (beg + search.length > end) {
            return -1;
        }
        return beg;
    }

    public static final boolean isSpace(char c) {
        return c == ' ';
    }

    public static final void verbose(String s) {
        if (onDebug) {
            System.err.println(s);
        }
    }

    public static final String suppressWhiteSpace(String s) {
        if (s != null) {
            int i;
            int len = s.length();
            for (i = 0; i < len && Util.isWhiteSpace(s.charAt(i)); ++i) {
            }
            if (i == 0) {
                return s;
            }
            return i == len ? null : s.substring(i);
        }
        return null;
    }

    public static final String strip(String s) {
        int index = 0;
        char[] news = new char[s.length()];
        for (char c : s.toCharArray()) {
            if (Util.isWhiteSpace(c)) continue;
            news[index++] = c;
        }
        return new String(news, 0, index);
    }

    public static final boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\n' || c == '\r' || c == '\t';
    }

    public static final String displayFloat(Float value) {
        float floatValue;
        int intValue = value.intValue();
        if ((float)intValue == (floatValue = value.floatValue())) {
            return Integer.toString(intValue, 10);
        }
        return value.toString();
    }

    public static final String displayFloat(float value) {
        int intValue = (int)value;
        if ((float)intValue == value) {
            return Integer.toString(intValue, 10);
        }
        return Float.toString(value);
    }

    public static String escapeHTML(String s) {
        int length;
        if (s == null) {
            return null;
        }
        int newLength = length = s.length();
        boolean someCharacterEscaped = false;
        block18: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            if (cint < 32) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        break;
                    }
                    default: {
                        --newLength;
                        someCharacterEscaped = true;
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\"': {
                    newLength += 5;
                    someCharacterEscaped = true;
                    continue block18;
                }
                case '&': 
                case '\'': {
                    newLength += 4;
                    someCharacterEscaped = true;
                    continue block18;
                }
                case '<': 
                case '>': {
                    newLength += 3;
                    someCharacterEscaped = true;
                }
            }
        }
        if (!someCharacterEscaped) {
            return s;
        }
        StringBuilder sb = new StringBuilder(newLength);
        block19: for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            int cint = 0xFFFF & c;
            if (cint < 32) {
                switch (c) {
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': {
                        sb.append(c);
                        break;
                    }
                }
                continue;
            }
            switch (c) {
                case '\"': {
                    sb.append("&quot;");
                    continue block19;
                }
                case '\'': {
                    sb.append("&#39;");
                    continue block19;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block19;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block19;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block19;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    static {
        onDebug = Boolean.getBoolean("CSS.debug");
        maxEntitySize = 0x100000L;
    }
}

