/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * all(bvec3(false, false, false)) => false
 * all(bvec3(false, false, true)) => false
 * all(bvec3(false, true, false)) => false
 * all(bvec3(false, true, true)) => false
 * all(bvec3(true, false, false)) => false
 * all(bvec3(true, false, true)) => false
 * all(bvec3(true, true, false)) => false
 * all(bvec3(true, true, true)) => true
 */
#version 120

void main()
{
  float[all(bvec3(false, false, false)) == false ? 1 : -1] array0;
  float[all(bvec3(false, false, true)) == false ? 1 : -1] array1;
  float[all(bvec3(false, true, false)) == false ? 1 : -1] array2;
  float[all(bvec3(false, true, true)) == false ? 1 : -1] array3;
  float[all(bvec3(true, false, false)) == false ? 1 : -1] array4;
  float[all(bvec3(true, false, true)) == false ? 1 : -1] array5;
  float[all(bvec3(true, true, false)) == false ? 1 : -1] array6;
  float[all(bvec3(true, true, true)) == true ? 1 : -1] array7;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length());
}
