/*
 * Decompiled with CFR 0.152.
 */
package de.escape.quincunx.gimmicks;

import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.text.StringCharacterIterator;

public class MultiLineLabel
extends Panel {
    protected Label[] singles;
    protected int lines;
    protected int alignment = 1;

    public MultiLineLabel() {
        super(new GridLayout(1, 0, 0, 0));
    }

    public MultiLineLabel(String text) {
        super(new GridLayout(1, 0, 0, 0));
        this.setText(text);
    }

    public MultiLineLabel(String text, int align) {
        super(new GridLayout(1, 0, 0, 0));
        this.setText(text);
        this.setAlignment(align);
    }

    public void setText(String text) {
        if (text != null && text.length() > 0) {
            this.lines = 1;
            StringCharacterIterator it = new StringCharacterIterator(text);
            char c = it.first();
            while (c != '\uffff') {
                if (c == '\n') {
                    ++this.lines;
                }
                c = it.next();
            }
            this.setLayout(new GridLayout(this.lines, 1));
            this.singles = new Label[this.lines];
            int start = 0;
            int end = 0;
            int l = 0;
            c = it.first();
            while (c != '\uffff') {
                if (c == '\n') {
                    if (end >= start) {
                        this.singles[l] = new Label(text.substring(start, end), this.alignment);
                        this.add(this.singles[l]);
                        ++l;
                    }
                    start = end + 1;
                }
                c = it.next();
                ++end;
            }
            if (end > start) {
                this.singles[l] = new Label(text.substring(start, end), this.alignment);
                this.add(this.singles[l]);
            }
        }
    }

    public void setAlignment(int align) {
        this.alignment = align;
        int l = 0;
        while (l < this.lines) {
            this.singles[l].setAlignment(this.alignment);
            ++l;
        }
    }

    public int getAlignment() {
        return this.alignment;
    }

    public String getText() {
        String ret = "";
        int l = 0;
        while (l < this.lines) {
            if (l > 0) {
                ret = String.valueOf(ret) + '\n';
            }
            ret = String.valueOf(ret) + this.singles[l].getText();
            ++l;
        }
        return ret;
    }
}

