/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.util;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import de.plushnikov.intellij.plugin.Version;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LombokLibraryUtil {
    private static final Logger LOG = Logger.getInstance(LombokLibraryUtil.class);
    private static final String LOMBOK_PACKAGE = "lombok.experimental";

    public static boolean hasLombokLibrary(@NotNull Project project) {
        if (project == null) {
            LombokLibraryUtil.$$$reportNull$$$0(0);
        }
        if (project.isDefault() || !project.isInitialized()) {
            return false;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        return CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(LOMBOK_PACKAGE);
            return new CachedValueProvider.Result((Object)aPackage, new Object[]{ProjectRootManager.getInstance((Project)project)});
        }) != null;
    }

    @NotNull
    public static String getLombokVersionCached(@NotNull Project project) {
        if (project == null) {
            LombokLibraryUtil.$$$reportNull$$$0(1);
        }
        String string = (String)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            String lombokVersion = null;
            try {
                lombokVersion = (String)ReadAction.nonBlocking(() -> LombokLibraryUtil.getLombokVersionInternal(project)).executeSynchronously();
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable e) {
                LOG.error(e);
            }
            return new CachedValueProvider.Result((Object)StringUtil.notNullize((String)lombokVersion), new Object[]{ProjectRootManager.getInstance((Project)project)});
        });
        if (string == null) {
            LombokLibraryUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static String getLombokVersionInternal(@NotNull Project project) {
        List entries;
        PsiDirectory[] directories;
        PsiPackage aPackage;
        if (project == null) {
            LombokLibraryUtil.$$$reportNull$$$0(3);
        }
        if ((aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(LOMBOK_PACKAGE)) != null && (directories = aPackage.getDirectories()).length > 0 && !(entries = ProjectRootManager.getInstance((Project)project).getFileIndex().getOrderEntriesForFile(directories[0].getVirtualFile())).isEmpty()) {
            return Version.parseLombokVersion((OrderEntry)entries.get(0));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/util/LombokLibraryUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/util/LombokLibraryUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLombokVersionCached";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "hasLombokLibrary";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLombokVersionCached";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLombokVersionInternal";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

