/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor.handler.singular;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import de.plushnikov.intellij.plugin.processor.handler.BuilderInfo;
import de.plushnikov.intellij.plugin.processor.handler.singular.BuilderElementHandler;
import de.plushnikov.intellij.plugin.psi.LombokLightFieldBuilder;
import de.plushnikov.intellij.plugin.psi.LombokLightMethodBuilder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NonSingularHandler
implements BuilderElementHandler {
    NonSingularHandler() {
    }

    @Override
    public Collection<PsiField> renderBuilderFields(@NotNull BuilderInfo info) {
        if (info == null) {
            NonSingularHandler.$$$reportNull$$$0(0);
        }
        ArrayList<PsiField> result = new ArrayList<PsiField>();
        result.add((PsiField)new LombokLightFieldBuilder(info.getManager(), info.renderFieldName(), info.getFieldType()).withContainingClass(info.getBuilderClass()).withModifier("private").withNavigationElement((PsiElement)info.getVariable()));
        if (info.hasBuilderDefaultAnnotation()) {
            result.add((PsiField)new LombokLightFieldBuilder(info.getManager(), info.renderFieldDefaultSetName(), (PsiType)PsiType.BOOLEAN).withContainingClass(info.getBuilderClass()).withModifier("private").withNavigationElement((PsiElement)info.getVariable()));
        }
        return result;
    }

    @Override
    public Collection<PsiMethod> renderBuilderMethod(@NotNull BuilderInfo info) {
        if (info == null) {
            NonSingularHandler.$$$reportNull$$$0(1);
        }
        String blockText = this.getAllMethodBody(info);
        String methodName = this.calcBuilderMethodName(info);
        LombokLightMethodBuilder methodBuilder = new LombokLightMethodBuilder(info.getManager(), methodName).withContainingClass(info.getBuilderClass()).withMethodReturnType(info.getBuilderType()).withParameter(info.getFieldName(), info.getFieldType()).withNavigationElement((PsiElement)info.getVariable()).withModifier(info.getVisibilityModifier()).withAnnotations(info.getAnnotations()).withBodyText(blockText);
        return Collections.singleton(methodBuilder);
    }

    @Override
    public List<String> getBuilderMethodNames(@NotNull String newName, @Nullable PsiAnnotation singularAnnotation) {
        if (newName == null) {
            NonSingularHandler.$$$reportNull$$$0(2);
        }
        return Collections.singletonList(newName);
    }

    @Override
    public String createSingularName(PsiAnnotation singularAnnotation, String psiFieldName) {
        return psiFieldName;
    }

    private String getAllMethodBody(@NotNull BuilderInfo info) {
        if (info == null) {
            NonSingularHandler.$$$reportNull$$$0(3);
        }
        StringBuilder codeBlockTemplate = new StringBuilder("this.{0} = {1};\n");
        if (info.hasBuilderDefaultAnnotation()) {
            codeBlockTemplate.append("this.{2} = true;\n");
        }
        codeBlockTemplate.append("return {3};");
        return MessageFormat.format(codeBlockTemplate.toString(), info.renderFieldName(), info.getFieldName(), info.renderFieldDefaultSetName(), info.getBuilderChainResult());
    }

    @Override
    public String renderBuildPrepare(@NotNull BuilderInfo info) {
        if (info == null) {
            NonSingularHandler.$$$reportNull$$$0(4);
        }
        if (info.hasBuilderDefaultAnnotation()) {
            return MessageFormat.format("{0} {1} = this.{1};\nif (!this.{2}) '{'\n  {1} = {4}.{3}();\n'}'", info.getFieldType().getCanonicalText(false), info.renderFieldName(), info.renderFieldDefaultSetName(), info.renderFieldDefaultProviderName(), info.getBuilderClass().getContainingClass().getName());
        }
        return "";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
        }
        objectArray2[1] = "de/plushnikov/intellij/plugin/processor/handler/singular/NonSingularHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "renderBuilderFields";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "renderBuilderMethod";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getBuilderMethodNames";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getAllMethodBody";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "renderBuildPrepare";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

