/*
 * Decompiled with CFR 0.152.
 */
package de.plushnikov.intellij.plugin.processor;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.containers.ContainerUtil;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigDiscovery;
import de.plushnikov.intellij.plugin.lombokconfig.ConfigKey;
import de.plushnikov.intellij.plugin.processor.LombokPsiElementUsage;
import de.plushnikov.intellij.plugin.processor.Processor;
import de.plushnikov.intellij.plugin.psi.LombokLightModifierList;
import de.plushnikov.intellij.plugin.thirdparty.LombokCopyableAnnotations;
import de.plushnikov.intellij.plugin.util.LombokProcessorUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationSearchUtil;
import de.plushnikov.intellij.plugin.util.PsiAnnotationUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractProcessor
implements Processor {
    private final String[] supportedAnnotationClasses;
    private final Class<? extends PsiElement> supportedClass;
    protected final ConfigDiscovery configDiscovery;

    protected AbstractProcessor(@NotNull Class<? extends PsiElement> supportedClass, String ... supportedAnnotationClasses) {
        if (supportedClass == null) {
            AbstractProcessor.$$$reportNull$$$0(0);
        }
        if (supportedAnnotationClasses == null) {
            AbstractProcessor.$$$reportNull$$$0(1);
        }
        this.configDiscovery = ConfigDiscovery.getInstance();
        this.supportedClass = supportedClass;
        this.supportedAnnotationClasses = supportedAnnotationClasses;
    }

    @Override
    @NotNull
    public final @NotNull String @NotNull [] getSupportedAnnotationClasses() {
        if (this.supportedAnnotationClasses == null) {
            AbstractProcessor.$$$reportNull$$$0(2);
        }
        return this.supportedAnnotationClasses;
    }

    @Override
    @NotNull
    public final Class<? extends PsiElement> getSupportedClass() {
        Class<? extends PsiElement> clazz = this.supportedClass;
        if (clazz == null) {
            AbstractProcessor.$$$reportNull$$$0(3);
        }
        return clazz;
    }

    @NotNull
    public abstract Collection<PsiAnnotation> collectProcessedAnnotations(@NotNull PsiClass var1);

    protected boolean supportAnnotationVariant(@NotNull PsiAnnotation psiAnnotation) {
        if (psiAnnotation == null) {
            AbstractProcessor.$$$reportNull$$$0(4);
        }
        return true;
    }

    protected void filterToleratedElements(@NotNull Collection<? extends PsiModifierListOwner> definedMethods) {
        if (definedMethods == null) {
            AbstractProcessor.$$$reportNull$$$0(5);
        }
        definedMethods.removeIf(definedMethod -> PsiAnnotationSearchUtil.isAnnotatedWith(definedMethod, "lombok.experimental.Tolerate"));
    }

    protected boolean readAnnotationOrConfigProperty(@NotNull PsiAnnotation psiAnnotation, @NotNull PsiClass psiClass, @NotNull String annotationParameter, @NotNull ConfigKey configKey) {
        Boolean declaredAnnotationValue;
        if (psiAnnotation == null) {
            AbstractProcessor.$$$reportNull$$$0(6);
        }
        if (psiClass == null) {
            AbstractProcessor.$$$reportNull$$$0(7);
        }
        if (annotationParameter == null) {
            AbstractProcessor.$$$reportNull$$$0(8);
        }
        if (configKey == null) {
            AbstractProcessor.$$$reportNull$$$0(9);
        }
        boolean result = null == (declaredAnnotationValue = PsiAnnotationUtil.getDeclaredBooleanAnnotationValue(psiAnnotation, annotationParameter)) ? this.configDiscovery.getBooleanLombokConfigProperty(configKey, psiClass) : declaredAnnotationValue.booleanValue();
        return result;
    }

    protected static void copyOnXAnnotations(@Nullable PsiAnnotation processedAnnotation, @NotNull PsiModifierList modifierList, @NotNull String onXParameterName) {
        if (modifierList == null) {
            AbstractProcessor.$$$reportNull$$$0(10);
        }
        if (onXParameterName == null) {
            AbstractProcessor.$$$reportNull$$$0(11);
        }
        if (processedAnnotation == null) {
            return;
        }
        Iterable<String> annotationsToAdd = LombokProcessorUtil.getOnX(processedAnnotation, onXParameterName);
        annotationsToAdd.forEach(arg_0 -> ((PsiModifierList)modifierList).addAnnotation(arg_0));
    }

    @NotNull
    protected static List<PsiAnnotation> copyableAnnotations(@NotNull PsiField psiField, @NotNull LombokCopyableAnnotations copyableAnnotations) {
        Object[] fieldAnnotations;
        if (psiField == null) {
            AbstractProcessor.$$$reportNull$$$0(12);
        }
        if (copyableAnnotations == null) {
            AbstractProcessor.$$$reportNull$$$0(13);
        }
        if (0 == (fieldAnnotations = psiField.getAnnotations()).length) {
            List<PsiAnnotation> list = Collections.emptyList();
            if (list == null) {
                AbstractProcessor.$$$reportNull$$$0(14);
            }
            return list;
        }
        HashMap<String, String> fullQualifiedToShortNames = new HashMap<String, String>(copyableAnnotations.getFullQualifiedToShortNames());
        PsiClass containingClass = psiField.getContainingClass();
        if (LombokCopyableAnnotations.BASE_COPYABLE.equals((Object)copyableAnnotations) && null != containingClass) {
            Collection<String> configuredCopyableAnnotations = ConfigDiscovery.getInstance().getMultipleValueLombokConfigProperty(ConfigKey.COPYABLE_ANNOTATIONS, containingClass);
            configuredCopyableAnnotations.forEach(fqn -> fullQualifiedToShortNames.put((String)fqn, StringUtil.getShortName((String)fqn)));
        }
        List existedShortAnnotationNames = ContainerUtil.map((Object[])fieldAnnotations, PsiAnnotationSearchUtil::getShortNameOf);
        fullQualifiedToShortNames.values().retainAll(existedShortAnnotationNames);
        List<PsiAnnotation> list = PsiAnnotationSearchUtil.findAllAnnotations((PsiModifierListOwner)psiField, fullQualifiedToShortNames.keySet());
        if (list == null) {
            AbstractProcessor.$$$reportNull$$$0(15);
        }
        return list;
    }

    protected static void copyCopyableAnnotations(@NotNull PsiField fromPsiElement, @NotNull LombokLightModifierList toModifierList, @NotNull LombokCopyableAnnotations copyableAnnotations) {
        if (fromPsiElement == null) {
            AbstractProcessor.$$$reportNull$$$0(16);
        }
        if (toModifierList == null) {
            AbstractProcessor.$$$reportNull$$$0(17);
        }
        if (copyableAnnotations == null) {
            AbstractProcessor.$$$reportNull$$$0(18);
        }
        List<PsiAnnotation> annotationsToAdd = AbstractProcessor.copyableAnnotations(fromPsiElement, copyableAnnotations);
        annotationsToAdd.forEach(toModifierList::withAnnotation);
    }

    @Override
    public LombokPsiElementUsage checkFieldUsage(@NotNull PsiField psiField, @NotNull PsiAnnotation psiAnnotation) {
        if (psiField == null) {
            AbstractProcessor.$$$reportNull$$$0(19);
        }
        if (psiAnnotation == null) {
            AbstractProcessor.$$$reportNull$$$0(20);
        }
        return LombokPsiElementUsage.NONE;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supportedAnnotationClasses";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "de/plushnikov/intellij/plugin/processor/AbstractProcessor";
                break;
            }
            case 4: 
            case 6: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiAnnotation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definedMethods";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotationParameter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configKey";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modifierList";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onXParameterName";
                break;
            }
            case 12: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiField";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyableAnnotations";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPsiElement";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModifierList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "de/plushnikov/intellij/plugin/processor/AbstractProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedAnnotationClasses";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedClass";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "copyableAnnotations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "supportAnnotationVariant";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterToleratedElements";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "readAnnotationOrConfigProperty";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "copyOnXAnnotations";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "copyableAnnotations";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "copyCopyableAnnotations";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "checkFieldUsage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 14: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

