/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.jps.incremental;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.kotlin.jps.incremental.CacheAttributesManager;
import org.jetbrains.kotlin.jps.incremental.CacheVersion;
import org.jetbrains.kotlin.jps.incremental.CacheVersionManager;
import org.jetbrains.kotlin.jps.incremental.CompositeLookupsCacheAttributes;
import org.jetbrains.kotlin.jps.incremental.LookupsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0002H\u0016J\n\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0016J\u0012\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0002H\u0016R\u0016\u0010\t\u001a\n \n*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u0004\u0018\u00010\u0002X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u000f8G\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributesManager;", "Lorg/jetbrains/kotlin/jps/incremental/CacheAttributesManager;", "Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "rootPath", "Ljava/nio/file/Path;", "expectedComponents", "", "", "(Ljava/nio/file/Path;Ljava/util/Set;)V", "actualComponentsFile", "kotlin.jvm.PlatformType", "expected", "getExpected", "()Lorg/jetbrains/kotlin/jps/incremental/CompositeLookupsCacheAttributes;", "versionManager", "Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "versionManagerForTesting", "getVersionManagerForTesting", "()Lorg/jetbrains/kotlin/jps/incremental/CacheVersionManager;", "isCompatible", "", "actual", "loadActual", "writeVersion", "", "values", "kotlin.jps-plugin"})
public final class CompositeLookupsCacheAttributesManager
implements CacheAttributesManager<CompositeLookupsCacheAttributes> {
    private final CacheVersionManager versionManager;
    private final Path actualComponentsFile;
    @Nullable
    private final CompositeLookupsCacheAttributes expected;

    @Override
    @Nullable
    public CompositeLookupsCacheAttributes getExpected() {
        return this.expected;
    }

    @Override
    @Nullable
    public CompositeLookupsCacheAttributes loadActual() {
        CacheVersion cacheVersion = this.versionManager.loadActual();
        if (cacheVersion == null) {
            return null;
        }
        CacheVersion version = cacheVersion;
        Path path = this.actualComponentsFile;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"actualComponentsFile");
        Path path2 = path;
        Object object = new LinkOption[]{};
        boolean bl = false;
        if (Files.notExists(path2, Arrays.copyOf(object, ((LinkOption[])object).length))) {
            return null;
        }
        try {
            Path path3 = this.actualComponentsFile;
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"actualComponentsFile");
            object = path3;
            Charset charset = Charsets.UTF_8;
            boolean bl2 = false;
            List<String> list = Files.readAllLines((Path)object, charset);
            Intrinsics.checkNotNullExpressionValue(list, (String)"Files.readAllLines(this, charset)");
            object = CollectionsKt.toSet((Iterable)list);
        }
        catch (IOException e) {
            return null;
        }
        Object components = object;
        return new CompositeLookupsCacheAttributes(version.getIntValue(), (Set<String>)components);
    }

    @Override
    public void writeVersion(@Nullable CompositeLookupsCacheAttributes values) {
        if (values == null) {
            this.versionManager.writeVersion(null);
            Path path = this.actualComponentsFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"actualComponentsFile");
            Path path2 = path;
            boolean bl = false;
            Files.deleteIfExists(path2);
        } else {
            this.versionManager.writeVersion(new CacheVersion(values.getVersion()));
            Path path = this.actualComponentsFile;
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"actualComponentsFile");
            Path path3 = path.getParent();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"actualComponentsFile.parent");
            Path path4 = path3;
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(path4, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"Files.createDirectories(this, *attributes)");
            Path path5 = this.actualComponentsFile;
            Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"actualComponentsFile");
            PathsKt.writeText$default((Path)path5, (CharSequence)CollectionsKt.joinToString$default((Iterable)values.getComponents(), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
        }
    }

    @Override
    public boolean isCompatible(@NotNull CompositeLookupsCacheAttributes actual, @NotNull CompositeLookupsCacheAttributes expected) {
        Intrinsics.checkNotNullParameter((Object)actual, (String)"actual");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        return actual.getVersion() == expected.getVersion() && actual.getComponents().containsAll((Collection)expected.getComponents());
    }

    @TestOnly
    @NotNull
    public final CacheVersionManager getVersionManagerForTesting() {
        return this.versionManager;
    }

    public CompositeLookupsCacheAttributesManager(@NotNull Path rootPath, @NotNull Set<String> expectedComponents) {
        CompositeLookupsCacheAttributes compositeLookupsCacheAttributes;
        Intrinsics.checkNotNullParameter((Object)rootPath, (String)"rootPath");
        Intrinsics.checkNotNullParameter(expectedComponents, (String)"expectedComponents");
        Collection collection = expectedComponents;
        boolean bl = false;
        this.versionManager = LookupsKt.lookupsCacheVersionManager(rootPath, !collection.isEmpty());
        this.actualComponentsFile = rootPath.resolve("components.txt");
        if (expectedComponents.isEmpty()) {
            compositeLookupsCacheAttributes = null;
        } else {
            CacheVersion cacheVersion = this.versionManager.getExpected();
            Intrinsics.checkNotNull((Object)cacheVersion);
            compositeLookupsCacheAttributes = new CompositeLookupsCacheAttributes(cacheVersion.getIntValue(), expectedComponents);
        }
        this.expected = compositeLookupsCacheAttributes;
    }
}

