/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.concurrent.CompletionStage;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractAssert;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.AssertDelegateTarget;
import org.assertj.core.api.AssertFactory;
import org.assertj.core.api.AssertProvider;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.CharSequenceAssert;
import org.assertj.core.api.ClassBasedNavigableIterableAssert;
import org.assertj.core.api.ClassBasedNavigableListAssert;
import org.assertj.core.api.CompletableFutureAssert;
import org.assertj.core.api.DoublePredicateAssert;
import org.assertj.core.api.FactoryBasedNavigableIterableAssert;
import org.assertj.core.api.FactoryBasedNavigableListAssert;
import org.assertj.core.api.GenericComparableAssert;
import org.assertj.core.api.IntPredicateAssert;
import org.assertj.core.api.IterableAssert;
import org.assertj.core.api.IteratorAssert;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.LongPredicateAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.PathAssert;
import org.assertj.core.api.PredicateAssert;
import org.assertj.core.api.SpliteratorAssert;
import org.assertj.core.util.CheckReturnValue;

@CheckReturnValue
public class AssertionsForInterfaceTypes
extends AssertionsForClassTypes {
    public static <T> T assertThat(AssertProvider<T> component) {
        return component.assertThat();
    }

    protected AssertionsForInterfaceTypes() {
    }

    public static AbstractCharSequenceAssert<?, ? extends CharSequence> assertThat(CharSequence actual) {
        return new CharSequenceAssert(actual);
    }

    public static <ELEMENT> IterableAssert<ELEMENT> assertThat(Iterable<? extends ELEMENT> actual) {
        return new IterableAssert<ELEMENT>(actual);
    }

    public static <ELEMENT> IteratorAssert<ELEMENT> assertThat(Iterator<? extends ELEMENT> actual) {
        return new IteratorAssert<ELEMENT>(actual);
    }

    public static <ELEMENT> ListAssert<ELEMENT> assertThat(List<? extends ELEMENT> actual) {
        return new ListAssert<ELEMENT>(actual);
    }

    public static <ELEMENT> ListAssert<ELEMENT> assertThat(Stream<? extends ELEMENT> actual) {
        return new ListAssert<ELEMENT>(actual);
    }

    public static ListAssert<Double> assertThat(DoubleStream actual) {
        return new ListAssert<Double>(actual);
    }

    public static ListAssert<Long> assertThat(LongStream actual) {
        return new ListAssert<Long>(actual);
    }

    public static ListAssert<Integer> assertThat(IntStream actual) {
        return new ListAssert<Integer>(actual);
    }

    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(Iterable<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return new FactoryBasedNavigableIterableAssert(actual, FactoryBasedNavigableIterableAssert.class, assertFactory);
    }

    public static <ACTUAL extends Iterable<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableIterableAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(ACTUAL actual, Class<ELEMENT_ASSERT> assertClass) {
        return new ClassBasedNavigableIterableAssert(actual, ClassBasedNavigableIterableAssert.class, assertClass);
    }

    public static <ACTUAL extends List<? extends ELEMENT>, ELEMENT, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> FactoryBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, AssertFactory<ELEMENT, ELEMENT_ASSERT> assertFactory) {
        return new FactoryBasedNavigableListAssert(actual, FactoryBasedNavigableListAssert.class, assertFactory);
    }

    public static <ELEMENT, ACTUAL extends List<? extends ELEMENT>, ELEMENT_ASSERT extends AbstractAssert<ELEMENT_ASSERT, ELEMENT>> ClassBasedNavigableListAssert<?, ACTUAL, ELEMENT, ELEMENT_ASSERT> assertThat(List<? extends ELEMENT> actual, Class<ELEMENT_ASSERT> assertClass) {
        return new ClassBasedNavigableListAssert(actual, assertClass);
    }

    public static AbstractPathAssert<?> assertThat(Path actual) {
        return new PathAssert(actual);
    }

    public static <K, V> MapAssert<K, V> assertThat(Map<K, V> actual) {
        return new MapAssert<K, V>(actual);
    }

    public static <T extends Comparable<? super T>> AbstractComparableAssert<?, T> assertThat(T actual) {
        return new GenericComparableAssert<T>(actual);
    }

    public static <T extends AssertDelegateTarget> T assertThat(T assertion) {
        return assertion;
    }

    public static <T> PredicateAssert<T> assertThat(Predicate<T> actual) {
        return new PredicateAssert<T>(actual);
    }

    public static IntPredicateAssert assertThat(IntPredicate actual) {
        return new IntPredicateAssert(actual);
    }

    public static LongPredicateAssert assertThat(LongPredicate actual) {
        return new LongPredicateAssert(actual);
    }

    public static DoublePredicateAssert assertThat(DoublePredicate actual) {
        return new DoublePredicateAssert(actual);
    }

    public static <RESULT> CompletableFutureAssert<RESULT> assertThat(CompletionStage<RESULT> actual) {
        return new CompletableFutureAssert<RESULT>(actual);
    }

    public static <ELEMENT> SpliteratorAssert<ELEMENT> assertThat(Spliterator<ELEMENT> actual) {
        return new SpliteratorAssert<ELEMENT>(actual);
    }
}

