/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.intelliLang.inject;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.util.FileContentUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.intellij.plugins.intelliLang.Configuration;
import org.intellij.plugins.intelliLang.IntelliLangBundle;
import org.intellij.plugins.intelliLang.inject.InjectorUtils;
import org.intellij.plugins.intelliLang.inject.LanguageInjectionSupport;
import org.intellij.plugins.intelliLang.references.InjectedReferencesContributor;
import org.jetbrains.annotations.NotNull;

public final class UnInjectLanguageAction
implements IntentionAction,
LowPriorityAction {
    @NotNull
    public String getText() {
        String string = IntelliLangBundle.message("intelliLang.uninject.language.action.text", new Object[0]);
        if (string == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        int offset;
        PsiFile element;
        if (project == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(2);
        }
        if ((element = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)(offset = editor.getCaretModel().getOffset()))) == null) {
            return InjectedReferencesContributor.isInjected(file.findReferenceAt(offset));
        }
        return element.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT) != null;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            UnInjectLanguageAction.$$$reportNull$$$0(3);
        }
        ApplicationManager.getApplication().runReadAction(() -> UnInjectLanguageAction.invokeImpl(project, editor, file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeImpl(Project project, Editor editor, PsiFile file) {
        int offset = editor.getCaretModel().getOffset();
        PsiFile psiFile = InjectedLanguageUtil.findInjectedPsiNoCommit((PsiFile)file, (int)offset);
        if (psiFile == null) {
            PsiElement element;
            LanguageInjectionSupport support;
            PsiReference reference = file.findReferenceAt(offset);
            if (reference == null) {
                return;
            }
            if (reference.getElement() instanceof PsiLanguageInjectionHost) {
                PsiLanguageInjectionHost host = (PsiLanguageInjectionHost)reference.getElement();
                for (LanguageInjectionSupport support2 : InjectorUtils.getActiveInjectionSupports()) {
                    if (!support2.isApplicableTo(host) || !support2.removeInjectionInPlace(host)) continue;
                    PsiManager.getInstance((Project)project).dropPsiCaches();
                    return;
                }
            }
            if ((support = (LanguageInjectionSupport)(element = reference.getElement()).getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT)) != null && support.removeInjection(element)) {
                PsiManager.getInstance((Project)project).dropPsiCaches();
            }
            return;
        }
        PsiLanguageInjectionHost host = InjectedLanguageManager.getInstance((Project)project).getInjectionHost((PsiElement)psiFile);
        if (host == null) {
            return;
        }
        LanguageInjectionSupport support = (LanguageInjectionSupport)psiFile.getUserData(LanguageInjectionSupport.INJECTOR_SUPPORT);
        if (support == null) {
            return;
        }
        try {
            if (!support.removeInjectionInPlace(host)) {
                UnInjectLanguageAction.defaultFunctionalityWorked(host);
            }
        }
        finally {
            FileContentUtil.reparseFiles((Project)project, Collections.emptyList(), (boolean)true);
        }
    }

    private static boolean defaultFunctionalityWorked(PsiLanguageInjectionHost host) {
        HashSet<String> languages = new HashSet<String>();
        List files = InjectedLanguageManager.getInstance((Project)host.getProject()).getInjectedPsiFiles((PsiElement)host);
        if (files == null) {
            return false;
        }
        for (Pair pair : files) {
            for (Language lang = ((PsiElement)pair.first).getLanguage(); lang != null; lang = lang.getBaseLanguage()) {
                languages.add(lang.getID());
            }
        }
        return Configuration.getProjectInstance(host.getProject()).setHostInjectionEnabled(host, languages, false);
    }

    public boolean startInWriteAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/intelliLang/inject/UnInjectLanguageAction";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/intelliLang/inject/UnInjectLanguageAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

