/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.javac;

import com.google.protobuf.ByteString;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.javac.JavacRemoteProto;
import org.jetbrains.jps.javac.ModulePath;
import org.jetbrains.jps.javac.OutputFileObject;

public final class JavacProtoUtil {
    public static JavacRemoteProto.Message.Request createCancelRequest() {
        return (JavacRemoteProto.Message.Request)JavacRemoteProto.Message.Request.newBuilder().setRequestType(JavacRemoteProto.Message.Request.Type.CANCEL).build();
    }

    public static JavacRemoteProto.Message.Request createShutdownRequest() {
        return (JavacRemoteProto.Message.Request)JavacRemoteProto.Message.Request.newBuilder().setRequestType(JavacRemoteProto.Message.Request.Type.SHUTDOWN).build();
    }

    public static JavacRemoteProto.Message.Request createCompilationRequest(Iterable<String> options, Iterable<? extends File> files, Iterable<? extends File> classpath, Iterable<? extends File> platformCp, ModulePath modulePath, Iterable<? extends File> upgradeModulePath, Iterable<? extends File> sourcePath, Map<File, Set<File>> outs) {
        JavacRemoteProto.Message.Request.Builder builder = JavacRemoteProto.Message.Request.newBuilder();
        builder.setRequestType(JavacRemoteProto.Message.Request.Type.COMPILE);
        builder.addAllOption(options);
        for (File file : files) {
            builder.addFile(FileUtilRt.toSystemIndependentName((String)file.getPath()));
        }
        for (File file : classpath) {
            builder.addClasspath(FileUtilRt.toSystemIndependentName((String)file.getPath()));
        }
        for (File file : platformCp) {
            builder.addPlatformClasspath(FileUtilRt.toSystemIndependentName((String)file.getPath()));
        }
        for (File file : modulePath.getPath()) {
            String pathEntry = FileUtilRt.toSystemIndependentName((String)file.getPath());
            builder.addModulePath(pathEntry);
            String moduleName = modulePath.getModuleName(file);
            if (moduleName == null) continue;
            builder.putModuleNames(pathEntry, moduleName);
        }
        for (File file : upgradeModulePath) {
            builder.addUpgradeModulePath(FileUtilRt.toSystemIndependentName((String)file.getPath()));
        }
        for (File file : sourcePath) {
            builder.addSourcepath(FileUtilRt.toSystemIndependentName((String)file.getPath()));
        }
        for (Map.Entry entry : outs.entrySet()) {
            JavacRemoteProto.Message.Request.OutputGroup.Builder groupBuilder = JavacRemoteProto.Message.Request.OutputGroup.newBuilder();
            groupBuilder.setOutputRoot(FileUtilRt.toSystemIndependentName((String)((File)entry.getKey()).getPath()));
            for (File srcRoot : (Set)entry.getValue()) {
                groupBuilder.addSourceRoot(FileUtilRt.toSystemIndependentName((String)srcRoot.getPath()));
            }
            builder.addOutput((JavacRemoteProto.Message.Request.OutputGroup)groupBuilder.build());
        }
        return (JavacRemoteProto.Message.Request)builder.build();
    }

    public static JavacRemoteProto.Message.Response createOutputObjectResponse(OutputFileObject fileObject) {
        String relativePath;
        File outputRoot;
        String className;
        JavacRemoteProto.Message.Response.OutputObject.Builder msgBuilder = JavacRemoteProto.Message.Response.OutputObject.newBuilder();
        msgBuilder.setKind(JavacProtoUtil.convertKind(fileObject.getKind()));
        msgBuilder.setFilePath(FileUtilRt.toSystemIndependentName((String)fileObject.getFile().getPath()));
        msgBuilder.setIsGenerated(fileObject.isGenerated());
        BinaryContent content = fileObject.getContent();
        if (content != null) {
            msgBuilder.setContent(ByteString.copyFrom((byte[])content.getBuffer(), (int)content.getOffset(), (int)content.getLength()));
        }
        if ((className = fileObject.getClassName()) != null) {
            msgBuilder.setClassName(className);
        }
        if ((outputRoot = fileObject.getOutputRoot()) != null) {
            msgBuilder.setOutputRoot(FileUtilRt.toSystemIndependentName((String)outputRoot.getPath()));
        }
        if ((relativePath = fileObject.getRelativePath()) != null) {
            msgBuilder.setRelativePath(relativePath);
        }
        for (URI uri : fileObject.getSourceUris()) {
            msgBuilder.addSourceUri(uri.toString());
        }
        JavaFileManager.Location location = fileObject.getLocation();
        if (location != null) {
            msgBuilder.setLocation(location.getName());
        }
        JavacRemoteProto.Message.Response.Builder builder = JavacRemoteProto.Message.Response.newBuilder();
        builder.setResponseType(JavacRemoteProto.Message.Response.Type.OUTPUT_OBJECT).setOutputObject((JavacRemoteProto.Message.Response.OutputObject)msgBuilder.build());
        return (JavacRemoteProto.Message.Response)builder.build();
    }

    public static JavacRemoteProto.Message.Response createCustomDataResponse(String pluginId, String dataName, byte[] data) {
        JavacRemoteProto.Message.Response.OutputObject outObjMsg = (JavacRemoteProto.Message.Response.OutputObject)JavacRemoteProto.Message.Response.OutputObject.newBuilder().setKind(JavacRemoteProto.Message.Response.OutputObject.Kind.OTHER).setIsGenerated(false).setFilePath(pluginId).setClassName(dataName).setContent(ByteString.copyFrom((byte[])data)).build();
        return (JavacRemoteProto.Message.Response)JavacRemoteProto.Message.Response.newBuilder().setResponseType(JavacRemoteProto.Message.Response.Type.CUSTOM_OUTPUT_OBJECT).setOutputObject(outObjMsg).build();
    }

    public static JavacRemoteProto.Message.Response createSourceFileLoadedResponse(File srcFile) {
        JavacRemoteProto.Message.Response.OutputObject outObjMsg = (JavacRemoteProto.Message.Response.OutputObject)JavacRemoteProto.Message.Response.OutputObject.newBuilder().setKind(JavacProtoUtil.convertKind(JavaFileObject.Kind.SOURCE)).setIsGenerated(false).setFilePath(FileUtilRt.toSystemIndependentName((String)srcFile.getPath())).build();
        JavacRemoteProto.Message.Response.Builder builder = JavacRemoteProto.Message.Response.newBuilder();
        builder.setResponseType(JavacRemoteProto.Message.Response.Type.SRC_FILE_LOADED).setOutputObject(outObjMsg);
        return (JavacRemoteProto.Message.Response)builder.build();
    }

    public static JavacRemoteProto.Message.Response createClassDataResponse(String className, Collection<String> imports, Collection<String> staticImports) {
        JavacRemoteProto.Message.Response.ClassData.Builder msgBuilder = JavacRemoteProto.Message.Response.ClassData.newBuilder();
        msgBuilder.setClassName(className);
        if (!imports.isEmpty()) {
            msgBuilder.addAllImportStatement(imports);
        }
        if (!staticImports.isEmpty()) {
            msgBuilder.addAllStaticImport(imports);
        }
        JavacRemoteProto.Message.Response.Builder builder = JavacRemoteProto.Message.Response.newBuilder();
        builder.setResponseType(JavacRemoteProto.Message.Response.Type.CLASS_DATA).setClassData((JavacRemoteProto.Message.Response.ClassData)msgBuilder.build());
        return (JavacRemoteProto.Message.Response)builder.build();
    }

    public static JavacRemoteProto.Message.Response createStdOutputResponse(String text) {
        JavacRemoteProto.Message.Response.CompileMessage.Builder msgBuilder = JavacRemoteProto.Message.Response.CompileMessage.newBuilder();
        msgBuilder.setKind(JavacRemoteProto.Message.Response.CompileMessage.Kind.STD_OUT);
        msgBuilder.setText(text);
        JavacRemoteProto.Message.Response.Builder builder = JavacRemoteProto.Message.Response.newBuilder();
        builder.setResponseType(JavacRemoteProto.Message.Response.Type.BUILD_MESSAGE).setCompileMessage((JavacRemoteProto.Message.Response.CompileMessage)msgBuilder.build());
        return (JavacRemoteProto.Message.Response)builder.build();
    }

    public static JavacRemoteProto.Message.Response createBuildMessageResponse(Diagnostic<? extends JavaFileObject> diagnostic) {
        JavacRemoteProto.Message.Response.CompileMessage.Builder msgBuilder = JavacRemoteProto.Message.Response.CompileMessage.newBuilder();
        msgBuilder.setKind(JavacProtoUtil.convertKind(diagnostic.getKind()));
        msgBuilder.setText(diagnostic.getMessage(Locale.US));
        JavaFileObject source = diagnostic.getSource();
        URI srcUri = null;
        try {
            srcUri = source != null ? source.toUri() : null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (srcUri != null) {
            msgBuilder.setSourceUri(srcUri.toString());
        }
        msgBuilder.setLine(diagnostic.getLineNumber());
        msgBuilder.setColumn(diagnostic.getColumnNumber());
        msgBuilder.setProblemBeginOffset(diagnostic.getStartPosition());
        msgBuilder.setProblemEndOffset(diagnostic.getEndPosition());
        msgBuilder.setProblemLocationOffset(diagnostic.getPosition());
        JavacRemoteProto.Message.Response.Builder builder = JavacRemoteProto.Message.Response.newBuilder();
        builder.setResponseType(JavacRemoteProto.Message.Response.Type.BUILD_MESSAGE).setCompileMessage((JavacRemoteProto.Message.Response.CompileMessage)msgBuilder.build());
        return (JavacRemoteProto.Message.Response)builder.build();
    }

    public static JavacRemoteProto.Message.Response createRequestAckResponse() {
        return (JavacRemoteProto.Message.Response)JavacRemoteProto.Message.Response.newBuilder().setResponseType(JavacRemoteProto.Message.Response.Type.REQUEST_ACK).build();
    }

    public static JavacRemoteProto.Message.Response createBuildCompletedResponse(boolean code) {
        JavacRemoteProto.Message.Response.Builder builder = JavacRemoteProto.Message.Response.newBuilder();
        builder.setResponseType(JavacRemoteProto.Message.Response.Type.BUILD_COMPLETED).setCompletionStatus(code);
        return (JavacRemoteProto.Message.Response)builder.build();
    }

    public static JavacRemoteProto.Message.Failure createFailure(String description, @Nullable Throwable ex) {
        JavacRemoteProto.Message.Failure.Builder builder = JavacRemoteProto.Message.Failure.newBuilder();
        builder.setDescription(description);
        if (ex != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ex.printStackTrace(new PrintStream(baos));
            builder.setStacktrace(new String(baos.toByteArray()));
        }
        return (JavacRemoteProto.Message.Failure)builder.build();
    }

    public static JavacRemoteProto.Message toMessage(UUID requestId, JavacRemoteProto.Message.Request request) {
        return (JavacRemoteProto.Message)JavacRemoteProto.Message.newBuilder().setMessageType(JavacRemoteProto.Message.Type.REQUEST).setSessionId(JavacProtoUtil.toProtoUUID(requestId)).setRequest(request).build();
    }

    public static JavacRemoteProto.Message toMessage(UUID requestId, JavacRemoteProto.Message.Response response) {
        return (JavacRemoteProto.Message)JavacRemoteProto.Message.newBuilder().setMessageType(JavacRemoteProto.Message.Type.RESPONSE).setSessionId(JavacProtoUtil.toProtoUUID(requestId)).setResponse(response).build();
    }

    public static JavacRemoteProto.Message toMessage(UUID requestId, JavacRemoteProto.Message.Failure failure) {
        return (JavacRemoteProto.Message)JavacRemoteProto.Message.newBuilder().setMessageType(JavacRemoteProto.Message.Type.FAILURE).setSessionId(JavacProtoUtil.toProtoUUID(requestId)).setFailure(failure).build();
    }

    public static JavacRemoteProto.Message.UUID toProtoUUID(UUID requestId) {
        return (JavacRemoteProto.Message.UUID)JavacRemoteProto.Message.UUID.newBuilder().setMostSigBits(requestId.getMostSignificantBits()).setLeastSigBits(requestId.getLeastSignificantBits()).build();
    }

    public static UUID fromProtoUUID(JavacRemoteProto.Message.UUID requestId) {
        return new UUID(requestId.getMostSigBits(), requestId.getLeastSigBits());
    }

    private static JavacRemoteProto.Message.Response.OutputObject.Kind convertKind(JavaFileObject.Kind kind) {
        switch (kind) {
            case CLASS: {
                return JavacRemoteProto.Message.Response.OutputObject.Kind.CLASS;
            }
            case SOURCE: {
                return JavacRemoteProto.Message.Response.OutputObject.Kind.SOURCE;
            }
            case HTML: {
                return JavacRemoteProto.Message.Response.OutputObject.Kind.HTML;
            }
        }
        return JavacRemoteProto.Message.Response.OutputObject.Kind.OTHER;
    }

    private static JavacRemoteProto.Message.Response.CompileMessage.Kind convertKind(Diagnostic.Kind kind) {
        switch (kind) {
            case ERROR: {
                return JavacRemoteProto.Message.Response.CompileMessage.Kind.ERROR;
            }
            case MANDATORY_WARNING: {
                return JavacRemoteProto.Message.Response.CompileMessage.Kind.MANDATORY_WARNING;
            }
            case WARNING: {
                return JavacRemoteProto.Message.Response.CompileMessage.Kind.WARNING;
            }
            case NOTE: {
                return JavacRemoteProto.Message.Response.CompileMessage.Kind.NOTE;
            }
        }
        return JavacRemoteProto.Message.Response.CompileMessage.Kind.OTHER;
    }
}

