/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.api;

import com.intellij.openapi.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.api.CmdlineRemoteProto;
import org.jetbrains.jps.builders.BuildTargetType;
import org.jetbrains.jps.builders.java.JavaModuleBuildTargetType;
import org.jetbrains.jps.incremental.messages.BuildMessage;

public final class CmdlineProtoUtil {
    public static CmdlineRemoteProto.Message.ControllerMessage createUpToDateCheckRequest(String project, List<? extends CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, Collection<String> paths, Map<String, String> userData, CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals, @Nullable CmdlineRemoteProto.Message.ControllerMessage.FSEvent event) {
        return CmdlineProtoUtil.createBuildParametersMessage(CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.Type.UP_TO_DATE_CHECK, project, scopes, userData, paths, globals, event);
    }

    public static CmdlineRemoteProto.Message.ControllerMessage createBuildRequest(@NotNull String project, List<? extends CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, Collection<String> paths, Map<String, String> userData, CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals, @Nullable CmdlineRemoteProto.Message.ControllerMessage.FSEvent event) {
        if (project == null) {
            CmdlineProtoUtil.$$$reportNull$$$0(0);
        }
        return CmdlineProtoUtil.createBuildParametersMessage(CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.Type.BUILD, project, scopes, userData, paths, globals, event);
    }

    public static List<CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> createAllModulesScopes(boolean forceBuild) {
        return Arrays.asList(CmdlineProtoUtil.createAllTargetsScope(JavaModuleBuildTargetType.PRODUCTION, forceBuild), CmdlineProtoUtil.createAllTargetsScope(JavaModuleBuildTargetType.TEST, forceBuild));
    }

    public static CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope createAllTargetsScope(BuildTargetType<?> type, boolean forceBuild) {
        return (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope)CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(type.getTypeId()).setAllTargets(true).setForceBuild(forceBuild).build();
    }

    public static CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope createTargetsScope(String targetTypeId, List<String> targetIds, boolean forceBuild) {
        return (CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope)CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope.newBuilder().setTypeId(targetTypeId).setForceBuild(forceBuild).addAllTargetId(targetIds).build();
    }

    private static CmdlineRemoteProto.Message.ControllerMessage createBuildParametersMessage(CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.Type buildType, @NotNull String project, List<? extends CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.TargetTypeBuildScope> scopes, Map<String, String> userData, Collection<String> paths, CmdlineRemoteProto.Message.ControllerMessage.GlobalSettings globals, @Nullable CmdlineRemoteProto.Message.ControllerMessage.FSEvent initialEvent) {
        if (project == null) {
            CmdlineProtoUtil.$$$reportNull$$$0(1);
        }
        CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.Builder builder = CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage.newBuilder();
        builder.setGlobalSettings(globals);
        builder.setBuildType(buildType);
        builder.setProjectId(project);
        builder.addAllScope(scopes);
        if (!userData.isEmpty()) {
            for (Map.Entry<String, String> entry : userData.entrySet()) {
                String key = entry.getKey();
                String value = entry.getValue();
                if (key == null || value == null) continue;
                builder.addBuilderParameter(CmdlineProtoUtil.createPair(key, value));
            }
        }
        if (!paths.isEmpty()) {
            builder.addAllFilePath(paths);
        }
        CmdlineRemoteProto.Message.ControllerMessage.Builder controlMessageBuilder = CmdlineRemoteProto.Message.ControllerMessage.newBuilder();
        if (initialEvent != null) {
            controlMessageBuilder.setFsEvent(initialEvent);
        }
        return (CmdlineRemoteProto.Message.ControllerMessage)controlMessageBuilder.setType(CmdlineRemoteProto.Message.ControllerMessage.Type.BUILD_PARAMETERS).setParamsMessage((CmdlineRemoteProto.Message.ControllerMessage.ParametersMessage)builder.build()).build();
    }

    public static CmdlineRemoteProto.Message.KeyValuePair createPair(String key, String value) {
        return (CmdlineRemoteProto.Message.KeyValuePair)CmdlineRemoteProto.Message.KeyValuePair.newBuilder().setKey(key).setValue(value).build();
    }

    public static CmdlineRemoteProto.Message.Failure createFailure(@Nls(capitalization=Nls.Capitalization.Sentence) String description, @Nullable Throwable cause) {
        CmdlineRemoteProto.Message.Failure.Builder builder = CmdlineRemoteProto.Message.Failure.newBuilder();
        if (description != null) {
            builder.setDescription(description);
        }
        if (cause != null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (PrintStream stream = new PrintStream(baos);){
                cause.printStackTrace(stream);
            }
            String stacktrace = new String(baos.toByteArray(), StandardCharsets.UTF_8);
            builder.setStacktrace(stacktrace);
            if (description == null) {
                builder.setDescription(stacktrace);
            }
        }
        return (CmdlineRemoteProto.Message.Failure)builder.build();
    }

    public static CmdlineRemoteProto.Message.ControllerMessage createCancelCommand() {
        return (CmdlineRemoteProto.Message.ControllerMessage)CmdlineRemoteProto.Message.ControllerMessage.newBuilder().setType(CmdlineRemoteProto.Message.ControllerMessage.Type.CANCEL_BUILD_COMMAND).build();
    }

    public static CmdlineRemoteProto.Message.BuilderMessage createCompileProgressMessageResponse(@Nls(capitalization=Nls.Capitalization.Sentence) String text) {
        return CmdlineProtoUtil.createCompileMessage(BuildMessage.Kind.PROGRESS, text, null, -1L, -1L, -1L, -1L, -1L, -1.0f, Collections.emptyList());
    }

    public static CmdlineRemoteProto.Message.BuilderMessage createCompileProgressMessageResponse(@Nls(capitalization=Nls.Capitalization.Sentence) String text, float done) {
        return CmdlineProtoUtil.createCompileMessage(BuildMessage.Kind.PROGRESS, text, null, -1L, -1L, -1L, -1L, -1L, done, Collections.emptyList());
    }

    public static CmdlineRemoteProto.Message.BuilderMessage createCompileMessage(BuildMessage.Kind kind, @Nls(capitalization=Nls.Capitalization.Sentence) String text, String path, long beginOffset, long endOffset, long offset, long line, long column, float done, Collection<String> moduleNames) {
        CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Builder builder = CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.newBuilder();
        switch (kind) {
            case ERROR: {
                builder.setKind(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.ERROR);
                break;
            }
            case WARNING: {
                builder.setKind(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.WARNING);
                break;
            }
            case INFO: {
                builder.setKind(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.INFO);
                break;
            }
            case JPS_INFO: {
                builder.setKind(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.JPS_INFO);
                break;
            }
            case INTERNAL_BUILDER_ERROR: {
                builder.setKind(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.INTERNAL_BUILDER_ERROR);
                break;
            }
            case OTHER: {
                builder.setKind(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.OTHER);
                break;
            }
            default: {
                builder.setKind(CmdlineRemoteProto.Message.BuilderMessage.CompileMessage.Kind.PROGRESS);
            }
        }
        if (text != null) {
            builder.setText(text);
        }
        if (path != null) {
            builder.setSourceFilePath(path);
        }
        if (beginOffset >= 0L) {
            builder.setProblemBeginOffset(beginOffset);
        }
        if (endOffset >= 0L) {
            builder.setProblemEndOffset(endOffset);
        }
        if (offset >= 0L) {
            builder.setProblemLocationOffset(offset);
        }
        if (line >= 0L) {
            builder.setLine(line);
        }
        if (column >= 0L) {
            builder.setColumn(column);
        }
        if (done >= 0.0f) {
            builder.setDone(done);
        }
        if (!moduleNames.isEmpty()) {
            builder.addAllModuleNames(moduleNames);
        }
        return (CmdlineRemoteProto.Message.BuilderMessage)CmdlineRemoteProto.Message.BuilderMessage.newBuilder().setType(CmdlineRemoteProto.Message.BuilderMessage.Type.COMPILE_MESSAGE).setCompileMessage((CmdlineRemoteProto.Message.BuilderMessage.CompileMessage)builder.build()).build();
    }

    public static CmdlineRemoteProto.Message.BuilderMessage createCustomBuilderMessage(String builderId, String messageType, String messageText) {
        CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage builderMessage = (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage)CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage.newBuilder().setBuilderId(builderId).setMessageType(messageType).setMessageText(messageText).build();
        return CmdlineProtoUtil.createBuildEvent(CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type.CUSTOM_BUILDER_MESSAGE, null, null, null, builderMessage);
    }

    public static CmdlineRemoteProto.Message.BuilderMessage createBuildCompletedEvent(@Nullable String description, CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status) {
        return CmdlineProtoUtil.createBuildEvent(CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type.BUILD_COMPLETED, description, status, null, null);
    }

    public static CmdlineRemoteProto.Message.BuilderMessage createFileGeneratedEvent(Collection<? extends Pair<String, String>> paths) {
        return CmdlineProtoUtil.createBuildEvent(CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type.FILES_GENERATED, null, null, paths, null);
    }

    private static CmdlineRemoteProto.Message.BuilderMessage createBuildEvent(CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Type type, @Nullable String description, @Nullable CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Status status, @Nullable Collection<? extends Pair<String, String>> generatedPaths, @Nullable CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.CustomBuilderMessage builderMessage) {
        CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.Builder builder = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.newBuilder().setEventType(type);
        if (description != null) {
            builder.setDescription(description);
        }
        if (status != null) {
            builder.setCompletionStatus(status);
        }
        if (generatedPaths != null) {
            for (Pair<String, String> pair : generatedPaths) {
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile.Builder fileBuilder = CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile.newBuilder();
                CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile generatedFile = (CmdlineRemoteProto.Message.BuilderMessage.BuildEvent.GeneratedFile)fileBuilder.setOutputRoot((String)pair.first).setRelativePath((String)pair.second).build();
                builder.addGeneratedFiles(generatedFile);
            }
        }
        if (builderMessage != null) {
            builder.setCustomBuilderMessage(builderMessage);
        }
        return (CmdlineRemoteProto.Message.BuilderMessage)CmdlineRemoteProto.Message.BuilderMessage.newBuilder().setType(CmdlineRemoteProto.Message.BuilderMessage.Type.BUILD_EVENT).setBuildEvent((CmdlineRemoteProto.Message.BuilderMessage.BuildEvent)builder.build()).build();
    }

    public static CmdlineRemoteProto.Message.BuilderMessage createParamRequest() {
        return (CmdlineRemoteProto.Message.BuilderMessage)CmdlineRemoteProto.Message.BuilderMessage.newBuilder().setType(CmdlineRemoteProto.Message.BuilderMessage.Type.PARAM_REQUEST).build();
    }

    public static CmdlineRemoteProto.Message toMessage(UUID sessionId, CmdlineRemoteProto.Message.BuilderMessage builderMessage) {
        return (CmdlineRemoteProto.Message)CmdlineRemoteProto.Message.newBuilder().setSessionId(CmdlineProtoUtil.toProtoUUID(sessionId)).setType(CmdlineRemoteProto.Message.Type.BUILDER_MESSAGE).setBuilderMessage(builderMessage).build();
    }

    public static CmdlineRemoteProto.Message toMessage(UUID sessionId, CmdlineRemoteProto.Message.ControllerMessage builderMessage) {
        return (CmdlineRemoteProto.Message)CmdlineRemoteProto.Message.newBuilder().setSessionId(CmdlineProtoUtil.toProtoUUID(sessionId)).setType(CmdlineRemoteProto.Message.Type.CONTROLLER_MESSAGE).setControllerMessage(builderMessage).build();
    }

    public static CmdlineRemoteProto.Message toMessage(UUID sessionId, CmdlineRemoteProto.Message.Failure failure) {
        return (CmdlineRemoteProto.Message)CmdlineRemoteProto.Message.newBuilder().setSessionId(CmdlineProtoUtil.toProtoUUID(sessionId)).setType(CmdlineRemoteProto.Message.Type.FAILURE).setFailure(failure).build();
    }

    private static CmdlineRemoteProto.Message.UUID toProtoUUID(UUID sessionId) {
        CmdlineRemoteProto.Message.UUID.Builder uuidBuilder = CmdlineRemoteProto.Message.UUID.newBuilder();
        return (CmdlineRemoteProto.Message.UUID)uuidBuilder.setMostSigBits(sessionId.getMostSignificantBits()).setLeastSigBits(sessionId.getLeastSignificantBits()).build();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "project";
        objectArray2[1] = "org/jetbrains/jps/api/CmdlineProtoUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuildRequest";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createBuildParametersMessage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

