/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns;

import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.TargetModules;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.UiPackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.versions.NormalizedPackageVersion;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.PackagesTableItem;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.editors.PackageVersionTableCellEditor;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packages.columns.renderers.PackageVersionTableCellRenderer;
import java.util.Collection;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00030\u0001BE\u0012>\u0010\u0004\u001a:\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005\u00a2\u0006\u0002\u0010\fJ\u0014\u0010\u0015\u001a\u00020\u00162\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0014\u0010\u0018\u001a\u00020\u00192\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016J\u0016\u0010\u001a\u001a\u00020\u00122\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0002H\u0016J$\u0010\u001b\u001a\u00020\u000b2\f\u0010\u0017\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00022\f\u0010\u001c\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0003H\u0016J\u0016\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u0018\u0010\u001e\u001a\u0006\u0012\u0002\b\u00030\u00032\n\u0010\u0017\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0016R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000RF\u0010\u0004\u001a:\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\u0003\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\u0017\u0012\u0015\u0012\u0002\b\u00030\t\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/VersionColumn;", "Lcom/intellij/util/ui/ColumnInfo;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/PackagesTableItem;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/UiPackageModel;", "versionSetter", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "uiPackageModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/versions/NormalizedPackageVersion;", "newVersion", "", "(Lkotlin/jvm/functions/Function2;)V", "cellEditor", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/editors/PackageVersionTableCellEditor;", "cellRenderer", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packages/columns/renderers/PackageVersionTableCellRenderer;", "onlyStable", "", "targetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;", "getEditor", "Ljavax/swing/table/TableCellEditor;", "item", "getRenderer", "Ljavax/swing/table/TableCellRenderer;", "isCellEditable", "setValue", "value", "updateData", "valueOf", "intellij.packageSearch"})
public final class VersionColumn
extends ColumnInfo<PackagesTableItem<?>, UiPackageModel<?>> {
    private final PackageVersionTableCellRenderer cellRenderer;
    private final PackageVersionTableCellEditor cellEditor;
    private boolean onlyStable;
    private TargetModules targetModules;
    private final Function2<UiPackageModel<?>, NormalizedPackageVersion<?>, Unit> versionSetter;

    @NotNull
    public TableCellRenderer getRenderer(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return this.cellRenderer;
    }

    @NotNull
    public TableCellEditor getEditor(@NotNull PackagesTableItem<?> item) {
        Intrinsics.checkNotNullParameter(item, (String)"item");
        return (TableCellEditor)((Object)this.cellEditor);
    }

    public boolean isCellEditable(@Nullable PackagesTableItem<?> item) {
        boolean bl;
        Object object = item;
        if (object != null && (object = ((PackagesTableItem)object).getUiPackageModel()) != null && (object = ((UiPackageModel)object).getSortedVersions()) != null) {
            Collection collection = (Collection)object;
            boolean bl2 = false;
            bl = !collection.isEmpty();
        } else {
            bl = false;
        }
        return bl;
    }

    public final void updateData(boolean onlyStable, @NotNull TargetModules targetModules) {
        Intrinsics.checkNotNullParameter((Object)targetModules, (String)"targetModules");
        this.onlyStable = onlyStable;
        this.targetModules = targetModules;
        this.cellRenderer.updateData(onlyStable);
        this.cellEditor.updateData(onlyStable);
    }

    @NotNull
    public UiPackageModel<?> valueOf(@NotNull PackagesTableItem<?> item) {
        UiPackageModel uiPackageModel;
        Intrinsics.checkNotNullParameter(item, (String)"item");
        PackagesTableItem<?> packagesTableItem = item;
        if (packagesTableItem instanceof PackagesTableItem.InstalledPackage) {
            uiPackageModel = ((PackagesTableItem.InstalledPackage)item).getUiPackageModel();
        } else if (packagesTableItem instanceof PackagesTableItem.InstallablePackage) {
            uiPackageModel = ((PackagesTableItem.InstallablePackage)item).getUiPackageModel();
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return uiPackageModel;
    }

    public void setValue(@Nullable PackagesTableItem<?> item, @Nullable UiPackageModel<?> value) {
        NormalizedPackageVersion<?> selectedVersion;
        UiPackageModel<?> uiPackageModel = value;
        NormalizedPackageVersion<Object> normalizedPackageVersion = selectedVersion = uiPackageModel != null ? uiPackageModel.getSelectedVersion() : null;
        if (selectedVersion == null) {
            return;
        }
        PackagesTableItem<?> packagesTableItem = item;
        if (Intrinsics.areEqual(selectedVersion, packagesTableItem != null && (packagesTableItem = packagesTableItem.getUiPackageModel()) != null ? ((UiPackageModel)((Object)packagesTableItem)).getSelectedVersion() : null)) {
            return;
        }
        this.versionSetter.invoke(value, selectedVersion);
    }

    public VersionColumn(@NotNull Function2<? super UiPackageModel<?>, ? super NormalizedPackageVersion<?>, Unit> versionSetter) {
        Intrinsics.checkNotNullParameter(versionSetter, (String)"versionSetter");
        super(PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.columns.versions", new Object[0]));
        this.versionSetter = versionSetter;
        this.cellRenderer = new PackageVersionTableCellRenderer();
        this.cellEditor = new PackageVersionTableCellEditor();
        this.targetModules = TargetModules.None.INSTANCE;
    }
}

