/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails;

import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.newui.ColorButton;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBFont;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.jetbrains.packagesearch.api.v2.ApiStandardPackage;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.UtilsKt;
import com.jetbrains.packagesearch.intellij.plugin.configuration.PackageSearchGeneralConfiguration;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUI;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.KnownRepositories;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.OperationExecutor;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.PackageOperations;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.RepositoryModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.TargetModules;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.UiPackageModel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageOperationType;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperation;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.HeaderLayout;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.InfoBannerPanel;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.PackageDetailsHeaderPanel$WhenMappings;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.packagedetails.PackageDetailsHeaderPanelKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.BordersKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.HtmlEditorPane;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.IntScalingExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.JComponentExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.JPopupMenuExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.ui.util.MenuAction;
import com.jetbrains.packagesearch.intellij.plugin.util.StringExtensionsKt;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.io.StringReader;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u0001.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\b\u0010!\u001a\u00020\u001eH\u0002J\b\u0010\"\u001a\u00020\u001eH\u0002J\b\u0010#\u001a\u00020\u001eH\u0002J\u0010\u0010$\u001a\u00020\u001e2\u0006\u0010%\u001a\u00020&H\u0002J\u0012\u0010'\u001a\u00020\u001e2\b\u0010(\u001a\u0004\u0018\u00010)H\u0002J\b\u0010*\u001a\u00020+H\u0002J\f\u0010,\u001a\u00020-*\u00020-H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0014\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001a\u001a\u0014\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/PackageDetailsHeaderPanel;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "operationExecutor", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/OperationExecutor;", "(Lcom/intellij/openapi/project/Project;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/OperationExecutor;)V", "copyMenu", "Lcom/intellij/openapi/ui/JBPopupMenu;", "copyMenuItem", "Ljavax/swing/JMenuItem;", "identifierLabel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/util/HtmlEditorPane;", "infoPanel", "Lcom/intellij/util/ui/components/BorderLayoutPanel;", "nameLabel", "overflowButton", "Lcom/intellij/openapi/actionSystem/impl/ActionButton;", "primaryActionButton", "Lcom/intellij/ide/plugins/newui/ColorButton;", "primaryOperations", "Lkotlinx/coroutines/Deferred;", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation;", "removeMenuAction", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/util/MenuAction;", "removeOperations", "repoWarningBanner", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/InfoBannerPanel;", "display", "", "viewModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/PackageDetailsHeaderPanel$ViewModel;", "onCopyClicked", "onPrimaryActionClicked", "onRemoveClicked", "updateActions", "packageOperations", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/PackageOperations;", "updateRepoWarningBanner", "repoToInstall", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/RepositoryModel;", "willAutomaticallyAddRepo", "", "stripHtml", "", "ViewModel", "intellij.packageSearch"})
public final class PackageDetailsHeaderPanel
extends JPanel {
    private final InfoBannerPanel repoWarningBanner;
    private final HtmlEditorPane nameLabel;
    private final HtmlEditorPane identifierLabel;
    private final ColorButton primaryActionButton;
    private Deferred<? extends List<? extends PackageSearchOperation<?>>> primaryOperations;
    private final MenuAction removeMenuAction;
    private final ActionButton overflowButton;
    private Deferred<? extends List<? extends PackageSearchOperation<?>>> removeOperations;
    private final JMenuItem copyMenuItem;
    private final JBPopupMenu copyMenu;
    private final BorderLayoutPanel infoPanel;
    private final Project project;
    private final OperationExecutor operationExecutor;

    public final void display(@NotNull ViewModel viewModel) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)viewModel, (String)"viewModel");
            Object packageModel = viewModel.getUiPackageModel().getPackageModel();
            ApiStandardPackage apiStandardPackage = ((PackageModel)packageModel).getRemoteInfo();
            String name = apiStandardPackage != null ? apiStandardPackage.getName() : null;
            String rawIdentifier = viewModel.getUiPackageModel().getIdentifier-f1q_7Ec();
            if (name != null && Intrinsics.areEqual((Object)name, (Object)rawIdentifier) ^ true) {
                this.nameLabel.setBody(CollectionsKt.listOf((Object)HtmlChunk.span((String)("font-size: " + IntScalingExtensionsKt.scaledFontSize(16) + ';')).addRaw("<b>" + UtilsKt.normalizeWhitespace(((PackageModel)packageModel).getRemoteInfo().getName()) + "</b>")));
                this.identifierLabel.setBodyText(rawIdentifier);
                this.identifierLabel.setVisible(true);
            } else {
                this.nameLabel.setBody(CollectionsKt.listOf((Object)HtmlChunk.span((String)("font-size: " + IntScalingExtensionsKt.scaledFontSize(16) + ';')).addRaw("<b>" + rawIdentifier + "</b>")));
                this.identifierLabel.setText(null);
                this.identifierLabel.setVisible(false);
            }
            PackageOperations packageOperations = viewModel.getUiPackageModel().getPackageOperations();
            RepositoryModel repoToInstall = packageOperations.getRepoToAddWhenInstalling();
            this.updateRepoWarningBanner(repoToInstall);
            this.updateActions(packageOperations);
            JPopupMenu jPopupMenu = this.overflowButton.getComponentPopupMenu();
            if (jPopupMenu == null) break block2;
            jPopupMenu.setVisible(false);
        }
    }

    private final void updateRepoWarningBanner(RepositoryModel repoToInstall) {
        block1: {
            block0: {
                if (repoToInstall != null) break block0;
                this.repoWarningBanner.setVisible(false);
                break block1;
            }
            if (!this.willAutomaticallyAddRepo()) break block1;
            this.repoWarningBanner.setText(PackageSearchBundle.INSTANCE.message("packagesearch.repository.willBeAddedOnInstall", repoToInstall.getDisplayName()));
            this.repoWarningBanner.setVisible(true);
        }
    }

    private final boolean willAutomaticallyAddRepo() {
        return PackageSearchGeneralConfiguration.Companion.getInstance(this.project).getAutoAddMissingRepositories();
    }

    private final void updateActions(PackageOperations packageOperations) {
        this.overflowButton.setVisible(true);
        if (packageOperations.getPrimaryOperationType() != null) {
            this.primaryOperations = packageOperations.getPrimaryOperations();
            this.primaryActionButton.setVisible(true);
            PackageOperationType packageOperationType = packageOperations.getPrimaryOperationType();
            if (packageOperationType != null) {
                switch (PackageDetailsHeaderPanel$WhenMappings.$EnumSwitchMapping$0[packageOperationType.ordinal()]) {
                    case 1: {
                        this.primaryActionButton.setText(PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.actions.add.text", new Object[0]));
                        break;
                    }
                    case 2: {
                        this.primaryActionButton.setText(PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.actions.upgrade.text", new Object[0]));
                        break;
                    }
                    case 3: {
                        this.primaryActionButton.setText(PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.actions.set", new Object[0]));
                        break;
                    }
                    default: {
                        break;
                    }
                }
            }
        } else {
            this.primaryOperations = null;
            this.primaryActionButton.setVisible(false);
        }
        this.removeOperations = packageOperations.getRemoveOperations();
    }

    private final void onPrimaryActionClicked() {
        block0: {
            Deferred<? extends List<? extends PackageSearchOperation<?>>> deferred = this.primaryOperations;
            if (deferred == null) break block0;
            Deferred<? extends List<? extends PackageSearchOperation<?>>> deferred2 = deferred;
            boolean bl = false;
            boolean bl2 = false;
            Deferred<? extends List<? extends PackageSearchOperation<?>>> it = deferred2;
            boolean bl3 = false;
            this.operationExecutor.executeOperations(it);
        }
    }

    private final void onRemoveClicked() {
        block0: {
            Deferred<? extends List<? extends PackageSearchOperation<?>>> deferred = this.removeOperations;
            if (deferred == null) break block0;
            Deferred<? extends List<? extends PackageSearchOperation<?>>> deferred2 = deferred;
            boolean bl = false;
            boolean bl2 = false;
            Deferred<? extends List<? extends PackageSearchOperation<?>>> it = deferred2;
            boolean bl3 = false;
            this.operationExecutor.executeOperations(it);
        }
    }

    private final void onCopyClicked() {
        Object object;
        Component component = this.copyMenu.getInvoker();
        if (!(component instanceof JTextComponent)) {
            component = null;
        }
        if ((object = (JTextComponent)component) == null || (object = ((JTextComponent)object).getText()) == null || (object = StringExtensionsKt.nullIfBlank((String)object)) == null) {
            return;
        }
        Object text = object;
        CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(this.stripHtml((String)text)));
    }

    private final String stripHtml(String $this$stripHtml) {
        StringBuilder stringBuilder = new StringBuilder();
        ParserDelegator parserDelegator = new ParserDelegator();
        HTMLEditorKit.ParserCallback parserCallback2 = new HTMLEditorKit.ParserCallback(stringBuilder){
            final /* synthetic */ StringBuilder $stringBuilder;

            public void handleText(@NotNull char[] data, int pos) {
                Intrinsics.checkNotNullParameter((Object)data, (String)"data");
                this.$stringBuilder.append(data);
            }
            {
                this.$stringBuilder = $captured_local_variable$0;
            }
        };
        String string = $this$stripHtml;
        boolean bl = false;
        parserDelegator.parse(new StringReader(string), parserCallback2, true);
        String string2 = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"stringBuilder.toString()");
        return string2;
    }

    public PackageDetailsHeaderPanel(@NotNull Project project, @NotNull OperationExecutor operationExecutor) {
        Object $this$run;
        JComponent $this$apply;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)operationExecutor, (String)"operationExecutor");
        this.project = project;
        this.operationExecutor = operationExecutor;
        Object object = new InfoBannerPanel(null, null, null, 7, null);
        boolean bl = false;
        boolean bl2 = false;
        InfoBannerPanel infoBannerPanel = object;
        PackageDetailsHeaderPanel packageDetailsHeaderPanel = this;
        boolean bl3 = false;
        $this$apply.setVisible(false);
        Unit unit = Unit.INSTANCE;
        packageDetailsHeaderPanel.repoWarningBanner = object;
        object = new HtmlEditorPane();
        bl = false;
        bl2 = false;
        $this$apply = object;
        packageDetailsHeaderPanel = this;
        boolean bl4 = false;
        $this$apply.setBorder((Border)BordersKt.emptyBorder$default(0, 1, null));
        $this$apply.setFont((Font)JBFont.label().asBold().deriveFont(IntScalingExtensionsKt.scaledFontSize(16)));
        unit = Unit.INSTANCE;
        packageDetailsHeaderPanel.nameLabel = object;
        object = new HtmlEditorPane();
        bl = false;
        bl2 = false;
        $this$apply = object;
        packageDetailsHeaderPanel = this;
        boolean bl5 = false;
        $this$apply.setBorder((Border)BordersKt.emptyBorder$default(0, 1, null));
        $this$apply.setForeground(PackageSearchUI.getTextColorSecondary$intellij_packageSearch$default(PackageSearchUI.INSTANCE, false, 1, null));
        unit = Unit.INSTANCE;
        packageDetailsHeaderPanel.identifierLabel = object;
        object = new ColorButton();
        bl = false;
        bl2 = false;
        $this$apply = object;
        packageDetailsHeaderPanel = this;
        boolean bl6 = false;
        $this$apply.addActionListener(new ActionListener(this){
            final /* synthetic */ PackageDetailsHeaderPanel this$0;
            {
                this.this$0 = packageDetailsHeaderPanel;
            }

            public final void actionPerformed(ActionEvent it) {
                PackageDetailsHeaderPanel.access$onPrimaryActionClicked(this.this$0);
            }
        });
        unit = Unit.INSTANCE;
        packageDetailsHeaderPanel.primaryActionButton = object;
        object = new MenuAction();
        bl = false;
        bl2 = false;
        $this$apply = object;
        packageDetailsHeaderPanel = this;
        boolean bl7 = false;
        $this$apply.add((AnAction)new DumbAwareAction(PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.actions.remove.text", new Object[0]), this){
            final /* synthetic */ PackageDetailsHeaderPanel this$0;
            {
                this.this$0 = packageDetailsHeaderPanel;
                super($super_call_param$1);
                this.this$0.setMinimumSize(new Dimension(PackageDetailsHeaderPanelKt.access$getMinPopupMenuWidth$p(), 0));
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                PackageDetailsHeaderPanel.access$onRemoveClicked(this.this$0);
            }
        });
        unit = Unit.INSTANCE;
        packageDetailsHeaderPanel.removeMenuAction = object;
        object = this;
        bl = false;
        bl2 = false;
        $this$apply = (PackageDetailsHeaderPanel)object;
        packageDetailsHeaderPanel = this;
        boolean bl8 = false;
        Presentation presentation = new Presentation();
        presentation.setIcon(AllIcons.Actions.More);
        presentation.putClientProperty(ActionButton.HIDE_DROPDOWN_ICON, (Object)true);
        unit = new ActionButton((AnAction)((PackageDetailsHeaderPanel)$this$run).removeMenuAction, presentation, "PackageSearchPackageDetailsHeader", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
        packageDetailsHeaderPanel.overflowButton = unit;
        object = PackageSearchUI.INSTANCE.menuItem$intellij_packageSearch(PackageSearchBundle.INSTANCE.message("packagesearch.ui.toolwindow.packages.details.menu.copy", new Object[0]), null, (Function0<Unit>)((Function0)new Function0<Unit>(this){

            public final void invoke() {
                PackageDetailsHeaderPanel.access$onCopyClicked((PackageDetailsHeaderPanel)this.receiver);
            }
        }));
        bl = false;
        bl2 = false;
        $this$run = object;
        packageDetailsHeaderPanel = this;
        boolean bl9 = false;
        ((AbstractButton)$this$apply).setMnemonic(67);
        $this$apply.setMinimumSize(new Dimension(PackageDetailsHeaderPanelKt.access$getMinPopupMenuWidth$p(), 0));
        unit = Unit.INSTANCE;
        packageDetailsHeaderPanel.copyMenuItem = object;
        object = new JBPopupMenu();
        bl = false;
        bl2 = false;
        $this$apply = object;
        packageDetailsHeaderPanel = this;
        boolean bl10 = false;
        $this$apply.setMinimumSize(new Dimension(PackageDetailsHeaderPanelKt.access$getMinPopupMenuWidth$p(), 0));
        $this$apply.add(this.copyMenuItem);
        unit = Unit.INSTANCE;
        packageDetailsHeaderPanel.copyMenu = object;
        this.infoPanel = PackageSearchUI.INSTANCE.headerPanel$intellij_packageSearch((Function1<? super BorderLayoutPanel, Unit>)((Function1)new Function1<BorderLayoutPanel, Unit>(this){
            final /* synthetic */ PackageDetailsHeaderPanel this$0;

            public final void invoke(@NotNull BorderLayoutPanel $this$headerPanel) {
                Intrinsics.checkNotNullParameter((Object)$this$headerPanel, (String)"$receiver");
                $this$headerPanel.setBorder((Border)BordersKt.emptyBorder(IntScalingExtensionsKt.scaled(12)));
                $this$headerPanel.setLayout((LayoutManager)new HeaderLayout());
                $this$headerPanel.add((Component)PackageDetailsHeaderPanel.access$getNameLabel$p(this.this$0), (Object)((Object)HeaderLayout.Role.NAME));
                $this$headerPanel.add((Component)PackageDetailsHeaderPanel.access$getPrimaryActionButton$p(this.this$0), (Object)((Object)HeaderLayout.Role.PRIMARY_ACTION));
                $this$headerPanel.add((Component)PackageDetailsHeaderPanel.access$getOverflowButton$p(this.this$0), (Object)((Object)HeaderLayout.Role.OVERFLOW_BUTTON));
                $this$headerPanel.add((Component)PackageDetailsHeaderPanel.access$getIdentifierLabel$p(this.this$0), (Object)((Object)HeaderLayout.Role.IDENTIFIER));
            }
            {
                this.this$0 = packageDetailsHeaderPanel;
                super(1);
            }
        }));
        this.setLayout(new BorderLayout());
        this.setBorder((Border)new JBEmptyBorder(0));
        this.add((Component)this.repoWarningBanner, "North");
        this.add((Component)this.infoPanel, "Center");
        UIUtil.enableEagerSoftWrapping((JTextComponent)this.nameLabel);
        UIUtil.enableEagerSoftWrapping((JTextComponent)this.identifierLabel);
        JComponentExtensionsKt.onRightClick(this.nameLabel, (Function1<? super MouseEvent, Unit>)((Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (nameLabel.isVisible()) {
                    JPopupMenuExtensionsKt.showUnderneath$default((JPopupMenu)copyMenu, nameLabel, 0, 2, null);
                }
            }
        }));
        JComponentExtensionsKt.onRightClick(this.identifierLabel, (Function1<? super MouseEvent, Unit>)((Function1)new Function1<MouseEvent, Unit>(){

            public final void invoke(@NotNull MouseEvent it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (identifierLabel.isVisible()) {
                    JPopupMenuExtensionsKt.showUnderneath$default((JPopupMenu)copyMenu, identifierLabel, 0, 2, null);
                }
            }
        }));
    }

    public static final /* synthetic */ void access$onPrimaryActionClicked(PackageDetailsHeaderPanel $this) {
        $this.onPrimaryActionClicked();
    }

    public static final /* synthetic */ void access$onRemoveClicked(PackageDetailsHeaderPanel $this) {
        $this.onRemoveClicked();
    }

    public static final /* synthetic */ void access$onCopyClicked(PackageDetailsHeaderPanel $this) {
        $this.onCopyClicked();
    }

    public static final /* synthetic */ ColorButton access$getPrimaryActionButton$p(PackageDetailsHeaderPanel $this) {
        return $this.primaryActionButton;
    }

    public static final /* synthetic */ ActionButton access$getOverflowButton$p(PackageDetailsHeaderPanel $this) {
        return $this.overflowButton;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0080\b\u0018\u00002\u00020\u0001B)\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\r\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J5\u0010\u0017\u001a\u00020\u00002\f\b\u0002\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/packagedetails/PackageDetailsHeaderPanel$ViewModel;", "", "uiPackageModel", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/UiPackageModel;", "knownRepositoriesInTargetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$InTargetModules;", "targetModules", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;", "onlyStable", "", "(Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/UiPackageModel;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$InTargetModules;Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;Z)V", "getKnownRepositoriesInTargetModules", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/KnownRepositories$InTargetModules;", "getOnlyStable", "()Z", "getTargetModules", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/TargetModules;", "getUiPackageModel", "()Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/UiPackageModel;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.packageSearch"})
    public static final class ViewModel {
        @NotNull
        private final UiPackageModel<?> uiPackageModel;
        @NotNull
        private final KnownRepositories.InTargetModules knownRepositoriesInTargetModules;
        @NotNull
        private final TargetModules targetModules;
        private final boolean onlyStable;

        @NotNull
        public final UiPackageModel<?> getUiPackageModel() {
            return this.uiPackageModel;
        }

        @NotNull
        public final KnownRepositories.InTargetModules getKnownRepositoriesInTargetModules() {
            return this.knownRepositoriesInTargetModules;
        }

        @NotNull
        public final TargetModules getTargetModules() {
            return this.targetModules;
        }

        public final boolean getOnlyStable() {
            return this.onlyStable;
        }

        public ViewModel(@NotNull UiPackageModel<?> uiPackageModel, @NotNull KnownRepositories.InTargetModules knownRepositoriesInTargetModules, @NotNull TargetModules targetModules, boolean onlyStable) {
            Intrinsics.checkNotNullParameter(uiPackageModel, (String)"uiPackageModel");
            Intrinsics.checkNotNullParameter((Object)knownRepositoriesInTargetModules, (String)"knownRepositoriesInTargetModules");
            Intrinsics.checkNotNullParameter((Object)targetModules, (String)"targetModules");
            this.uiPackageModel = uiPackageModel;
            this.knownRepositoriesInTargetModules = knownRepositoriesInTargetModules;
            this.targetModules = targetModules;
            this.onlyStable = onlyStable;
        }

        @NotNull
        public final UiPackageModel<?> component1() {
            return this.uiPackageModel;
        }

        @NotNull
        public final KnownRepositories.InTargetModules component2() {
            return this.knownRepositoriesInTargetModules;
        }

        @NotNull
        public final TargetModules component3() {
            return this.targetModules;
        }

        public final boolean component4() {
            return this.onlyStable;
        }

        @NotNull
        public final ViewModel copy(@NotNull UiPackageModel<?> uiPackageModel, @NotNull KnownRepositories.InTargetModules knownRepositoriesInTargetModules, @NotNull TargetModules targetModules, boolean onlyStable) {
            Intrinsics.checkNotNullParameter(uiPackageModel, (String)"uiPackageModel");
            Intrinsics.checkNotNullParameter((Object)knownRepositoriesInTargetModules, (String)"knownRepositoriesInTargetModules");
            Intrinsics.checkNotNullParameter((Object)targetModules, (String)"targetModules");
            return new ViewModel(uiPackageModel, knownRepositoriesInTargetModules, targetModules, onlyStable);
        }

        public static /* synthetic */ ViewModel copy$default(ViewModel viewModel, UiPackageModel uiPackageModel, KnownRepositories.InTargetModules inTargetModules, TargetModules targetModules, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                uiPackageModel = viewModel.uiPackageModel;
            }
            if ((n & 2) != 0) {
                inTargetModules = viewModel.knownRepositoriesInTargetModules;
            }
            if ((n & 4) != 0) {
                targetModules = viewModel.targetModules;
            }
            if ((n & 8) != 0) {
                bl = viewModel.onlyStable;
            }
            return viewModel.copy(uiPackageModel, inTargetModules, targetModules, bl);
        }

        @NotNull
        public String toString() {
            return "ViewModel(uiPackageModel=" + this.uiPackageModel + ", knownRepositoriesInTargetModules=" + this.knownRepositoriesInTargetModules + ", targetModules=" + this.targetModules + ", onlyStable=" + this.onlyStable + ")";
        }

        public int hashCode() {
            UiPackageModel<?> uiPackageModel = this.uiPackageModel;
            KnownRepositories.InTargetModules inTargetModules = this.knownRepositoriesInTargetModules;
            TargetModules targetModules = this.targetModules;
            int n = (((uiPackageModel != null ? uiPackageModel.hashCode() : 0) * 31 + (inTargetModules != null ? ((Object)inTargetModules).hashCode() : 0)) * 31 + (targetModules != null ? targetModules.hashCode() : 0)) * 31;
            int n2 = this.onlyStable ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            return n + n2;
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ViewModel)) break block3;
                    ViewModel viewModel = (ViewModel)object;
                    if (!Intrinsics.areEqual(this.uiPackageModel, viewModel.uiPackageModel) || !Intrinsics.areEqual((Object)this.knownRepositoriesInTargetModules, (Object)viewModel.knownRepositoriesInTargetModules) || !Intrinsics.areEqual((Object)this.targetModules, (Object)viewModel.targetModules) || this.onlyStable != viewModel.onlyStable) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

