/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management;

import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.data.PackageSearchProjectService;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ProjectModule;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.OperationExecutor;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.OperationFailureRenderer;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperation;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.models.operations.PackageSearchOperationFailure;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.NotifyingOperationExecutor;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.NotifyingOperationExecutor$WhenMappings;
import com.jetbrains.packagesearch.intellij.plugin.ui.toolwindow.panels.management.PackageManagementOperationExecutor;
import com.jetbrains.packagesearch.intellij.plugin.util.LogExtensionsKt;
import com.jetbrains.packagesearch.intellij.plugin.util.ProjectExtensionsKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000eH\u0016J \u0010\u000b\u001a\u00020\f2\u0016\u0010\r\u001a\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f0\u000e0\u0010H\u0016J&\u0010\u0011\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u000eH\u0002J&\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\n\b\u0003\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\b\u0001\u0010\u0019\u001a\u00020\u0018H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/NotifyingOperationExecutor;", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/OperationExecutor;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "innerExecutor", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/PackageManagementOperationExecutor;", "operationFailureRenderer", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/OperationFailureRenderer;", "executeOperations", "", "operations", "", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperation;", "Lkotlinx/coroutines/Deferred;", "onOperationsFail", "failureType", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/panels/management/PackageManagementOperationExecutor$FailureType;", "failures", "Lcom/jetbrains/packagesearch/intellij/plugin/ui/toolwindow/models/operations/PackageSearchOperationFailure;", "showErrorNotification", "subtitle", "", "message", "intellij.packageSearch"})
public final class NotifyingOperationExecutor
implements OperationExecutor {
    private final PackageManagementOperationExecutor innerExecutor;
    private final OperationFailureRenderer operationFailureRenderer;
    private final Project project;

    @Override
    public void executeOperations(@NotNull List<? extends PackageSearchOperation<?>> operations) {
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        this.innerExecutor.executeOperations(operations);
    }

    @Override
    public void executeOperations(@NotNull Deferred<? extends List<? extends PackageSearchOperation<?>>> operations) {
        Intrinsics.checkNotNullParameter(operations, (String)"operations");
        this.innerExecutor.executeOperations(operations);
    }

    private final void onOperationsFail(Project project, PackageManagementOperationExecutor.FailureType failureType, List<PackageSearchOperationFailure> failures) {
        String string;
        switch (NotifyingOperationExecutor$WhenMappings.$EnumSwitchMapping$0[failureType.ordinal()]) {
            case 1: {
                string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.error.subtitle.someFailed", new Object[0]);
                break;
            }
            case 2: {
                string = PackageSearchBundle.INSTANCE.message("packagesearch.operation.error.subtitle.allFailed", new Object[0]);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String subtitle = string;
        String message = this.operationFailureRenderer.renderFailuresAsHtmlBulletList(failures);
        this.showErrorNotification(project, subtitle, message);
    }

    private final void showErrorNotification(Project project, @Nls String subtitle, @Nls String message) {
        NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("packagesearch.notification");
        if (notificationGroup == null) {
            LogExtensionsKt.logError$default(null, showErrorNotification.1.INSTANCE, 1, null);
        }
        notificationGroup.createNotification(PackageSearchBundle.INSTANCE.message("packagesearch.title", new Object[0]), message, NotificationType.ERROR).setSubtitle(subtitle).notify(project);
    }

    static /* synthetic */ void showErrorNotification$default(NotifyingOperationExecutor notifyingOperationExecutor, Project project, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        notifyingOperationExecutor.showErrorNotification(project, string, string2);
    }

    public NotifyingOperationExecutor(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        this.innerExecutor = new PackageManagementOperationExecutor(coroutineScope, (Function1<? super List<ProjectModule>, Unit>)((Function1)new Function1<List<? extends ProjectModule>, Unit>(ProjectExtensionsKt.getPackageSearchProjectService(this.project)){

            public final void invoke(@NotNull List<ProjectModule> p1) {
                Intrinsics.checkNotNullParameter(p1, (String)"p1");
                ((PackageSearchProjectService)this.receiver).notifyOperationExecuted(p1);
            }
        }), (Function2<? super PackageManagementOperationExecutor.FailureType, ? super List<PackageSearchOperationFailure>, Unit>)((Function2)new Function2<PackageManagementOperationExecutor.FailureType, List<? extends PackageSearchOperationFailure>, Unit>(this){
            final /* synthetic */ NotifyingOperationExecutor this$0;

            public final void invoke(@NotNull PackageManagementOperationExecutor.FailureType failureType, @NotNull List<PackageSearchOperationFailure> failures) {
                Intrinsics.checkNotNullParameter((Object)((Object)failureType), (String)"failureType");
                Intrinsics.checkNotNullParameter(failures, (String)"failures");
                NotifyingOperationExecutor.access$onOperationsFail(this.this$0, NotifyingOperationExecutor.access$getProject$p(this.this$0), failureType, failures);
            }
            {
                this.this$0 = notifyingOperationExecutor;
                super(2);
            }
        }));
        this.operationFailureRenderer = new OperationFailureRenderer();
    }

    public /* synthetic */ NotifyingOperationExecutor(Project project, CoroutineScope coroutineScope, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            coroutineScope = ProjectExtensionsKt.getLifecycleScope(project);
        }
        this(project, coroutineScope);
    }

    public static final /* synthetic */ void access$onOperationsFail(NotifyingOperationExecutor $this, Project project, PackageManagementOperationExecutor.FailureType failureType, List failures) {
        $this.onOperationsFail(project, failureType, failures);
    }

    public static final /* synthetic */ Project access$getProject$p(NotifyingOperationExecutor $this) {
        return $this.project;
    }
}

