/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.packagesearch.intellij.plugin.configuration.ui;

import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.labels.LinkListener;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.packagesearch.intellij.plugin.PackageSearchBundle;
import com.jetbrains.packagesearch.intellij.plugin.configuration.PackageSearchGeneralConfiguration;
import com.jetbrains.packagesearch.intellij.plugin.configuration.ui.PackageSearchGeneralConfigurable;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.AnalyticsAwareConfigurableContributorDriver;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ConfigurableContributor;
import com.jetbrains.packagesearch.intellij.plugin.extensibility.ConfigurableContributorDriver;
import com.jetbrains.packagesearch.intellij.plugin.fus.PackageSearchEventsLogger;
import com.jetbrains.packagesearch.intellij.plugin.ui.PackageSearchUI;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\n\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u0018H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016J\b\u0010\u001b\u001a\u00020\u0014H\u0016J\b\u0010\u001c\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/configuration/ui/PackageSearchGeneralConfigurable;", "Lcom/intellij/openapi/options/SearchableConfigurable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "autoAddRepositoriesCheckBox", "Ljavax/swing/JCheckBox;", "builder", "Lcom/intellij/util/ui/FormBuilder;", "kotlin.jvm.PlatformType", "configuration", "Lcom/jetbrains/packagesearch/intellij/plugin/configuration/PackageSearchGeneralConfiguration;", "extensions", "", "Lcom/jetbrains/packagesearch/intellij/plugin/extensibility/ConfigurableContributorDriver;", "isAnyContributorModified", "", "()Z", "isAutoAddRepositoriesModified", "apply", "", "createComponent", "Ljavax/swing/JComponent;", "getDisplayName", "", "getId", "isModified", "reset", "restoreDefaults", "Companion", "intellij.packageSearch"})
public final class PackageSearchGeneralConfigurable
implements SearchableConfigurable {
    private final List<ConfigurableContributorDriver> extensions;
    private boolean isAutoAddRepositoriesModified;
    private final FormBuilder builder;
    private final PackageSearchGeneralConfiguration configuration;
    private final JCheckBox autoAddRepositoriesCheckBox;
    @NotNull
    public static final String ID = "preferences.packagesearch.PackageSearchGeneralConfigurable";
    @NotNull
    public static final Companion Companion = new Companion(null);

    private final boolean isAnyContributorModified() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this.extensions;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConfigurableContributorDriver it = (ConfigurableContributorDriver)element$iv;
                    boolean bl2 = false;
                    if (!it.isModified()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    @NotNull
    public String getDisplayName() {
        return PackageSearchBundle.INSTANCE.message("packagesearch.configuration.title", new Object[0]);
    }

    @Nullable
    public JComponent createComponent() {
        Iterable $this$forEach$iv = this.extensions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ConfigurableContributorDriver it = (ConfigurableContributorDriver)element$iv;
            boolean bl = false;
            FormBuilder formBuilder = this.builder;
            Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"builder");
            it.contributeUserInterface(formBuilder);
        }
        this.builder.addComponent((JComponent)new TitledSeparator(PackageSearchBundle.INSTANCE.message("packagesearch.configuration.general", new Object[0])), 0);
        this.builder.addComponent((JComponent)this.autoAddRepositoriesCheckBox);
        this.builder.addComponent((JComponent)new LinkLabel(PackageSearchBundle.INSTANCE.message("packagesearch.configuration.restore.defaults", new Object[0]), null, new LinkListener(this){
            final /* synthetic */ PackageSearchGeneralConfigurable this$0;

            public final void linkSelected(LinkLabel<Object> $noName_0, Object $noName_1) {
                PackageSearchGeneralConfigurable.access$restoreDefaults(this.this$0);
            }
            {
                this.this$0 = packageSearchGeneralConfigurable;
            }
        }));
        this.builder.addComponentFillVertically((JComponent)new JPanel(), 0);
        FormBuilder formBuilder = this.builder;
        Intrinsics.checkNotNullExpressionValue((Object)formBuilder, (String)"builder");
        return formBuilder.getPanel();
    }

    public boolean isModified() {
        return this.isAutoAddRepositoriesModified || this.isAnyContributorModified();
    }

    public void reset() {
        for (ConfigurableContributorDriver contributor : this.extensions) {
            contributor.reset();
        }
        this.autoAddRepositoriesCheckBox.setSelected(this.configuration.getAutoAddMissingRepositories());
        this.isAutoAddRepositoriesModified = false;
    }

    private final void restoreDefaults() {
        for (ConfigurableContributorDriver contributor : this.extensions) {
            contributor.restoreDefaults();
        }
        boolean defaultAutoAddRepositories = true;
        this.isAutoAddRepositoriesModified = this.autoAddRepositoriesCheckBox.isSelected() == defaultAutoAddRepositories;
        this.autoAddRepositoriesCheckBox.setSelected(defaultAutoAddRepositories);
        PackageSearchEventsLogger.Companion.logPreferencesRestoreDefaults();
    }

    public void apply() {
        boolean bl = false;
        Set analyticsFields = new LinkedHashSet();
        for (ConfigurableContributorDriver contributor : this.extensions) {
            contributor.apply();
            if (!(contributor instanceof AnalyticsAwareConfigurableContributorDriver)) continue;
            analyticsFields.addAll((Collection)((AnalyticsAwareConfigurableContributorDriver)contributor).provideApplyEventAnalyticsData());
        }
        this.configuration.setAutoAddMissingRepositories(this.autoAddRepositoriesCheckBox.isSelected());
        Collection contributor = analyticsFields;
        EventPair eventPair = PackageSearchEventsLogger.Companion.getPreferencesAutoAddRepositoriesField$intellij_packageSearch().with((Object)this.configuration.getAutoAddMissingRepositories());
        boolean bl2 = false;
        contributor.add(eventPair);
        Collection $this$toTypedArray$iv = analyticsFields;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        EventPair[] eventPairArray = thisCollection$iv.toArray(new EventPair[0]);
        if (eventPairArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        PackageSearchEventsLogger.Companion.logPreferencesChanged(Arrays.copyOf(eventPairArray, eventPairArray.length));
        this.isAutoAddRepositoriesModified = false;
    }

    /*
     * WARNING - void declaration
     */
    public PackageSearchGeneralConfigurable(@NotNull Project project) {
        Collection<ConfigurableContributorDriver> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$sortedBy$iv = ConfigurableContributor.Companion.extensionsForProject(project);
        boolean $i$f$sortedBy = false;
        boolean bl = false;
        $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator<T>(){

            public final int compare(T a, T b) {
                boolean bl = false;
                ConfigurableContributor it = (ConfigurableContributor)a;
                boolean bl2 = false;
                Comparable comparable = (Comparable)((Object)it.getClass().getSimpleName());
                it = (ConfigurableContributor)b;
                Comparable comparable2 = comparable;
                bl2 = false;
                String string = it.getClass().getSimpleName();
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)string)));
            }
        });
        PackageSearchGeneralConfigurable packageSearchGeneralConfigurable = this;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ConfigurableContributor configurableContributor = (ConfigurableContributor)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            ConfigurableContributorDriver configurableContributorDriver = it.createDriver();
            collection.add(configurableContributorDriver);
        }
        collection = (List)destination$iv$iv;
        packageSearchGeneralConfigurable.extensions = collection;
        this.builder = FormBuilder.createFormBuilder();
        this.configuration = PackageSearchGeneralConfiguration.Companion.getInstance(project);
        this.autoAddRepositoriesCheckBox = PackageSearchUI.INSTANCE.checkBox$intellij_packageSearch(PackageSearchBundle.INSTANCE.message("packagesearch.configuration.automatically.add.repositories", new Object[0]), (Function1<? super JCheckBox, Unit>)((Function1)new Function1<JCheckBox, Unit>(this){
            final /* synthetic */ PackageSearchGeneralConfigurable this$0;

            public final void invoke(@NotNull JCheckBox $this$checkBox) {
                Intrinsics.checkNotNullParameter((Object)$this$checkBox, (String)"$receiver");
                $this$checkBox.setSelected(PackageSearchGeneralConfigurable.access$getConfiguration$p(this.this$0).getAutoAddMissingRepositories());
                $this$checkBox.addItemListener(new ItemListener(this){
                    final /* synthetic */ autoAddRepositoriesCheckBox.1 this$0;

                    public final void itemStateChanged(ItemEvent it) {
                        ItemEvent itemEvent = it;
                        Intrinsics.checkNotNullExpressionValue((Object)itemEvent, (String)"it");
                        boolean newIsSelected = itemEvent.getStateChange() == 1;
                        PackageSearchGeneralConfigurable.access$setAutoAddRepositoriesModified$p(this.this$0.this$0, newIsSelected != PackageSearchGeneralConfigurable.access$getConfiguration$p(this.this$0.this$0).getAutoAddMissingRepositories());
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = packageSearchGeneralConfigurable;
                super(1);
            }
        }));
    }

    public static final /* synthetic */ void access$restoreDefaults(PackageSearchGeneralConfigurable $this) {
        $this.restoreDefaults();
    }

    public static final /* synthetic */ PackageSearchGeneralConfiguration access$getConfiguration$p(PackageSearchGeneralConfigurable $this) {
        return $this.configuration;
    }

    public static final /* synthetic */ boolean access$isAutoAddRepositoriesModified$p(PackageSearchGeneralConfigurable $this) {
        return $this.isAutoAddRepositoriesModified;
    }

    public static final /* synthetic */ void access$setAutoAddRepositoriesModified$p(PackageSearchGeneralConfigurable $this, boolean bl) {
        $this.isAutoAddRepositoriesModified = bl;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/jetbrains/packagesearch/intellij/plugin/configuration/ui/PackageSearchGeneralConfigurable$Companion;", "", "()V", "ID", "", "intellij.packageSearch"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

