/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlinx.serialization.compiler.diagnostic;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.config.KotlinCompilerVersion;
import org.jetbrains.kotlin.descriptors.ClassConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.annotations.Annotated;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.Annotations;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.DiagnosticFactory0;
import org.jetbrains.kotlin.js.resolve.diagnostics.SourceLocationUtilsKt;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtModifierList;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPureClassOrObject;
import org.jetbrains.kotlin.psi.KtTypeElement;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.resolve.ResolveUtilKt;
import org.jetbrains.kotlin.resolve.checkers.DeclarationChecker;
import org.jetbrains.kotlin.resolve.checkers.DeclarationCheckerContext;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.jvm.annotations.JvmAnnotationUtilKt;
import org.jetbrains.kotlin.resolve.lazy.descriptors.LazyAnnotationDescriptor;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElementKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.SimpleType;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.AbstractSerialGenerator;
import org.jetbrains.kotlinx.serialization.compiler.backend.common.TypeUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationErrors;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.SerializationPluginDeclarationCheckerKt;
import org.jetbrains.kotlinx.serialization.compiler.diagnostic.VersionReader;
import org.jetbrains.kotlinx.serialization.compiler.resolve.KSerializationUtilKt;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperties;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializableProperty;
import org.jetbrains.kotlinx.serialization.compiler.resolve.SerializationAnnotations;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0002J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\tH\u0002J\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u0018\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ&\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u000b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\b\u001a\u00020\tH\u0002J:\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u0011\u001a\u00020!2\b\u0010\"\u001a\u0004\u0018\u00010#2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0002J \u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J \u0010)\u001a\u00020\u00072\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\tH\u0002J2\u0010*\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010+\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010,2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0002J\u0018\u0010-\u001a\u00020\u00072\u0006\u0010\u0013\u001a\u00020.2\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010/\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u00100\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000bH\u0016J6\u00101\u001a\u00020\u0007*\u0002022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00103\u001a\u00020 2\b\u00104\u001a\u0004\u0018\u0001052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0002J6\u00106\u001a\u00020\u0007*\u0002022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u00103\u001a\u00020 2\b\u0010\"\u001a\u0004\u0018\u00010,2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010$\u001a\u00020%H\u0002J\f\u00107\u001a\u00020\u0004*\u00020\u000bH\u0002J\f\u00108\u001a\u00020\u0004*\u00020 H\u0002J!\u00109\u001a\u00020\u0007*\u00020\u000b2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020<\u0012\u0004\u0012\u00020\u00070;H\u0082\bJ$\u0010=\u001a\u00020\u0007*\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000b2\u000e\u0010>\u001a\n\u0012\u0006\b\u0000\u0012\u00020<0?H\u0002R\u0014\u0010\u0003\u001a\u00020\u00048TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0005\u00a8\u0006@"}, d2={"Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/SerializationPluginDeclarationChecker;", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationChecker;", "()V", "isIde", "", "()Z", "analyzePropertiesSerializers", "", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "serializableClass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "props", "", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperty;", "buildSerializableProperties", "Lorg/jetbrains/kotlinx/serialization/compiler/resolve/SerializableProperties;", "descriptor", "canBeSerializedInternally", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "canSupportInlineClasses", "module", "Lorg/jetbrains/kotlin/descriptors/ModuleDescriptor;", "check", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "context", "Lorg/jetbrains/kotlin/resolve/checkers/DeclarationCheckerContext;", "checkCorrectTransientAnnotationIsUsed", "properties", "checkCustomSerializerMatch", "classType", "Lorg/jetbrains/kotlin/types/KotlinType;", "Lorg/jetbrains/kotlin/descriptors/annotations/Annotated;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "fallbackElement", "Lcom/intellij/psi/PsiElement;", "checkMinKotlin", "versions", "Lorg/jetbrains/kotlinx/serialization/compiler/diagnostic/VersionReader$RuntimeVersions;", "checkMinRuntime", "checkSerializerNullability", "serializerType", "Lorg/jetbrains/kotlin/psi/KtTypeElement;", "checkTransients", "Lorg/jetbrains/kotlin/psi/KtPureClassOrObject;", "declarationHasInitializer", "serializationPluginEnabledOn", "checkType", "Lorg/jetbrains/kotlinx/serialization/compiler/backend/common/AbstractSerialGenerator;", "type", "ktType", "Lorg/jetbrains/kotlin/psi/KtTypeReference;", "checkTypeArguments", "isSerializableEnumWithMissingSerializer", "isUnsupportedInlineType", "onSerializableAnnotation", "report", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "reportOnSerializableAnnotation", "error", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticFactory0;", "kotlinx-serialization-compiler-plugin"})
public class SerializationPluginDeclarationChecker
implements DeclarationChecker {
    public final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull DeclarationCheckerContext context2) {
        Object object;
        VersionReader.RuntimeVersions runtimeVersions;
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!(descriptor2 instanceof ClassDescriptor)) {
            return;
        }
        if (!this.canBeSerializedInternally((ClassDescriptor)descriptor2, declaration2, context2.getTrace())) {
            return;
        }
        if (!(declaration2 instanceof KtPureClassOrObject)) {
            return;
        }
        if (!this.isIde() && (runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(DescriptorUtilsKt.getModule((DeclarationDescriptor)descriptor2), context2.getTrace())) != null) {
            object = runtimeVersions;
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            this.checkMinKotlin((VersionReader.RuntimeVersions)it, (ClassDescriptor)descriptor2, context2.getTrace());
            this.checkMinRuntime((VersionReader.RuntimeVersions)it, (ClassDescriptor)descriptor2, context2.getTrace());
        }
        if ((object = this.buildSerializableProperties((ClassDescriptor)descriptor2, context2.getTrace())) == null) {
            return;
        }
        SerializableProperties props = object;
        this.checkCorrectTransientAnnotationIsUsed((ClassDescriptor)descriptor2, props.getSerializableProperties(), context2.getTrace());
        this.checkTransients((KtPureClassOrObject)declaration2, context2.getTrace());
        this.analyzePropertiesSerializers(context2.getTrace(), (ClassDescriptor)descriptor2, props.getSerializableProperties());
    }

    private final void checkMinRuntime(VersionReader.RuntimeVersions versions, ClassDescriptor descriptor2, BindingTrace trace) {
        if (!versions.implementationVersionMatchSupported()) {
            SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor2;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry != null) {
                String string;
                KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
                boolean bl = false;
                boolean bl2 = false;
                KtAnnotationEntry it = ktAnnotationEntry2;
                boolean bl3 = false;
                Object object = versions.getImplementationVersion();
                String string2 = object == null ? "too low" : ((string = object.toString()) == null ? "too low" : string);
                object = KotlinCompilerVersion.getVersion();
                trace.report((Diagnostic)SerializationErrors.PROVIDED_RUNTIME_TOO_LOW.on((PsiElement)it, (Object)string2, (Object)(object == null ? "unknown" : object), (Object)VersionReader.INSTANCE.getMINIMAL_SUPPORTED_VERSION().toString()));
            }
        }
    }

    private final void checkMinKotlin(VersionReader.RuntimeVersions versions, ClassDescriptor descriptor2, BindingTrace trace) {
        if (versions.currentCompilerMatchRequired()) {
            return;
        }
        SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
        ClassDescriptor $this$onSerializableAnnotation$iv = descriptor2;
        boolean $i$f$onSerializableAnnotation = false;
        KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
        if (ktAnnotationEntry != null) {
            String string;
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl = false;
            boolean bl2 = false;
            KtAnnotationEntry it = ktAnnotationEntry2;
            boolean bl3 = false;
            String string2 = KotlinCompilerVersion.getVersion();
            String string3 = string2 == null ? "too low" : string2;
            string2 = versions.getImplementationVersion();
            String string4 = string2 == null ? "unknown" : ((string = string2.toString()) == null ? "unknown" : string);
            string2 = versions.getRequireKotlinVersion();
            trace.report((Diagnostic)SerializationErrors.REQUIRED_KOTLIN_TOO_HIGH.on((PsiElement)it, (Object)string3, (Object)string4, (Object)(string2 == null ? "N/A" : ((string = string2.toString()) == null ? "N/A" : string))));
        }
    }

    protected boolean isIde() {
        return false;
    }

    private final void checkCorrectTransientAnnotationIsUsed(ClassDescriptor descriptor2, List<SerializableProperty> properties2, BindingTrace trace) {
        boolean bl;
        block7: {
            Iterable $this$any$iv = DescriptorUtilsKt.getSuperInterfaces((ClassDescriptor)descriptor2);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)DescriptorUtilsKt.getFqNameSafe((DeclarationDescriptor)((DeclarationDescriptor)it)).asString(), (Object)"java.io.Serializable")) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        for (SerializableProperty prop : properties2) {
            Annotations annotations2;
            Annotations annotations3;
            AnnotationDescriptor incorrectTransient;
            Object element$iv;
            if (prop.getTransient() || (incorrectTransient = (element$iv = prop.getDescriptor().getBackingField()) == null ? null : ((annotations3 = element$iv.getAnnotations()) == null ? null : annotations3.findAnnotation(JvmAnnotationUtilKt.TRANSIENT_ANNOTATION_FQ_NAME))) == null) continue;
            annotations3 = KotlinSourceElementKt.getPsi((SourceElement)incorrectTransient.getSource());
            if (annotations3 == null) {
                PsiElement psiElement2 = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)prop.getDescriptor()));
                if (psiElement2 == null) continue;
                annotations2 = psiElement2;
            } else {
                annotations2 = annotations3;
            }
            Annotations elementToReport = annotations2;
            trace.report((Diagnostic)SerializationErrors.INCORRECT_TRANSIENT.on((PsiElement)elementToReport));
        }
    }

    private final boolean canBeSerializedInternally(ClassDescriptor descriptor2, KtDeclaration declaration2, BindingTrace trace) {
        ClassDescriptor superClass;
        if (this.isSerializableEnumWithMissingSerializer(descriptor2)) {
            KtModifierList ktModifierList = declaration2.getModifierList();
            KtElement declarationToReport = ktModifierList == null ? (KtElement)declaration2 : (KtElement)ktModifierList;
            trace.report((Diagnostic)SerializationErrors.EXPLICIT_SERIALIZABLE_IS_REQUIRED.on((PsiElement)declarationToReport));
            return false;
        }
        if (!descriptor2.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
            return false;
        }
        if (!this.serializationPluginEnabledOn(descriptor2)) {
            DiagnosticFactory0<PsiElement> declarationToReport = SerializationErrors.PLUGIN_IS_NOT_ENABLED;
            Intrinsics.checkNotNullExpressionValue(declarationToReport, (String)"PLUGIN_IS_NOT_ENABLED");
            this.reportOnSerializableAnnotation(trace, descriptor2, declarationToReport);
            return false;
        }
        if (InlineClassesUtilsKt.isInlineClass((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)) && !this.canSupportInlineClasses(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)), trace)) {
            SerializationPluginDeclarationChecker declarationToReport = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor2;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry != null) {
                VersionReader.RuntimeVersions runtimeVersions;
                KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
                boolean bl = false;
                boolean bl2 = false;
                KtAnnotationEntry it = ktAnnotationEntry2;
                boolean bl3 = false;
                trace.report((Diagnostic)SerializationErrors.INLINE_CLASSES_NOT_SUPPORTED.on((PsiElement)it, (Object)VersionReader.INSTANCE.getMinVersionForInlineClasses$kotlinx_serialization_compiler_plugin().toString(), (Object)String.valueOf((runtimeVersions = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(DescriptorUtilsKt.getModule((DeclarationDescriptor)((DeclarationDescriptor)descriptor2)), trace)) == null ? null : runtimeVersions.getImplementationVersion())));
            }
            return false;
        }
        if (!KSerializationUtilKt.getHasSerializableAnnotationWithoutArgs(descriptor2)) {
            return false;
        }
        if (SerializationPluginDeclarationCheckerKt.getSerializableAnnotationIsUseless(descriptor2)) {
            DiagnosticFactory0<KtAnnotationEntry> this_$iv = SerializationErrors.SERIALIZABLE_ANNOTATION_IGNORED;
            Intrinsics.checkNotNullExpressionValue(this_$iv, (String)"SERIALIZABLE_ANNOTATION_IGNORED");
            this.reportOnSerializableAnnotation(trace, descriptor2, this_$iv);
            return false;
        }
        if (!KSerializationUtilKt.isSerializableEnum(descriptor2) && !KSerializationUtilKt.isInternalSerializable(superClass = DescriptorUtilsKt.getSuperClassOrAny((ClassDescriptor)descriptor2))) {
            Object v0;
            block11: {
                Collection $this$onSerializableAnnotation$iv = superClass.getConstructors();
                Intrinsics.checkNotNullExpressionValue((Object)$this$onSerializableAnnotation$iv, (String)"superClass.constructors");
                Iterable $this$singleOrNull$iv = $this$onSerializableAnnotation$iv;
                boolean $i$f$singleOrNull = false;
                Object single$iv = null;
                boolean found$iv = false;
                for (Object element$iv : $this$singleOrNull$iv) {
                    ClassConstructorDescriptor it = (ClassConstructorDescriptor)element$iv;
                    boolean bl = false;
                    if (!(it.getValueParameters().size() == 0)) continue;
                    if (found$iv) {
                        v0 = null;
                        break block11;
                    }
                    single$iv = element$iv;
                    found$iv = true;
                }
                v0 = !found$iv ? null : single$iv;
            }
            if (v0 == null) {
                DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = SerializationErrors.NON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR;
                Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"NON_SERIALIZABLE_PARENT_MUST_HAVE_NOARG_CTOR");
                this.reportOnSerializableAnnotation(trace, descriptor2, diagnosticFactory0);
                return false;
            }
        }
        return true;
    }

    private final boolean isSerializableEnumWithMissingSerializer(ClassDescriptor $this$isSerializableEnumWithMissingSerializer) {
        boolean bl;
        block6: {
            if ($this$isSerializableEnumWithMissingSerializer.getKind() != ClassKind.ENUM_CLASS) {
                return false;
            }
            if ($this$isSerializableEnumWithMissingSerializer.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
                return false;
            }
            if (KSerializationUtilKt.getHasAnySerialAnnotation($this$isSerializableEnumWithMissingSerializer.getAnnotations())) {
                return true;
            }
            Iterable $this$any$iv = KSerializationUtilKt.enumEntries($this$isSerializableEnumWithMissingSerializer);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ClassDescriptor it = (ClassDescriptor)element$iv;
                    boolean bl2 = false;
                    if (!KSerializationUtilKt.getHasAnySerialAnnotation(it.getAnnotations())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    public boolean serializationPluginEnabledOn(@NotNull ClassDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        return true;
    }

    private final SerializableProperties buildSerializableProperties(ClassDescriptor descriptor2, BindingTrace trace) {
        if (!descriptor2.getAnnotations().hasAnnotation(SerializationAnnotations.INSTANCE.getSerializableAnnotationFqName())) {
            return null;
        }
        if (!KSerializationUtilKt.isInternalSerializable(descriptor2)) {
            return null;
        }
        if (KSerializationUtilKt.getHasCompanionObjectAsSerializer(descriptor2)) {
            return null;
        }
        DiagnosticFactory0<KtAnnotationEntry> diagnosticFactory0 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)diagnosticFactory0, (String)"trace.bindingContext");
        SerializableProperties props = new SerializableProperties(descriptor2, (BindingContext)diagnosticFactory0);
        if (!props.isExternallySerializable()) {
            diagnosticFactory0 = SerializationErrors.PRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY;
            Intrinsics.checkNotNullExpressionValue(diagnosticFactory0, (String)"PRIMARY_CONSTRUCTOR_PARAMETER_IS_NOT_A_PROPERTY");
            this.reportOnSerializableAnnotation(trace, descriptor2, diagnosticFactory0);
        }
        boolean bl = false;
        Set namesSet = new LinkedHashSet();
        Iterable $this$forEach$iv = props.getSerializableProperties();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl2 = false;
            if (namesSet.add(it.getName())) continue;
            SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
            ClassDescriptor $this$onSerializableAnnotation$iv = descriptor2;
            boolean $i$f$onSerializableAnnotation = false;
            KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
            if (ktAnnotationEntry == null) continue;
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl3 = false;
            boolean bl4 = false;
            KtAnnotationEntry a = ktAnnotationEntry2;
            boolean bl5 = false;
            trace.report((Diagnostic)SerializationErrors.DUPLICATE_SERIAL_NAME.on((PsiElement)a, (Object)it.getName()));
        }
        trace.record(SerializationPluginDeclarationCheckerKt.getSERIALIZABLE_PROPERTIES(), (Object)descriptor2, (Object)props);
        return props;
    }

    private final void checkTransients(KtPureClassOrObject declaration2, BindingTrace trace) {
        Map propertiesMap;
        BindingContext bindingContext2 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"trace.bindingContext");
        Map<PropertyDescriptor, KtProperty> map2 = TypeUtilKt.bodyPropertiesDescriptorsMap(declaration2, bindingContext2, false);
        bindingContext2 = trace.getBindingContext();
        Intrinsics.checkNotNullExpressionValue((Object)bindingContext2, (String)"trace.bindingContext");
        Map $this$forEach$iv = propertiesMap = MapsKt.plus(map2, TypeUtilKt.primaryConstructorPropertiesDescriptorsMap(declaration2, bindingContext2));
        boolean $i$f$forEach = false;
        Map map3 = $this$forEach$iv;
        boolean bl = false;
        Iterator iterator = map3.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry $dstr$descriptor$declaration = element$iv = iterator.next();
            boolean bl2 = false;
            Map.Entry entry = $dstr$descriptor$declaration;
            boolean bl3 = false;
            PropertyDescriptor descriptor2 = (PropertyDescriptor)entry.getKey();
            Map.Entry entry2 = $dstr$descriptor$declaration;
            boolean bl4 = false;
            KtDeclaration declaration3 = (KtDeclaration)entry2.getValue();
            boolean isInitialized = this.declarationHasInitializer(declaration3) || descriptor2.isLateInit();
            boolean isMarkedTransient = KSerializationUtilKt.getSerialTransient(descriptor2.getAnnotations());
            boolean hasBackingField = ResolveUtilKt.hasBackingField((PropertyDescriptor)descriptor2, (BindingContext)trace.getBindingContext());
            if (!hasBackingField && isMarkedTransient) {
                AnnotationDescriptor annotationDescriptor = descriptor2.getAnnotations().findAnnotation(SerializationAnnotations.INSTANCE.getSerialTransientFqName());
                LazyAnnotationDescriptor lazyAnnotationDescriptor = annotationDescriptor instanceof LazyAnnotationDescriptor ? (LazyAnnotationDescriptor)annotationDescriptor : null;
                KtAnnotationEntry transientPsi = lazyAnnotationDescriptor == null ? null : lazyAnnotationDescriptor.getAnnotationEntry();
                lazyAnnotationDescriptor = transientPsi;
                trace.report((Diagnostic)SerializationErrors.TRANSIENT_IS_REDUNDANT.on((PsiElement)(lazyAnnotationDescriptor == null ? (KtElement)declaration3 : (KtElement)lazyAnnotationDescriptor)));
            }
            if (!isMarkedTransient || isInitialized || !hasBackingField) continue;
            trace.report((Diagnostic)SerializationErrors.TRANSIENT_MISSING_INITIALIZER.on((PsiElement)declaration3));
        }
    }

    private final boolean declarationHasInitializer(KtDeclaration declaration2) {
        KtDeclaration ktDeclaration = declaration2;
        return ktDeclaration instanceof KtParameter ? ((KtParameter)declaration2).hasDefaultValue() : (ktDeclaration instanceof KtProperty ? ((KtProperty)declaration2).hasDelegateExpressionOrInitializer() : false);
    }

    private final void analyzePropertiesSerializers(BindingTrace trace, ClassDescriptor serializableClass, List<SerializableProperty> props) {
        BindingContext bindingContext2 = trace.getBindingContext();
        AbstractSerialGenerator generatorContextForAnalysis2 = new AbstractSerialGenerator(serializableClass, bindingContext2){
            final /* synthetic */ ClassDescriptor $serializableClass;
            {
                this.$serializableClass = $serializableClass;
                Intrinsics.checkNotNullExpressionValue((Object)$super_call_param$1, (String)"bindingContext");
                super($super_call_param$1, $serializableClass);
            }
        };
        Iterable $this$forEach$iv = props;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtTypeReference ktType;
            ClassDescriptor serializer2;
            SerializableProperty it = (SerializableProperty)element$iv;
            boolean bl = false;
            KotlinType kotlinType = it.getSerializableWith();
            ClassDescriptor classDescriptor = serializer2 = kotlinType == null ? null : KSerializationUtilKt.toClassDescriptor(kotlinType);
            PsiElement psiElement2 = SourceLocationUtilsKt.findPsi((DeclarationDescriptor)((DeclarationDescriptor)it.getDescriptor()));
            if (psiElement2 == null) continue;
            PsiElement propertyPsi = psiElement2;
            KtCallableDeclaration ktCallableDeclaration = propertyPsi instanceof KtCallableDeclaration ? (KtCallableDeclaration)propertyPsi : null;
            KtTypeReference ktTypeReference = ktType = ktCallableDeclaration == null ? null : ktCallableDeclaration.getTypeReference();
            if (serializer2 != null) {
                KtTypeReference ktTypeReference2 = ktType;
                KtTypeElement element3 = ktTypeReference2 == null ? null : ktTypeReference2.getTypeElement();
                this.checkCustomSerializerMatch(it.getModule(), it.getType(), (Annotated)it.getDescriptor(), (KtElement)element3, trace, propertyPsi);
                KotlinType kotlinType2 = it.getType();
                ktTypeReference2 = serializer2.getDefaultType();
                Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference2, (String)"serializer.defaultType");
                this.checkSerializerNullability(kotlinType2, (KotlinType)ktTypeReference2, element3, trace, propertyPsi);
                this.checkTypeArguments(generatorContextForAnalysis2, it.getModule(), it.getType(), element3, trace, propertyPsi);
                continue;
            }
            this.checkType(generatorContextForAnalysis2, it.getModule(), it.getType(), ktType, trace, propertyPsi);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void checkTypeArguments(AbstractSerialGenerator $this$checkTypeArguments, ModuleDescriptor module2, KotlinType type2, KtTypeElement element3, BindingTrace trace, PsiElement fallbackElement) {
        Iterable $this$forEachIndexed$iv = type2.getArguments();
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            List list2;
            void it;
            int n = index$iv++;
            boolean bl = false;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            TypeProjection typeProjection = (TypeProjection)item$iv;
            int i2 = n;
            boolean bl2 = false;
            KotlinType kotlinType = it.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"it.type");
            KotlinType kotlinType2 = kotlinType;
            kotlinType = element3;
            this.checkType($this$checkTypeArguments, module2, kotlinType2, kotlinType == null ? null : ((list2 = kotlinType.getTypeArgumentsAsTypes()) == null ? null : (KtTypeReference)CollectionsKt.getOrNull((List)list2, (int)i2)), trace, fallbackElement);
        }
    }

    private final boolean isUnsupportedInlineType(KotlinType $this$isUnsupportedInlineType) {
        return InlineClassesUtilsKt.isInlineClassType((KotlinType)$this$isUnsupportedInlineType) && !KotlinBuiltIns.isPrimitiveTypeOrNullablePrimitiveType((KotlinType)$this$isUnsupportedInlineType);
    }

    private final boolean canSupportInlineClasses(ModuleDescriptor module2, BindingTrace trace) {
        if (this.isIde()) {
            return true;
        }
        return VersionReader.INSTANCE.canSupportInlineClasses(module2, trace);
    }

    private final void checkType(AbstractSerialGenerator $this$checkType, ModuleDescriptor module2, KotlinType type2, KtTypeReference ktType, BindingTrace trace, PsiElement fallbackElement) {
        ClassDescriptor serializer2;
        KtTypeElement element3;
        if (KSerializationUtilKt.getGenericIndex(type2) != null) {
            return;
        }
        Object object = ktType;
        KtTypeElement ktTypeElement = element3 = object == null ? null : object.getTypeElement();
        if (this.isUnsupportedInlineType(type2) && !this.canSupportInlineClasses(module2, trace)) {
            object = element3;
            PsiElement psiElement2 = object == null ? fallbackElement : (PsiElement)object;
            object = VersionReader.INSTANCE.getVersionsForCurrentModuleFromTrace(module2, trace);
            trace.report((Diagnostic)SerializationErrors.INLINE_CLASSES_NOT_SUPPORTED.on(psiElement2, (Object)VersionReader.INSTANCE.getMinVersionForInlineClasses$kotlinx_serialization_compiler_plugin().toString(), (Object)String.valueOf(object == null ? null : ((VersionReader.RuntimeVersions)object).getImplementationVersion())));
        }
        if ((serializer2 = TypeUtilKt.findTypeSerializerOrContextUnchecked($this$checkType, module2, type2)) != null) {
            this.checkCustomSerializerMatch(module2, type2, (Annotated)type2, (KtElement)element3, trace, fallbackElement);
            SimpleType simpleType = serializer2.getDefaultType();
            Intrinsics.checkNotNullExpressionValue((Object)simpleType, (String)"serializer.defaultType");
            this.checkSerializerNullability(type2, (KotlinType)simpleType, element3, trace, fallbackElement);
            this.checkTypeArguments($this$checkType, module2, type2, element3, trace, fallbackElement);
        } else {
            KtTypeElement ktTypeElement2 = element3;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_NOT_FOUND.on(ktTypeElement2 == null ? fallbackElement : (PsiElement)ktTypeElement2, (Object)type2));
        }
    }

    private final void checkCustomSerializerMatch(ModuleDescriptor module2, KotlinType classType, Annotated descriptor2, KtElement element3, BindingTrace trace, PsiElement fallbackElement) {
        KotlinType kotlinType;
        KotlinType kotlinType2;
        List list2;
        Object v0;
        KotlinType serializerType;
        block4: {
            KotlinType kotlinType3 = KSerializationUtilKt.serializableWith(descriptor2.getAnnotations(), module2);
            if (kotlinType3 == null) {
                return;
            }
            serializerType = kotlinType3;
            Iterable iterable = TypeUtilsKt.supertypes((KotlinType)serializerType);
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                KotlinType it = (KotlinType)t;
                boolean bl3 = false;
                if (!KSerializationUtilKt.isKSerializer(it)) continue;
                v0 = t;
                break block4;
            }
            v0 = null;
        }
        KotlinType kotlinType4 = v0;
        List list3 = list2 = kotlinType4 == null ? null : kotlinType4.getArguments();
        KotlinType kotlinType5 = list2 == null ? null : (kotlinType2 = (kotlinType4 = (TypeProjection)CollectionsKt.first((List)list2)) == null ? null : kotlinType4.getType());
        if (kotlinType2 == null) {
            return;
        }
        KotlinType serializerForType = kotlinType = kotlinType2;
        if (!Intrinsics.areEqual((Object)classType.getConstructor(), (Object)serializerForType.getConstructor())) {
            kotlinType = element3;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_TYPE_INCOMPATIBLE.on(kotlinType == null ? fallbackElement : (PsiElement)kotlinType, (Object)classType, (Object)serializerType, (Object)serializerForType));
        }
    }

    private final void checkSerializerNullability(KotlinType classType, KotlinType serializerType, KtTypeElement element3, BindingTrace trace, PsiElement fallbackElement) {
        Object v0;
        Iterable iterable;
        block3: {
            iterable = TypeUtilsKt.supertypes((KotlinType)serializerType);
            boolean bl = false;
            Iterable iterable2 = iterable;
            boolean bl2 = false;
            for (Object t : iterable2) {
                KotlinType it = (KotlinType)t;
                boolean bl3 = false;
                if (!KSerializationUtilKt.isKSerializer(it)) continue;
                v0 = t;
                break block3;
            }
            v0 = null;
        }
        KotlinType kotlinType = v0;
        if (kotlinType == null) {
            return;
        }
        KotlinType castedToKSerial = kotlinType;
        iterable = ((TypeProjection)CollectionsKt.first((List)castedToKSerial.getArguments())).getType();
        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"castedToKSerial.arguments.first().type");
        Iterable serializerForType = iterable;
        if (!classType.isMarkedNullable() && serializerForType.isMarkedNullable()) {
            iterable = element3;
            trace.report((Diagnostic)SerializationErrors.SERIALIZER_NULLABILITY_INCOMPATIBLE.on(iterable == null ? fallbackElement : (PsiElement)iterable, (Object)serializerType, (Object)classType));
        }
    }

    private final void onSerializableAnnotation(ClassDescriptor $this$onSerializableAnnotation, Function1<? super KtAnnotationEntry, Unit> report) {
        boolean $i$f$onSerializableAnnotation = false;
        KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation);
        if (ktAnnotationEntry != null) {
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl = false;
            boolean bl2 = false;
            report.invoke((Object)ktAnnotationEntry2);
        }
    }

    private final void reportOnSerializableAnnotation(BindingTrace $this$reportOnSerializableAnnotation, ClassDescriptor descriptor2, DiagnosticFactory0<? super KtAnnotationEntry> error2) {
        SerializationPluginDeclarationChecker serializationPluginDeclarationChecker = this;
        ClassDescriptor $this$onSerializableAnnotation$iv = descriptor2;
        boolean $i$f$onSerializableAnnotation = false;
        KtAnnotationEntry ktAnnotationEntry = KSerializationUtilKt.findSerializableAnnotationDeclaration((Annotated)$this$onSerializableAnnotation$iv);
        if (ktAnnotationEntry != null) {
            KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
            boolean bl = false;
            boolean bl2 = false;
            KtAnnotationEntry e = ktAnnotationEntry2;
            boolean bl3 = false;
            $this$reportOnSerializableAnnotation.report((Diagnostic)error2.on((PsiElement)e));
        }
    }
}

