/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.util;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFile;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinFileType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0001\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0014J\b\u0010\u0012\u001a\u00020\tH\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0014H\u0004R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/util/DialogWithEditor;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "title", "", "initialText", "(Lcom/intellij/openapi/project/Project;Ljava/lang/String;Ljava/lang/String;)V", "editor", "Lcom/intellij/openapi/editor/Editor;", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getInitialText", "()Ljava/lang/String;", "getProject", "()Lcom/intellij/openapi/project/Project;", "createCenterPanel", "Ljavax/swing/JComponent;", "createEditor", "dispose", "", "getPreferredFocusedComponent", "init", "kotlin.idea"})
public class DialogWithEditor
extends DialogWrapper {
    @NotNull
    private final Editor editor;
    @NotNull
    private final Project project;
    @NotNull
    private final String initialText;

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    protected final void init() {
        super.init();
    }

    private final Editor createEditor() {
        Editor editor2;
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNull((Object)editorFactory);
        EditorFactory editorFactory2 = editorFactory;
        LightVirtualFile virtualFile2 = new LightVirtualFile("dummy.kt", (FileType)KotlinFileType.INSTANCE, (CharSequence)this.initialText);
        Document document = FileDocumentManager.getInstance().getDocument((VirtualFile)virtualFile2);
        Intrinsics.checkNotNull((Object)document);
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"FileDocumentManager.getI\u2026etDocument(virtualFile)!!");
        Document document2 = document;
        Editor editor3 = editor2 = editorFactory2.createEditor(document2, this.project, (FileType)KotlinFileType.INSTANCE, false);
        Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor");
        EditorSettings editorSettings = editor3.getSettings();
        Intrinsics.checkNotNullExpressionValue((Object)editorSettings, (String)"editor.settings");
        EditorSettings settings2 = editorSettings;
        settings2.setVirtualSpace(false);
        settings2.setLineMarkerAreaShown(false);
        settings2.setFoldingOutlineShown(false);
        settings2.setRightMarginShown(false);
        settings2.setAdditionalPageAtBottom(false);
        settings2.setAdditionalLinesCount(2);
        settings2.setAdditionalColumnsCount(12);
        boolean bl = editor2 instanceof EditorEx;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ((EditorEx)editor2).setEmbeddedIntoDialogWrapper(true);
        EditorColorsScheme editorColorsScheme = editor2.getColorsScheme();
        EditorColorsScheme editorColorsScheme2 = editor2.getColorsScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme2, (String)"editor.getColorsScheme()");
        editorColorsScheme.setColor(EditorColors.CARET_ROW_COLOR, editorColorsScheme2.getDefaultBackground());
        return editor2;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new BorderLayout());
        panel2.add((Component)this.editor.getComponent(), "Center");
        return panel2;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.editor.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"editor.contentComponent");
        return jComponent;
    }

    protected void dispose() {
        super.dispose();
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNull((Object)editorFactory);
        editorFactory.releaseEditor(this.editor);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final String getInitialText() {
        return this.initialText;
    }

    public DialogWithEditor(@NotNull Project project2, @NlsContexts.DialogTitle @NotNull String title, @NotNull String initialText) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)initialText, (String)"initialText");
        super(project2, true);
        this.project = project2;
        this.initialText = initialText;
        this.editor = this.createEditor();
        this.init();
        this.setTitle(title);
    }
}

