/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.ultimate.nodejs.mocha;

import com.intellij.execution.RunManager;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.jetbrains.nodejs.mocha.execution.MochaConfigurationType;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfiguration;
import com.jetbrains.nodejs.mocha.execution.MochaRunConfigurationProducer;
import com.jetbrains.nodejs.mocha.execution.MochaRunSettings;
import com.jetbrains.nodejs.mocha.execution.MochaTestKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.js.JsUtilsKt;
import org.jetbrains.kotlin.idea.js.KotlinJSRunConfigurationDataProvider;
import org.jetbrains.kotlin.idea.run.RcUtilsKt;
import org.jetbrains.kotlin.idea.ultimate.nodejs.NodeJsUtilKt;
import org.jetbrains.kotlin.idea.ultimate.nodejs.TestElementInfo;
import org.jetbrains.kotlin.idea.ultimate.nodejs.TestElementPath;
import org.jetbrains.kotlin.idea.ultimate.nodejs.mocha.KotlinMochaRunConfigurationProducer$WhenMappings;
import org.jetbrains.kotlin.idea.ultimate.nodejs.mocha.MochaConfigData;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtilKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u0005\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\"\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u000fH\u0002J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J&\u0010\u0019\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014R\u0014\u0010\u0005\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0007\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/kotlin/idea/ultimate/nodejs/mocha/KotlinMochaRunConfigurationProducer;", "Lcom/jetbrains/nodejs/mocha/execution/MochaRunConfigurationProducer;", "Lorg/jetbrains/kotlin/idea/js/KotlinJSRunConfigurationDataProvider;", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/mocha/MochaConfigData;", "()V", "isForTests", "", "()Z", "collectMochaTestRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "createTestElementRunInfo", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/TestElementInfo;", "Lcom/jetbrains/nodejs/mocha/execution/MochaRunSettings;", "Lorg/jetbrains/kotlin/idea/ultimate/nodejs/mocha/MochaTestElementInfo;", "configData", "originalSettings", "getConfigurationData", "context", "Lcom/intellij/execution/actions/ConfigurationContext;", "isConfigurationFromCompatibleContext", "configuration", "Lcom/jetbrains/nodejs/mocha/execution/MochaRunConfiguration;", "setupConfigurationFromCompatibleContext", "sourceElement", "Lcom/intellij/openapi/util/Ref;", "Lcom/intellij/psi/PsiElement;", "kotlin-ultimate.javascript.nodeJs"})
public final class KotlinMochaRunConfigurationProducer
extends MochaRunConfigurationProducer
implements KotlinJSRunConfigurationDataProvider<MochaConfigData> {
    /*
     * WARNING - void declaration
     */
    private final List<VirtualFile> collectMochaTestRoots(Project project2) {
        void var3_4;
        void $this$mapNotNullTo$iv;
        void $this$filterIsInstanceTo$iv$iv;
        RunManager runManager = RunManager.Companion.getInstance(project2);
        MochaConfigurationType mochaConfigurationType = MochaConfigurationType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)mochaConfigurationType, (String)"MochaConfigurationType.getInstance()");
        Iterable $this$filterIsInstance$iv = runManager.getConfigurationsList((ConfigurationType)mochaConfigurationType);
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof MochaRunConfiguration)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filterIsInstance$iv = (List)destination$iv$iv;
        Collection destination$iv = (Collection)new SmartList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv.iterator();
        while (iterator.hasNext()) {
            VirtualFile virtualFile2;
            String string;
            MochaRunSettings settings2;
            Object element$iv$iv;
            Object element$iv = element$iv$iv = iterator.next();
            boolean bl = false;
            MochaRunConfiguration configuration2 = (MochaRunConfiguration)element$iv;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)configuration2.getRunSettings(), (String)"configuration.runSettings");
            switch (KotlinMochaRunConfigurationProducer$WhenMappings.$EnumSwitchMapping$0[settings2.getTestKind().ordinal()]) {
                case 1: {
                    string = settings2.getTestDirPath();
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = settings2.getTestFilePath();
                    break;
                }
                default: {
                    string = null;
                }
            }
            String path2 = string;
            CharSequence charSequence = path2;
            boolean bl3 = false;
            boolean bl4 = false;
            if ((charSequence == null || StringsKt.isBlank((CharSequence)charSequence) ? null : LocalFileSystem.getInstance().findFileByPath(path2)) == null) continue;
            virtualFile2 = virtualFile2;
            boolean bl5 = false;
            boolean bl6 = false;
            VirtualFile it$iv = virtualFile2;
            boolean bl7 = false;
            destination$iv.add(it$iv);
        }
        return (List)var3_4;
    }

    /*
     * WARNING - void declaration
     */
    private final TestElementInfo<MochaRunSettings> createTestElementRunInfo(MochaConfigData configData, MochaRunSettings originalSettings) {
        MochaRunSettings mochaRunSettings;
        Project project2 = configData.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"configData.module.project");
        Project project3 = project2;
        String string = originalSettings.getWorkingDir();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"originalSettings.workingDir");
        if (StringsKt.isBlank((CharSequence)string)) {
            VirtualFile virtualFile2 = project3.getBaseDir();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"project.baseDir");
            String string2 = FileUtil.toSystemDependentName((String)virtualFile2.getPath());
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"FileUtil.toSystemDepende\u2026ame(project.baseDir.path)");
            String workingDir = string2;
            mochaRunSettings = originalSettings.builder().setWorkingDir(workingDir).build();
        } else {
            mochaRunSettings = originalSettings;
        }
        Intrinsics.checkNotNullExpressionValue((Object)mochaRunSettings, (String)"if (originalSettings.wor\u2026  } else originalSettings");
        MochaRunSettings settings2 = mochaRunSettings;
        MochaRunSettings.Builder builder = settings2.builder();
        Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"settings.builder()");
        MochaRunSettings.Builder builder2 = builder;
        builder2.setTestFilePath(configData.getJsOutputFilePath());
        String string3 = settings2.getUi();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"settings.ui");
        Object object = string3;
        boolean bl = false;
        if (object.length() == 0) {
            builder2.setUi("bdd");
        }
        if ((object = configData.getTestElementPath()) instanceof TestElementPath.BySuite) {
            void suiteNames2;
            TestElementPath.BySuite bySuite = (TestElementPath.BySuite)configData.getTestElementPath();
            List<String> list2 = bySuite.component1();
            String testName = bySuite.component2();
            if (testName == null) {
                builder2.setTestKind(MochaTestKind.SUITE);
                builder2.setSuiteNames((List)suiteNames2);
            } else {
                builder2.setTestKind(MochaTestKind.TEST);
                builder2.setTestNames(CollectionsKt.plus((Collection)((Collection)suiteNames2), (Object)testName));
            }
        } else if (object instanceof TestElementPath.BySingleFile) {
            builder2.setTestKind(MochaTestKind.TEST_FILE);
        }
        builder2.setEnvData(NodeJsUtilKt.getNodeJsEnvironmentVars(configData.getModule(), true));
        MochaRunSettings mochaRunSettings2 = builder2.build();
        Intrinsics.checkNotNullExpressionValue((Object)mochaRunSettings2, (String)"builder.build()");
        return new TestElementInfo<MochaRunSettings>(mochaRunSettings2, configData.getElement());
    }

    @Override
    @Nullable
    public MochaConfigData getConfigurationData(@NotNull ConfigurationContext context2) {
        boolean bl;
        MochaConfigData configData;
        Project project2;
        VirtualFile file2;
        block12: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Module module2 = context2.getModule();
            if (module2 == null || (module2 = JsUtilsKt.asJsModule(module2)) == null) {
                return null;
            }
            Module module3 = module2;
            if (MultiplatformUtilKt.isNewMPPModule(module3)) {
                return null;
            }
            PsiElement psiElement2 = context2.getPsiLocation();
            if (psiElement2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"context.psiLocation ?: return null");
            PsiElement element3 = psiElement2;
            VirtualFile virtualFile2 = module3.getModuleFile();
            if (virtualFile2 == null) {
                return null;
            }
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"module.moduleFile ?: return null");
            file2 = virtualFile2;
            Project project3 = module3.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"module.project");
            project2 = project3;
            String string = JsUtilsKt.getJsTestOutputFilePath(module3);
            if (string == null) {
                return null;
            }
            String testFilePath = string;
            TestElementPath testElementPath = TestElementPath.Companion.forElement(element3, module3);
            if (testElementPath == null) {
                return null;
            }
            TestElementPath testElementPath2 = testElementPath;
            configData = new MochaConfigData(element3, module3, testFilePath, testElementPath2);
            if (context2.getOriginalConfiguration((ConfigurationType)MochaConfigurationType.getInstance()) instanceof MochaRunConfiguration) {
                return configData;
            }
            VirtualFile[] $this$any$iv = ProjectRootsUtilKt.getSourceRoots(module3);
            boolean $i$f$any = false;
            VirtualFile[] virtualFileArray = $this$any$iv;
            int n = virtualFileArray.length;
            for (int j = 0; j < n; ++j) {
                VirtualFile element$iv;
                VirtualFile it = element$iv = virtualFileArray[j];
                boolean bl2 = false;
                if (!this.isTestRunnerPackageAvailableFor(project2, it)) continue;
                bl = true;
                break block12;
            }
            bl = false;
        }
        if (bl) {
            return configData;
        }
        List<VirtualFile> roots2 = this.collectMochaTestRoots(project2);
        if (roots2.isEmpty()) {
            return null;
        }
        HashSet<VirtualFile> dirs2 = new HashSet<VirtualFile>();
        for (VirtualFile root : roots2) {
            if (root.isDirectory()) {
                dirs2.add(root);
                continue;
            }
            if (!Intrinsics.areEqual((Object)root, (Object)file2)) continue;
            return configData;
        }
        return VfsUtilCore.isUnder((VirtualFile)file2, (Set)dirs2) ? configData : null;
    }

    @Override
    public boolean isForTests() {
        return true;
    }

    protected boolean isConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration2, @NotNull ConfigurationContext context2) {
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        MochaConfigData mochaConfigData = this.getConfigurationData(context2);
        if (mochaConfigData == null) {
            return false;
        }
        MochaConfigData configData = mochaConfigData;
        MochaRunSettings mochaRunSettings = configuration2.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mochaRunSettings, (String)"configuration.runSettings");
        TestElementInfo<MochaRunSettings> testElementInfo = this.createTestElementRunInfo(configData, mochaRunSettings);
        MochaRunSettings thisRunSettings = testElementInfo.component1();
        MochaRunSettings mochaRunSettings2 = configuration2.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mochaRunSettings2, (String)"configuration.runSettings");
        MochaRunSettings thatRunSettings = mochaRunSettings2;
        MochaTestKind mochaTestKind = thisRunSettings.getTestKind();
        Intrinsics.checkNotNullExpressionValue((Object)mochaTestKind, (String)"thisRunSettings.testKind");
        MochaTestKind thisTestKind = mochaTestKind;
        if (thisTestKind != thatRunSettings.getTestKind()) {
            return false;
        }
        return thisTestKind == MochaTestKind.DIRECTORY ? Intrinsics.areEqual((Object)thisRunSettings.getTestDirPath(), (Object)thatRunSettings.getTestDirPath()) : (thisTestKind == MochaTestKind.PATTERN ? Intrinsics.areEqual((Object)thisRunSettings.getTestFilePattern(), (Object)thatRunSettings.getTestFilePattern()) : (thisTestKind == MochaTestKind.TEST_FILE ? Intrinsics.areEqual((Object)thisRunSettings.getTestFilePath(), (Object)thatRunSettings.getTestFilePath()) : (thisTestKind == MochaTestKind.SUITE ? Intrinsics.areEqual((Object)thisRunSettings.getTestFilePath(), (Object)thatRunSettings.getTestFilePath()) && Intrinsics.areEqual((Object)thisRunSettings.getSuiteNames(), (Object)thatRunSettings.getSuiteNames()) : (thisTestKind != MochaTestKind.TEST ? false : Intrinsics.areEqual((Object)thisRunSettings.getTestFilePath(), (Object)thatRunSettings.getTestFilePath()) && Intrinsics.areEqual((Object)thisRunSettings.getTestNames(), (Object)thatRunSettings.getTestNames())))));
    }

    /*
     * WARNING - void declaration
     */
    protected boolean setupConfigurationFromCompatibleContext(@NotNull MochaRunConfiguration configuration2, @NotNull ConfigurationContext context2, @NotNull Ref<PsiElement> sourceElement) {
        void runSettings;
        Intrinsics.checkNotNullParameter((Object)configuration2, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter(sourceElement, (String)"sourceElement");
        MochaConfigData mochaConfigData = this.getConfigurationData(context2);
        if (mochaConfigData == null) {
            return false;
        }
        MochaConfigData configData = mochaConfigData;
        MochaRunSettings mochaRunSettings = configuration2.getRunSettings();
        Intrinsics.checkNotNullExpressionValue((Object)mochaRunSettings, (String)"configuration.runSettings");
        TestElementInfo<MochaRunSettings> testElementInfo = this.createTestElementRunInfo(configData, mochaRunSettings);
        MochaRunSettings mochaRunSettings2 = testElementInfo.component1();
        PsiElement enclosingTestElement = testElementInfo.component2();
        if (runSettings.getTestKind() == MochaTestKind.DIRECTORY) {
            return false;
        }
        configuration2.setRunSettings((MochaRunSettings)runSettings);
        sourceElement.set((Object)enclosingTestElement);
        configuration2.setGeneratedName();
        RcUtilsKt.addBuildTask((RunConfiguration)configuration2);
        return true;
    }
}

