/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.slicer;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.search.SearchScope;
import com.intellij.slicer.SliceUsage;
import com.intellij.usageView.UsageInfo;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceAnalysisMode;
import org.jetbrains.kotlin.idea.slicer.KotlinSliceUsage;
import org.jetbrains.kotlin.idea.slicer.LambdaCallsBehaviour;
import org.jetbrains.kotlin.idea.slicer.SliceProducer;
import org.jetbrains.kotlin.idea.slicer.Slicer;
import org.jetbrains.kotlin.psi.KtCallableDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ImplicitReceiver;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0096\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J(\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0016R\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/slicer/ReceiverSliceProducer;", "Lorg/jetbrains/kotlin/idea/slicer/SliceProducer;", "()V", "testPresentation", "", "getTestPresentation", "()Ljava/lang/String;", "equals", "", "other", "", "hashCode", "", "produce", "", "Lcom/intellij/slicer/SliceUsage;", "usage", "Lcom/intellij/usageView/UsageInfo;", "mode", "Lorg/jetbrains/kotlin/idea/slicer/KotlinSliceAnalysisMode;", "parent", "kotlin.idea"})
public final class ReceiverSliceProducer
implements SliceProducer {
    @NotNull
    public static final ReceiverSliceProducer INSTANCE;

    @Override
    @Nullable
    public Collection<SliceUsage> produce(@NotNull UsageInfo usage, @NotNull KotlinSliceAnalysisMode mode, @NotNull SliceUsage parent2) {
        PsiExpression psiExpression;
        PsiElement refElement2;
        Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        PsiElement psiElement2 = usage.getElement();
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"usage.element ?: return emptyList()");
        PsiElement psiElement3 = refElement2 = psiElement2;
        if (psiElement3 instanceof KtExpression) {
            ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)refElement2), null, (int)1, null);
            if (resolvedCall2 == null) {
                return CollectionsKt.emptyList();
            }
            ResolvedCall resolvedCall3 = resolvedCall2;
            ReceiverValue receiver2 = resolvedCall3.getExtensionReceiver();
            if (receiver2 instanceof ExpressionReceiver) {
                return CollectionsKt.listOf((Object)((Object)new KotlinSliceUsage((PsiElement)((ExpressionReceiver)receiver2).getExpression(), parent2, mode, true)));
            }
            if (receiver2 instanceof ImplicitReceiver) {
                DeclarationDescriptor declarationDescriptor = ((ImplicitReceiver)receiver2).getDeclarationDescriptor();
                if (!(declarationDescriptor instanceof CallableDescriptor)) {
                    declarationDescriptor = null;
                }
                CallableDescriptor callableDescriptor = (CallableDescriptor)declarationDescriptor;
                if (callableDescriptor == null) {
                    return CollectionsKt.emptyList();
                }
                CallableDescriptor callableDescriptor2 = callableDescriptor;
                DeclarationDescriptor declarationDescriptor2 = (DeclarationDescriptor)callableDescriptor2;
                Project project2 = usage.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"usage.project");
                SearchScope searchScope2 = parent2.getScope().toSearchScope();
                Intrinsics.checkNotNullExpressionValue((Object)searchScope2, (String)"parent.scope.toSearchScope()");
                PsiElement declaration2 = Slicer.Companion.descriptorToPsi(declarationDescriptor2, project2, searchScope2);
                if (declaration2 instanceof KtFunctionLiteral) {
                    KotlinSliceAnalysisMode newMode = mode.withBehaviour(new LambdaCallsBehaviour(INSTANCE));
                    return CollectionsKt.listOf((Object)((Object)new KotlinSliceUsage(declaration2, parent2, newMode, true)));
                }
                if (declaration2 instanceof KtCallableDeclaration) {
                    KtTypeReference ktTypeReference = ((KtCallableDeclaration)declaration2).getReceiverTypeReference();
                    if (ktTypeReference == null) {
                        return CollectionsKt.emptyList();
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"declaration.receiverType\u2026nce ?: return emptyList()");
                    KtTypeReference receiverTypeReference = ktTypeReference;
                    return CollectionsKt.listOf((Object)((Object)new KotlinSliceUsage((PsiElement)receiverTypeReference, parent2, mode, false)));
                }
                return CollectionsKt.emptyList();
            }
            return CollectionsKt.emptyList();
        }
        PsiElement psiElement4 = refElement2.getParent();
        if (!(psiElement4 instanceof PsiCall)) {
            psiElement4 = null;
        }
        if ((psiExpression = (PsiExpression)psiElement4) == null || (psiExpression = psiExpression.getArgumentList()) == null || (psiExpression = psiExpression.getExpressions()) == null || (psiExpression = (PsiExpression)ArraysKt.getOrNull((Object[])psiExpression, (int)0)) == null) {
            return CollectionsKt.emptyList();
        }
        PsiExpression argument2 = psiExpression;
        return CollectionsKt.listOf((Object)((Object)new KotlinSliceUsage((PsiElement)argument2, parent2, mode, false)));
    }

    @Override
    @Nullable
    public String getTestPresentation() {
        return "RECEIVER";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        return other == this;
    }

    @Override
    public int hashCode() {
        return 0;
    }

    private ReceiverSliceProducer() {
    }

    static {
        ReceiverSliceProducer receiverSliceProducer;
        INSTANCE = receiverSliceProducer = new ReceiverSliceProducer();
    }
}

