/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.scratch.ScratchFile;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchAction;
import org.jetbrains.kotlin.idea.scratch.actions.RunScratchFromHereAction;
import org.jetbrains.kotlin.idea.scratch.actions.ScratchCompilationSupport;
import org.jetbrains.kotlin.idea.scratch.ui.KtScratchFileEditorProviderKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u000eH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner;", "Lcom/intellij/openapi/editor/event/DocumentListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "myAlarm", "Lcom/intellij/util/Alarm;", "dispose", "", "documentChanged", "event", "Lcom/intellij/openapi/editor/event/DocumentEvent;", "getScratchFile", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFile;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "runScratch", "scratchFile", "Companion", "kotlin.jvm"})
public final class ScratchFileAutoRunner
implements DocumentListener,
Disposable {
    private final Alarm myAlarm;
    private final Project project;
    public static final int AUTO_RUN_DELAY_IN_SECONDS = 2;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public void documentChanged(@NotNull DocumentEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        VirtualFile virtualFile2 = FileDocumentManager.getInstance().getFile(event.getDocument());
        if (virtualFile2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"FileDocumentManager.getI\u2026event.document) ?: return");
        VirtualFile file2 = virtualFile2;
        if (Disposer.isDisposed((Disposable)this)) {
            return;
        }
        ScratchFile scratchFile = this.getScratchFile(file2, this.project);
        if (scratchFile == null) {
            return;
        }
        ScratchFile scratchFile2 = scratchFile;
        if (!scratchFile2.getOptions().isInteractiveMode()) {
            return;
        }
        CharSequence charSequence = event.getNewFragment();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"event.newFragment");
        CharSequence charSequence2 = charSequence;
        boolean bl = false;
        if (!StringsKt.isBlank((CharSequence)charSequence2)) {
            this.runScratch(scratchFile2);
        }
    }

    private final void runScratch(ScratchFile scratchFile) {
        this.myAlarm.cancelAllRequests();
        if (ScratchCompilationSupport.INSTANCE.isInProgress(scratchFile) && !scratchFile.getOptions().isRepl()) {
            ScratchCompilationSupport.INSTANCE.forceStop();
        }
        this.myAlarm.addRequest(new Runnable(scratchFile){
            final /* synthetic */ ScratchFile $scratchFile;

            public final void run() {
                block3: {
                    Object object = this.$scratchFile.getKtScratchFile();
                    if (object == null) break block3;
                    KtFile ktFile = object;
                    boolean bl = false;
                    boolean bl2 = false;
                    KtFile it = ktFile;
                    boolean bl3 = false;
                    object = it.isValid() && !this.$scratchFile.hasErrors() ? ktFile : null;
                    if (object != null) {
                        ktFile = object;
                        bl = false;
                        bl2 = false;
                        it = ktFile;
                        boolean bl4 = false;
                        if (this.$scratchFile.getOptions().isRepl()) {
                            RunScratchFromHereAction.Companion.doAction(this.$scratchFile);
                        } else {
                            RunScratchAction.Companion.doAction(this.$scratchFile, true);
                        }
                    }
                }
            }
            {
                this.$scratchFile = scratchFile;
            }
        }, 2000, true);
    }

    private final ScratchFile getScratchFile(VirtualFile file2, Project project2) {
        TextEditor editor2;
        TextEditor textEditor;
        FileEditor fileEditor = FileEditorManager.getInstance((Project)project2).getSelectedEditor(file2);
        if (!(fileEditor instanceof TextEditor)) {
            fileEditor = null;
        }
        return (textEditor = (editor2 = (TextEditor)fileEditor)) != null && (textEditor = KtScratchFileEditorProviderKt.findScratchFileEditorWithPreview(textEditor)) != null ? textEditor.getScratchFile() : null;
    }

    public void dispose() {
    }

    public ScratchFileAutoRunner(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner$Companion;", "", "()V", "AUTO_RUN_DELAY_IN_SECONDS", "", "addListener", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/fileEditor/TextEditor;", "getInstance", "Lorg/jetbrains/kotlin/idea/scratch/ScratchFileAutoRunner;", "kotlin.jvm"})
    public static final class Companion {
        public final void addListener(@NotNull Project project2, @NotNull TextEditor editor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
            if (ScratchUtilsKt.getScratchFile(editor2) != null) {
                Editor editor3 = editor2.getEditor();
                Intrinsics.checkNotNullExpressionValue((Object)editor3, (String)"editor.editor");
                editor3.getDocument().addDocumentListener((DocumentListener)this.getInstance(project2));
                Disposer.register((Disposable)((Disposable)editor2), (Disposable)new Disposable(editor2, project2){
                    final /* synthetic */ TextEditor $editor;
                    final /* synthetic */ Project $project;

                    public final void dispose() {
                        Editor editor2 = this.$editor.getEditor();
                        Intrinsics.checkNotNullExpressionValue((Object)editor2, (String)"editor.editor");
                        editor2.getDocument().removeDocumentListener((DocumentListener)org.jetbrains.kotlin.idea.scratch.ScratchFileAutoRunner$Companion.access$getInstance(ScratchFileAutoRunner.Companion, this.$project));
                    }
                    {
                        this.$editor = textEditor;
                        this.$project = project2;
                    }
                });
            }
        }

        private final ScratchFileAutoRunner getInstance(Project project2) {
            ComponentManager $this$getServiceSafe$iv = (ComponentManager)project2;
            boolean $i$f$getServiceSafe = false;
            Object object = $this$getServiceSafe$iv.getService(ScratchFileAutoRunner.class);
            if (object == null) {
                String string = "Unable to locate service " + ScratchFileAutoRunner.class.getName();
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return (ScratchFileAutoRunner)object;
        }

        private Companion() {
        }

        public static final /* synthetic */ ScratchFileAutoRunner access$getInstance(Companion $this, Project project2) {
            return $this.getInstance(project2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

