/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.roots;

import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.ExternalProjectInfo;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.project.ContentRootData;
import com.intellij.openapi.externalSystem.model.project.ProjectData;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.NonPhysicalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.ex.JpsElementBase;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaResourceRootProperties;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.kotlin.config.KotlinResourceRootTypeKt;
import org.jetbrains.kotlin.config.ResourceKotlinRootType;
import org.jetbrains.kotlin.config.SourceKotlinRootType;
import org.jetbrains.kotlin.config.TestResourceKotlinRootType;
import org.jetbrains.kotlin.config.TestSourceKotlinRootType;
import org.jetbrains.kotlin.idea.configuration.GradleDetectorKt;
import org.jetbrains.kotlin.idea.framework.KotlinSdkType;
import org.jetbrains.kotlin.idea.roots.NodeWithData;
import org.jetbrains.kotlin.idea.roots.ProjectRootUtilsKt;
import org.jetbrains.kotlin.idea.util.SafeAnalyzeKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u008a\u0001\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u001a\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b\u001a\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u0013\u001a\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\n\u001a\u00020\u000b\u001a\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00152\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u000e\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c\u001a\u0010\u0010\u001d\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013\u001a\"\u0010\u001f\u001a\u00020\u001a2\b\u0010\u001e\u001a\u0004\u0018\u00010\u00132\u0010\u0010 \u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\"0!\u001a\u000e\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020%\u001a\u0010\u0010&\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0015*\u00020\u000b\u001a2\u0010'\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H)0(0\u0015\"\b\b\u0000\u0010)*\u00020**\u0006\u0012\u0002\b\u00030\u00102\f\u0010+\u001a\b\u0012\u0004\u0012\u0002H)0,\u001a\u001e\u0010-\u001a\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u00020/0\"\u0012\u0004\u0012\u00020/\u0018\u00010.*\u000200\u001a\u0014\u00101\u001a\n 2*\u0004\u0018\u00010/0/*\u000200H\u0002\"#\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002*\u00020\u00038FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0006\u0010\u0007\u00a8\u00063"}, d2={"pathAsUrl", "", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot;", "getPathAsUrl$annotations", "(Lcom/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot;)V", "getPathAsUrl", "(Lcom/intellij/openapi/externalSystem/model/project/ContentRootData$SourceRoot;)Ljava/lang/String;", "collectSuitableDestinationSourceRoots", "", "module", "Lcom/intellij/openapi/module/Module;", "result", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "findGradleProjectStructure", "Lcom/intellij/openapi/externalSystem/model/DataNode;", "Lcom/intellij/openapi/externalSystem/model/project/ProjectData;", "file", "Lcom/intellij/psi/PsiFile;", "getKotlinAwareDestinationSourceRoots", "", "project", "Lcom/intellij/openapi/project/Project;", "getSuitableDestinationSourceRoots", "isForGeneratedSources", "", "sourceFolder", "Lcom/intellij/openapi/roots/SourceFolder;", "isOutsideKotlinAwareSourceRoot", "psiFile", "isOutsideSourceRootSet", "sourceRootTypes", "", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRootType;", "migrateNonJvmSourceFolders", "modifiableRootModel", "Lcom/intellij/openapi/roots/ModifiableRootModel;", "collectKotlinAwareDestinationSourceRoots", "findAll", "Lorg/jetbrains/kotlin/idea/roots/NodeWithData;", "T", "", "key", "Lcom/intellij/openapi/externalSystem/model/Key;", "getMigratedSourceRootTypeWithProperties", "Lkotlin/Pair;", "Lorg/jetbrains/jps/model/JpsElement;", "Lorg/jetbrains/jps/model/module/JpsModuleSourceRoot;", "getOrCreateProperties", "kotlin.jvm.PlatformType", "kotlin.idea"})
public final class ProjectRootUtilsKt {
    private static final JpsElement getOrCreateProperties(JpsModuleSourceRoot $this$getOrCreateProperties) {
        JpsElement jpsElement;
        block6: {
            block5: {
                jpsElement = $this$getOrCreateProperties.getProperties($this$getOrCreateProperties.getRootType());
                if (jpsElement == null) break block5;
                JpsElement jpsElement2 = jpsElement;
                boolean bl = false;
                boolean bl2 = false;
                JpsElement it = jpsElement2;
                boolean bl3 = false;
                JpsElement jpsElement3 = it;
                if (!(jpsElement3 instanceof JpsElementBase)) {
                    jpsElement3 = null;
                }
                JpsElementBase jpsElementBase = (JpsElementBase)jpsElement3;
                if (jpsElementBase != null) {
                    jpsElementBase.setParent(null);
                }
                if ((jpsElement = jpsElement2) != null) break block6;
            }
            jpsElement = (JpsElement)$this$getOrCreateProperties.getRootType().createDefaultProperties();
        }
        return jpsElement;
    }

    @Nullable
    public static final Pair<JpsModuleSourceRootType<JpsElement>, JpsElement> getMigratedSourceRootTypeWithProperties(@NotNull JpsModuleSourceRoot $this$getMigratedSourceRootTypeWithProperties) {
        JpsModuleSourceRootType jpsModuleSourceRootType;
        JpsModuleSourceRootType currentRootType;
        Intrinsics.checkNotNullParameter((Object)$this$getMigratedSourceRootTypeWithProperties, (String)"$this$getMigratedSourceRootTypeWithProperties");
        JpsModuleSourceRootType jpsModuleSourceRootType2 = $this$getMigratedSourceRootTypeWithProperties.getRootType();
        Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRootType2, (String)"rootType");
        JpsModuleSourceRootType jpsModuleSourceRootType3 = currentRootType = jpsModuleSourceRootType2;
        if (Intrinsics.areEqual((Object)jpsModuleSourceRootType3, (Object)JavaSourceRootType.SOURCE)) {
            SourceKotlinRootType sourceKotlinRootType = SourceKotlinRootType.INSTANCE;
            if (sourceKotlinRootType == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.jps.model.module.JpsModuleSourceRootType<org.jetbrains.jps.model.JpsElement>");
            }
            jpsModuleSourceRootType = (JpsModuleSourceRootType)sourceKotlinRootType;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType3, (Object)JavaSourceRootType.TEST_SOURCE)) {
            jpsModuleSourceRootType = (JpsModuleSourceRootType)TestSourceKotlinRootType.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType3, (Object)JavaResourceRootType.RESOURCE)) {
            jpsModuleSourceRootType = (JpsModuleSourceRootType)ResourceKotlinRootType.INSTANCE;
        } else if (Intrinsics.areEqual((Object)jpsModuleSourceRootType3, (Object)JavaResourceRootType.TEST_RESOURCE)) {
            jpsModuleSourceRootType = (JpsModuleSourceRootType)TestResourceKotlinRootType.INSTANCE;
        } else {
            return null;
        }
        if (jpsModuleSourceRootType == null) {
            throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.jps.model.module.JpsModuleSourceRootType<org.jetbrains.jps.model.JpsElement>");
        }
        JpsModuleSourceRootType newSourceRootType = jpsModuleSourceRootType;
        return TuplesKt.to((Object)newSourceRootType, (Object)ProjectRootUtilsKt.getOrCreateProperties($this$getMigratedSourceRootTypeWithProperties));
    }

    /*
     * WARNING - void declaration
     */
    public static final void migrateNonJvmSourceFolders(@NotNull ModifiableRootModel modifiableRootModel) {
        Intrinsics.checkNotNullParameter((Object)modifiableRootModel, (String)"modifiableRootModel");
        ContentEntry[] contentEntryArray = modifiableRootModel.getContentEntries();
        int n = contentEntryArray.length;
        for (int j = 0; j < n; ++j) {
            ContentEntry contentEntry;
            ContentEntry contentEntry2 = contentEntry = contentEntryArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)contentEntry2, (String)"contentEntry");
            SourceFolder[] sourceFolderArray = contentEntry2.getSourceFolders();
            int n2 = sourceFolderArray.length;
            for (int k = 0; k < n2; ++k) {
                void newSourceRootType;
                String url;
                Pair<JpsModuleSourceRootType<JpsElement>, JpsElement> pair;
                SourceFolder sourceFolder;
                SourceFolder sourceFolder2 = sourceFolder = sourceFolderArray[k];
                Intrinsics.checkNotNullExpressionValue((Object)sourceFolder2, (String)"sourceFolder");
                JpsModuleSourceRoot jpsModuleSourceRoot = sourceFolder2.getJpsElement();
                Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRoot, (String)"sourceFolder.jpsElement");
                if (ProjectRootUtilsKt.getMigratedSourceRootTypeWithProperties(jpsModuleSourceRoot) == null) {
                    continue;
                }
                JpsModuleSourceRootType jpsModuleSourceRootType = (JpsModuleSourceRootType)pair.component1();
                JpsElement properties2 = (JpsElement)pair.component2();
                Intrinsics.checkNotNullExpressionValue((Object)sourceFolder.getUrl(), (String)"sourceFolder.url");
                contentEntry.removeSourceFolder(sourceFolder);
                contentEntry.addSourceFolder(url, (JpsModuleSourceRootType)newSourceRootType, properties2);
            }
        }
        KotlinSdkType.Companion.setUpIfNeeded$default(KotlinSdkType.Companion, null, null, 3, null);
    }

    @IntellijInternalApi
    public static /* synthetic */ void getPathAsUrl$annotations(ContentRootData.SourceRoot sourceRoot) {
    }

    @NotNull
    public static final String getPathAsUrl(@NotNull ContentRootData.SourceRoot $this$pathAsUrl) {
        Intrinsics.checkNotNullParameter((Object)$this$pathAsUrl, (String)"$this$pathAsUrl");
        String string = VirtualFileManager.constructUrl((String)"file", (String)FileUtil.toSystemIndependentName((String)$this$pathAsUrl.getPath()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VirtualFileManager.const\u2026temIndependentName(path))");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<VirtualFile> getKotlinAwareDestinationSourceRoots(@NotNull Project project2) {
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        Intrinsics.checkNotNullExpressionValue((Object)moduleArray, (String)"ModuleManager.getInstance(project).modules");
        Module[] $this$flatMap$iv = moduleArray;
        boolean $i$f$flatMap = false;
        Module[] moduleArray2 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        void var6_6 = $this$flatMapTo$iv$iv;
        int n = ((void)var6_6).length;
        for (int j = 0; j < n; ++j) {
            void element$iv$iv;
            void it = element$iv$iv = var6_6[j];
            boolean bl = false;
            void v2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"it");
            Iterable list$iv$iv = ProjectRootUtilsKt.collectKotlinAwareDestinationSourceRoots((Module)v2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<VirtualFile> collectKotlinAwareDestinationSourceRoots(@NotNull Module $this$collectKotlinAwareDestinationSourceRoots) {
        Intrinsics.checkNotNullParameter((Object)$this$collectKotlinAwareDestinationSourceRoots, (String)"$this$collectKotlinAwareDestinationSourceRoots");
        Object[] objectArray = ProjectUtil.getRootManager((Module)$this$collectKotlinAwareDestinationSourceRoots).getContentEntries();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"rootManager\n        .contentEntries");
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filterNot((Sequence)SequencesKt.flatMap((Sequence)ArraysKt.asSequence((Object[])objectArray), (Function1)collectKotlinAwareDestinationSourceRoots.1.INSTANCE), (Function1)collectKotlinAwareDestinationSourceRoots.2.INSTANCE), (Function1)collectKotlinAwareDestinationSourceRoots.3.INSTANCE));
    }

    public static final boolean isOutsideSourceRootSet(@Nullable PsiFile psiFile2, @NotNull Set<? extends JpsModuleSourceRootType<?>> sourceRootTypes) {
        Intrinsics.checkNotNullParameter(sourceRootTypes, (String)"sourceRootTypes");
        if (psiFile2 == null || psiFile2 instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile virtualFile2 = psiFile2.getVirtualFile();
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile file2 = virtualFile2;
        if (file2.getFileSystem() instanceof NonPhysicalFileSystem) {
            return false;
        }
        ProjectRootManager projectRootManager = ProjectRootManager.getInstance((Project)psiFile2.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)projectRootManager, (String)"ProjectRootManager.getInstance(psiFile.project)");
        ProjectFileIndex projectFileIndex = projectRootManager.getFileIndex();
        Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"ProjectRootManager.getIn\u2026siFile.project).fileIndex");
        ProjectFileIndex projectFileIndex2 = projectFileIndex;
        return !projectFileIndex2.isUnderSourceRootOfType(file2, sourceRootTypes) && !projectFileIndex2.isInLibrary(file2);
    }

    public static final boolean isOutsideKotlinAwareSourceRoot(@Nullable PsiFile psiFile2) {
        return ProjectRootUtilsKt.isOutsideSourceRootSet(psiFile2, SafeAnalyzeKt.getKOTLIN_AWARE_SOURCE_ROOT_TYPES());
    }

    @NotNull
    public static final List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        ArrayList roots2 = new ArrayList();
        ModuleManager moduleManager = ModuleManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
        Module[] moduleArray = moduleManager.getModules();
        int n = moduleArray.length;
        for (int j = 0; j < n; ++j) {
            Module module2;
            Module module3 = module2 = moduleArray[j];
            Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"module");
            ProjectRootUtilsKt.collectSuitableDestinationSourceRoots(module3, roots2);
        }
        return roots2;
    }

    @NotNull
    public static final List<VirtualFile> getSuitableDestinationSourceRoots(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        ArrayList roots2 = new ArrayList();
        ProjectRootUtilsKt.collectSuitableDestinationSourceRoots(module2, roots2);
        return roots2;
    }

    public static final void collectSuitableDestinationSourceRoots(@NotNull Module module2, @NotNull List<VirtualFile> result2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
        for (ContentEntry entry : moduleRootManager.getContentEntries()) {
            Iterator iterator = entry.getSourceFolders(SafeAnalyzeKt.getKOTLIN_AWARE_SOURCE_ROOT_TYPES()).iterator();
            while (iterator.hasNext()) {
                SourceFolder sourceFolder;
                SourceFolder sourceFolder2 = sourceFolder = (SourceFolder)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)sourceFolder2, (String)"sourceFolder");
                if (ProjectRootUtilsKt.isForGeneratedSources(sourceFolder2)) continue;
                ContainerUtil.addIfNotNull((Collection)result2, (Object)sourceFolder.getFile());
            }
        }
    }

    public static final boolean isForGeneratedSources(@NotNull SourceFolder sourceFolder) {
        Intrinsics.checkNotNullParameter((Object)sourceFolder, (String)"sourceFolder");
        JavaSourceRootProperties properties2 = (JavaSourceRootProperties)sourceFolder.getJpsElement().getProperties(SafeAnalyzeKt.getKOTLIN_AWARE_SOURCE_ROOT_TYPES());
        JavaResourceRootProperties javaResourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(JavaModuleSourceRootTypes.RESOURCES);
        JavaResourceRootProperties kotlinResourceProperties = (JavaResourceRootProperties)sourceFolder.getJpsElement().getProperties(KotlinResourceRootTypeKt.getALL_KOTLIN_RESOURCE_ROOT_TYPES());
        return properties2 != null && properties2.isForGeneratedSources() || javaResourceProperties != null && javaResourceProperties.isForGeneratedSources() || kotlinResourceProperties != null && kotlinResourceProperties.isForGeneratedSources();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<NodeWithData<T>> findAll(@NotNull DataNode<?> $this$findAll, @NotNull Key<T> key) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter($this$findAll, (String)"$this$findAll");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Collection collection = ExternalSystemApiUtil.findAll($this$findAll, key);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"ExternalSystemApiUtil.findAll(this, key)");
        Collection nodes = collection;
        Iterable $this$mapNotNull$iv = nodes;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            NodeWithData<Object> nodeWithData;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            DataNode it = (DataNode)element$iv$iv;
            boolean bl2 = false;
            if (it.getData(key) == null) {
                nodeWithData = null;
            } else {
                Object data;
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"it.getData(key) ?: return@mapNotNull null");
                DataNode dataNode = it;
                Intrinsics.checkNotNullExpressionValue((Object)dataNode, (String)"it");
                nodeWithData = new NodeWithData<Object>(dataNode, data);
            }
            if (nodeWithData == null) continue;
            NodeWithData<Object> nodeWithData2 = nodeWithData;
            boolean bl3 = false;
            boolean bl4 = false;
            NodeWithData<Object> it$iv$iv = nodeWithData2;
            boolean bl5 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull PsiFile file2) {
        DataNode<ProjectData> dataNode;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Module module2 = ModuleUtilCore.findModuleForFile((VirtualFile)file2.getVirtualFile(), (Project)file2.getProject());
        if (module2 != null) {
            Module module3 = module2;
            boolean bl = false;
            boolean bl2 = false;
            Module it = module3;
            boolean bl3 = false;
            Module module4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)module4, (String)"it");
            dataNode = ProjectRootUtilsKt.findGradleProjectStructure(module4);
        } else {
            dataNode = null;
        }
        return dataNode;
    }

    @Nullable
    public static final DataNode<ProjectData> findGradleProjectStructure(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        String string = ExternalSystemApiUtil.getExternalProjectPath((Module)module2);
        if (string == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ExternalSystemApiUtil.ge\u2026th(module) ?: return null");
        String externalProjectPath = string;
        ExternalProjectInfo externalProjectInfo = ExternalSystemUtil.getExternalProjectInfo((Project)module2.getProject(), (ProjectSystemId)GradleDetectorKt.getGRADLE_SYSTEM_ID(), (String)externalProjectPath);
        if (externalProjectInfo == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)externalProjectInfo, (String)"ExternalSystemUtil.getEx\u2026ojectPath) ?: return null");
        ExternalProjectInfo projectInfo = externalProjectInfo;
        return projectInfo.getExternalProjectStructure();
    }
}

