/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.maven;

import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.importing.MavenImporter;
import org.jetbrains.idea.maven.importing.MavenRootModelAdapter;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsProcessorTask;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.kotlin.idea.formatter.ProjectCodeStyleImporter;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J0\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016Jb\u0010\u000f\u001a\u00020\b2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00152\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/KotlinCodeStyleMavenImporter;", "Lorg/jetbrains/idea/maven/importing/MavenImporter;", "()V", "isApplicable", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "preProcess", "", "module", "Lcom/intellij/openapi/module/Module;", "changes", "Lorg/jetbrains/idea/maven/project/MavenProjectChanges;", "modifiableModelsProvider", "Lcom/intellij/openapi/externalSystem/service/project/IdeModifiableModelsProvider;", "process", "rootModel", "Lorg/jetbrains/idea/maven/importing/MavenRootModelAdapter;", "mavenModel", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "mavenProjectToModuleName", "", "", "postTasks", "", "Lorg/jetbrains/idea/maven/project/MavenProjectsProcessorTask;", "Companion", "kotlin.maven"})
public final class KotlinCodeStyleMavenImporter
extends MavenImporter {
    private static final String KOTLIN_CODE_STYLE_MAVEN_SETTING = "kotlin.code.style";
    @NotNull
    public static final Companion Companion = new Companion(null);

    public boolean isApplicable(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return Companion.getCodeStyleString(mavenProject) != null;
    }

    public void preProcess(@Nullable Module module2, @Nullable MavenProject mavenProject, @Nullable MavenProjectChanges changes, @Nullable IdeModifiableModelsProvider modifiableModelsProvider) {
    }

    public void process(@Nullable IdeModifiableModelsProvider modifiableModelsProvider, @NotNull Module module2, @Nullable MavenRootModelAdapter rootModel, @NotNull MavenProjectsTree mavenModel, @NotNull MavenProject mavenProject, @Nullable MavenProjectChanges changes, @Nullable Map<MavenProject, String> mavenProjectToModuleName, @NotNull List<MavenProjectsProcessorTask> postTasks) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)mavenModel, (String)"mavenModel");
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        Intrinsics.checkNotNullParameter(postTasks, (String)"postTasks");
        if (!mavenModel.getRootProjects().contains(mavenProject)) {
            return;
        }
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        ProjectCodeStyleImporter.INSTANCE.apply(project2, Companion.getCodeStyleString(mavenProject));
    }

    public KotlinCodeStyleMavenImporter() {
        super("org.jetbrains.kotlin", "kotlin-maven-plugin");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lorg/jetbrains/kotlin/idea/maven/KotlinCodeStyleMavenImporter$Companion;", "", "()V", "KOTLIN_CODE_STYLE_MAVEN_SETTING", "", "getCodeStyleString", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "kotlin.maven"})
    public static final class Companion {
        @Nullable
        public final String getCodeStyleString(@NotNull MavenProject mavenProject) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            return mavenProject.getProperties().getProperty(KotlinCodeStyleMavenImporter.KOTLIN_CODE_STYLE_MAVEN_SETTING);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

