/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections.dfa;

import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.TypeConstraint;
import com.intellij.codeInspection.dataFlow.TypeConstraints;
import com.intellij.codeInspection.dataFlow.jvm.SpecialField;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeBinOp;
import com.intellij.codeInspection.dataFlow.rangeSet.LongRangeSet;
import com.intellij.codeInspection.dataFlow.types.DfBooleanConstantType;
import com.intellij.codeInspection.dataFlow.types.DfDoubleConstantType;
import com.intellij.codeInspection.dataFlow.types.DfFloatConstantType;
import com.intellij.codeInspection.dataFlow.types.DfIntConstantType;
import com.intellij.codeInspection.dataFlow.types.DfLongConstantType;
import com.intellij.codeInspection.dataFlow.types.DfNullConstantType;
import com.intellij.codeInspection.dataFlow.types.DfPrimitiveType;
import com.intellij.codeInspection.dataFlow.types.DfReferenceType;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.types.DfTypes;
import com.intellij.codeInspection.dataFlow.value.RelationType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.FunctionDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.dfa.LambdaAndParameter;
import org.jetbrains.kotlin.idea.project.PlatformKt;
import org.jetbrains.kotlin.idea.util.SafeAnalyzeKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtBinaryExpressionWithTypeRHS;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParenthesizedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSuperTypeListEntry;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.bindingContextUtil.BindingContextUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMapping;
import org.jetbrains.kotlin.resolve.calls.model.ArgumentMatch;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.constants.BooleanValue;
import org.jetbrains.kotlin.resolve.constants.ByteValue;
import org.jetbrains.kotlin.resolve.constants.CharValue;
import org.jetbrains.kotlin.resolve.constants.CompileTimeConstant;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;
import org.jetbrains.kotlin.resolve.constants.DoubleValue;
import org.jetbrains.kotlin.resolve.constants.FloatValue;
import org.jetbrains.kotlin.resolve.constants.IntValue;
import org.jetbrains.kotlin.resolve.constants.LongValue;
import org.jetbrains.kotlin.resolve.constants.NullValue;
import org.jetbrains.kotlin.resolve.constants.ShortValue;
import org.jetbrains.kotlin.resolve.constants.evaluate.ConstantExpressionEvaluator;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.source.KotlinSourceElement;
import org.jetbrains.kotlin.types.FlexibleTypesKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000^\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001a\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0006\u001a\u00020\nH\u0000\u001a\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0000\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0000\u001a\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0000\u001a\u0016\u0010\u0017\u001a\u00020\u0015*\u0004\u0018\u00010\u00162\u0006\u0010\u0018\u001a\u00020\u0001H\u0000\u001a\u0016\u0010\u0019\u001a\u0004\u0018\u00010\u0016*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u000e\u0010\u001c\u001a\u0004\u0018\u00010\u0016*\u00020\u001dH\u0000\u001a\u0016\u0010\u001e\u001a\u00020\u0005*\u0004\u0018\u00010\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0014\u0010\u001f\u001a\u00020\u0005*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0016\u0010 \u001a\u0004\u0018\u00010!*\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u00a8\u0006\""}, d2={"correctFqName", "", "fqNameUnsafe", "Lorg/jetbrains/kotlin/name/FqNameUnsafe;", "getConstant", "Lcom/intellij/codeInspection/dataFlow/types/DfType;", "expr", "Lorg/jetbrains/kotlin/psi/KtConstantExpression;", "getInlineableLambda", "Lorg/jetbrains/kotlin/idea/inspections/dfa/LambdaAndParameter;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "mathOpFromAssignmentToken", "Lcom/intellij/codeInspection/dataFlow/rangeSet/LongRangeBinOp;", "token", "Lcom/intellij/psi/tree/IElementType;", "mathOpFromToken", "ref", "Lorg/jetbrains/kotlin/psi/KtOperationReferenceExpression;", "relationFromToken", "Lcom/intellij/codeInspection/dataFlow/value/RelationType;", "canBeNull", "", "Lorg/jetbrains/kotlin/types/KotlinType;", "fqNameEquals", "fqName", "getArrayElementType", "context", "Lorg/jetbrains/kotlin/psi/KtElement;", "getKotlinType", "Lorg/jetbrains/kotlin/psi/KtExpression;", "toDfType", "toDfTypeNotNullable", "toPsiType", "Lcom/intellij/psi/PsiType;", "kotlin.idea"})
public final class KtDfaHelpersKt {
    @NotNull
    public static final DfType toDfType(@Nullable KotlinType $this$toDfType, @NotNull KtElement context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if ($this$toDfType == null) {
            DfType dfType = DfType.TOP;
            Intrinsics.checkNotNullExpressionValue((Object)dfType, (String)"DfType.TOP");
            return dfType;
        }
        if (KtDfaHelpersKt.canBeNull($this$toDfType)) {
            DfType dfType;
            DfType dfType2;
            DfType notNullableType = KtDfaHelpersKt.toDfTypeNotNullable(TypeUtilsKt.makeNotNullable((KotlinType)$this$toDfType), context2);
            if (notNullableType instanceof DfPrimitiveType) {
                DfType dfType3 = SpecialField.UNBOX.asDfType(notNullableType).meet(DfTypes.typedObject((PsiType)KtDfaHelpersKt.toPsiType($this$toDfType, context2), (Nullability)Nullability.UNKNOWN));
                Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"SpecialField.UNBOX.asDfT\u2026t), Nullability.UNKNOWN))");
                notNullableType = dfType3;
            }
            if ((dfType2 = notNullableType) instanceof DfReferenceType) {
                DfType dfType4 = ((DfReferenceType)notNullableType).dropNullability().meet((DfType)DfaNullability.NULLABLE.asDfType());
                dfType = dfType4;
                Intrinsics.checkNotNullExpressionValue((Object)dfType4, (String)"notNullableType.dropNull\u2026lity.NULLABLE.asDfType())");
            } else if (Intrinsics.areEqual((Object)dfType2, (Object)DfType.BOTTOM)) {
                DfNullConstantType dfNullConstantType = DfTypes.NULL;
                Intrinsics.checkNotNullExpressionValue((Object)dfNullConstantType, (String)"DfTypes.NULL");
                dfType = (DfType)dfNullConstantType;
            } else {
                dfType = notNullableType;
            }
            return dfType;
        }
        return KtDfaHelpersKt.toDfTypeNotNullable($this$toDfType, context2);
    }

    /*
     * WARNING - void declaration
     */
    private static final DfType toDfTypeNotNullable(KotlinType $this$toDfTypeNotNullable, KtElement context2) {
        DfType dfType;
        ClassifierDescriptor descriptor2 = $this$toDfTypeNotNullable.getConstructor().getDeclarationDescriptor();
        if (descriptor2 instanceof TypeAliasDescriptor) {
            dfType = KtDfaHelpersKt.toDfType((KotlinType)((TypeAliasDescriptor)descriptor2).getExpandedType(), context2);
        } else if (descriptor2 instanceof ClassDescriptor) {
            DfType dfType2;
            FqNameUnsafe fqNameUnsafe = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)descriptor2));
            if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._boolean)) {
                dfType2 = (DfType)DfTypes.BOOLEAN;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._byte)) {
                dfType2 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)-128, (long)127));
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._char)) {
                int n = 0;
                boolean bl = false;
                long l = n;
                n = 65535;
                bl = false;
                dfType2 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)l, (long)n));
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._short)) {
                dfType2 = DfTypes.intRange((LongRangeSet)LongRangeSet.range((long)Short.MIN_VALUE, (long)Short.MAX_VALUE));
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._int)) {
                dfType2 = (DfType)DfTypes.INT;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._long)) {
                dfType2 = (DfType)DfTypes.LONG;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._float)) {
                dfType2 = (DfType)DfTypes.FLOAT;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames._double)) {
                dfType2 = (DfType)DfTypes.DOUBLE;
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames.array)) {
                PsiType psiType = KtDfaHelpersKt.toPsiType($this$toDfTypeNotNullable, context2);
                if (psiType == null) {
                    DfType dfType3 = DfType.TOP;
                    Intrinsics.checkNotNullExpressionValue((Object)dfType3, (String)"DfType.TOP");
                    return dfType3;
                }
                dfType2 = TypeConstraints.instanceOf((PsiType)psiType).asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT);
            } else if (Intrinsics.areEqual((Object)fqNameUnsafe, (Object)StandardNames.FqNames.any)) {
                dfType2 = (DfType)DfTypes.NOT_NULL_OBJECT;
            } else {
                TypeConstraint typeConstraint;
                String psi2;
                Name name2 = fqNameUnsafe.shortNameOrSpecial();
                Intrinsics.checkNotNullExpressionValue((Object)name2, (String)"fqNameUnsafe.shortNameOrSpecial()");
                if (name2.isSpecial()) {
                    SourceElement sourceElement = ((ClassDescriptor)descriptor2).getSource();
                    Intrinsics.checkNotNullExpressionValue((Object)sourceElement, (String)"descriptor.source");
                    SourceElement source = sourceElement;
                    if (source instanceof KotlinSourceElement && (psi2 = ((KotlinSourceElement)source).getPsi()) instanceof KtObjectDeclaration) {
                        DfType dfType4;
                        void $this$mapTo$iv$iv;
                        void $this$map$iv;
                        BindingContext bindingContext2 = ResolutionUtils.analyze$default((KtElement)psi2, null, (int)1, null);
                        Iterable iterable = ((KtObjectDeclaration)psi2).getSuperTypeListEntries();
                        boolean $i$f$map = false;
                        void var10_12 = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        for (Object item$iv$iv : $this$mapTo$iv$iv) {
                            void entry;
                            KtSuperTypeListEntry ktSuperTypeListEntry = (KtSuperTypeListEntry)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl = false;
                            KtTypeReference ktTypeReference = entry.getTypeReference();
                            PsiType psiType = ktTypeReference != null && (ktTypeReference = BindingContextUtilsKt.getAbbreviatedTypeOrType((KtTypeReference)ktTypeReference, (BindingContext)bindingContext2)) != null ? KtDfaHelpersKt.toPsiType((KotlinType)ktTypeReference, (KtElement)psi2) : null;
                            PsiClass psiClass2 = PsiUtil.resolveClassInClassTypeOnly(psiType);
                            collection.add(psiClass2);
                        }
                        List superTypes = (List)destination$iv$iv;
                        if (superTypes.contains(null)) {
                            DfType dfType5 = DfType.TOP;
                            dfType4 = dfType5;
                            Intrinsics.checkNotNullExpressionValue((Object)dfType5, (String)"DfType.TOP");
                        } else {
                            DfType dfType6 = TypeConstraints.exactSubtype((PsiElement)((PsiElement)psi2), (List)superTypes).asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT);
                            dfType4 = dfType6;
                            Intrinsics.checkNotNullExpressionValue((Object)dfType6, (String)"TypeConstraints.exactSub\u2026(DfTypes.NOT_NULL_OBJECT)");
                        }
                        return dfType4;
                    }
                }
                switch (psi2 = KtDfaHelpersKt.correctFqName(fqNameUnsafe)) {
                    case "kotlin.ByteArray": {
                        typeConstraint = TypeConstraints.exact((PsiType)((PsiType)PsiType.BYTE.createArrayType()));
                        break;
                    }
                    case "kotlin.IntArray": {
                        typeConstraint = TypeConstraints.exact((PsiType)((PsiType)PsiType.INT.createArrayType()));
                        break;
                    }
                    case "kotlin.LongArray": {
                        typeConstraint = TypeConstraints.exact((PsiType)((PsiType)PsiType.LONG.createArrayType()));
                        break;
                    }
                    case "kotlin.ShortArray": {
                        typeConstraint = TypeConstraints.exact((PsiType)((PsiType)PsiType.SHORT.createArrayType()));
                        break;
                    }
                    case "kotlin.CharArray": {
                        typeConstraint = TypeConstraints.exact((PsiType)((PsiType)PsiType.CHAR.createArrayType()));
                        break;
                    }
                    case "kotlin.BooleanArray": {
                        typeConstraint = TypeConstraints.exact((PsiType)((PsiType)PsiType.BOOLEAN.createArrayType()));
                        break;
                    }
                    case "kotlin.FloatArray": {
                        typeConstraint = TypeConstraints.exact((PsiType)((PsiType)PsiType.FLOAT.createArrayType()));
                        break;
                    }
                    case "kotlin.DoubleArray": {
                        typeConstraint = TypeConstraints.exact((PsiType)((PsiType)PsiType.DOUBLE.createArrayType()));
                        break;
                    }
                    default: {
                        void typeFqName;
                        PsiClass psiClass3 = JavaPsiFacade.getInstance((Project)context2.getProject()).findClass((String)typeFqName, context2.getResolveScope());
                        if (psiClass3 == null) {
                            DfType dfType7 = DfType.TOP;
                            Intrinsics.checkNotNullExpressionValue((Object)dfType7, (String)"DfType.TOP");
                            return dfType7;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)psiClass3, (String)"JavaPsiFacade.getInstanc\u2026ope) ?: return DfType.TOP");
                        PsiClass psiClass4 = psiClass3;
                        typeConstraint = TypeConstraints.exactClass((PsiClass)psiClass4).instanceOf();
                    }
                }
                Intrinsics.checkNotNullExpressionValue((Object)typeConstraint, (String)"when (val typeFqName = c\u2026      }\n                }");
                TypeConstraint typeConstraint2 = typeConstraint;
                DfType dfType8 = typeConstraint2.asDfType().meet((DfType)DfTypes.NOT_NULL_OBJECT);
                Intrinsics.checkNotNullExpressionValue((Object)dfType8, (String)"typeConstraint.asDfType(\u2026(DfTypes.NOT_NULL_OBJECT)");
                return dfType8;
            }
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"when (val fqNameUnsafe =\u2026)\n            }\n        }");
        } else {
            DfType dfType9 = DfType.TOP;
            dfType = dfType9;
            Intrinsics.checkNotNullExpressionValue((Object)dfType9, (String)"DfType.TOP");
        }
        return dfType;
    }

    private static final String correctFqName(FqNameUnsafe fqNameUnsafe) {
        String string;
        String string2;
        String string3 = fqNameUnsafe.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"fqNameUnsafe.asString()");
        switch (string2 = string3) {
            case "kotlin.Any": {
                string = "java.lang.Object";
                break;
            }
            case "kotlin.String": {
                string = "java.lang.String";
                break;
            }
            case "kotlin.CharSequence": {
                string = "java.lang.CharSequence";
                break;
            }
            case "kotlin.Throwable": {
                string = "java.lang.Throwable";
                break;
            }
            case "kotlin.Cloneable": {
                string = "java.lang.Cloneable";
                break;
            }
            case "kotlin.Number": {
                string = "java.lang.Number";
                break;
            }
            case "kotlin.Comparable": {
                string = "java.lang.Comparable";
                break;
            }
            case "kotlin.Enum": {
                string = "java.lang.Enum";
                break;
            }
            case "kotlin.Annotation": {
                string = "java.lang.annotation.Annotation";
                break;
            }
            case "kotlin.Nothing": {
                string = "java.lang.Void";
                break;
            }
            case "kotlin.collections.Iterable": 
            case "kotlin.collections.MutableIterable": {
                string = "java.lang.Iterable";
                break;
            }
            case "kotlin.collections.MutableIterator": 
            case "kotlin.collections.Iterator": {
                string = "java.util.Iterator";
                break;
            }
            case "kotlin.collections.MutableCollection": 
            case "kotlin.collections.Collection": {
                string = "java.util.Collection";
                break;
            }
            case "kotlin.collections.List": 
            case "kotlin.collections.MutableList": {
                string = "java.util.List";
                break;
            }
            case "kotlin.collections.ListIterator": 
            case "kotlin.collections.MutableListIterator": {
                string = "java.util.ListIterator";
                break;
            }
            case "kotlin.collections.Set": 
            case "kotlin.collections.MutableSet": {
                string = "java.util.Set";
                break;
            }
            case "kotlin.collections.MutableMap": 
            case "kotlin.collections.Map": {
                string = "java.util.Map";
                break;
            }
            case "kotlin.collections.MapEntry": 
            case "kotlin.collections.MutableMapEntry": {
                string = "java.util.Map.Entry";
                break;
            }
            default: {
                string = string2;
            }
        }
        return string;
    }

    public static final boolean fqNameEquals(@Nullable KotlinType $this$fqNameEquals, @NotNull String fqName2) {
        ClassifierDescriptor classifierDescriptor;
        Intrinsics.checkNotNullParameter((Object)fqName2, (String)"fqName");
        return $this$fqNameEquals != null && Intrinsics.areEqual((classifierDescriptor = $this$fqNameEquals.getConstructor().getDeclarationDescriptor()) != null && (classifierDescriptor = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) != null ? classifierDescriptor.asString() : null, (Object)fqName2);
    }

    public static final boolean canBeNull(@NotNull KotlinType $this$canBeNull) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeNull, (String)"$this$canBeNull");
        return $this$canBeNull.isMarkedNullable() || FlexibleTypesKt.isNullabilityFlexible((KotlinType)$this$canBeNull);
    }

    @NotNull
    public static final DfType getConstant(@NotNull KtConstantExpression expr2) {
        DfType dfType;
        ConstantValue constant;
        Object object;
        Intrinsics.checkNotNullParameter((Object)expr2, (String)"expr");
        BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)((KtElement)expr2), (BodyResolveMode)BodyResolveMode.PARTIAL);
        KotlinType type2 = bindingContext2.getType((KtExpression)expr2);
        if (type2 == null) {
            object = null;
        } else {
            CompileTimeConstant compileTimeConstant = ConstantExpressionEvaluator.Companion.getConstant((KtExpression)expr2, bindingContext2);
            object = compileTimeConstant != null ? compileTimeConstant.toConstantValue(type2) : null;
        }
        ConstantValue constantValue = constant = object;
        if (constantValue instanceof NullValue) {
            DfNullConstantType dfNullConstantType = DfTypes.NULL;
            Intrinsics.checkNotNullExpressionValue((Object)dfNullConstantType, (String)"DfTypes.NULL");
            dfType = (DfType)dfNullConstantType;
        } else if (constantValue instanceof BooleanValue) {
            DfBooleanConstantType dfBooleanConstantType = DfTypes.booleanValue((boolean)((Boolean)((BooleanValue)constant).getValue()));
            Intrinsics.checkNotNullExpressionValue((Object)dfBooleanConstantType, (String)"DfTypes.booleanValue(constant.value)");
            dfType = (DfType)dfBooleanConstantType;
        } else if (constantValue instanceof ByteValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((ByteValue)constant).getValue()).byteValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value.toInt())");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof ShortValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((ShortValue)constant).getValue()).shortValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value.toInt())");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof CharValue) {
            char c = ((Character)((CharValue)constant).getValue()).charValue();
            boolean bl = false;
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)c);
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value.code)");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof IntValue) {
            DfIntConstantType dfIntConstantType = DfTypes.intValue((int)((Number)((IntValue)constant).getValue()).intValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfIntConstantType, (String)"DfTypes.intValue(constant.value)");
            dfType = (DfType)dfIntConstantType;
        } else if (constantValue instanceof LongValue) {
            DfLongConstantType dfLongConstantType = DfTypes.longValue((long)((Number)((LongValue)constant).getValue()).longValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfLongConstantType, (String)"DfTypes.longValue(constant.value)");
            dfType = (DfType)dfLongConstantType;
        } else if (constantValue instanceof FloatValue) {
            DfFloatConstantType dfFloatConstantType = DfTypes.floatValue((float)((Number)((FloatValue)constant).getValue()).floatValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfFloatConstantType, (String)"DfTypes.floatValue(constant.value)");
            dfType = (DfType)dfFloatConstantType;
        } else if (constantValue instanceof DoubleValue) {
            DfDoubleConstantType dfDoubleConstantType = DfTypes.doubleValue((double)((Number)((DoubleValue)constant).getValue()).doubleValue());
            Intrinsics.checkNotNullExpressionValue((Object)dfDoubleConstantType, (String)"DfTypes.doubleValue(constant.value)");
            dfType = (DfType)dfDoubleConstantType;
        } else {
            DfType dfType2 = DfType.TOP;
            dfType = dfType2;
            Intrinsics.checkNotNullExpressionValue((Object)dfType2, (String)"DfType.TOP");
        }
        return dfType;
    }

    @Nullable
    public static final KotlinType getKotlinType(@NotNull KtExpression $this$getKotlinType) {
        Intrinsics.checkNotNullParameter((Object)$this$getKotlinType, (String)"$this$getKotlinType");
        PsiElement parent2 = $this$getKotlinType.getParent();
        if (parent2 instanceof KtDotQualifiedExpression && Intrinsics.areEqual((Object)((KtDotQualifiedExpression)parent2).getSelectorExpression(), (Object)$this$getKotlinType)) {
            parent2 = ((KtDotQualifiedExpression)parent2).getParent();
        }
        while (parent2 instanceof KtParenthesizedExpression) {
            parent2 = ((KtParenthesizedExpression)parent2).getParent();
        }
        if (parent2 instanceof KtBinaryExpressionWithTypeRHS) {
            ResolvedCall call;
            KtSimpleNameExpression ktSimpleNameExpression = ((KtBinaryExpressionWithTypeRHS)parent2).getOperationReference();
            Intrinsics.checkNotNullExpressionValue((Object)ktSimpleNameExpression, (String)"parent.operationReference");
            if (Intrinsics.areEqual((Object)ktSimpleNameExpression.getText(), (Object)"as?") && (call = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)$this$getKotlinType), null, (int)1, null)) != null) {
                ClassifierDescriptor typeDescriptor;
                CallableDescriptor descriptor2 = call.getResultingDescriptor();
                CallableDescriptor callableDescriptor = descriptor2.getOriginal();
                Intrinsics.checkNotNullExpressionValue((Object)callableDescriptor, (String)"descriptor.original");
                KotlinType kotlinType = callableDescriptor.getReturnType();
                ClassifierDescriptor classifierDescriptor = kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null ? kotlinType.getDeclarationDescriptor() : (typeDescriptor = null);
                if (typeDescriptor instanceof TypeParameterDescriptor) {
                    List list2 = ((TypeParameterDescriptor)typeDescriptor).getUpperBounds();
                    Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"typeDescriptor.upperBounds");
                    KotlinType upperBound = (KotlinType)CollectionsKt.singleOrNull((List)list2);
                    if (upperBound != null) {
                        return upperBound;
                    }
                }
            }
        }
        return SafeAnalyzeKt.safeAnalyzeNonSourceRootCode((KtElement)$this$getKotlinType, BodyResolveMode.PARTIAL).getType($this$getKotlinType);
    }

    @Nullable
    public static final KotlinType getArrayElementType(@NotNull KotlinType $this$getArrayElementType, @NotNull KtElement context2) {
        Intrinsics.checkNotNullParameter((Object)$this$getArrayElementType, (String)"$this$getArrayElementType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!KotlinBuiltIns.isArrayOrPrimitiveArray((KotlinType)$this$getArrayElementType)) {
            return null;
        }
        KotlinType kotlinType = PlatformKt.getBuiltIns(context2).getArrayElementType($this$getArrayElementType);
        Intrinsics.checkNotNullExpressionValue((Object)kotlinType, (String)"context.builtIns.getArrayElementType(this)");
        KotlinType type2 = kotlinType;
        if (KotlinBuiltIns.isArray((KotlinType)$this$getArrayElementType) && KotlinBuiltIns.isPrimitiveType((KotlinType)type2)) {
            return TypeUtilsKt.makeNullable((KotlinType)type2);
        }
        return type2;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static final PsiType toPsiType(@NotNull KotlinType $this$toPsiType, @NotNull KtElement context2) {
        PsiType psiType;
        Intrinsics.checkNotNullParameter((Object)$this$toPsiType, (String)"$this$toPsiType");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ClassifierDescriptor classifierDescriptor = $this$toPsiType.getConstructor().getDeclarationDescriptor();
        if (classifierDescriptor == null || (classifierDescriptor = DescriptorUtilsKt.getFqNameUnsafe((DeclarationDescriptor)((DeclarationDescriptor)classifierDescriptor))) == null) {
            return null;
        }
        ClassifierDescriptor typeFqName = classifierDescriptor;
        boolean boxed = KtDfaHelpersKt.canBeNull($this$toPsiType);
        Function1<PsiPrimitiveType, PsiType> $fun$orBoxed$1 = new Function1<PsiPrimitiveType, PsiType>(boxed, context2){
            final /* synthetic */ boolean $boxed;
            final /* synthetic */ KtElement $context;

            @Nullable
            public final PsiType invoke(@NotNull PsiPrimitiveType $this$orBoxed) {
                Intrinsics.checkNotNullParameter((Object)$this$orBoxed, (String)"$this$orBoxed");
                return this.$boxed ? (PsiType)$this$orBoxed.getBoxedType((PsiElement)this.$context) : (PsiType)$this$orBoxed;
            }
            {
                this.$boxed = bl;
                this.$context = ktElement;
                super(1);
            }
        };
        ClassifierDescriptor classifierDescriptor2 = typeFqName;
        if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames._int)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.INT;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.INT");
            psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
        } else if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames._long)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.LONG;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.LONG");
            psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
        } else if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames._short)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.SHORT;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.SHORT");
            psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
        } else if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames._boolean)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.BOOLEAN;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.BOOLEAN");
            psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
        } else if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames._byte)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.BYTE;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.BYTE");
            psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
        } else if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames._char)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.CHAR;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.CHAR");
            psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
        } else if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames._double)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.DOUBLE;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.DOUBLE");
            psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
        } else if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames._float)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.FLOAT;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.FLOAT");
            psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
        } else if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames.nothing)) {
            PsiPrimitiveType psiPrimitiveType = PsiType.VOID;
            Intrinsics.checkNotNullExpressionValue((Object)psiPrimitiveType, (String)"PsiType.VOID");
            psiType = $fun$orBoxed$1.invoke(psiPrimitiveType);
        } else if (Intrinsics.areEqual((Object)classifierDescriptor2, (Object)StandardNames.FqNames.array)) {
            KotlinType kotlinType = KtDfaHelpersKt.getArrayElementType($this$toPsiType, context2);
            psiType = (PsiType)(kotlinType != null && (kotlinType = KtDfaHelpersKt.toPsiType(kotlinType, context2)) != null ? kotlinType.createArrayType() : null);
        } else {
            String string;
            switch (string = KtDfaHelpersKt.correctFqName((FqNameUnsafe)typeFqName)) {
                case "kotlin.ByteArray": {
                    PsiArrayType psiArrayType = PsiType.BYTE.createArrayType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"PsiType.BYTE.createArrayType()");
                    psiType = (PsiType)psiArrayType;
                    break;
                }
                case "kotlin.IntArray": {
                    PsiArrayType psiArrayType = PsiType.INT.createArrayType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"PsiType.INT.createArrayType()");
                    psiType = (PsiType)psiArrayType;
                    break;
                }
                case "kotlin.LongArray": {
                    PsiArrayType psiArrayType = PsiType.LONG.createArrayType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"PsiType.LONG.createArrayType()");
                    psiType = (PsiType)psiArrayType;
                    break;
                }
                case "kotlin.ShortArray": {
                    PsiArrayType psiArrayType = PsiType.SHORT.createArrayType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"PsiType.SHORT.createArrayType()");
                    psiType = (PsiType)psiArrayType;
                    break;
                }
                case "kotlin.CharArray": {
                    PsiArrayType psiArrayType = PsiType.CHAR.createArrayType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"PsiType.CHAR.createArrayType()");
                    psiType = (PsiType)psiArrayType;
                    break;
                }
                case "kotlin.BooleanArray": {
                    PsiArrayType psiArrayType = PsiType.BOOLEAN.createArrayType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"PsiType.BOOLEAN.createArrayType()");
                    psiType = (PsiType)psiArrayType;
                    break;
                }
                case "kotlin.FloatArray": {
                    PsiArrayType psiArrayType = PsiType.FLOAT.createArrayType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"PsiType.FLOAT.createArrayType()");
                    psiType = (PsiType)psiArrayType;
                    break;
                }
                case "kotlin.DoubleArray": {
                    PsiArrayType psiArrayType = PsiType.DOUBLE.createArrayType();
                    Intrinsics.checkNotNullExpressionValue((Object)psiArrayType, (String)"PsiType.DOUBLE.createArrayType()");
                    psiType = (PsiType)psiArrayType;
                    break;
                }
                default: {
                    void fqNameString;
                    PsiClassType psiClassType = JavaPsiFacade.getElementFactory((Project)context2.getProject()).createTypeByFQClassName((String)fqNameString, context2.getResolveScope());
                    Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"JavaPsiFacade.getElement\u2026ng, context.resolveScope)");
                    psiType = (PsiType)psiClassType;
                }
            }
        }
        return psiType;
    }

    @Nullable
    public static final RelationType relationFromToken(@NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IElementType iElementType = token;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LT) ? RelationType.LT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GT) ? RelationType.GT : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LTEQ) ? RelationType.LE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.GTEQ) ? RelationType.GE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQ) ? RelationType.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQ) ? RelationType.NE : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EQEQEQ) ? RelationType.EQ : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.EXCLEQEQEQ) ? RelationType.NE : null)))))));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public static final LongRangeBinOp mathOpFromToken(@NotNull KtOperationReferenceExpression ref2) {
        Intrinsics.checkNotNullParameter((Object)ref2, (String)"ref");
        String string = ref2.getText();
        if (string == null) return null;
        switch (string) {
            case "+": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.PLUS;
                return longRangeBinOp;
            }
            case "-": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MINUS;
                return longRangeBinOp;
            }
            case "*": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MUL;
                return longRangeBinOp;
            }
            case "/": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.DIV;
                return longRangeBinOp;
            }
            case "%": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.MOD;
                return longRangeBinOp;
            }
            case "and": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.AND;
                return longRangeBinOp;
            }
            case "or": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.OR;
                return longRangeBinOp;
            }
            case "xor": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.XOR;
                return longRangeBinOp;
            }
            case "shl": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.SHL;
                return longRangeBinOp;
            }
            case "shr": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.SHR;
                return longRangeBinOp;
            }
            case "ushr": {
                LongRangeBinOp longRangeBinOp = LongRangeBinOp.USHR;
                return longRangeBinOp;
            }
            default: {
                return null;
            }
        }
    }

    @Nullable
    public static final LongRangeBinOp mathOpFromAssignmentToken(@NotNull IElementType token) {
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        IElementType iElementType = token;
        return Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PLUSEQ) ? LongRangeBinOp.PLUS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MINUSEQ) ? LongRangeBinOp.MINUS : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.MULTEQ) ? LongRangeBinOp.MUL : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.DIVEQ) ? LongRangeBinOp.DIV : (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.PERCEQ) ? LongRangeBinOp.MOD : null))));
    }

    @Nullable
    public static final LambdaAndParameter getInlineableLambda(@NotNull KtCallExpression expr2) {
        ArgumentMatch argumentMatch;
        FunctionDescriptor descriptor2;
        Intrinsics.checkNotNullParameter((Object)expr2, (String)"expr");
        List list2 = expr2.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expr.lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        if (ktLambdaArgument == null) {
            return null;
        }
        KtLambdaArgument lambdaArgument = ktLambdaArgument;
        KtLambdaExpression ktLambdaExpression2 = lambdaArgument.getLambdaExpression();
        if (ktLambdaExpression2 == null) {
            return null;
        }
        KtLambdaExpression lambdaExpression2 = ktLambdaExpression2;
        int index2 = expr2.getValueArguments().indexOf(lambdaArgument);
        boolean bl = index2 >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        ResolvedCall resolvedCall2 = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)expr2), null, (int)1, null);
        if (resolvedCall2 == null) {
            return null;
        }
        ResolvedCall resolvedCall3 = resolvedCall2;
        CallableDescriptor callableDescriptor = resolvedCall3.getResultingDescriptor();
        if (!(callableDescriptor instanceof FunctionDescriptor)) {
            callableDescriptor = null;
        }
        if ((descriptor2 = (FunctionDescriptor)callableDescriptor) == null || !descriptor2.isInline()) {
            return null;
        }
        ArgumentMapping argumentMapping = resolvedCall3.getArgumentMapping((ValueArgument)lambdaArgument);
        if (!(argumentMapping instanceof ArgumentMatch)) {
            argumentMapping = null;
        }
        if ((argumentMatch = (ArgumentMatch)argumentMapping) == null || (argumentMatch = argumentMatch.getValueParameter()) == null) {
            return null;
        }
        ArgumentMatch parameterDescriptor = argumentMatch;
        if (parameterDescriptor.isNoinline()) {
            return null;
        }
        return new LambdaAndParameter(lambdaExpression2, (ValueParameterDescriptor)parameterDescriptor);
    }
}

