/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.inspections.AbstractRangeInspection;
import org.jetbrains.kotlin.idea.inspections.ReplaceRangeToWithUntilInspectionKt;
import org.jetbrains.kotlin.idea.intentions.ReplaceUntilWithRangeToIntentionKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.CreateByPatternKt;
import org.jetbrains.kotlin.psi.KtBinaryExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.constants.ConstantValue;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \r2\u00020\u0001:\u0002\r\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithUntilInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractRangeInspection;", "()V", "visitDownTo", "", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "context", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "visitRangeTo", "visitUntil", "Companion", "ReplaceWithUntilQuickFix", "kotlin.idea"})
public final class ReplaceRangeToWithUntilInspection
extends AbstractRangeInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void visitRangeTo(@NotNull KtExpression expression2, @NotNull BindingContext context2, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        if (!ReplaceRangeToWithUntilInspection.Companion.isApplicable(expression2)) {
            return;
        }
        holder.registerProblem((PsiElement)expression2, KotlinBundle.message("inspection.replace.range.to.with.until.display.name", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithUntilQuickFix()});
    }

    @Override
    public void visitUntil(@NotNull KtExpression expression2, @NotNull BindingContext context2, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    @Override
    public void visitDownTo(@NotNull KtExpression expression2, @NotNull BindingContext context2, @NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithUntilInspection$ReplaceWithUntilQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "getName", "kotlin.idea"})
    public static final class ReplaceWithUntilQuickFix
    implements LocalQuickFix {
        @NotNull
        public String getName() {
            return KotlinBundle.message("replace.with.until.quick.fix.text", new Object[0]);
        }

        @NotNull
        public String getFamilyName() {
            return this.getName();
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            PsiElement psiElement2 = descriptor2.getPsiElement();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtExpression");
            }
            KtExpression element3 = (KtExpression)psiElement2;
            Companion.applyFix(element3);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\b\u001a\u00020\u0006H\u0002J\f\u0010\u000b\u001a\u00020\n*\u00020\u0006H\u0002\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReplaceRangeToWithUntilInspection$Companion;", "", "()V", "applyFix", "", "element", "Lorg/jetbrains/kotlin/psi/KtExpression;", "applyFixIfApplicable", "expression", "isApplicable", "", "isMinusOne", "kotlin.idea"})
    public static final class Companion {
        public final void applyFixIfApplicable(@NotNull KtExpression expression2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            if (this.isApplicable(expression2)) {
                this.applyFix(expression2);
            }
        }

        private final boolean isApplicable(KtExpression expression2) {
            KtExpression ktExpression = ReplaceUntilWithRangeToIntentionKt.getArguments(expression2);
            return ktExpression != null && (ktExpression = (KtExpression)ktExpression.getSecond()) != null && (ktExpression = ReplaceRangeToWithUntilInspectionKt.access$deparenthesize(ktExpression)) != null && this.isMinusOne(ktExpression);
        }

        private final void applyFix(KtExpression element3) {
            KtBinaryExpression ktBinaryExpression;
            Pair<KtExpression, KtExpression> pair = ReplaceUntilWithRangeToIntentionKt.getArguments(element3);
            if (pair == null) {
                return;
            }
            Pair<KtExpression, KtExpression> args2 = pair;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null);
            Object[] objectArray = new Object[2];
            KtExpression ktExpression = (KtExpression)args2.getFirst();
            if (ktExpression == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"args.first ?: return");
            objectArray[0] = ktExpression;
            KtExpression ktExpression2 = (KtExpression)args2.getSecond();
            Object object = ktExpression2 != null ? ReplaceRangeToWithUntilInspectionKt.access$deparenthesize(ktExpression2) : null;
            if (!(object instanceof KtBinaryExpression)) {
                object = null;
            }
            if ((ktBinaryExpression = (KtBinaryExpression)object) == null || (ktBinaryExpression = ktBinaryExpression.getLeft()) == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)ktBinaryExpression, (String)"(args.second?.deparenthe\u2026pression)?.left ?: return");
            objectArray[1] = ktBinaryExpression;
            element3.replace((PsiElement)CreateByPatternKt.createExpressionByPattern$default((KtPsiFactory)ktPsiFactory, (String)"$0 until $1", (Object[])objectArray, (boolean)false, (int)4, null));
        }

        private final boolean isMinusOne(KtExpression $this$isMinusOne) {
            ConstantValue constantValue;
            if (!($this$isMinusOne instanceof KtBinaryExpression)) {
                return false;
            }
            if (Intrinsics.areEqual((Object)((KtBinaryExpression)$this$isMinusOne).getOperationToken(), (Object)KtTokens.MINUS) ^ true) {
                return false;
            }
            KtExpression ktExpression = ((KtBinaryExpression)$this$isMinusOne).getRight();
            ConstantValue constantValue2 = constantValue = ktExpression != null ? AbstractRangeInspection.Companion.constantValueOrNull$default(AbstractRangeInspection.Companion, ktExpression, null, 1, null) : null;
            Object object = constantValue2 != null ? constantValue2.getValue() : null;
            if (!(object instanceof Number)) {
                object = null;
            }
            Number number = (Number)object;
            if (number == null) {
                return false;
            }
            int rightValue = number.intValue();
            return rightValue == 1;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

