/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.actions.VcsFacade;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.formatter.CollectChangesWithoutApplyModelKt;
import org.jetbrains.kotlin.idea.formatter.FormattingChange;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0015B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J-\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\rJ\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0012\u0010\u0002\u001a\u00020\u00038\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReformatInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "processChangedFilesOnly", "", "(Z)V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "createOptionsPanel", "Ljavax/swing/JComponent;", "isEmptyLineReformat", "whitespace", "Lcom/intellij/psi/PsiWhiteSpace;", "change", "Lorg/jetbrains/kotlin/idea/formatter/FormattingChange;", "ReformatQuickFix", "kotlin.idea"})
public final class ReformatInspection
extends LocalInspectionTool {
    @JvmField
    public boolean processChangedFilesOnly;

    /*
     * WARNING - void declaration
     */
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor[] problemDescriptorArray;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file2 instanceof KtFile && ((KtFile)file2).isWritable() && ProjectRootsUtil.isInProjectSource$default((PsiElement)file2, false, 2, null))) {
            return null;
        }
        if (this.processChangedFilesOnly && !VcsFacade.getInstance().hasChanges(file2)) {
            return null;
        }
        Iterable<FormattingChange> iterable = CollectChangesWithoutApplyModelKt.collectFormattingChanges(file2);
        boolean bl = false;
        boolean bl2 = false;
        Set<FormattingChange> it = iterable;
        boolean bl3 = false;
        Collection collection = it;
        boolean bl4 = false;
        Set<FormattingChange> set2 = !collection.isEmpty() ? iterable : null;
        if (set2 != null) {
            void $this$toTypedArray$iv;
            void $this$mapNotNullTo$iv$iv;
            Collection $this$mapNotNull$iv;
            iterable = set2;
            boolean $i$f$mapNotNull = false;
            void var6_7 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                ProblemDescriptor problemDescriptor;
                int n;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl5 = false;
                FormattingChange change = (FormattingChange)element$iv$iv;
                boolean bl6 = false;
                FormattingChange formattingChange = change;
                if (formattingChange instanceof FormattingChange.ShiftIndentInsideRange) {
                    n = ((FormattingChange.ShiftIndentInsideRange)change).getRange().getStartOffset();
                } else if (formattingChange instanceof FormattingChange.ReplaceWhiteSpace) {
                    n = ((FormattingChange.ReplaceWhiteSpace)change).getTextRange().getStartOffset();
                } else {
                    throw new NoWhenBranchMatchedException();
                }
                int rangeOffset = n;
                if (file2.findElementAt(rangeOffset) == null) {
                    problemDescriptor = null;
                } else {
                    PsiElement leaf;
                    Intrinsics.checkNotNullExpressionValue((Object)leaf, (String)"file.findElementAt(rangeOffset) ?: return null");
                    problemDescriptor = !leaf.isValid() ? null : (leaf instanceof PsiWhiteSpace && this.isEmptyLineReformat((PsiWhiteSpace)leaf, change) ? null : manager.createProblemDescriptor(leaf, KotlinBundle.message("file.is.not.properly.formatted", new Object[0]), (LocalQuickFix)ReformatQuickFix.INSTANCE, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly));
                }
                if (problemDescriptor == null) continue;
                ProblemDescriptor problemDescriptor2 = problemDescriptor;
                boolean bl7 = false;
                boolean bl8 = false;
                ProblemDescriptor it$iv$iv = problemDescriptor2;
                boolean bl9 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            ProblemDescriptor[] problemDescriptorArray2 = thisCollection$iv.toArray(new ProblemDescriptor[0]);
            if (problemDescriptorArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            problemDescriptorArray = problemDescriptorArray2;
        } else {
            problemDescriptorArray = null;
        }
        return problemDescriptorArray;
    }

    @NotNull
    public JComponent createOptionsPanel() {
        return (JComponent)new SingleCheckboxOptionsPanel(KotlinBundle.message("apply.only.to.modified.files.for.projects.under.a.version.control", new Object[0]), (InspectionProfileEntry)this, "processChangedFilesOnly");
    }

    private final boolean isEmptyLineReformat(PsiWhiteSpace whitespace, FormattingChange change) {
        char it;
        char element$iv;
        int n;
        if (!(change instanceof FormattingChange.ReplaceWhiteSpace)) {
            return false;
        }
        String beforeText = whitespace.getText();
        String afterText = ((FormattingChange.ReplaceWhiteSpace)change).getWhiteSpace();
        String string = beforeText;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"beforeText");
        CharSequence $this$count$iv = string;
        boolean $i$f$count = false;
        int count$iv = 0;
        CharSequence charSequence = $this$count$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            it = element$iv = charSequence.charAt(n);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        $this$count$iv = afterText;
        int n2 = count$iv;
        $i$f$count = false;
        count$iv = 0;
        charSequence = $this$count$iv;
        for (n = 0; n < charSequence.length(); ++n) {
            it = element$iv = charSequence.charAt(n);
            boolean bl = false;
            if (!(it == '\n')) continue;
            ++count$iv;
        }
        int n3 = count$iv;
        return n2 == n3 && Intrinsics.areEqual((Object)StringsKt.substringAfterLast$default((String)beforeText, (char)'\n', null, (int)2, null), (Object)StringsKt.substringAfterLast$default((String)afterText, (char)'\n', null, (int)2, null));
    }

    public ReformatInspection(boolean processChangedFilesOnly) {
        this.processChangedFilesOnly = processChangedFilesOnly;
    }

    public /* synthetic */ ReformatInspection(boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            bl = false;
        }
        this(bl);
    }

    public ReformatInspection() {
        this(false, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/ReformatInspection$ReformatQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "()V", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "getFamilyName", "", "kotlin.idea"})
    private static final class ReformatQuickFix
    implements LocalQuickFix {
        @NotNull
        public static final ReformatQuickFix INSTANCE;

        @NotNull
        public String getFamilyName() {
            return KotlinBundle.message("reformat.quick.fix.family.name", new Object[0]);
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
            PsiElement psiElement2 = descriptor2.getPsiElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"descriptor.psiElement");
            codeStyleManager.reformat((PsiElement)psiElement2.getContainingFile());
        }

        private ReformatQuickFix() {
        }

        static {
            ReformatQuickFix reformatQuickFix;
            INSTANCE = reformatQuickFix = new ReformatQuickFix();
        }
    }
}

