/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.lexer.KtKeywordToken;
import org.jetbrains.kotlin.lexer.KtModifierKeywordToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtModifierListOwner;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0002\u001a\n\u0010\u0003\u001a\u00020\u0004*\u00020\u0002\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u001a\n\u0010\t\u001a\u00020\u0001*\u00020\u0002\u00a8\u0006\n"}, d2={"canBeCompletelyDeleted", "", "Lorg/jetbrains/kotlin/psi/KtPropertyAccessor;", "deleteBody", "", "isBackingFieldReferenceTo", "Lorg/jetbrains/kotlin/psi/KtExpression;", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isRedundantGetter", "kotlin.idea"})
public final class RedundantGetterInspectionKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isRedundantGetter(@NotNull KtPropertyAccessor $this$isRedundantGetter) {
        Intrinsics.checkNotNullParameter((Object)$this$isRedundantGetter, (String)"$this$isRedundantGetter");
        if (!$this$isRedundantGetter.isGetter()) {
            return false;
        }
        KtExpression ktExpression = $this$isRedundantGetter.getBodyExpression();
        if (ktExpression == null) return RedundantGetterInspectionKt.canBeCompletelyDeleted($this$isRedundantGetter);
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"bodyExpression ?: return canBeCompletelyDeleted()");
        KtExpression expression2 = ktExpression;
        KtProperty ktProperty = $this$isRedundantGetter.getProperty();
        Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"property");
        if (RedundantGetterInspectionKt.isBackingFieldReferenceTo(expression2, ktProperty)) {
            return true;
        }
        if (!(expression2 instanceof KtBlockExpression)) return false;
        List list2 = ((KtBlockExpression)expression2).getStatements();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"expression.statements");
        KtExpression ktExpression2 = (KtExpression)CollectionsKt.singleOrNull((List)list2);
        if (ktExpression2 == null) return false;
        KtExpression statement = ktExpression2;
        KtExpression ktExpression3 = statement;
        if (!(ktExpression3 instanceof KtReturnExpression)) {
            ktExpression3 = null;
        }
        KtReturnExpression ktReturnExpression = (KtReturnExpression)ktExpression3;
        if (ktReturnExpression == null) return false;
        KtReturnExpression returnExpression2 = ktReturnExpression;
        KtExpression ktExpression4 = returnExpression2.getReturnedExpression();
        if (ktExpression4 == null) return false;
        KtProperty ktProperty2 = $this$isRedundantGetter.getProperty();
        Intrinsics.checkNotNullExpressionValue((Object)ktProperty2, (String)"property");
        if (!RedundantGetterInspectionKt.isBackingFieldReferenceTo(ktExpression4, ktProperty2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isBackingFieldReferenceTo(@NotNull KtExpression $this$isBackingFieldReferenceTo, @NotNull KtProperty property2) {
        Intrinsics.checkNotNullParameter((Object)$this$isBackingFieldReferenceTo, (String)"$this$isBackingFieldReferenceTo");
        Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
        if (!($this$isBackingFieldReferenceTo instanceof KtNameReferenceExpression)) return false;
        String string = ((KtNameReferenceExpression)$this$isBackingFieldReferenceTo).getText();
        KtKeywordToken ktKeywordToken = KtTokens.FIELD_KEYWORD;
        Intrinsics.checkNotNullExpressionValue((Object)ktKeywordToken, (String)"KtTokens.FIELD_KEYWORD");
        if (!Intrinsics.areEqual((Object)string, (Object)ktKeywordToken.getValue())) return false;
        if (!PsiUtilsKt.isAncestor$default((PsiElement)((PsiElement)property2), (PsiElement)((PsiElement)$this$isBackingFieldReferenceTo), (boolean)false, (int)2, null)) return false;
        return true;
    }

    public static final boolean canBeCompletelyDeleted(@NotNull KtPropertyAccessor $this$canBeCompletelyDeleted) {
        Intrinsics.checkNotNullParameter((Object)$this$canBeCompletelyDeleted, (String)"$this$canBeCompletelyDeleted");
        if ($this$canBeCompletelyDeleted.getModifierList() == null) {
            return true;
        }
        List list2 = $this$canBeCompletelyDeleted.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"annotationEntries");
        Collection collection = list2;
        boolean bl = false;
        if (!collection.isEmpty()) {
            return false;
        }
        if ($this$canBeCompletelyDeleted.hasModifier(KtTokens.EXTERNAL_KEYWORD)) {
            return false;
        }
        KtModifierKeywordToken ktModifierKeywordToken = KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)$this$canBeCompletelyDeleted));
        KtProperty ktProperty = $this$canBeCompletelyDeleted.getProperty();
        Intrinsics.checkNotNullExpressionValue((Object)ktProperty, (String)"property");
        return Intrinsics.areEqual((Object)ktModifierKeywordToken, (Object)KtPsiUtilKt.visibilityModifierTypeOrDefault((KtModifierListOwner)((KtModifierListOwner)ktProperty)));
    }

    public static final void deleteBody(@NotNull KtPropertyAccessor $this$deleteBody) {
        Intrinsics.checkNotNullParameter((Object)$this$deleteBody, (String)"$this$deleteBody");
        PsiElement psiElement2 = $this$deleteBody.getLeftParenthesis();
        if (psiElement2 == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"leftParenthesis ?: return");
        PsiElement leftParenthesis = psiElement2;
        $this$deleteBody.deleteChildRange(leftParenthesis, $this$deleteBody.getLastChild());
    }
}

