/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.IntentionWrapper;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtNodeTypes;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.VariableDescriptor;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.inspections.AbstractKotlinInspection;
import org.jetbrains.kotlin.idea.intentions.RemoveExplicitTypeIntention;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtConstantExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtNameReferenceExpression;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtTypeReference;
import org.jetbrains.kotlin.psi.KtVisitorVoid;
import org.jetbrains.kotlin.psi.VisitorWrappersKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.AbbreviatedType;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantExplicitTypeInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractKotlinInspection;", "()V", "buildVisitor", "Lorg/jetbrains/kotlin/psi/KtVisitorVoid;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "Companion", "kotlin.idea"})
public final class RedundantExplicitTypeInspection
extends AbstractKotlinInspection {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public KtVisitorVoid buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        return VisitorWrappersKt.propertyVisitor((Function1)((Function1)new Function1<KtProperty, Unit>(holder){
            final /* synthetic */ ProblemsHolder $holder;

            public final void invoke(@NotNull KtProperty property2) {
                Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
                KtTypeReference ktTypeReference = property2.getTypeReference();
                if (ktTypeReference == null) {
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"property.typeReference ?: return");
                KtTypeReference typeReference2 = ktTypeReference;
                if (RedundantExplicitTypeInspection.Companion.hasRedundantType(property2)) {
                    this.$holder.registerProblem((PsiElement)typeReference2, KotlinBundle.message("explicitly.given.type.is.redundant.here", new Object[0]), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[]{(LocalQuickFix)new IntentionWrapper((IntentionAction)new RemoveExplicitTypeIntention())});
                }
            }
            {
                this.$holder = problemsHolder;
                super(1);
            }
        }));
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u0004*\u0004\u0018\u00010\bH\u0002\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/RedundantExplicitTypeInspection$Companion;", "", "()V", "hasRedundantType", "", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "isCompanionObject", "Lorg/jetbrains/kotlin/types/KotlinType;", "kotlin.idea"})
    public static final class Companion {
        /*
         * Enabled aggressive block sorting
         * Lifted jumps to return sites
         */
        public final boolean hasRedundantType(@NotNull KtProperty property2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            if (!property2.isLocal()) {
                return false;
            }
            KtTypeReference ktTypeReference = property2.getTypeReference();
            if (ktTypeReference == null) return false;
            Intrinsics.checkNotNullExpressionValue((Object)ktTypeReference, (String)"property.typeReference ?: return false");
            KtTypeReference typeReference2 = ktTypeReference;
            KtExpression ktExpression = property2.getInitializer();
            if (ktExpression == null) return false;
            Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"property.initializer ?: return false");
            KtExpression initializer2 = ktExpression;
            VariableDescriptor variableDescriptor = ResolutionUtils.resolveToDescriptorIfAny$default((KtProperty)property2, null, (int)1, null);
            VariableDescriptor variableDescriptor2 = variableDescriptor;
            if (variableDescriptor == null) return false;
            KotlinType kotlinType = variableDescriptor2.getType();
            variableDescriptor2 = kotlinType;
            if (kotlinType == null) return false;
            Intrinsics.checkNotNullExpressionValue((Object)variableDescriptor2, (String)"property.resolveToDescri\u2026y()?.type ?: return false");
            VariableDescriptor type2 = variableDescriptor2;
            if (type2 instanceof AbbreviatedType) {
                return false;
            }
            KtExpression ktExpression2 = initializer2;
            if (ktExpression2 instanceof KtConstantExpression) {
                ASTNode aSTNode = ((KtConstantExpression)initializer2).getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"initializer.node");
                IElementType iElementType = aSTNode.getElementType();
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.BOOLEAN_CONSTANT)) {
                    if (KotlinBuiltIns.isBoolean((KotlinType)type2)) return true;
                    return false;
                }
                if (Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.INTEGER_CONSTANT)) {
                    String string = ((KtConstantExpression)initializer2).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"initializer.text");
                    if (StringsKt.endsWith$default((String)string, (String)"L", (boolean)false, (int)2, null)) {
                        if (KotlinBuiltIns.isLong((KotlinType)type2)) return true;
                        return false;
                    }
                    if (KotlinBuiltIns.isInt((KotlinType)type2)) return true;
                    return false;
                }
                if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.FLOAT_CONSTANT)) {
                    if (!Intrinsics.areEqual((Object)iElementType, (Object)KtNodeTypes.CHARACTER_CONSTANT)) return false;
                    if (KotlinBuiltIns.isChar((KotlinType)type2)) return true;
                    return false;
                }
                String string = ((KtConstantExpression)initializer2).getText();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"initializer.text");
                if (!StringsKt.endsWith$default((String)string, (String)"f", (boolean)false, (int)2, null)) {
                    String string2 = ((KtConstantExpression)initializer2).getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"initializer.text");
                    if (!StringsKt.endsWith$default((String)string2, (String)"F", (boolean)false, (int)2, null)) {
                        if (KotlinBuiltIns.isDouble((KotlinType)type2)) return true;
                        return false;
                    }
                }
                if (KotlinBuiltIns.isFloat((KotlinType)type2)) return true;
                return false;
            }
            if (ktExpression2 instanceof KtStringTemplateExpression) {
                if (KotlinBuiltIns.isString((KotlinType)type2)) return true;
                return false;
            }
            if (ktExpression2 instanceof KtNameReferenceExpression) {
                if (Intrinsics.areEqual((Object)typeReference2.getText(), (Object)((KtNameReferenceExpression)initializer2).getReferencedName()) ^ true) {
                    return false;
                }
                KotlinType initializerType = CallUtilKt.getType((KtExpression)initializer2, (BindingContext)ResolutionUtils.analyze((KtElement)((KtElement)property2), (BodyResolveMode)BodyResolveMode.PARTIAL));
                if (!(Intrinsics.areEqual((Object)initializerType, (Object)type2) ^ true)) return true;
                if (!this.isCompanionObject(initializerType)) return true;
                return false;
            }
            if (!(ktExpression2 instanceof KtCallExpression)) return false;
            KtExpression ktExpression3 = ((KtCallExpression)initializer2).getCalleeExpression();
            if (!(Intrinsics.areEqual((Object)typeReference2.getText(), (Object)(ktExpression3 != null ? ktExpression3.getText() : null)) ^ true)) return true;
            return false;
        }

        private final boolean isCompanionObject(KotlinType $this$isCompanionObject) {
            KotlinType kotlinType = $this$isCompanionObject;
            return kotlinType != null && (kotlinType = kotlinType.getConstructor()) != null && (kotlinType = kotlinType.getDeclarationDescriptor()) != null && DescriptorUtilsKt.isCompanionObject((DeclarationDescriptor)((DeclarationDescriptor)kotlinType));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

