/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.inspections;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.DefaultBuiltIns;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.idea.KotlinBundle;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.core.PsiModificationUtilsKt;
import org.jetbrains.kotlin.idea.inspections.AbstractApplicabilityBasedInspection;
import org.jetbrains.kotlin.idea.inspections.collections.FunctionUtilsKt;
import org.jetbrains.kotlin.idea.util.ExpressionExtKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtParameterList;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.resolve.scopes.receivers.ReceiverValue;
import org.jetbrains.kotlin.synthetic.SyntheticExtensionsUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\"\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u000e\u0010\u0014\u001a\u0004\u0018\u00010\u0015*\u00020\u0002H\u0002R\u0014\u0010\u0004\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/idea/inspections/JavaMapForEachInspection;", "Lorg/jetbrains/kotlin/idea/inspections/AbstractApplicabilityBasedInspection;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "()V", "defaultFixText", "", "getDefaultFixText", "()Ljava/lang/String;", "applyTo", "", "element", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "inspectionHighlightRangeInElement", "Lcom/intellij/openapi/util/TextRange;", "inspectionText", "isApplicable", "", "lambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "kotlin.idea"})
public final class JavaMapForEachInspection
extends AbstractApplicabilityBasedInspection<KtCallExpression> {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isApplicable(@NotNull KtCallExpression element3) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getCalleeExpression();
        if (ktExpression == null) return false;
        Intrinsics.checkNotNullExpressionValue((Object)ktExpression, (String)"element.calleeExpression ?: return false");
        KtExpression calleeExpression2 = ktExpression;
        if (Intrinsics.areEqual((Object)calleeExpression2.getText(), (Object)"forEach") ^ true) {
            return false;
        }
        if (element3.getValueArguments().size() != 1) {
            return false;
        }
        KtLambdaExpression ktLambdaExpression2 = this.lambda(element3);
        if (ktLambdaExpression2 == null) return false;
        KtLambdaExpression lambda2 = ktLambdaExpression2;
        List list2 = lambda2.getValueParameters();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"lambda.valueParameters");
        List lambdaParameters = list2;
        if (lambdaParameters.size() != 2) return false;
        Iterable $this$any$iv = lambdaParameters;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                KtParameter it = (KtParameter)element$iv;
                boolean bl2 = false;
                KtParameter ktParameter = it;
                Intrinsics.checkNotNullExpressionValue((Object)ktParameter, (String)"it");
                if (ktParameter.getDestructuringDeclaration() != null) {
                    return false;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return false;
            }
            bl = false;
        }
        if (bl) {
            return false;
        }
        BindingContext context2 = ResolutionUtils.analyze((KtElement)((KtElement)element3), (BodyResolveMode)BodyResolveMode.PARTIAL);
        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)element3), (BindingContext)context2);
        if (resolvedCall2 == null) return false;
        ResolvedCall resolvedCall3 = resolvedCall2;
        ReceiverValue receiverValue = resolvedCall3.getDispatchReceiver();
        ReceiverValue receiverValue2 = receiverValue;
        if (receiverValue == null) return false;
        KotlinType kotlinType = receiverValue2.getType();
        receiverValue2 = kotlinType;
        if (kotlinType == null) return false;
        if (!FunctionUtilsKt.isMap((KotlinType)receiverValue2, (KotlinBuiltIns)DefaultBuiltIns.Companion.getInstance())) return false;
        if (!SyntheticExtensionsUtilsKt.isResolvedWithSamConversions((ResolvedCall)resolvedCall3)) return false;
        return true;
    }

    @Override
    @Nullable
    public TextRange inspectionHighlightRangeInElement(@NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        KtExpression ktExpression = element3.getCalleeExpression();
        return ktExpression != null ? ExpressionExtKt.textRangeIn((PsiElement)ktExpression, (PsiElement)element3) : null;
    }

    @Override
    @NotNull
    public String inspectionText(@NotNull KtCallExpression element3) {
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        return KotlinBundle.message("java.map.foreach.method.call.should.be.replaced.with.kotlin.s.foreach", new Object[0]);
    }

    @Override
    @NotNull
    public String getDefaultFixText() {
        return KotlinBundle.message("replace.with.kotlin.s.foreach", new Object[0]);
    }

    @Override
    public void applyTo(@NotNull KtCallExpression element3, @NotNull Project project2, @Nullable Editor editor2) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            KtLambdaExpression ktLambdaExpression2 = this.lambda(element3);
            if (ktLambdaExpression2 == null) {
                return;
            }
            KtLambdaExpression lambda2 = ktLambdaExpression2;
            List list2 = lambda2.getValueParameters();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"lambda.valueParameters");
            List valueParameters2 = list2;
            KtFunctionLiteral ktFunctionLiteral = lambda2.getFunctionLiteral();
            Intrinsics.checkNotNullExpressionValue((Object)ktFunctionLiteral, (String)"lambda.functionLiteral");
            KtParameterList ktParameterList = ktFunctionLiteral.getValueParameterList();
            if (ktParameterList == null) break block1;
            KtPsiFactory ktPsiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)element3), (boolean)false, (int)2, null);
            StringBuilder stringBuilder = new StringBuilder().append('(');
            Object e = valueParameters2.get(0);
            Intrinsics.checkNotNullExpressionValue(e, (String)"valueParameters[0]");
            StringBuilder stringBuilder2 = stringBuilder.append(((KtParameter)e).getText()).append(", ");
            Object e2 = valueParameters2.get(1);
            Intrinsics.checkNotNullExpressionValue(e2, (String)"valueParameters[1]");
            ktParameterList.replace((PsiElement)ktPsiFactory.createLambdaParameterList(stringBuilder2.append(((KtParameter)e2).getText()).append(')').toString()));
        }
    }

    private final KtLambdaExpression lambda(KtCallExpression $this$lambda) {
        KtLambdaExpression ktLambdaExpression2;
        List list2 = $this$lambda.getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"lambdaArguments");
        KtLambdaArgument ktLambdaArgument = (KtLambdaArgument)CollectionsKt.singleOrNull((List)list2);
        Object object = ktLambdaArgument != null ? ktLambdaArgument.getArgumentExpression() : null;
        if (!(object instanceof KtLambdaExpression)) {
            object = null;
        }
        if ((ktLambdaExpression2 = (KtLambdaExpression)object) == null) {
            ktLambdaExpression2 = PsiModificationUtilsKt.getLastLambdaExpression($this$lambda);
        }
        return ktLambdaExpression2;
    }

    public JavaMapForEachInspection() {
        super(KtCallExpression.class);
    }
}

