/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradleJava.scripting.roots;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.gradle.scripting.settings.StandaloneScriptsStorage;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.GradleBuildRoot;
import org.jetbrains.kotlin.idea.gradleJava.scripting.roots.StandaloneScriptsUpdater;

@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001+B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\bJ\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u0007J\u0010\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010!\u001a\u00020\u0007J\u0010\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010#\u001a\u00020\u0007J\u0010\u0010$\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u0007J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u001e\u001a\u00020\u0007J\u0006\u0010'\u001a\u00020\u001dJ\u0010\u0010(\u001a\u0004\u0018\u00010\b2\u0006\u0010)\u001a\u00020\u0007J\u0012\u0010*\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0016R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\u0012\u001a\u00060\u0013R\u00020\u00008BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000e\u00a8\u0006,"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex;", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/StandaloneScriptsUpdater;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "byProjectDir", "Ljava/util/HashMap;", "", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "Lkotlin/collections/HashMap;", "byWorkingDir", "list", "", "getList", "()Ljava/util/Collection;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "standaloneScriptRoots", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex$StandaloneScriptRootsCache;", "getStandaloneScriptRoots", "()Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex$StandaloneScriptRootsCache;", "standaloneScriptRoots$delegate", "Lkotlin/Lazy;", "standaloneScripts", "getStandaloneScripts", "add", "value", "addStandaloneScript", "", "path", "findNearestRoot", "getBuildByProjectDir", "projectDir", "getBuildByRootDir", "dir", "getStandaloneScriptRoot", "isStandaloneScript", "", "rebuildProjectRoots", "remove", "prefix", "removeStandaloneScript", "StandaloneScriptRootsCache", "kotlin.gradle.gradle-java"})
public final class GradleBuildRootIndex
implements StandaloneScriptsUpdater {
    private final Logger log;
    private final Lazy standaloneScriptRoots$delegate;
    private final HashMap<String, GradleBuildRoot> byWorkingDir;
    private final HashMap<String, GradleBuildRoot> byProjectDir;
    private final Project project;

    private final StandaloneScriptRootsCache getStandaloneScriptRoots() {
        Lazy lazy = this.standaloneScriptRoots$delegate;
        GradleBuildRootIndex gradleBuildRootIndex = this;
        Object var3_3 = null;
        boolean bl = false;
        return (StandaloneScriptRootsCache)lazy.getValue();
    }

    @NotNull
    public final Collection<GradleBuildRoot> getList() {
        Collection<GradleBuildRoot> collection = this.byWorkingDir.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"byWorkingDir.values");
        return collection;
    }

    public final synchronized void rebuildProjectRoots() {
        this.byProjectDir.clear();
        Collection<GradleBuildRoot> collection = this.byWorkingDir.values();
        Intrinsics.checkNotNullExpressionValue(collection, (String)"byWorkingDir.values");
        Iterable $this$forEach$iv = collection;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            GradleBuildRoot buildRoot = (GradleBuildRoot)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = buildRoot.getProjectRoots();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                Map map2 = this.byProjectDir;
                GradleBuildRoot gradleBuildRoot = buildRoot;
                Intrinsics.checkNotNullExpressionValue((Object)gradleBuildRoot, (String)"buildRoot");
                map2.put(it, gradleBuildRoot);
            }
        }
        $this$forEach$iv = this.getStandaloneScriptRoots().all();
        StandaloneScriptRootsCache standaloneScriptRootsCache = this.getStandaloneScriptRoots();
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            String p1 = (String)element$iv;
            boolean bl = false;
            standaloneScriptRootsCache.updateRootsCache(p1);
        }
    }

    @Nullable
    public final synchronized GradleBuildRoot getBuildByRootDir(@NotNull String dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return this.byWorkingDir.get(dir);
    }

    @Nullable
    public final synchronized GradleBuildRoot findNearestRoot(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        Pair max = null;
        Set<Map.Entry<String, GradleBuildRoot>> set2 = this.byWorkingDir.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"byWorkingDir.entries");
        Iterable $this$forEach$iv = set2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry it = (Map.Entry)element$iv;
            boolean bl = false;
            Object k = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k, (String)"it.key");
            if (!StringsKt.startsWith$default((String)path2, (String)((String)k), (boolean)false, (int)2, null)) continue;
            if (max != null) {
                int n = ((String)it.getKey()).length();
                Pair pair = max;
                Intrinsics.checkNotNull((Object)pair);
                if (n <= ((String)pair.getFirst()).length()) continue;
            }
            Object k2 = it.getKey();
            Intrinsics.checkNotNullExpressionValue(k2, (String)"it.key");
            Object v = it.getValue();
            Intrinsics.checkNotNullExpressionValue(v, (String)"it.value");
            max = TuplesKt.to(k2, v);
        }
        Pair pair = max;
        return pair != null ? (GradleBuildRoot)pair.getSecond() : null;
    }

    @Nullable
    public final synchronized GradleBuildRoot getBuildByProjectDir(@NotNull String projectDir) {
        Intrinsics.checkNotNullParameter((Object)projectDir, (String)"projectDir");
        return this.byProjectDir.get(projectDir);
    }

    public final synchronized boolean isStandaloneScript(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.getStandaloneScriptRoots().all().contains(path2);
    }

    @Nullable
    public final synchronized GradleBuildRoot getStandaloneScriptRoot(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.getStandaloneScriptRoots().get(path2);
    }

    @Nullable
    public final synchronized GradleBuildRoot add(@NotNull GradleBuildRoot value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        String prefix = value2.getPathPrefix();
        GradleBuildRoot old = this.byWorkingDir.put(prefix, value2);
        this.rebuildProjectRoots();
        this.log.info(prefix + ": " + old + " -> " + value2);
        return old;
    }

    @Nullable
    public final synchronized GradleBuildRoot remove(@NotNull String prefix) {
        GradleBuildRoot gradleBuildRoot;
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        GradleBuildRoot gradleBuildRoot2 = this.byWorkingDir.remove(prefix);
        if (gradleBuildRoot2 != null) {
            GradleBuildRoot gradleBuildRoot3 = gradleBuildRoot2;
            boolean bl = false;
            boolean bl2 = false;
            GradleBuildRoot it = gradleBuildRoot3;
            boolean bl3 = false;
            this.rebuildProjectRoots();
            this.log.info(prefix + ": removed");
            gradleBuildRoot = gradleBuildRoot3;
        } else {
            gradleBuildRoot = null;
        }
        return gradleBuildRoot;
    }

    @Override
    public synchronized void addStandaloneScript(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        this.getStandaloneScriptRoots().add(path2);
    }

    @Override
    @Nullable
    public synchronized GradleBuildRoot removeStandaloneScript(@NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        return this.getStandaloneScriptRoots().remove(path2);
    }

    @Override
    @NotNull
    public synchronized Collection<String> getStandaloneScripts() {
        return this.getStandaloneScriptRoots().all();
    }

    public GradleBuildRootIndex(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GradleBuildRootIndex.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.log = logger;
        this.standaloneScriptRoots$delegate = LazyKt.lazy((Function0)((Function0)new Function0<StandaloneScriptRootsCache>(this){
            final /* synthetic */ GradleBuildRootIndex this$0;

            @NotNull
            public final StandaloneScriptRootsCache invoke() {
                return this.this$0.new StandaloneScriptRootsCache();
            }
            {
                this.this$0 = gradleBuildRootIndex;
                super(0);
            }
        }));
        this.byWorkingDir = new HashMap();
        this.byProjectDir = new HashMap();
    }

    @Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005J\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00050\u000fJ\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0005J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u0005J\u000e\u0010\u0012\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0005R\u001c\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex$StandaloneScriptRootsCache;", "", "(Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRootIndex;)V", "standaloneScriptRoots", "", "", "Lorg/jetbrains/kotlin/idea/gradleJava/scripting/roots/GradleBuildRoot;", "standaloneScripts", "", "getStandaloneScripts", "()Ljava/util/Set;", "add", "", "path", "all", "", "get", "remove", "updateRootsCache", "kotlin.gradle.gradle-java"})
    private final class StandaloneScriptRootsCache {
        private final Map<String, GradleBuildRoot> standaloneScriptRoots;

        private final Set<String> getStandaloneScripts() {
            Object object = StandaloneScriptsStorage.Companion.getInstance(GradleBuildRootIndex.this.project);
            if (object == null || (object = ((StandaloneScriptsStorage)object).getFiles()) == null) {
                boolean bl = false;
                object = new HashSet();
            }
            return object;
        }

        @NotNull
        public final List<String> all() {
            return CollectionsKt.toList((Iterable)this.getStandaloneScripts());
        }

        @Nullable
        public final GradleBuildRoot get(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            return this.standaloneScriptRoots.get(path2);
        }

        public final void add(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.getStandaloneScripts().add(path2);
            this.updateRootsCache(path2);
        }

        @Nullable
        public final GradleBuildRoot remove(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.getStandaloneScripts().remove(path2);
            return this.standaloneScriptRoots.remove(path2);
        }

        public final void updateRootsCache(@NotNull String path2) {
            Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
            this.standaloneScriptRoots.put(path2, GradleBuildRootIndex.this.findNearestRoot(path2));
        }

        /*
         * WARNING - void declaration
         */
        public StandaloneScriptRootsCache() {
            void $this$forEach$iv;
            boolean bl = false;
            this.standaloneScriptRoots = new LinkedHashMap();
            Iterable iterable = this.getStandaloneScripts();
            StandaloneScriptRootsCache standaloneScriptRootsCache = this;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String p1 = (String)element$iv;
                boolean bl2 = false;
                standaloneScriptRootsCache.updateRootsCache(p1);
            }
        }
    }
}

