/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.configuration;

import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.extensions.gradle.GradleVersionInfo;
import org.jetbrains.kotlin.idea.extensions.gradle.GradleVersionProvider;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.settings.GradleSettings;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u000e\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/configuration/GradleVersionProviderImpl;", "Lorg/jetbrains/kotlin/idea/extensions/gradle/GradleVersionProvider;", "()V", "getCurrentVersion", "Lorg/jetbrains/kotlin/idea/extensions/gradle/GradleVersionInfo;", "project", "Lcom/intellij/openapi/project/Project;", "path", "", "getCurrentVersionGlobal", "getVersion", "versionString", "wrapVersion", "version", "Lorg/gradle/util/GradleVersion;", "Version", "kotlin.gradle.gradle-idea"})
public final class GradleVersionProviderImpl
implements GradleVersionProvider {
    @NotNull
    public static final GradleVersionProviderImpl INSTANCE;

    @NotNull
    public final GradleVersionInfo wrapVersion(@NotNull GradleVersion version2) {
        Intrinsics.checkNotNullParameter((Object)version2, (String)"version");
        return new Version(version2);
    }

    @Override
    @NotNull
    public GradleVersionInfo getVersion(@NotNull String versionString) {
        Intrinsics.checkNotNullParameter((Object)versionString, (String)"versionString");
        GradleVersion gradleVersion2 = GradleVersion.version((String)versionString);
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"GradleVersion.version(versionString)");
        return new Version(gradleVersion2);
    }

    @Override
    @NotNull
    public GradleVersionInfo getCurrentVersionGlobal() {
        GradleVersion gradleVersion2 = GradleVersion.current();
        Intrinsics.checkNotNullExpressionValue((Object)gradleVersion2, (String)"GradleVersion.current()");
        return new Version(gradleVersion2);
    }

    @Override
    @Nullable
    public GradleVersionInfo getCurrentVersion(@NotNull Project project2, @NotNull String path2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path");
        GradleSettings gradleSettings = GradleSettings.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)gradleSettings, (String)"GradleSettings.getInstance(project)");
        GradleSettings settings2 = gradleSettings;
        GradleProjectSettings gradleProjectSettings = (GradleProjectSettings)settings2.getLinkedProjectSettings(path2);
        if (gradleProjectSettings == null || (gradleProjectSettings = gradleProjectSettings.resolveGradleVersion()) == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)gradleProjectSettings, (String)"settings.getLinkedProjec\u2026eVersion() ?: return null");
        GradleProjectSettings raw2 = gradleProjectSettings;
        return new Version((GradleVersion)raw2);
    }

    private GradleVersionProviderImpl() {
    }

    static {
        GradleVersionProviderImpl gradleVersionProviderImpl;
        INSTANCE = gradleVersionProviderImpl = new GradleVersionProviderImpl();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001H\u0096\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/configuration/GradleVersionProviderImpl$Version;", "Lorg/jetbrains/kotlin/idea/extensions/gradle/GradleVersionInfo;", "raw", "Lorg/gradle/util/GradleVersion;", "(Lorg/gradle/util/GradleVersion;)V", "getRaw", "()Lorg/gradle/util/GradleVersion;", "compareTo", "", "other", "kotlin.gradle.gradle-idea"})
    private static final class Version
    implements GradleVersionInfo {
        @NotNull
        private final GradleVersion raw;

        @Override
        public int compareTo(@NotNull GradleVersionInfo other) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            GradleVersionInfo gradleVersionInfo = other;
            if (!(gradleVersionInfo instanceof Version)) {
                gradleVersionInfo = null;
            }
            if ((Version)gradleVersionInfo == null) {
                String string = "Can't compare versions from different version providers";
                boolean bl = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            return this.raw.compareTo(((Version)other).raw);
        }

        @NotNull
        public final GradleVersion getRaw() {
            return this.raw;
        }

        public Version(@NotNull GradleVersion raw2) {
            Intrinsics.checkNotNullParameter((Object)raw2, (String)"raw");
            this.raw = raw2;
        }
    }
}

