/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.gradle.configuration;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.IntellijInternalApi;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.model.ExternalProject;

@IntellijInternalApi
@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\b\u0007\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0003J\u0006\u0010\b\u001a\u00020\u0006J\u0018\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003H\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u00032\u0006\u0010\f\u001a\u00020\u0003R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/configuration/GradlePropertiesFileFacade;", "", "baseDir", "", "(Ljava/lang/String;)V", "addCodeStyleProperty", "", "value", "addNotImportedCommonSourceSetsProperty", "addProperty", "key", "readProperty", "propertyName", "Companion", "kotlin.gradle.gradle-idea"})
public final class GradlePropertiesFileFacade {
    private final String baseDir;
    @NotNull
    public static final String KOTLIN_CODE_STYLE_GRADLE_SETTING = "kotlin.code.style";
    @NotNull
    public static final String KOTLIN_NOT_IMPORTED_COMMON_SOURCE_SETS_SETTING = "kotlin.import.noCommonSourceSets";
    private static final String GRADLE_PROPERTIES_FILE_NAME = "gradle.properties";
    private static final String GRADLE_PROPERTIES_LOCAL_FILE_NAME = "local.properties";
    private static final List<String> GRADLE_PROPERTY_FILES;
    @NotNull
    public static final Companion Companion;

    @Nullable
    public final String readProperty(@NotNull String propertyName) {
        Intrinsics.checkNotNullParameter((Object)propertyName, (String)"propertyName");
        VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(this.baseDir);
        if (virtualFile2 == null) {
            return null;
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile2, (String)"LocalFileSystem.getInsta\u2026h(baseDir) ?: return null");
        VirtualFile baseVirtualDir = virtualFile2;
        for (String propertyFileName : GRADLE_PROPERTY_FILES) {
            VirtualFile propertyFile;
            if (baseVirtualDir.findChild(propertyFileName) == null) {
                continue;
            }
            Intrinsics.checkNotNullExpressionValue((Object)propertyFile, (String)"baseVirtualDir.findChild\u2026ertyFileName) ?: continue");
            Object object = new Properties();
            boolean bl = false;
            boolean bl2 = false;
            Object it = object;
            boolean bl3 = false;
            ((Properties)it).load(propertyFile.getInputStream());
            String string = ((Properties)object).getProperty(propertyName);
            if (string == null) continue;
            object = string;
            bl = false;
            bl2 = false;
            it = object;
            boolean bl4 = false;
            return it;
        }
        return null;
    }

    public final void addCodeStyleProperty(@NotNull String value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.addProperty(KOTLIN_CODE_STYLE_GRADLE_SETTING, value2);
    }

    public final void addNotImportedCommonSourceSetsProperty() {
        this.addProperty(KOTLIN_NOT_IMPORTED_COMMON_SOURCE_SETS_SETTING, String.valueOf(true));
    }

    private final void addProperty(String key, String value2) {
        String string = this.baseDir;
        String[] stringArray = new String[]{GRADLE_PROPERTIES_FILE_NAME};
        boolean bl = false;
        Path path2 = Paths.get(string, Arrays.copyOf(stringArray, stringArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(base, *subpaths)");
        Path projectPropertiesPath = path2;
        String keyValue = key + '=' + value2;
        Path path3 = projectPropertiesPath;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        boolean bl2 = false;
        String updatedText = Files.exists(path3, Arrays.copyOf(linkOptionArray, linkOptionArray.length)) ? PathsKt.readText$default((Path)projectPropertiesPath, null, (int)1, null) + System.lineSeparator() + keyValue : keyValue;
        PathsKt.writeText$default((Path)projectPropertiesPath, (CharSequence)updatedText, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    public GradlePropertiesFileFacade(@NotNull String baseDir) {
        Intrinsics.checkNotNullParameter((Object)baseDir, (String)"baseDir");
        this.baseDir = baseDir;
    }

    static {
        Companion = new Companion(null);
        GRADLE_PROPERTY_FILES = CollectionsKt.listOf((Object[])new String[]{GRADLE_PROPERTIES_LOCAL_FILE_NAME, GRADLE_PROPERTIES_FILE_NAME});
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/gradle/configuration/GradlePropertiesFileFacade$Companion;", "", "()V", "GRADLE_PROPERTIES_FILE_NAME", "", "GRADLE_PROPERTIES_LOCAL_FILE_NAME", "GRADLE_PROPERTY_FILES", "", "KOTLIN_CODE_STYLE_GRADLE_SETTING", "KOTLIN_NOT_IMPORTED_COMMON_SOURCE_SETS_SETTING", "forExternalProject", "Lorg/jetbrains/kotlin/idea/gradle/configuration/GradlePropertiesFileFacade;", "externalProject", "Lorg/jetbrains/plugins/gradle/model/ExternalProject;", "forProject", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.gradle.gradle-idea"})
    public static final class Companion {
        @NotNull
        public final GradlePropertiesFileFacade forProject(@NotNull Project project2) {
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            String string = project2.getBasePath();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"project.basePath!!");
            return new GradlePropertiesFileFacade(string);
        }

        @NotNull
        public final GradlePropertiesFileFacade forExternalProject(@NotNull ExternalProject externalProject) {
            Intrinsics.checkNotNullParameter((Object)externalProject, (String)"externalProject");
            File file2 = externalProject.getProjectDir();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"externalProject.projectDir");
            String string = file2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"externalProject.projectDir.path");
            return new GradlePropertiesFileFacade(string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

