/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.framework.ui;

import com.google.common.collect.ImmutableMap;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinJvmBundle;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0004J2\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0004\u0018\u00010\t2\b\b\u0001\u0010\u0005\u001a\u00020\u00062\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\tJ\"\u0010\u000b\u001a\u00020\u00062\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/framework/ui/FileUIUtils;", "", "()V", "copyWithOverwriteDialog", "Ljava/nio/file/Path;", "messagesTitle", "", "destinationFolder", "file", "", "filesWithDestinations", "createRelativePath", "project", "Lcom/intellij/openapi/project/Project;", "contextDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "relativePath", "kotlin.jvm"})
public final class FileUIUtils {
    @NotNull
    public static final FileUIUtils INSTANCE;

    @Nullable
    public final Path copyWithOverwriteDialog(@Nls @NotNull String messagesTitle, @NotNull String destinationFolder, @NotNull Path file2) {
        Intrinsics.checkNotNullParameter((Object)messagesTitle, (String)"messagesTitle");
        Intrinsics.checkNotNullParameter((Object)destinationFolder, (String)"destinationFolder");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        ImmutableMap immutableMap = ImmutableMap.of((Object)file2, (Object)destinationFolder);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"ImmutableMap.of(file, destinationFolder)");
        Map<Path, Path> map2 = this.copyWithOverwriteDialog(messagesTitle, (Map)immutableMap);
        return map2 != null ? (Path)MapsKt.getValue(map2, (Object)file2) : null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final Map<Path, Path> copyWithOverwriteDialog(@Nls @NotNull String messagesTitle, @NotNull Map<Path, String> filesWithDestinations) {
        Object $this$map$iv;
        boolean bl;
        Object object;
        Path $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)messagesTitle, (String)"messagesTitle");
        Intrinsics.checkNotNullParameter(filesWithDestinations, (String)"filesWithDestinations");
        boolean bl2 = false;
        Set fileNames = new LinkedHashSet();
        LinkedHashMap targetFiles = new LinkedHashMap(filesWithDestinations.size());
        Object object2 = filesWithDestinations;
        boolean bl3 = false;
        Object object3 = object2.entrySet().iterator();
        while (object3.hasNext()) {
            void file2;
            Map.Entry<Path, String> entry;
            Map.Entry<Path, String> entry2 = entry = object3.next();
            boolean bl4 = false;
            object2 = entry2.getKey();
            entry2 = entry;
            bl4 = false;
            String destinationPath = entry2.getValue();
            String fileName = PathsKt.getName((Path)file2);
            bl4 = fileNames.add(fileName);
            boolean bl5 = false;
            boolean bl6 = false;
            if (!bl4) {
                boolean bl7 = false;
                String string = "There are several files with the same name: " + fileName;
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            Map map2 = targetFiles;
            String[] stringArray = new String[]{fileName};
            bl5 = false;
            Path path2 = Paths.get(destinationPath, Arrays.copyOf(stringArray, stringArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(base, *subpaths)");
            map2.put(file2, path2);
        }
        Set set2 = targetFiles.entrySet();
        Intrinsics.checkNotNullExpressionValue(set2, (String)"targetFiles.entries");
        Iterable $this$filter$iv = set2;
        boolean $i$f$filter = false;
        Iterable destinationPath = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path value2;
            Map.Entry $dstr$_u24__u24$value = (Map.Entry)element$iv$iv;
            boolean bl8 = false;
            object = $dstr$_u24__u24$value;
            boolean bl9 = false;
            Path path3 = value2 = (Path)object.getValue();
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"value");
            object = path3;
            LinkOption[] linkOptionArray = new LinkOption[]{};
            bl = false;
            if (!Files.exists((Path)object, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        List existentFiles = (List)destination$iv$iv2;
        $this$filter$iv = existentFiles;
        $i$f$filter = false;
        if (!$this$filter$iv.isEmpty()) {
            String string;
            if (existentFiles.size() == 1) {
                Object v = ((Map.Entry)existentFiles.iterator().next()).getValue();
                Intrinsics.checkNotNullExpressionValue(v, (String)"existentFiles.iterator().next().value");
                Path conflictingFile = (Path)v;
                Object[] objectArray = new Object[2];
                objectArray[0] = PathsKt.getName((Path)conflictingFile);
                Path path4 = conflictingFile.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"conflictingFile.parent");
                $this$filterTo$iv$iv = path4;
                boolean destination$iv$iv2 = false;
                objectArray[1] = ((Object)$this$filterTo$iv$iv.toAbsolutePath()).toString();
                string = KotlinJvmBundle.message("file.exists.single", objectArray);
            } else {
                void $this$mapTo$iv$iv;
                $this$map$iv = existentFiles;
                boolean $i$f$map = false;
                Object $i$f$filterTo2 = $this$map$iv;
                Collection destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Path value3;
                    void $dstr$_u24__u24$value;
                    object = (Map.Entry)item$iv$iv;
                    Collection collection = destination$iv$iv3;
                    boolean bl10 = false;
                    void var17_45 = $dstr$_u24__u24$value;
                    bl = false;
                    Path path5 = value3 = (Path)var17_45.getValue();
                    collection.add(path5);
                }
                Collection conflictFiles = (List)destination$iv$iv3;
                Object[] objectArray = new Object[1];
                String string2 = StringUtil.join((Iterable)conflictFiles, (String)"\n");
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.join(conflictFiles, \"\\n\")");
                objectArray[0] = string2;
                string = KotlinJvmBundle.message("file.exists", objectArray);
            }
            String message2 = string;
            int replaceIfExist = Messages.showYesNoDialog(null, (String)message2, (String)(messagesTitle + KotlinJvmBundle.message("file.overwrite.title", new Object[0])), (String)KotlinJvmBundle.message("file.overwrite.overwrite", new Object[0]), (String)KotlinJvmBundle.message("file.overwrite.cancel", new Object[0]), (Icon)Messages.getWarningIcon());
            if (replaceIfExist != 0) {
                return null;
            }
        }
        $this$map$iv = targetFiles;
        boolean $i$f$map = false;
        Iterator iterator = $this$map$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void key;
            Object $this$mapTo$iv$iv = object3 = iterator.next();
            boolean bl11 = false;
            $this$map$iv = (Path)$this$mapTo$iv$iv.getKey();
            $this$mapTo$iv$iv = object3;
            bl11 = false;
            Path value4 = (Path)$this$mapTo$iv$iv.getValue();
            try {
                Path path6 = value4.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path6, (String)"value.parent");
                Object object4 = path6;
                boolean bl12 = false;
                String destinationPath2 = ((Object)object4.toAbsolutePath()).toString();
                if (!ProjectWizardUtil.createDirectoryIfNotExists((String)KotlinJvmBundle.message("file.destination.folder", new Object[0]), (String)destinationPath2, (boolean)false)) {
                    Messages.showErrorDialog((String)KotlinJvmBundle.message("file.error.new.folder", destinationPath2), (String)messagesTitle);
                    return null;
                }
                object4 = key;
                bl12 = true;
                boolean bl13 = false;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                Intrinsics.checkNotNullExpressionValue((Object)Files.copy((Path)object4, value4, Arrays.copyOf(copyOptionArray, copyOptionArray.length)), (String)"Files.copy(this, target, *options)");
                LocalFileSystem.getInstance().refreshAndFindFileByNioFile(value4);
            }
            catch (IOException e) {
                Messages.showErrorDialog((String)KotlinJvmBundle.message("file.error.copy", PathsKt.getName((Path)key)), (String)messagesTitle);
                return null;
            }
        }
        return targetFiles;
    }

    @NotNull
    public final String createRelativePath(@Nullable Project project2, @Nullable VirtualFile contextDirectory, @NotNull String relativePath) {
        String string;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
                if ((contextDirectory != null ? PathUtil.getLocalPath((VirtualFile)contextDirectory) : (string = project2 != null ? PathUtil.getLocalPath((VirtualFile)project2.getBaseDir()) : null)) == null) break block2;
                String string2 = string;
                boolean bl = false;
                boolean bl2 = false;
                String it = string2;
                boolean bl3 = false;
                String string3 = it;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"it");
                Object object = string3;
                String[] stringArray = new String[]{relativePath};
                boolean bl4 = false;
                Path path2 = Paths.get((String)object, Arrays.copyOf(stringArray, stringArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"Paths.get(base, *subpaths)");
                object = path2;
                boolean bl5 = false;
                string = ((Object)object.toAbsolutePath()).toString();
                if (string != null) break block3;
            }
            string = "";
        }
        return string;
    }

    private FileUIUtils() {
    }

    static {
        FileUIUtils fileUIUtils;
        INSTANCE = fileUIUtils = new FileUIUtils();
    }
}

