/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.formatter;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.formatter.Visitor;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtClassBody;
import org.jetbrains.kotlin.psi.KtEnumEntry;
import org.jetbrains.kotlin.psi.KtNamedDeclaration;
import org.jetbrains.kotlin.psi.KtPsiFactory;
import org.jetbrains.kotlin.psi.KtPsiFactoryKt;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/formatter/Visitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "range", "Lcom/intellij/openapi/util/TextRange;", "(Lcom/intellij/openapi/util/TextRange;)V", "getRange", "()Lcom/intellij/openapi/util/TextRange;", "setRange", "visitNamedDeclaration", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtNamedDeclaration;", "kotlin.idea"})
final class Visitor
extends KtTreeVisitorVoid {
    @NotNull
    private TextRange range;

    public void visitNamedDeclaration(@NotNull KtNamedDeclaration declaration2) {
        Intrinsics.checkNotNullParameter((Object)declaration2, (String)"declaration");
        visitNamedDeclaration.1 $fun$containsToken$1 = visitNamedDeclaration.1.INSTANCE;
        if (!this.range.contains(declaration2.getTextRange())) {
            return;
        }
        PsiElement psiElement2 = declaration2.getParent();
        if (!(psiElement2 instanceof KtClassBody)) {
            psiElement2 = null;
        }
        KtClassBody ktClassBody = (KtClassBody)psiElement2;
        if (ktClassBody == null) {
            return;
        }
        KtClassBody classBody = ktClassBody;
        PsiElement psiElement3 = classBody.getParent();
        if (!(psiElement3 instanceof KtClass)) {
            psiElement3 = null;
        }
        KtClass ktClass2 = (KtClass)psiElement3;
        if (ktClass2 == null) {
            return;
        }
        KtClass klass2 = ktClass2;
        if (!klass2.isEnum()) {
            return;
        }
        int delta = 0;
        KtPsiFactory psiFactory = KtPsiFactoryKt.KtPsiFactory$default((PsiElement)((PsiElement)klass2), (boolean)false, (int)2, null);
        if (declaration2 instanceof KtEnumEntry) {
            PsiElement comma = psiFactory.createComma();
            PsiElement $this$nextSiblingOfSameType$iv = (PsiElement)declaration2;
            boolean $i$f$nextSiblingOfSameType = false;
            KtEnumEntry nextEntry = (KtEnumEntry)PsiTreeUtil.getNextSiblingOfType((PsiElement)$this$nextSiblingOfSameType$iv, KtEnumEntry.class);
            if (nextEntry != null) {
                PsiElement psiElement4 = (PsiElement)declaration2;
                KtSingleValueToken ktSingleValueToken = KtTokens.COMMA;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.COMMA");
                if (!$fun$containsToken$1.invoke(psiElement4, (IElementType)ktSingleValueToken)) {
                    declaration2.add(comma);
                    delta += comma.getTextLength();
                }
            }
        } else {
            int n;
            Object v6;
            block21: {
                Iterable $this$lastIsInstanceOrNull$iv = klass2.getDeclarations();
                boolean $i$f$lastIsInstanceOrNull = false;
                Iterable iterable = $this$lastIsInstanceOrNull$iv;
                if (iterable instanceof List) {
                    int n2 = ((Collection)$this$lastIsInstanceOrNull$iv).size() + -1;
                    if (0 <= n2) {
                        do {
                            int i$iv;
                            Object element$iv;
                            if (!((element$iv = ((List)$this$lastIsInstanceOrNull$iv).get(i$iv = n2--)) instanceof KtEnumEntry)) continue;
                            v6 = element$iv;
                            break block21;
                        } while (0 <= n2);
                    }
                    v6 = null;
                } else {
                    Iterable $this$firstIsInstanceOrNull$iv$iv = CollectionsKt.reversed((Iterable)$this$lastIsInstanceOrNull$iv);
                    boolean $i$f$firstIsInstanceOrNull = false;
                    for (Object element$iv$iv : $this$firstIsInstanceOrNull$iv$iv) {
                        if (!(element$iv$iv instanceof KtEnumEntry)) continue;
                        v6 = element$iv$iv;
                        break block21;
                    }
                    v6 = null;
                }
            }
            KtEnumEntry lastEntry = v6;
            if (lastEntry != null) {
                PsiElement psiElement5;
                PsiElement psiElement6 = (PsiElement)lastEntry;
                KtSingleValueToken ktSingleValueToken = KtTokens.SEMICOLON;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.SEMICOLON");
                if ($fun$containsToken$1.invoke(psiElement6, (IElementType)ktSingleValueToken) || Intrinsics.areEqual((Object)((psiElement5 = lastEntry.getNextSibling()) != null && (psiElement5 = psiElement5.getNode()) != null ? psiElement5.getElementType() : null), (Object)KtTokens.SEMICOLON)) {
                    return;
                }
            }
            if (lastEntry == null) {
                PsiElement psiElement7 = (PsiElement)classBody;
                KtSingleValueToken ktSingleValueToken = KtTokens.SEMICOLON;
                Intrinsics.checkNotNullExpressionValue((Object)ktSingleValueToken, (String)"KtTokens.SEMICOLON");
                if ($fun$containsToken$1.invoke(psiElement7, (IElementType)ktSingleValueToken)) {
                    return;
                }
            }
            PsiElement semicolon = psiFactory.createSemicolon();
            if (lastEntry != null) {
                classBody.addAfter(semicolon, (PsiElement)lastEntry);
                n = semicolon.getTextLength();
            } else {
                PsiElement newLine = psiFactory.createNewLine();
                classBody.addAfter(semicolon, classBody.getLBrace());
                classBody.addAfter(psiFactory.createNewLine(), classBody.getLBrace());
                n = semicolon.getTextLength() + newLine.getTextLength();
            }
            delta += n;
        }
        this.range = new TextRange(this.range.getStartOffset(), this.range.getEndOffset() + delta);
    }

    @NotNull
    public final TextRange getRange() {
        return this.range;
    }

    public final void setRange(@NotNull TextRange textRange) {
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"<set-?>");
        this.range = textRange;
    }

    public Visitor(@NotNull TextRange range) {
        Intrinsics.checkNotNullParameter((Object)range, (String)"range");
        this.range = range;
    }
}

