/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.editor;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;
import org.jetbrains.kotlin.idea.editor.KotlinMultilineStringEnterHandler;
import org.jetbrains.kotlin.idea.refactoring.DataContextUtilsKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtCallElement;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLiteralStringTemplateEntry;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtQualifiedExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtStringTemplateExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016JF\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016H\u0016J2\u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\"\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler;", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegateAdapter;", "()V", "isInBrace", "", "wasInMultilineString", "whiteSpaceAfterCaret", "", "postProcessEnter", "Lcom/intellij/codeInsight/editorActions/enter/EnterHandlerDelegate$Result;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "preprocessEnter", "caretOffset", "Lcom/intellij/openapi/util/Ref;", "", "caretAdvance", "originalHandler", "Lcom/intellij/openapi/editor/actionSystem/EditorActionHandler;", "offset", "hostPosition", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "Companion", "kotlin.idea"})
public final class KotlinMultilineStringEnterHandler
extends EnterHandlerDelegateAdapter {
    private boolean wasInMultilineString;
    private String whiteSpaceAfterCaret = "";
    private boolean isInBrace;
    private static final char DEFAULT_TRIM_MARGIN_CHAR = '|';
    private static final String TRIM_INDENT_CALL = "trimIndent";
    private static final String TRIM_MARGIN_CALL = "trimMargin";
    private static final String MULTILINE_QUOTE = "\"\"\"";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, @Nullable EditorActionHandler originalHandler) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter(caretOffset, (String)"caretOffset");
        Intrinsics.checkNotNullParameter(caretAdvance, (String)"caretAdvance");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        int offset2 = ((Number)caretOffset.get()).intValue();
        if (!(editor2 instanceof EditorWindow)) {
            return this.preprocessEnter(file2, editor2, offset2, originalHandler, dataContext);
        }
        Companion.HostPosition hostPosition = KotlinMultilineStringEnterHandler.Companion.getHostPosition(dataContext);
        if (hostPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Companion.HostPosition hostPosition2 = hostPosition;
        return this.preprocessEnter(hostPosition2, originalHandler, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    private final EnterHandlerDelegate.Result preprocessEnter(Companion.HostPosition hostPosition, EditorActionHandler originalHandler, DataContext dataContext) {
        void editor2;
        void file2;
        Companion.HostPosition hostPosition2 = hostPosition;
        PsiFile psiFile2 = hostPosition2.component1();
        Editor editor3 = hostPosition2.component2();
        int offset2 = hostPosition2.component3();
        return this.preprocessEnter((PsiFile)file2, (Editor)editor2, offset2, originalHandler, dataContext);
    }

    /*
     * WARNING - void declaration
     */
    private final EnterHandlerDelegate.Result preprocessEnter(PsiFile file2, Editor editor2, int offset2, EditorActionHandler originalHandler, DataContext dataContext) {
        block8: {
            String string;
            String text2;
            Document document;
            block7: {
                void $this$takeWhile$iv;
                if (!(file2 instanceof KtFile)) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                Document document2 = editor2.getDocument();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
                document = document2;
                String string2 = document.getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"document.text");
                text2 = string2;
                if (offset2 == 0 || offset2 >= text2.length()) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                PsiElement element3 = file2.findElementAt(offset2);
                if (!Companion.inMultilineString(element3, offset2)) {
                    return EnterHandlerDelegate.Result.Continue;
                }
                this.wasInMultilineString = true;
                String string3 = text2;
                boolean bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(offset2);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
                string3 = string5;
                KotlinMultilineStringEnterHandler kotlinMultilineStringEnterHandler = this;
                boolean $i$f$takeWhile = false;
                int n = 0;
                int n2 = $this$takeWhile$iv.length();
                while (n < n2) {
                    void index$iv;
                    char ch = $this$takeWhile$iv.charAt((int)index$iv);
                    boolean bl2 = false;
                    if (!(ch == ' ' || ch == '\t')) {
                        void var13_16 = $this$takeWhile$iv;
                        int n3 = 0;
                        boolean bl3 = false;
                        String string6 = var13_16.substring(n3, (int)index$iv);
                        string = string6;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block7;
                    }
                    ++index$iv;
                }
                string = $this$takeWhile$iv;
            }
            void var17_19 = string;
            kotlinMultilineStringEnterHandler.whiteSpaceAfterCaret = var17_19;
            document.deleteString(offset2, offset2 + this.whiteSpaceAfterCaret.length());
            char ch1 = text2.charAt(offset2 - 1);
            char ch2 = text2.charAt(offset2);
            boolean bl = this.isInBrace = ch1 == '(' && ch2 == ')' || ch1 == '{' && ch2 == '}' || ch1 == '>' && ch2 == '<';
            if (!this.isInBrace || !CodeInsightSettings.getInstance().SMART_INDENT_ON_ENTER) {
                return EnterHandlerDelegate.Result.Continue;
            }
            EditorActionHandler editorActionHandler = originalHandler;
            if (editorActionHandler == null) break block8;
            CaretModel caretModel = editor2.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            editorActionHandler.execute(editor2, caretModel.getCurrentCaret(), dataContext);
        }
        return EnterHandlerDelegate.Result.DefaultForceIndent;
    }

    @NotNull
    public EnterHandlerDelegate.Result postProcessEnter(@NotNull PsiFile file2, @NotNull Editor editor2, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        if (!(editor2 instanceof EditorWindow)) {
            return this.postProcessEnter(file2, editor2);
        }
        Companion.HostPosition hostPosition = KotlinMultilineStringEnterHandler.Companion.getHostPosition(dataContext);
        if (hostPosition == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Companion.HostPosition hostPosition2 = hostPosition;
        return this.postProcessEnter(hostPosition2.getFile(), hostPosition2.getEditor());
    }

    private final EnterHandlerDelegate.Result postProcessEnter(PsiFile file2, Editor editor2) {
        Character c;
        if (!(file2 instanceof KtFile)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!this.wasInMultilineString) {
            return EnterHandlerDelegate.Result.Continue;
        }
        this.wasInMultilineString = false;
        Project project2 = ((KtFile)file2).getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"file.project");
        Project project3 = project2;
        Document document = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"editor.document");
        Document document2 = document;
        PsiDocumentManager.getInstance((Project)project3).commitDocument(document2);
        CaretModel caretModel = editor2.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
        CaretModel caretModel2 = caretModel;
        int offset2 = caretModel2.getOffset();
        PsiElement psiElement2 = file2.findElementAt(offset2);
        if (psiElement2 == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"file.findElementAt(offse\u2026?: return Result.Continue");
        PsiElement element3 = psiElement2;
        KtStringTemplateExpression ktStringTemplateExpression = Companion.findString(element3, offset2);
        if (ktStringTemplateExpression == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        KtStringTemplateExpression literal = ktStringTemplateExpression;
        boolean hasTrimIndentCallInChain = Companion.hasTrimIndentCallInChain(literal);
        if (hasTrimIndentCallInChain) {
            c = null;
        } else {
            c = Companion.getMarginCharFromTrimMarginCallsInChain(literal);
            if (c == null) {
                c = org.jetbrains.kotlin.idea.editor.KotlinMultilineStringEnterHandler$Companion.getMarginCharFromLiteral$default(Companion, literal, '\u0000', 2, null);
            }
        }
        Character marginChar = c;
        ApplicationUtilsKt.runWriteAction((Function0)new Function0<Unit>(this, file2, document2, offset2, literal, hasTrimIndentCallInChain, marginChar, caretModel2){
            final /* synthetic */ KotlinMultilineStringEnterHandler this$0;
            final /* synthetic */ PsiFile $file;
            final /* synthetic */ Document $document;
            final /* synthetic */ int $offset;
            final /* synthetic */ KtStringTemplateExpression $literal;
            final /* synthetic */ boolean $hasTrimIndentCallInChain;
            final /* synthetic */ Character $marginChar;
            final /* synthetic */ CaretModel $caretModel;

            /*
             * Unable to fully structure code
             */
            public final void invoke() {
                block40: {
                    block38: {
                        block41: {
                            block37: {
                                block39: {
                                    settings = new Companion.MultilineSettings(this.$file);
                                    v0 = this.$document.createRangeMarker(this.$offset, this.$offset);
                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"document.createRangeMarker(offset, offset)");
                                    caretMarker = v0;
                                    caretMarker.setGreedyToRight(true);
                                    $fun$caretOffset$1 = new Function0<Integer>(caretMarker){
                                        final /* synthetic */ RangeMarker $caretMarker;

                                        public final int invoke() {
                                            return this.$caretMarker.getEndOffset();
                                        }
                                        {
                                            this.$caretMarker = rangeMarker;
                                            super(0);
                                        }
                                    };
                                    prevLineNumber = this.$document.getLineNumber(this.$offset) - 1;
                                    var5_5 = prevLineNumber >= 0;
                                    var6_7 = false;
                                    var7_9 = false;
                                    if (_Assertions.ENABLED && !var5_5) {
                                        var8_11 = false;
                                        var8_12 = "Assertion failed";
                                        throw (Throwable)new AssertionError((Object)var8_12);
                                    }
                                    prevLine = KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber, this.$document);
                                    currentLine = KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber + 1, this.$document);
                                    nextLine = this.$document.getLineCount() > prevLineNumber + 2 ? KotlinMultilineStringEnterHandler.Companion.getLineByNumber(prevLineNumber + 2, this.$document) : "";
                                    v1 = this.$literal.getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"literal.text");
                                    v2 = StringsKt.indexOf$default((CharSequence)v1, (String)"\n", (int)0, (boolean)false, (int)6, null);
                                    v3 = this.$literal.getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"literal.text");
                                    wasSingleLine = v2 == StringsKt.lastIndexOf$default((CharSequence)v3, (String)"\n", (int)0, (boolean)false, (int)6, null);
                                    v4 = this.$literal.getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"literal.text");
                                    lines = StringsKt.split$default((CharSequence)v4, (String[])new String[]{"\n"}, (boolean)false, (int)0, (int)6, null);
                                    v5 = this.$literal.getTextRange();
                                    Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"literal.textRange");
                                    literalOffset = v5.getStartOffset();
                                    if (!wasSingleLine && (lines.size() != 3 || !KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0))) break block39;
                                    if (this.$hasTrimIndentCallInChain) ** GOTO lbl-1000
                                    if (this.$marginChar == null) {
                                        var12_16 = (String)CollectionsKt.first((List)lines);
                                        var13_18 = false;
                                        v6 = var12_16;
                                        if (v6 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                        }
                                        ** if (!Intrinsics.areEqual((Object)StringsKt.trim((CharSequence)((CharSequence)v6)).toString(), (Object)"\"\"\"")) goto lbl-1000
                                    }
                                    ** GOTO lbl-1000
lbl-1000:
                                    // 2 sources

                                    {
                                        v7 = true;
                                        ** GOTO lbl43
                                    }
lbl-1000:
                                    // 2 sources

                                    {
                                        v7 = shouldUseTrimIndent = false;
                                    }
lbl43:
                                    // 2 sources

                                    if (shouldUseTrimIndent) {
                                        v8 = null;
                                    } else {
                                        v9 = this.$marginChar;
                                        v8 = Character.valueOf(v9 != null ? v9.charValue() : '|');
                                    }
                                    newMarginChar = v8;
                                    KotlinMultilineStringEnterHandler.Companion.insertTrimCall(this.$document, this.$literal, shouldUseTrimIndent != false ? null : newMarginChar);
                                    prevIndent = settings.indentLength(prevLine);
                                    indentSize = prevIndent + settings.getMarginIndent();
                                    KotlinMultilineStringEnterHandler.Companion.forceIndent($fun$caretOffset$1.invoke(), indentSize, newMarginChar, this.$document, settings);
                                    v10 = this.$literal.getText();
                                    Intrinsics.checkNotNullExpressionValue((Object)v10, (String)"literal.text");
                                    var16_25 = v10;
                                    var17_30 = this.$offset - literalOffset;
                                    var18_35 = false;
                                    v11 = var16_25;
                                    if (v11 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    v12 = v11.substring(var17_30);
                                    Intrinsics.checkNotNullExpressionValue((Object)v12, (String)"(this as java.lang.String).substring(startIndex)");
                                    isInLineEnd = Intrinsics.areEqual((Object)v12, (Object)"\"\"\"");
                                    if (isInLineEnd) {
                                        caretMarker.setGreedyToRight(false);
                                        KotlinMultilineStringEnterHandler.Companion.insertNewLine($fun$caretOffset$1.invoke(), prevIndent, this.$document, settings);
                                        caretMarker.setGreedyToRight(true);
                                    }
                                    if (KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0)) {
                                        KotlinMultilineStringEnterHandler.Companion.forceIndent($fun$caretOffset$1.invoke() + 1, indentSize, newMarginChar, this.$document, settings);
                                    }
                                    break block40;
                                }
                                v13 = isPrevLineFirst = this.$document.getLineNumber(literalOffset) == prevLineNumber;
                                if (isPrevLineFirst) {
                                    prevIndent = (String)CollectionsKt.first((List)lines);
                                    indentSize = "\"\"\"".length();
                                    isInLineEnd = 0;
                                    v14 = prevIndent;
                                    if (v14 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    v15 = v14.substring(indentSize);
                                    v16 = v15;
                                    Intrinsics.checkNotNullExpressionValue((Object)v15, (String)"(this as java.lang.String).substring(startIndex)");
                                } else {
                                    v16 = prevLine;
                                }
                                indentInPreviousLine = KotlinMultilineStringEnterHandler.Companion.prefixLength(v16, (Function1<? super Character, Boolean>)((Function1)postProcessEnter.indentInPreviousLine.1.INSTANCE));
                                if (isPrevLineFirst) {
                                    indentSize = (String)CollectionsKt.first((List)lines);
                                    isInLineEnd = indentInPreviousLine + "\"\"\"".length();
                                    var16_26 = false;
                                    v17 = indentSize;
                                    if (v17 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    v18 = v17.substring(isInLineEnd);
                                    v19 = v18;
                                    Intrinsics.checkNotNullExpressionValue((Object)v18, (String)"(this as java.lang.String).substring(startIndex)");
                                } else {
                                    indentSize = prevLine;
                                    isInLineEnd = 0;
                                    v20 = indentSize;
                                    if (v20 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                                    }
                                    v21 = v20.substring(indentInPreviousLine);
                                    v19 = v21;
                                    Intrinsics.checkNotNullExpressionValue((Object)v21, (String)"(this as java.lang.String).substring(startIndex)");
                                }
                                prefixStripped = v19;
                                $this$filterNot$iv = lines.subList(1, lines.size());
                                $i$f$filterNot = false;
                                var17_31 = $this$filterNot$iv;
                                destination$iv$iv = new ArrayList<E>();
                                $i$f$filterNotTo = false;
                                for (T element$iv$iv : $this$filterNotTo$iv$iv) {
                                    it = (String)element$iv$iv;
                                    $i$a$-filterNot-KotlinMultilineStringEnterHandler$postProcessEnter$1$nonBlankNotFirstLines$1 = false;
                                    if (StringsKt.isBlank((CharSequence)it)) ** GOTO lbl-1000
                                    var24_52 = it;
                                    var25_54 = false;
                                    v22 = var24_52;
                                    if (v22 == null) {
                                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                    }
                                    if (Intrinsics.areEqual((Object)StringsKt.trimStart((CharSequence)v22).toString(), (Object)"\"\"\"")) lbl-1000:
                                    // 2 sources

                                    {
                                        v23 = true;
                                    } else {
                                        v23 = false;
                                    }
                                    if (v23) continue;
                                    destination$iv$iv.add(element$iv$iv);
                                }
                                nonBlankNotFirstLines = (List)destination$iv$iv;
                                if (this.$marginChar == null || StringsKt.startsWith$default((CharSequence)prefixStripped, (char)this.$marginChar.charValue(), (boolean)false, (int)2, null)) ** GOTO lbl-1000
                                $i$f$filterNot = nonBlankNotFirstLines;
                                $this$filterNotTo$iv$iv = false;
                                if (!($i$f$filterNot.isEmpty() == false)) ** GOTO lbl-1000
                                $this$none$iv = nonBlankNotFirstLines;
                                $i$f$none = false;
                                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                                    v24 = true;
                                } else {
                                    for (E element$iv : $this$none$iv) {
                                        it = (String)element$iv;
                                        $i$a$-none-KotlinMultilineStringEnterHandler$postProcessEnter$1$marginCharToInsert$1 = false;
                                        it = it;
                                        $i$a$-filterNot-KotlinMultilineStringEnterHandler$postProcessEnter$1$nonBlankNotFirstLines$1 = false;
                                        v25 = it;
                                        if (v25 == null) {
                                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                                        }
                                        if (!StringsKt.startsWith$default((CharSequence)StringsKt.trimStart((CharSequence)v25).toString(), (char)this.$marginChar.charValue(), (boolean)false, (int)2, null)) continue;
                                        v24 = false;
                                        break block37;
                                    }
                                    v24 = true;
                                }
                            }
                            if (v24) {
                                v26 = null;
                            } else lbl-1000:
                            // 3 sources

                            {
                                v26 = marginCharToInsert = this.$marginChar;
                            }
                            if (marginCharToInsert == null) break block41;
                            $this$none$iv = currentLine;
                            $i$f$none = false;
                            v27 = $this$none$iv;
                            if (v27 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            if (StringsKt.startsWith$default((CharSequence)StringsKt.trimStart((CharSequence)v27).toString(), (char)marginCharToInsert.charValue(), (boolean)false, (int)2, null)) break block40;
                        }
                        indentLength = KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0) != false ? settings.indentLength(nextLine) : (isPrevLineFirst == false ? settings.indentLength(prevLine) : settings.indentLength(prevLine) + settings.getMarginIndent());
                        KotlinMultilineStringEnterHandler.Companion.forceIndent($fun$caretOffset$1.invoke(), indentLength, marginCharToInsert, this.$document, settings);
                        if (marginCharToInsert != null && StringsKt.startsWith$default((CharSequence)prefixStripped, (char)marginCharToInsert.charValue(), (boolean)false, (int)2, null)) {
                            destination$iv$iv = prefixStripped;
                            element$iv = 1;
                            it = 0;
                            v28 = destination$iv$iv;
                            if (v28 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                            }
                            v29 = v28.substring(element$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)v29, (String)"(this as java.lang.String).substring(startIndex)");
                            destination$iv$iv = v29;
                            $i$f$takeWhile = false;
                            it = 0;
                            var21_47 = $this$takeWhile$iv.length();
                            while (it < var21_47) {
                                it = $this$takeWhile$iv.charAt((int)index$iv);
                                $i$a$-takeWhile-KotlinMultilineStringEnterHandler$postProcessEnter$1$wsAfterMargin$1 = false;
                                if (!(it == ' ' || it == '\t')) {
                                    var22_50 = $this$takeWhile$iv;
                                    var23_51 = 0;
                                    var24_53 = false;
                                    v30 = var22_50.substring(var23_51, (int)index$iv);
                                    v31 = v30;
                                    Intrinsics.checkNotNullExpressionValue((Object)v30, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                                    break block38;
                                }
                                ++index$iv;
                            }
                            v31 = $this$takeWhile$iv;
                        } else {
                            v31 = "";
                        }
                    }
                    wsAfterMargin = v31;
                    this.$document.insertString($fun$caretOffset$1.invoke(), (CharSequence)wsAfterMargin);
                    if (KotlinMultilineStringEnterHandler.access$isInBrace$p(this.this$0)) {
                        nextLineOffset = this.$document.getLineStartOffset(prevLineNumber + 2);
                        KotlinMultilineStringEnterHandler.Companion.forceIndent(nextLineOffset, 0, null, this.$document, settings);
                        v32 = new StringBuilder();
                        v33 = marginCharToInsert;
                        if (v33 == null || (v33 = String.valueOf(v33.charValue())) == null) {
                            v33 = "";
                        }
                        this.$document.insertString(nextLineOffset, (CharSequence)v32.append((String)v33).append(wsAfterMargin).toString());
                        KotlinMultilineStringEnterHandler.Companion.forceIndent(nextLineOffset, indentLength, null, this.$document, settings);
                    }
                }
                this.$document.insertString($fun$caretOffset$1.invoke(), (CharSequence)KotlinMultilineStringEnterHandler.access$getWhiteSpaceAfterCaret$p(this.this$0));
                this.$caretModel.moveToOffset($fun$caretOffset$1.invoke());
                caretMarker.dispose();
            }
            {
                this.this$0 = kotlinMultilineStringEnterHandler;
                this.$file = psiFile2;
                this.$document = document;
                this.$offset = n;
                this.$literal = ktStringTemplateExpression;
                this.$hasTrimIndentCallInChain = bl;
                this.$marginChar = c;
                this.$caretModel = caretModel;
                super(0);
            }
        });
        return EnterHandlerDelegate.Result.Stop;
    }

    public static final /* synthetic */ boolean access$isInBrace$p(KotlinMultilineStringEnterHandler $this) {
        return $this.isInBrace;
    }

    public static final /* synthetic */ void access$setInBrace$p(KotlinMultilineStringEnterHandler $this, boolean bl) {
        $this.isInBrace = bl;
    }

    public static final /* synthetic */ String access$getWhiteSpaceAfterCaret$p(KotlinMultilineStringEnterHandler $this) {
        return $this.whiteSpaceAfterCaret;
    }

    public static final /* synthetic */ void access$setWhiteSpaceAfterCaret$p(KotlinMultilineStringEnterHandler $this, String string) {
        $this.whiteSpaceAfterCaret = string;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u000212B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ5\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\u0002\u0010\u0017J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0016\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u0016\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\nH\u0002J\u001f\u0010\"\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\n2\b\b\u0002\u0010\u0012\u001a\u00020\u0004\u00a2\u0006\u0002\u0010#J\u0015\u0010$\u001a\u0004\u0018\u00010\u00042\u0006\u0010!\u001a\u00020\n\u00a2\u0006\u0002\u0010%J\u000e\u0010&\u001a\u00020'2\u0006\u0010!\u001a\u00020\nJ\u0018\u0010(\u001a\u00020'2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ&\u0010)\u001a\u00020\u00102\u0006\u0010*\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J%\u0010+\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010-J\u001e\u0010.\u001a\u00020\u000e*\u00020\u00062\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020'00R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion;", "", "()V", "DEFAULT_TRIM_MARGIN_CHAR", "", "MULTILINE_QUOTE", "", "TRIM_INDENT_CALL", "TRIM_MARGIN_CALL", "findString", "Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;", "element", "Lcom/intellij/psi/PsiElement;", "offset", "", "forceIndent", "", "indent", "marginChar", "document", "Lcom/intellij/openapi/editor/Document;", "settings", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;", "(IILjava/lang/Character;Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;)V", "getHostPosition", "Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "getLineByNumber", "number", "getLiteralCalls", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "str", "getMarginCharFromLiteral", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;C)Ljava/lang/Character;", "getMarginCharFromTrimMarginCallsInChain", "(Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;)Ljava/lang/Character;", "hasTrimIndentCallInChain", "", "inMultilineString", "insertNewLine", "nlOffset", "insertTrimCall", "literal", "(Lcom/intellij/openapi/editor/Document;Lorg/jetbrains/kotlin/psi/KtStringTemplateExpression;Ljava/lang/Character;)V", "prefixLength", "f", "Lkotlin/Function1;", "HostPosition", "MultilineSettings", "kotlin.idea"})
    public static final class Companion {
        @Nullable
        public final KtStringTemplateExpression findString(@Nullable PsiElement element3, int offset2) {
            Object v0;
            block6: {
                if (!(element3 instanceof LeafPsiElement)) {
                    return null;
                }
                IElementType iElementType = ((LeafPsiElement)element3).getElementType();
                if (!Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.REGULAR_STRING_PART)) {
                    if (Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.CLOSING_QUOTE) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.SHORT_TEMPLATE_ENTRY_START) || Intrinsics.areEqual((Object)iElementType, (Object)KtTokens.LONG_TEMPLATE_ENTRY_START)) {
                        if (((LeafPsiElement)element3).getStartOffset() != offset2) {
                            return null;
                        }
                    } else {
                        return null;
                    }
                }
                Sequence $this$firstIsInstanceOrNull$iv = PsiUtilsKt.getParents((PsiElement)element3);
                boolean $i$f$firstIsInstanceOrNull = false;
                for (Object element$iv : $this$firstIsInstanceOrNull$iv) {
                    if (!(element$iv instanceof KtStringTemplateExpression)) continue;
                    v0 = element$iv;
                    break block6;
                }
                v0 = null;
            }
            return v0;
        }

        public final boolean inMultilineString(@Nullable PsiElement element3, int offset2) {
            KtStringTemplateExpression ktStringTemplateExpression = this.findString(element3, offset2);
            return !(ktStringTemplateExpression != null ? KtPsiUtilKt.isSingleQuoted((KtStringTemplateExpression)ktStringTemplateExpression) : true);
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final Character getMarginCharFromLiteral(@NotNull KtStringTemplateExpression str, char marginChar) {
            void $this$filterTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)str, (String)"str");
            String string = str.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"str.text");
            List lines = StringsKt.lines((CharSequence)string);
            if (lines.size() <= 2) {
                return null;
            }
            Iterable $this$filter$iv = lines.subList(1, lines.size() - 1);
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl = false;
                if (!(!StringsKt.isBlank((CharSequence)it))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List middleNonBlank = (List)destination$iv$iv;
            $this$filter$iv = middleNonBlank;
            $i$f$filter = false;
            if (!$this$filter$iv.isEmpty()) {
                boolean bl;
                block8: {
                    Iterable $this$all$iv = middleNonBlank;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            String it = (String)element$iv;
                            boolean bl2 = false;
                            String string2 = it;
                            boolean bl3 = false;
                            String string3 = string2;
                            if (string3 == null) {
                                throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                            }
                            if (StringsKt.startsWith$default((CharSequence)((Object)StringsKt.trimStart((CharSequence)string3)).toString(), (char)marginChar, (boolean)false, (int)2, null)) continue;
                            bl = false;
                            break block8;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    return Character.valueOf(marginChar);
                }
            }
            return null;
        }

        public static /* synthetic */ Character getMarginCharFromLiteral$default(Companion companion, KtStringTemplateExpression ktStringTemplateExpression, char c, int n, Object object) {
            if ((n & 2) != 0) {
                c = (char)124;
            }
            return companion.getMarginCharFromLiteral(ktStringTemplateExpression, c);
        }

        /*
         * WARNING - void declaration
         */
        private final Sequence<KtCallExpression> getLiteralCalls(KtStringTemplateExpression str) {
            void previous;
            Ref.ObjectRef objectRef = new Ref.ObjectRef();
            objectRef.element = (PsiElement)str;
            return SequencesKt.mapNotNull((Sequence)SequencesKt.takeWhile((Sequence)PsiUtilsKt.getParents((PsiElement)((PsiElement)str)), (Function1)((Function1)new Function1<PsiElement, Boolean>((Ref.ObjectRef)previous){
                final /* synthetic */ Ref.ObjectRef $previous;

                public final boolean invoke(@NotNull PsiElement parent2) {
                    boolean bl;
                    Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
                    if (parent2 instanceof KtQualifiedExpression && Intrinsics.areEqual((Object)((KtQualifiedExpression)parent2).getReceiverExpression(), (Object)((PsiElement)this.$previous.element))) {
                        this.$previous.element = parent2;
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.$previous = objectRef;
                    super(1);
                }
            })), (Function1)getLiteralCalls.2.INSTANCE);
        }

        @Nullable
        public final Character getMarginCharFromTrimMarginCallsInChain(@NotNull KtStringTemplateExpression str) {
            Object v1;
            block7: {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                Sequence<KtCallExpression> $this$firstOrNull$iv = this.getLiteralCalls(str);
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    KtCallExpression call = (KtCallExpression)element$iv;
                    boolean bl = false;
                    KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)call));
                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)KotlinMultilineStringEnterHandler.TRIM_MARGIN_CALL)) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            KtCallExpression ktCallExpression = v1;
            if (ktCallExpression == null) {
                return null;
            }
            KtCallExpression literalCall = ktCallExpression;
            List list2 = literalCall.getValueArguments();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"literalCall.valueArguments");
            KtValueArgument ktValueArgument = (KtValueArgument)CollectionsKt.getOrNull((List)list2, (int)0);
            if (ktValueArgument == null) {
                return Character.valueOf('|');
            }
            KtValueArgument firstArgument2 = ktValueArgument;
            KtExpression ktExpression = firstArgument2.getArgumentExpression();
            if (!(ktExpression instanceof KtStringTemplateExpression)) {
                ktExpression = null;
            }
            KtStringTemplateExpression ktStringTemplateExpression = (KtStringTemplateExpression)ktExpression;
            if (ktStringTemplateExpression == null) {
                return Character.valueOf('|');
            }
            KtStringTemplateExpression argumentExpression = ktStringTemplateExpression;
            Object[] objectArray = argumentExpression.getEntries();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"argumentExpression.entries");
            Object object = ArraysKt.singleOrNull((Object[])objectArray);
            if (!(object instanceof KtLiteralStringTemplateEntry)) {
                object = null;
            }
            KtLiteralStringTemplateEntry ktLiteralStringTemplateEntry = (KtLiteralStringTemplateEntry)object;
            if (ktLiteralStringTemplateEntry == null) {
                return Character.valueOf('|');
            }
            KtLiteralStringTemplateEntry entry = ktLiteralStringTemplateEntry;
            Object object2 = entry.getText();
            return Character.valueOf(object2 != null && (object2 = StringsKt.singleOrNull((CharSequence)((CharSequence)object2))) != null ? ((Character)object2).charValue() : (char)'|');
        }

        public final boolean hasTrimIndentCallInChain(@NotNull KtStringTemplateExpression str) {
            boolean bl;
            block1: {
                Intrinsics.checkNotNullParameter((Object)str, (String)"str");
                Sequence<KtCallExpression> $this$any$iv = this.getLiteralCalls(str);
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    KtCallExpression call = (KtCallExpression)element$iv;
                    boolean bl2 = false;
                    KtSimpleNameExpression ktSimpleNameExpression = KtPsiUtilKt.getCallNameExpression((KtCallElement)((KtCallElement)call));
                    if (!Intrinsics.areEqual((Object)(ktSimpleNameExpression != null ? ktSimpleNameExpression.getText() : null), (Object)KotlinMultilineStringEnterHandler.TRIM_INDENT_CALL)) continue;
                    bl = true;
                    break block1;
                }
                bl = false;
            }
            return bl;
        }

        @NotNull
        public final String getLineByNumber(int number, @NotNull Document document) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            String string = document.getText(new TextRange(document.getLineStartOffset(number), document.getLineEndOffset(number)));
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.getText(TextRan\u2026etLineEndOffset(number)))");
            return string;
        }

        public final void insertNewLine(int nlOffset, int indent, @NotNull Document document, @NotNull MultilineSettings settings2) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
            document.insertString(nlOffset, (CharSequence)"\n");
            this.forceIndent(nlOffset + 1, indent, null, document, settings2);
        }

        /*
         * WARNING - void declaration
         */
        public final void forceIndent(int offset2, int indent, @Nullable Character marginChar, @NotNull Document document, @NotNull MultilineSettings settings2) {
            String string;
            int lineStart;
            block3: {
                String line;
                Intrinsics.checkNotNullParameter((Object)document, (String)"document");
                Intrinsics.checkNotNullParameter((Object)settings2, (String)"settings");
                int lineNumber2 = document.getLineNumber(offset2);
                lineStart = document.getLineStartOffset(lineNumber2);
                String $this$takeWhile$iv = line = this.getLineByNumber(lineNumber2, document);
                boolean $i$f$takeWhile = false;
                int n = 0;
                int n2 = $this$takeWhile$iv.length();
                while (n < n2) {
                    void index$iv;
                    char c = $this$takeWhile$iv.charAt((int)index$iv);
                    boolean bl = false;
                    if (!(c == ' ' || c == '\t')) {
                        String string2 = $this$takeWhile$iv;
                        int n3 = 0;
                        boolean bl2 = false;
                        String string3 = string2.substring(n3, (int)index$iv);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block3;
                    }
                    ++index$iv;
                }
                string = $this$takeWhile$iv;
            }
            String wsPrefix = string;
            int n = lineStart + wsPrefix.length();
            StringBuilder stringBuilder = new StringBuilder().append(settings2.getSmartSpaces(indent));
            Object object = marginChar;
            if (object == null || (object = String.valueOf(((Character)object).charValue())) == null) {
                object = "";
            }
            document.replaceString(lineStart, n, (CharSequence)stringBuilder.append((String)object).toString());
        }

        /*
         * WARNING - void declaration
         */
        public final int prefixLength(@NotNull String $this$prefixLength, @NotNull Function1<? super Character, Boolean> f2) {
            CharSequence charSequence;
            String string;
            block2: {
                Intrinsics.checkNotNullParameter((Object)$this$prefixLength, (String)"$this$prefixLength");
                Intrinsics.checkNotNullParameter(f2, (String)"f");
                String $this$takeWhile$iv = $this$prefixLength;
                boolean $i$f$takeWhile = false;
                int n = 0;
                int n2 = $this$takeWhile$iv.length();
                while (n < n2) {
                    void index$iv;
                    if (!((Boolean)f2.invoke((Object)Character.valueOf($this$takeWhile$iv.charAt((int)index$iv)))).booleanValue()) {
                        String string2 = $this$takeWhile$iv;
                        int n3 = 0;
                        boolean bl = false;
                        String string3 = string2.substring(n3, (int)index$iv);
                        string = string3;
                        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                        break block2;
                    }
                    ++index$iv;
                }
                string = charSequence;
            }
            charSequence = string;
            boolean bl = false;
            return charSequence.length();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final void insertTrimCall(@NotNull Document document, @NotNull KtStringTemplateExpression literal, @Nullable Character marginChar) {
            Intrinsics.checkNotNullParameter((Object)document, (String)"document");
            Intrinsics.checkNotNullParameter((Object)literal, (String)"literal");
            if (this.hasTrimIndentCallInChain(literal)) return;
            if (this.getMarginCharFromTrimMarginCallsInChain(literal) != null) {
                return;
            }
            Sequence $this$any$iv = PsiUtilsKt.getParents((PsiElement)((PsiElement)literal));
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl = false;
                if (it instanceof KtAnnotationEntry) return;
                PsiElement psiElement2 = it;
                if (!(psiElement2 instanceof KtProperty)) {
                    psiElement2 = null;
                }
                KtProperty ktProperty = (KtProperty)psiElement2;
                if (ktProperty != null) {
                    if (ktProperty.hasModifier(KtTokens.CONST_KEYWORD)) {
                        return;
                    }
                }
                boolean bl2 = false;
                if (!bl2) continue;
                return;
            }
            boolean bl = false;
            if (bl) {
                return;
            }
            if (marginChar == null) {
                TextRange textRange = literal.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"literal.textRange");
                document.insertString(textRange.getEndOffset(), (CharSequence)".trimIndent()");
                return;
            } else {
                TextRange textRange = literal.getTextRange();
                Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"literal.textRange");
                char c = '|';
                document.insertString(textRange.getEndOffset(), (CharSequence)(marginChar.charValue() == c ? ".trimMargin()" : ".trimMargin(\"" + marginChar + "\")"));
            }
        }

        private final HostPosition getHostPosition(DataContext dataContext) {
            Editor editor2 = DataContextUtilsKt.getHostEditor(dataContext);
            if (!(editor2 instanceof EditorEx)) {
                editor2 = null;
            }
            EditorEx editorEx = (EditorEx)editor2;
            if (editorEx == null) {
                return null;
            }
            EditorEx editor3 = editorEx;
            Project project2 = DataContextUtilsKt.getProject(dataContext);
            VirtualFile virtualFile2 = editor3.getVirtualFile();
            if (virtualFile2 == null) {
                return null;
            }
            VirtualFile virtualFile3 = virtualFile2;
            PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile(virtualFile3, project2);
            if (psiFile2 == null) {
                return null;
            }
            PsiFile psiFile3 = psiFile2;
            Editor editor4 = (Editor)editor3;
            CaretModel caretModel = editor3.getCaretModel();
            Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"editor.caretModel");
            return new HostPosition(psiFile3, editor4, caretModel.getOffset());
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\tJ\u000e\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u0011R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$MultilineSettings;", "", "file", "Lcom/intellij/psi/PsiFile;", "(Lcom/intellij/psi/PsiFile;)V", "kotlinIndentOptions", "Lcom/intellij/psi/codeStyle/CommonCodeStyleSettings$IndentOptions;", "Lorg/jetbrains/annotations/NotNull;", "marginIndent", "", "getMarginIndent", "()I", "regularIndent", "tabSize", "useTabs", "", "getSmartSpaces", "", "count", "indentLength", "line", "kotlin.idea"})
        public static final class MultilineSettings {
            private final CommonCodeStyleSettings.IndentOptions kotlinIndentOptions;
            private final boolean useTabs;
            private final int tabSize;
            private final int regularIndent;
            private final int marginIndent;

            public final int getMarginIndent() {
                return this.marginIndent;
            }

            @NotNull
            public final String getSmartSpaces(int count) {
                String string;
                if (this.useTabs) {
                    string = StringUtil.repeat((String)"\t", (int)(count / this.tabSize)) + StringUtil.repeat((String)" ", (int)(count % this.tabSize));
                } else {
                    String string2 = StringUtil.repeat((String)" ", (int)count);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringUtil.repeat(\" \", count)");
                }
                return string;
            }

            public final int indentLength(@NotNull String line) {
                int n;
                Intrinsics.checkNotNullParameter((Object)line, (String)"line");
                if (this.useTabs) {
                    int tabsCount2 = Companion.prefixLength(line, (Function1<? super Character, Boolean>)((Function1)indentLength.tabsCount.1.INSTANCE));
                    String string = line;
                    boolean bl = false;
                    String string2 = string.substring(tabsCount2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
                    n = tabsCount2 * this.tabSize + Companion.prefixLength(string2, (Function1<? super Character, Boolean>)((Function1)indentLength.1.INSTANCE));
                } else {
                    n = Companion.prefixLength(line, (Function1<? super Character, Boolean>)((Function1)indentLength.2.INSTANCE));
                }
                return n;
            }

            public MultilineSettings(@NotNull PsiFile file2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                CommonCodeStyleSettings.IndentOptions indentOptions = CodeStyle.getIndentOptions((PsiFile)file2);
                Intrinsics.checkNotNullExpressionValue((Object)indentOptions, (String)"CodeStyle.getIndentOptions(file)");
                this.kotlinIndentOptions = indentOptions;
                this.useTabs = this.kotlinIndentOptions.USE_TAB_CHARACTER;
                this.tabSize = this.kotlinIndentOptions.TAB_SIZE;
                this.marginIndent = this.regularIndent = this.kotlinIndentOptions.INDENT_SIZE;
            }
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0012\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/editor/KotlinMultilineStringEnterHandler$Companion$HostPosition;", "", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "offset", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;I)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "getFile", "()Lcom/intellij/psi/PsiFile;", "getOffset", "()I", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "kotlin.idea"})
        private static final class HostPosition {
            @NotNull
            private final PsiFile file;
            @NotNull
            private final Editor editor;
            private final int offset;

            @NotNull
            public final PsiFile getFile() {
                return this.file;
            }

            @NotNull
            public final Editor getEditor() {
                return this.editor;
            }

            public final int getOffset() {
                return this.offset;
            }

            public HostPosition(@NotNull PsiFile file2, @NotNull Editor editor2, int offset2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                this.file = file2;
                this.editor = editor2;
                this.offset = offset2;
            }

            @NotNull
            public final PsiFile component1() {
                return this.file;
            }

            @NotNull
            public final Editor component2() {
                return this.editor;
            }

            public final int component3() {
                return this.offset;
            }

            @NotNull
            public final HostPosition copy(@NotNull PsiFile file2, @NotNull Editor editor2, int offset2) {
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                Intrinsics.checkNotNullParameter((Object)editor2, (String)"editor");
                return new HostPosition(file2, editor2, offset2);
            }

            public static /* synthetic */ HostPosition copy$default(HostPosition hostPosition, PsiFile psiFile2, Editor editor2, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    psiFile2 = hostPosition.file;
                }
                if ((n2 & 2) != 0) {
                    editor2 = hostPosition.editor;
                }
                if ((n2 & 4) != 0) {
                    n = hostPosition.offset;
                }
                return hostPosition.copy(psiFile2, editor2, n);
            }

            @NotNull
            public String toString() {
                return "HostPosition(file=" + this.file + ", editor=" + this.editor + ", offset=" + this.offset + ")";
            }

            public int hashCode() {
                PsiFile psiFile2 = this.file;
                Editor editor2 = this.editor;
                return ((psiFile2 != null ? psiFile2.hashCode() : 0) * 31 + (editor2 != null ? editor2.hashCode() : 0)) * 31 + Integer.hashCode(this.offset);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof HostPosition)) break block3;
                        HostPosition hostPosition = (HostPosition)object;
                        if (!Intrinsics.areEqual((Object)this.file, (Object)hostPosition.file) || !Intrinsics.areEqual((Object)this.editor, (Object)hostPosition.editor) || this.offset != hostPosition.offset) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

