/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.SmartStepTarget;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.Range;
import com.intellij.util.containers.OrderedSet;
import java.util.List;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.kotlin.idea.core.util.CodeInsightUtils;
import org.jetbrains.kotlin.idea.debugger.stepping.smartStepInto.SmartStepTargetVisitor;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtVisitor;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000\u0014\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a$\u0010\u0005\u001a\u0016\u0012\u0004\u0012\u00020\u0002 \u0006*\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\u00010\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u00a8\u0006\u0007"}, d2={"findSmartStepTargets", "", "Lcom/intellij/debugger/actions/SmartStepTarget;", "position", "Lcom/intellij/debugger/SourcePosition;", "findSmartStepTargetsInReadAction", "kotlin.jvm.PlatformType", "kotlin.jvm-debugger.core"})
public final class KotlinSmartStepIntoHandlerKt {
    private static final List<SmartStepTarget> findSmartStepTargetsInReadAction(SourcePosition position) {
        return (List)ReadAction.nonBlocking((Callable)new Callable(position){
            final /* synthetic */ SourcePosition $position;

            public final List<SmartStepTarget> call() {
                return KotlinSmartStepIntoHandlerKt.access$findSmartStepTargets(this.$position);
            }
            {
                this.$position = sourcePosition2;
            }
        }).executeSynchronously();
    }

    private static final List<SmartStepTarget> findSmartStepTargets(SourcePosition position) {
        KtElement ktElement;
        KtElement ktElement2;
        PsiElement psiElement2 = position.getElementAt();
        if (psiElement2 == null) {
            return CollectionsKt.emptyList();
        }
        PsiElement element3 = psiElement2;
        TextRange textRange = element3.getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"element.textRange");
        PsiElement psiElement3 = CodeInsightUtils.getTopmostElementAtOffset(element3, textRange.getStartOffset());
        if (!(psiElement3 instanceof KtElement)) {
            psiElement3 = null;
        }
        if ((ktElement2 = (ktElement = (KtElement)psiElement3)) == null || (ktElement2 = ktElement2.getTextRange()) == null) {
            return CollectionsKt.emptyList();
        }
        KtElement elementTextRange = ktElement2;
        PsiFile psiFile2 = position.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"position.file");
        PsiFile file2 = psiFile2;
        Document document = PsiDocumentManager.getInstance((Project)file2.getProject()).getDocument(file2);
        if (document == null) {
            return CollectionsKt.emptyList();
        }
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"PsiDocumentManager.getIn\u2026le) ?: return emptyList()");
        Document document2 = document;
        Range lines = new Range((Comparable)Integer.valueOf(document2.getLineNumber(elementTextRange.getStartOffset())), (Comparable)Integer.valueOf(document2.getLineNumber(elementTextRange.getEndOffset())));
        OrderedSet consumer2 = new OrderedSet();
        SmartStepTargetVisitor visitor2 = new SmartStepTargetVisitor(ktElement, (Range<Integer>)lines, (OrderedSet<SmartStepTarget>)consumer2);
        ktElement.accept((KtVisitor)visitor2, null);
        return (List)consumer2;
    }

    public static final /* synthetic */ List access$findSmartStepTargetsInReadAction(SourcePosition position) {
        return KotlinSmartStepIntoHandlerKt.findSmartStepTargetsInReadAction(position);
    }

    public static final /* synthetic */ List access$findSmartStepTargets(SourcePosition position) {
        return KotlinSmartStepIntoHandlerKt.findSmartStepTargets(position);
    }
}

