/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtilKt;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.backend.common.descriptors.DescriptorUtilsKt;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.evaluate.ExecutionContext;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerEvaluationBundle;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluatorBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinExpressionWrapper;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinSuspendFunctionWrapper;
import org.jetbrains.kotlin.idea.search.usagesSearch.SearchHelpersKt;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.calls.callUtil.CallUtilKt;
import org.jetbrains.kotlin.resolve.calls.checkers.CoroutineCallCheckerKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.types.KotlinType;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000eH\u0016J\u0010\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u001b\u001a\u00020\tH\u0002J\u0014\u0010\u001c\u001a\u00020\t*\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u000e\u0010\u001b\u001a\u00020\t*\u0004\u0018\u00010\u0007H\u0002J\u0012\u0010\u001d\u001a\u00020\t*\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J\u0012\u0010 \u001a\u00020\t*\b\u0012\u0004\u0012\u00020!0\u001eH\u0002J\u001a\u0010 \u001a\u00020\t*\b\u0012\u0004\u0012\u00020!0\u001e2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\""}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinSuspendFunctionWrapper;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinExpressionWrapper;", "bindingContext", "Lorg/jetbrains/kotlin/resolve/BindingContext;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "psiContext", "Lcom/intellij/psi/PsiElement;", "isCoroutineScopeAvailable", "", "(Lorg/jetbrains/kotlin/resolve/BindingContext;Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;Lcom/intellij/psi/PsiElement;Z)V", "getBindingContext", "()Lorg/jetbrains/kotlin/resolve/BindingContext;", "coroutineContextKeyword", "", "getExecutionContext", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/ExecutionContext;", "getPsiContext", "()Lcom/intellij/psi/PsiElement;", "checkIfKotlinxCoroutinesIsAvailable", "", "createWrappedExpressionText", "expressionText", "isApplicable", "expression", "Lorg/jetbrains/kotlin/psi/KtExpression;", "wrapInRunBlocking", "isCoroutineContextAvailable", "containsSuspendFunctionCall", "isCoroutineContextAvailableFromFunction", "Lkotlin/sequences/Sequence;", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "isCoroutineContextAvailableFromLambda", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "kotlin.jvm-debugger.evaluation"})
public final class KotlinSuspendFunctionWrapper
implements KotlinExpressionWrapper {
    private final String coroutineContextKeyword;
    @NotNull
    private final BindingContext bindingContext;
    @NotNull
    private final ExecutionContext executionContext;
    @Nullable
    private final PsiElement psiContext;

    @Override
    @NotNull
    public String createWrappedExpressionText(@NotNull String expressionText2) {
        Intrinsics.checkNotNullParameter((Object)expressionText2, (String)"expressionText");
        this.checkIfKotlinxCoroutinesIsAvailable();
        boolean isCoroutineContextAvailable2 = (Boolean)ApplicationUtilsKt.runReadAction((Function0)new Function0<Boolean>(this){
            final /* synthetic */ KotlinSuspendFunctionWrapper this$0;

            public final boolean invoke() {
                return KotlinSuspendFunctionWrapper.access$isCoroutineContextAvailable(this.this$0, this.this$0.getPsiContext());
            }
            {
                this.this$0 = kotlinSuspendFunctionWrapper;
                super(0);
            }
        });
        return this.wrapInRunBlocking(expressionText2, isCoroutineContextAvailable2);
    }

    @Override
    public boolean isApplicable(@NotNull KtExpression expression2) {
        Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
        return this.containsSuspendFunctionCall(expression2, this.bindingContext);
    }

    private final String wrapInRunBlocking(String expressionText2, boolean isCoroutineContextAvailable2) {
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl3 = false;
        boolean bl4 = false;
        StringBuilder $this$buildString = stringBuilder;
        boolean bl5 = false;
        $this$buildString.append("kotlinx.coroutines.runBlocking");
        if (isCoroutineContextAvailable2) {
            $this$buildString.append(StringsKt.trimIndent((String)("\n                     (\n                        @kotlin.OptIn(kotlin.ExperimentalStdlibApi::class)\n                        " + this.coroutineContextKeyword + ".minusKey(kotlinx.coroutines.CoroutineDispatcher)\n                    )\n                ")));
        }
        $this$buildString.append(" {\n\t");
        $this$buildString.append(expressionText2);
        $this$buildString.append("\n}");
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean containsSuspendFunctionCall(KtExpression $this$containsSuspendFunctionCall, BindingContext bindingContext2) {
        void result2;
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<Unit>(this, $this$containsSuspendFunctionCall, bindingContext2, (Ref.BooleanRef)result2){
            final /* synthetic */ KotlinSuspendFunctionWrapper this$0;
            final /* synthetic */ KtExpression $this_containsSuspendFunctionCall;
            final /* synthetic */ BindingContext $bindingContext;
            final /* synthetic */ Ref.BooleanRef $result;

            public final void invoke() {
                this.$this_containsSuspendFunctionCall.accept((PsiElementVisitor)new KtTreeVisitorVoid(this){
                    final /* synthetic */ containsSuspendFunctionCall.1 this$0;

                    public void visitCallExpression(@NotNull KtCallExpression callExpression2) {
                        Intrinsics.checkNotNullParameter((Object)callExpression2, (String)"callExpression");
                        ResolvedCall resolvedCall2 = CallUtilKt.getResolvedCall((KtElement)((KtElement)callExpression2), (BindingContext)this.this$0.$bindingContext);
                        if (resolvedCall2 != null && DescriptorUtilsKt.isSuspend((CallableDescriptor)resolvedCall2.getResultingDescriptor())) {
                            PsiElement $this$parentsOfType$iv = (PsiElement)callExpression2;
                            boolean withSelf$iv = true;
                            boolean $i$f$parentsOfType = false;
                            if (!KotlinSuspendFunctionWrapper.access$isCoroutineContextAvailableFromLambda(this.this$0.this$0, PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, KtLambdaExpression.class, (boolean)withSelf$iv), this.this$0.$bindingContext)) {
                                this.this$0.$result.element = true;
                                return;
                            }
                        }
                        callExpression2.acceptChildren((PsiElementVisitor)this);
                    }
                    {
                        this.this$0 = this$0;
                    }
                });
            }
            {
                this.this$0 = kotlinSuspendFunctionWrapper;
                this.$this_containsSuspendFunctionCall = ktExpression;
                this.$bindingContext = bindingContext2;
                this.$result = booleanRef;
                super(0);
            }
        }), (int)1, null);
        return result2.element;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isCoroutineContextAvailable(PsiElement $this$isCoroutineContextAvailable) {
        if ($this$isCoroutineContextAvailable == null) {
            return false;
        }
        PsiElement $this$parentsOfType$iv = $this$isCoroutineContextAvailable;
        boolean withSelf$iv = true;
        boolean $i$f$parentsOfType = false;
        if (this.isCoroutineContextAvailableFromFunction((Sequence<? extends KtNamedFunction>)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, KtNamedFunction.class, (boolean)withSelf$iv))) return true;
        $this$parentsOfType$iv = $this$isCoroutineContextAvailable;
        withSelf$iv = true;
        $i$f$parentsOfType = false;
        if (!this.isCoroutineContextAvailableFromLambda((Sequence<? extends KtLambdaExpression>)PsiTreeUtilKt.parentsOfType((PsiElement)$this$parentsOfType$iv, KtLambdaExpression.class, (boolean)withSelf$iv))) return false;
        return true;
    }

    private final boolean isCoroutineContextAvailableFromFunction(Sequence<? extends KtNamedFunction> $this$isCoroutineContextAvailableFromFunction) {
        for (KtNamedFunction item : $this$isCoroutineContextAvailableFromFunction) {
            CallableDescriptor descriptor2;
            DeclarationDescriptor declarationDescriptor = SearchHelpersKt.getDescriptor((KtDeclaration)item);
            if (!(declarationDescriptor instanceof CallableDescriptor)) {
                declarationDescriptor = null;
            }
            if ((CallableDescriptor)declarationDescriptor == null) {
                continue;
            }
            if (!DescriptorUtilsKt.isSuspend((CallableDescriptor)descriptor2)) continue;
            return true;
        }
        return false;
    }

    private final boolean isCoroutineContextAvailableFromLambda(Sequence<? extends KtLambdaExpression> $this$isCoroutineContextAvailableFromLambda, BindingContext bindingContext2) {
        for (KtLambdaExpression item : $this$isCoroutineContextAvailableFromLambda) {
            KotlinType type2;
            if (CallUtilKt.getType((KtExpression)((KtExpression)item), (BindingContext)bindingContext2) == null) {
                continue;
            }
            if (!FunctionTypesKt.isSuspendFunctionType((KotlinType)type2)) continue;
            return true;
        }
        return false;
    }

    private final boolean isCoroutineContextAvailableFromLambda(Sequence<? extends KtLambdaExpression> $this$isCoroutineContextAvailableFromLambda) {
        boolean bl;
        if (SequencesKt.none($this$isCoroutineContextAvailableFromLambda)) {
            bl = false;
        } else {
            BindingContext bindingContext2 = ResolutionUtils.analyze((KtElement)((KtElement)SequencesKt.last($this$isCoroutineContextAvailableFromLambda)), (BodyResolveMode)BodyResolveMode.PARTIAL);
            bl = this.isCoroutineContextAvailableFromLambda($this$isCoroutineContextAvailableFromLambda, bindingContext2);
        }
        return bl;
    }

    private final void checkIfKotlinxCoroutinesIsAvailable() {
        DebugProcessImpl debugProcess = this.executionContext.getDebugProcess();
        EvaluationContextImpl evaluationContext = this.executionContext.getEvaluationContext();
        try {
            debugProcess.findClass((EvaluationContext)evaluationContext, "kotlinx.coroutines.BuildersKt", evaluationContext.getClassLoader());
        }
        catch (EvaluateException ex) {
            Void void_ = KotlinEvaluatorBuilderKt.evaluationException(KotlinDebuggerEvaluationBundle.message("error.failed.to.wrap.suspend.function", new Object[0]));
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public final BindingContext getBindingContext() {
        return this.bindingContext;
    }

    @NotNull
    public final ExecutionContext getExecutionContext() {
        return this.executionContext;
    }

    @Nullable
    public final PsiElement getPsiContext() {
        return this.psiContext;
    }

    public KotlinSuspendFunctionWrapper(@NotNull BindingContext bindingContext2, @NotNull ExecutionContext executionContext2, @Nullable PsiElement psiContext, boolean isCoroutineScopeAvailable) {
        Intrinsics.checkNotNullParameter((Object)bindingContext2, (String)"bindingContext");
        Intrinsics.checkNotNullParameter((Object)executionContext2, (String)"executionContext");
        this.bindingContext = bindingContext2;
        this.executionContext = executionContext2;
        this.psiContext = psiContext;
        String string = isCoroutineScopeAvailable ? CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_3_FQ_NAME().shortName().asString() : CoroutineCallCheckerKt.getCOROUTINE_CONTEXT_1_3_FQ_NAME().asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (isCoroutineScopeAvai\u2026XT_1_3_FQ_NAME.asString()");
        this.coroutineContextKeyword = string;
    }

    public static final /* synthetic */ boolean access$isCoroutineContextAvailable(KotlinSuspendFunctionWrapper $this, PsiElement $this$access_u24isCoroutineContextAvailable) {
        return $this.isCoroutineContextAvailable($this$access_u24isCoroutineContextAvailable);
    }

    public static final /* synthetic */ boolean access$isCoroutineContextAvailableFromLambda(KotlinSuspendFunctionWrapper $this, Sequence $this$access_u24isCoroutineContextAvailableFromLambda, BindingContext bindingContext2) {
        return $this.isCoroutineContextAvailableFromLambda((Sequence<? extends KtLambdaExpression>)$this$access_u24isCoroutineContextAvailableFromLambda, bindingContext2);
    }
}

