/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.actions.AsyncStacksToggleAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.sun.jdi.Location;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.StackFrameInterceptor;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutinePreflightFrame;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.SkipCoroutineStackFrameProxyImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineFrameBuilder;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/CoroutineStackFrameInterceptor;", "Lorg/jetbrains/kotlin/idea/debugger/StackFrameInterceptor;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "createStackFrame", "Lcom/intellij/xdebugger/frame/XStackFrame;", "frame", "Lcom/intellij/debugger/jdi/StackFrameProxyImpl;", "debugProcess", "Lcom/intellij/debugger/engine/DebugProcessImpl;", "location", "Lcom/sun/jdi/Location;", "showCoroutinePanel", "", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineStackFrameInterceptor
implements StackFrameInterceptor {
    @NotNull
    private final Project project;

    @Override
    @Nullable
    public XStackFrame createStackFrame(@NotNull StackFrameProxyImpl frame, @NotNull DebugProcessImpl debugProcess, @NotNull Location location2) {
        Intrinsics.checkNotNullParameter((Object)frame, (String)"frame");
        Intrinsics.checkNotNullParameter((Object)debugProcess, (String)"debugProcess");
        Intrinsics.checkNotNullParameter((Object)location2, (String)"location");
        JavaDebugProcess javaDebugProcess = debugProcess.getXdebugProcess();
        if ((javaDebugProcess != null ? javaDebugProcess.getSession() : null) instanceof XDebugSessionImpl && !(frame instanceof SkipCoroutineStackFrameProxyImpl)) {
            JavaDebugProcess javaDebugProcess2 = debugProcess.getXdebugProcess();
            Object object = javaDebugProcess2 != null ? javaDebugProcess2.getSession() : null;
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.xdebugger.impl.XDebugSessionImpl");
            }
            if (AsyncStacksToggleAction.Companion.isAsyncStacksEnabled((XDebugSessionImpl)object)) {
                CoroutinePreflightFrame stackFrame;
                CoroutinePreflightFrame coroutinePreflightFrame;
                SuspendContextImpl suspendContextImpl;
                SuspendContextImpl suspendContextImpl2;
                boolean $i$f$isUnitTestMode = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    SuspendManager suspendManager = debugProcess.getSuspendManager();
                    Intrinsics.checkNotNullExpressionValue((Object)suspendManager, (String)"debugProcess.suspendManager");
                    suspendContextImpl2 = suspendManager.getPausedContext();
                } else {
                    DebuggerContextImpl debuggerContextImpl = debugProcess.getDebuggerContext();
                    Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"debugProcess.debuggerContext");
                    suspendContextImpl2 = debuggerContextImpl.getSuspendContext();
                }
                SuspendContextImpl suspendContextImpl3 = suspendContextImpl = suspendContextImpl2;
                if (suspendContextImpl3 != null) {
                    SuspendContextImpl suspendContextImpl4 = suspendContextImpl3;
                    boolean bl = false;
                    boolean bl2 = false;
                    SuspendContextImpl it = suspendContextImpl4;
                    boolean bl3 = false;
                    coroutinePreflightFrame = CoroutineFrameBuilder.Companion.coroutineExitFrame(frame, it);
                } else {
                    coroutinePreflightFrame = stackFrame = null;
                }
                if (stackFrame != null) {
                    this.showCoroutinePanel(debugProcess);
                }
                return (XStackFrame)stackFrame;
            }
        }
        return null;
    }

    private final void showCoroutinePanel(DebugProcessImpl debugProcess) {
        Application app$iv;
        DebuggerSession debuggerSession = debugProcess.getSession();
        Intrinsics.checkNotNullExpressionValue((Object)debuggerSession, (String)"debugProcess.session");
        XDebugSession xDebugSession = debuggerSession.getXDebugSession();
        RunnerLayoutUi $this$safeAs$iv = xDebugSession != null ? xDebugSession.getUI() : null;
        boolean $i$f$safeAs = false;
        RunnerLayoutUi runnerLayoutUi = $this$safeAs$iv;
        if (!(runnerLayoutUi instanceof RunnerLayoutUiImpl)) {
            runnerLayoutUi = null;
        }
        RunnerLayoutUiImpl runnerLayoutUiImpl = (RunnerLayoutUiImpl)runnerLayoutUi;
        if (runnerLayoutUiImpl == null) {
            return;
        }
        RunnerLayoutUiImpl ui = runnerLayoutUiImpl;
        RunnerContentUi runnerContentUi = (RunnerContentUi)RunnerContentUi.KEY.getData((DataProvider)ui);
        if (runnerContentUi == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)runnerContentUi, (String)"RunnerContentUi.KEY.getData(ui) ?: return");
        RunnerContentUi runnerContentUi2 = runnerContentUi;
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application application = app$iv = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"app");
        if (application.isDispatchThread()) {
            boolean bl = false;
            runnerContentUi2.findOrRestoreContentIfNeeded("XCoroutineThreadsContent");
        } else {
            boolean $i$f$invokeLater = false;
            Application application2 = ApplicationManager.getApplication();
            Runnable runnable = new Runnable(runnerContentUi2){
                final /* synthetic */ RunnerContentUi $runnerContentUi$inlined;
                {
                    this.$runnerContentUi$inlined = runnerContentUi;
                }

                public final void run() {
                    boolean bl = false;
                    this.$runnerContentUi$inlined.findOrRestoreContentIfNeeded("XCoroutineThreadsContent");
                }
            };
            ModalityState modalityState = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"ModalityState.defaultModalityState()");
            application2.invokeLater(runnable, modalityState);
        }
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public CoroutineStackFrameInterceptor(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }
}

