/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.ide.util.ModuleRendererFactory;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.sun.jdi.Location;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel$$special$;
import org.jetbrains.kotlin.idea.debugger.KotlinDebuggerCoreBundle;
import org.jetbrains.kotlin.idea.stubindex.PackageIndexUtil;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u000e2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0002\r\u000eB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001a\u0010\u0006\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinAlternativeSourceNotificationProvider;", "Lcom/intellij/ui/EditorNotifications$Provider;", "Lcom/intellij/ui/EditorNotificationPanel;", "myProject", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createNotificationPanel", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "getKey", "Lcom/intellij/openapi/util/Key;", "AlternativeSourceNotificationPanel", "Companion", "kotlin.jvm-debugger.core"})
public final class KotlinAlternativeSourceNotificationProvider
extends EditorNotifications.Provider<EditorNotificationPanel> {
    private final Project myProject;
    private static final Key<EditorNotificationPanel> KEY;
    private static final Key<Boolean> FILE_PROCESSED_KEY;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public Key<EditorNotificationPanel> getKey() {
        return KEY;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public EditorNotificationPanel createNotificationPanel(@NotNull VirtualFile file2, @NotNull FileEditor fileEditor) {
        String string;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$filterTo$iv;
        XSourcePosition position;
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)fileEditor, (String)"fileEditor");
        if (!DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE) {
            return null;
        }
        XDebuggerManager xDebuggerManager = XDebuggerManager.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerManager, (String)"XDebuggerManager.getInstance(myProject)");
        XDebugSession session = xDebuggerManager.getCurrentSession();
        if (session == null) {
            FILE_PROCESSED_KEY.set((UserDataHolder)file2, null);
            return null;
        }
        XSourcePosition xSourcePosition = position = session.getCurrentPosition();
        if (Intrinsics.areEqual((Object)file2, (Object)(xSourcePosition != null ? xSourcePosition.getFile() : null)) ^ true) {
            FILE_PROCESSED_KEY.set((UserDataHolder)file2, null);
            return null;
        }
        DumbService dumbService = DumbService.getInstance((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)dumbService, (String)"DumbService.getInstance(myProject)");
        if (dumbService.isDumb()) {
            return null;
        }
        PsiFile psiFile2 = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return null;
        }
        KtFile ktFile2 = ktFile;
        FqName packageFqName = ktFile2.getPackageFqName();
        String string2 = ktFile2.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"ktFile.name");
        String fileName = string2;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.myProject);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(myProject)");
        Iterable iterable = PackageIndexUtil.findFilesWithExactPackage(packageFqName, globalSearchScope, this.myProject);
        Iterable destination$iv = new HashSet();
        boolean $i$f$filterTo = false;
        for (Object element$iv : $this$filterTo$iv) {
            KtFile it = (KtFile)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)fileName)) continue;
            destination$iv.add(element$iv);
        }
        HashSet alternativeKtFiles = (HashSet)destination$iv;
        FILE_PROCESSED_KEY.set((UserDataHolder)file2, (Object)true);
        if (alternativeKtFiles.size() <= 1) {
            return null;
        }
        destination$iv = alternativeKtFiles;
        Collection collection = CollectionsKt.listOf((Object)ktFile2);
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            KtFile it = (KtFile)element$iv$iv;
            boolean bl = false;
            if (!(Intrinsics.areEqual((Object)it, (Object)ktFile2) ^ true)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        Collection currentFirstAlternatives = CollectionsKt.plus((Collection)collection, (Iterable)list2);
        XStackFrame frame = session.getCurrentStackFrame();
        if (frame instanceof JavaStackFrame) {
            StackFrameDescriptorImpl stackFrameDescriptorImpl = ((JavaStackFrame)frame).getDescriptor();
            Intrinsics.checkNotNullExpressionValue((Object)stackFrameDescriptorImpl, (String)"frame.descriptor");
            Location location2 = stackFrameDescriptorImpl.getLocation();
            Comparable<Location> comparable = location2;
            string = comparable != null && (comparable = comparable.declaringType()) != null ? comparable.name() : null;
        } else {
            string = null;
        }
        String locationDeclName = string;
        return new AlternativeSourceNotificationPanel(currentFirstAlternatives, this.myProject, file2, locationDeclName);
    }

    public KotlinAlternativeSourceNotificationProvider(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    static {
        Companion = new Companion(null);
        Key key = Key.create((String)"KotlinAlternativeSource");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create<EditorNotific\u2026KotlinAlternativeSource\")");
        KEY = key;
        Key key2 = Key.findKeyByName((String)"AlternativeSourceCheckDone");
        if (key2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.openapi.util.Key<kotlin.Boolean>");
        }
        FILE_PROCESSED_KEY = key2;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001:\u0001\fB-\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel;", "Lcom/intellij/ui/EditorNotificationPanel;", "alternatives", "", "Lorg/jetbrains/kotlin/psi/KtFile;", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "locationDeclName", "", "(Ljava/util/Collection;Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;)V", "ComboBoxFileElement", "kotlin.jvm-debugger.core"})
    private static final class AlternativeSourceNotificationPanel
    extends EditorNotificationPanel {
        /*
         * WARNING - void declaration
         */
        public AlternativeSourceNotificationPanel(@NotNull Collection<? extends KtFile> alternatives, final @NotNull Project project2, final @NotNull VirtualFile file2, @Nullable String locationDeclName) {
            void $this$apply;
            ComboBoxFileElement comboBoxFileElement;
            Object object;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(alternatives, (String)"alternatives");
            Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            Object[] objectArray = new Object[1];
            String string = file2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            objectArray[0] = string;
            this.setText(KotlinDebuggerCoreBundle.message("alternative.sources.notification.title", objectArray));
            Iterable $this$map$iv = alternatives;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                KtFile ktFile = (KtFile)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                comboBoxFileElement = new ComboBoxFileElement((KtFile)it);
                object.add(comboBoxFileElement);
            }
            List items = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = items;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Object[] objectArray2 = thisCollection$iv.toArray(new ComboBoxFileElement[0]);
            if (objectArray2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
            }
            ComboBox comboBox = new ComboBox(objectArray2);
            boolean bl = false;
            boolean bl2 = false;
            destination$iv$iv = comboBox;
            object = this.myLinksPanel;
            boolean bl3 = false;
            $this$apply.addActionListener(new ActionListener((ComboBox)$this$apply, project2, locationDeclName, file2){
                final /* synthetic */ ComboBox $this_apply;
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ String $locationDeclName$inlined;
                final /* synthetic */ VirtualFile $file$inlined;
                {
                    this.$this_apply = comboBox;
                    this.$project$inlined = project2;
                    this.$locationDeclName$inlined = string;
                    this.$file$inlined = virtualFile2;
                }

                public final void actionPerformed(ActionEvent it) {
                    DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx((Project)this.$project$inlined);
                    Intrinsics.checkNotNullExpressionValue((Object)debuggerManagerEx, (String)"DebuggerManagerEx.getInstanceEx(project)");
                    DebuggerContextImpl debuggerContextImpl = debuggerManagerEx.getContext();
                    Intrinsics.checkNotNullExpressionValue((Object)debuggerContextImpl, (String)"DebuggerManagerEx.getInstanceEx(project).context");
                    DebuggerContextImpl context2 = debuggerContextImpl;
                    DebuggerSession session = context2.getDebuggerSession();
                    Object object = this.$this_apply.getSelectedItem();
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type org.jetbrains.kotlin.idea.debugger.KotlinAlternativeSourceNotificationProvider.AlternativeSourceNotificationPanel.ComboBoxFileElement");
                    }
                    KtFile ktFile = ((ComboBoxFileElement)object).getKtFile();
                    PsiFile psiFile2 = ktFile.getContainingFile();
                    Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"ktFile.containingFile");
                    VirtualFile vFile = psiFile2.getVirtualFile();
                    if (session != null && vFile != null) {
                        DebugProcessImpl debugProcessImpl = session.getProcess();
                        Intrinsics.checkNotNullExpressionValue((Object)debugProcessImpl, (String)"session.process");
                        debugProcessImpl.getManagerThread().schedule(new DebuggerCommandImpl(this, vFile, session){
                            final /* synthetic */ AlternativeSourceNotificationPanel$$special$$inlined$apply$lambda$1 this$0;
                            final /* synthetic */ VirtualFile $vFile;
                            final /* synthetic */ DebuggerSession $session;
                            {
                                this.this$0 = this$0;
                                this.$vFile = $captured_local_variable$1;
                                this.$session = $captured_local_variable$2;
                            }

                            protected void action() {
                                if (!StringUtil.isEmpty((String)this.this$0.$locationDeclName$inlined)) {
                                    DebuggerUtilsEx.setAlternativeSourceUrl((String)this.this$0.$locationDeclName$inlined, (String)this.$vFile.getUrl(), (Project)this.this$0.$project$inlined);
                                }
                                DebuggerUIUtil.invokeLater((Runnable)new Runnable(this){
                                    final /* synthetic */ AlternativeSourceNotificationPanel$$special$$inlined$apply$lambda$1$1 this$0;
                                    {
                                        this.this$0 = var1_1;
                                    }

                                    public final void run() {
                                        FileEditorManager.getInstance((Project)this.this$0.this$0.$project$inlined).closeFile(this.this$0.this$0.$file$inlined);
                                        this.this$0.$session.refresh(true);
                                    }
                                });
                            }
                        });
                    } else {
                        FileEditorManager.getInstance((Project)this.$project$inlined).closeFile(this.$file$inlined);
                        ktFile.navigate(true);
                    }
                }
            });
            comboBoxFileElement = Unit.INSTANCE;
            ((Container)object).add((Component)comboBox);
            this.createActionLabel(KotlinDebuggerCoreBundle.message("alternative.sources.notification.hide", new Object[0]), new Runnable(){

                @Override
                public final void run() {
                    DebuggerSettings.getInstance().SHOW_ALTERNATIVE_SOURCE = false;
                    FILE_PROCESSED_KEY.set((UserDataHolder)file2, null);
                    FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project2);
                    FileEditor editor2 = fileEditorManager.getSelectedEditor(file2);
                    if (editor2 != null) {
                        fileEditorManager.removeTopComponent(editor2, (JComponent)((Object)this));
                    }
                }
            });
        }

        @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\r\u001a\u00020\bH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinAlternativeSourceNotificationProvider$AlternativeSourceNotificationPanel$ComboBoxFileElement;", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "(Lorg/jetbrains/kotlin/psi/KtFile;)V", "getKtFile", "()Lorg/jetbrains/kotlin/psi/KtFile;", "label", "", "getLabel", "()Ljava/lang/String;", "label$delegate", "Lkotlin/Lazy;", "toString", "kotlin.jvm-debugger.core"})
        private static final class ComboBoxFileElement {
            private final Lazy label$delegate;
            @NotNull
            private final KtFile ktFile;

            private final String getLabel() {
                Lazy lazy = this.label$delegate;
                ComboBoxFileElement comboBoxFileElement = this;
                Object var3_3 = null;
                boolean bl = false;
                return (String)lazy.getValue();
            }

            @NotNull
            public String toString() {
                return this.getLabel();
            }

            @NotNull
            public final KtFile getKtFile() {
                return this.ktFile;
            }

            public ComboBoxFileElement(@NotNull KtFile ktFile) {
                Intrinsics.checkNotNullParameter((Object)ktFile, (String)"ktFile");
                this.ktFile = ktFile;
                this.label$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<String>(this){
                    final /* synthetic */ ComboBoxFileElement this$0;

                    @NotNull
                    public final String invoke() {
                        ModuleRendererFactory moduleRendererFactory = ModuleRendererFactory.findInstance((Object)this.this$0.getKtFile());
                        Intrinsics.checkNotNullExpressionValue((Object)moduleRendererFactory, (String)"ModuleRendererFactory.findInstance(ktFile)");
                        ModuleRendererFactory factory2 = moduleRendererFactory;
                        Object object = factory2.getModuleTextWithIcon((Object)this.this$0.getKtFile());
                        if (object == null || (object = object.getText()) == null) {
                            object = "";
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"factory.getModuleTextWithIcon(ktFile)?.text ?: \"\"");
                        return object;
                    }
                    {
                        this.this$0 = comboBoxFileElement;
                        super(0);
                    }
                }));
            }
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001a\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R!\u0010\u0007\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0004\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/KotlinAlternativeSourceNotificationProvider$Companion;", "", "()V", "FILE_PROCESSED_KEY", "Lcom/intellij/openapi/util/Key;", "", "getFILE_PROCESSED_KEY$annotations", "KEY", "Lcom/intellij/ui/EditorNotificationPanel;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.core"})
    public static final class Companion {
        private static /* synthetic */ void getFILE_PROCESSED_KEY$annotations() {
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

