/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.core.script.configuration.listener;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.idea.core.script.ScriptUtilsKt;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.DefaultScriptChangeListener;
import org.jetbrains.kotlin.idea.core.script.configuration.listener.ScriptChangeListener;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0010\u001a\u00020\u0011H\u0002J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangesNotifier;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "defaultListener", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/DefaultScriptChangeListener;", "listeners", "", "Lorg/jetbrains/kotlin/idea/core/script/configuration/listener/ScriptChangeListener;", "getListeners", "()Ljava/util/Collection;", "scriptChangesListenerDelayMillis", "", "scriptsQueue", "Lcom/intellij/util/Alarm;", "areListenersDisabled", "", "getListener", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.core"})
public final class ScriptChangesNotifier {
    private final Alarm scriptsQueue;
    private final int scriptChangesListenerDelayMillis;
    private final DefaultScriptChangeListener defaultListener;
    private final Project project;

    private final Collection<ScriptChangeListener> getListeners() {
        boolean bl = false;
        List list2 = new ArrayList();
        boolean bl2 = false;
        boolean bl3 = false;
        List $this$apply = list2;
        boolean bl4 = false;
        List list3 = ScriptChangeListener.Companion.getLISTENER().getExtensions((AreaInstance)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"LISTENER.getExtensions(project)");
        $this$apply.addAll(list3);
        $this$apply.add(this.defaultListener);
        return list2;
    }

    private final ScriptChangeListener getListener(Project project2, VirtualFile file2) {
        Object v0;
        block2: {
            if (project2.isDisposed() || this.areListenersDisabled()) {
                return null;
            }
            Iterable $this$firstOrNull$iv = this.getListeners();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                ScriptChangeListener it = (ScriptChangeListener)element$iv;
                boolean bl = false;
                if (!it.isApplicable(file2)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean areListenersDisabled() {
        boolean $i$f$isUnitTestMode = false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
        if (!application.isUnitTestMode()) return false;
        Application application2 = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"ApplicationManager.getApplication()");
        if (!Intrinsics.areEqual((Object)ScriptUtilsKt.isScriptChangesNotifierDisabled(application2), (Object)true)) return false;
        return true;
    }

    public ScriptChangesNotifier(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
        this.scriptChangesListenerDelayMillis = 1400;
        Disposable parentDisposable = KotlinPluginDisposable.Companion.getInstance(this.project);
        this.scriptsQueue = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, KotlinPluginDisposable.Companion.getInstance(this.project));
        this.project.getMessageBus().connect(parentDisposable).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new FileEditorManagerListener(){

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                this.runScriptDependenciesUpdateIfNeeded(file2);
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    VirtualFile virtualFile2 = event.getNewFile();
                    if (virtualFile2 == null) break block0;
                    VirtualFile virtualFile3 = virtualFile2;
                    boolean bl = false;
                    boolean bl2 = false;
                    VirtualFile it = virtualFile3;
                    boolean bl3 = false;
                    this.runScriptDependenciesUpdateIfNeeded(it);
                }
            }

            private final void runScriptDependenciesUpdateIfNeeded(VirtualFile file2) {
                boolean $i$f$isUnitTestMode = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    ScriptChangeListener scriptChangeListener = this.getListener(project, file2);
                    if (scriptChangeListener != null) {
                        scriptChangeListener.editorActivated(file2);
                    }
                } else {
                    AppExecutorUtil.getAppExecutorService().submit(new Runnable(this, file2){
                        final /* synthetic */ 1 this$0;
                        final /* synthetic */ VirtualFile $file;

                        public final void run() {
                            block0: {
                                ScriptChangeListener scriptChangeListener = ScriptChangesNotifier.access$getListener(this.this$0.this, ScriptChangesNotifier.access$getProject$p(this.this$0.this), this.$file);
                                if (scriptChangeListener == null) break block0;
                                scriptChangeListener.editorActivated(this.$file);
                            }
                        }
                        {
                            this.this$0 = var1_1;
                            this.$file = virtualFile2;
                        }
                    });
                }
            }
        });
        EditorFactory editorFactory = EditorFactory.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)editorFactory, (String)"EditorFactory.getInstance()");
        editorFactory.getEventMulticaster().addDocumentListener(new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                Object object;
                block11: {
                    block10: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        Document document = event.getDocument();
                        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"event.document");
                        Document document2 = document;
                        object = FileDocumentManager.getInstance().getFile(document2);
                        if (object == null) break block10;
                        VirtualFile virtualFile2 = object;
                        boolean bl = false;
                        boolean bl2 = false;
                        VirtualFile it = virtualFile2;
                        boolean bl3 = false;
                        VirtualFile virtualFile3 = it;
                        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"it");
                        object = virtualFile3.isInLocalFileSystem() ? virtualFile2 : null;
                        if (object != null) break block11;
                    }
                    return;
                }
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"FileDocumentManager.getI\u2026calFileSystem } ?: return");
                VirtualFile file2 = object;
                FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
                if (fileEditorManager == null) {
                    return;
                }
                FileEditorManager editorManager = fileEditorManager;
                Object[] objectArray = editorManager.getOpenFiles();
                Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"editorManager.openFiles");
                if (!ArraysKt.contains((Object[])objectArray, (Object)file2)) {
                    return;
                }
                boolean $i$f$isUnitTestMode = false;
                Application application = ApplicationManager.getApplication();
                Intrinsics.checkNotNullExpressionValue((Object)application, (String)"ApplicationManager.getApplication()");
                if (application.isUnitTestMode()) {
                    ScriptChangeListener scriptChangeListener = this.getListener(project, file2);
                    if (scriptChangeListener != null) {
                        scriptChangeListener.documentChanged(file2);
                    }
                } else {
                    scriptsQueue.cancelAllRequests();
                    if (!project.isDisposed()) {
                        scriptsQueue.addRequest(new Runnable(this, file2){
                            final /* synthetic */ 2 this$0;
                            final /* synthetic */ VirtualFile $file;

                            public final void run() {
                                block0: {
                                    ScriptChangeListener scriptChangeListener = ScriptChangesNotifier.access$getListener(this.this$0.this, ScriptChangesNotifier.access$getProject$p(this.this$0.this), this.$file);
                                    if (scriptChangeListener == null) break block0;
                                    scriptChangeListener.documentChanged(this.$file);
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                this.$file = virtualFile2;
                            }
                        }, scriptChangesListenerDelayMillis, true);
                    }
                }
            }
        }, parentDisposable);
        ScriptChangeListener.Companion.getLISTENER().getExtensions((AreaInstance)this.project);
        this.defaultListener = new DefaultScriptChangeListener(this.project);
    }
}

