/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.completion;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.idea.completion.smart.SmartCompletionItemPriority;
import org.jetbrains.kotlin.idea.completion.smart.UtilsKt;
import org.jetbrains.kotlin.idea.core.completion.DeclarationLookupObject;
import org.jetbrains.kotlin.idea.util.CallType;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0017\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a2\u0006\u0002\u0010\tR\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/completion/CallableReferenceWeigher;", "Lcom/intellij/codeInsight/lookup/LookupElementWeigher;", "callType", "Lorg/jetbrains/kotlin/idea/util/CallType;", "(Lorg/jetbrains/kotlin/idea/util/CallType;)V", "weigh", "", "element", "Lcom/intellij/codeInsight/lookup/LookupElement;", "(Lcom/intellij/codeInsight/lookup/LookupElement;)Ljava/lang/Integer;", "kotlin.idea"})
public final class CallableReferenceWeigher
extends LookupElementWeigher {
    private final CallType<?> callType;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public Integer weigh(@NotNull LookupElement element3) {
        Integer n;
        CallableDescriptor descriptor2;
        CallableDescriptor callableDescriptor;
        Intrinsics.checkNotNullParameter((Object)element3, (String)"element");
        if (!Intrinsics.areEqual(this.callType, (Object)CallType.CALLABLE_REFERENCE.INSTANCE) && (SmartCompletionItemPriority)((Object)element3.getUserData(UtilsKt.getSMART_COMPLETION_ITEM_PRIORITY_KEY())) != SmartCompletionItemPriority.CALLABLE_REFERENCE) return null;
        Object object = element3.getObject();
        if (!(object instanceof DeclarationLookupObject)) {
            object = null;
        }
        DeclarationLookupObject declarationLookupObject = (DeclarationLookupObject)object;
        Object object2 = declarationLookupObject != null ? declarationLookupObject.getDescriptor() : null;
        if (!(object2 instanceof CallableDescriptor)) {
            object2 = null;
        }
        if ((callableDescriptor = (descriptor2 = (CallableDescriptor)object2)) != null && (callableDescriptor = callableDescriptor.getReturnType()) != null) {
            if (TypeUtilsKt.isNothing((KotlinType)callableDescriptor)) {
                n = 1;
                return n;
            }
        }
        n = 0;
        return n;
    }

    public CallableReferenceWeigher(@NotNull CallType<?> callType) {
        Intrinsics.checkNotNullParameter(callType, (String)"callType");
        super("kotlin.callableReference");
        this.callType = callType;
    }
}

