/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.caches.project;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.Queue;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.IdeaModuleInfosKt;
import org.jetbrains.kotlin.idea.caches.project.ModuleIndex;
import org.jetbrains.kotlin.idea.caches.project.ModuleIndexCacheKt$WhenMappings;
import org.jetbrains.kotlin.idea.caches.project.ModuleSourceInfo;
import org.jetbrains.kotlin.idea.caches.project.ModuleTestSourceInfo;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u0000 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u001a\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0010\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0001*\u00020\t\u00a8\u0006\n"}, d2={"getDependents", "", "Lcom/intellij/openapi/module/Module;", "module", "getModuleIndex", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleIndex;", "project", "Lcom/intellij/openapi/project/Project;", "getDependentModules", "Lorg/jetbrains/kotlin/idea/caches/project/ModuleSourceInfo;", "kotlin.core"})
public final class ModuleIndexCacheKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<ModuleSourceInfo> getDependentModules(@NotNull ModuleSourceInfo $this$getDependentModules) {
        Set set2;
        Intrinsics.checkNotNullParameter((Object)$this$getDependentModules, (String)"$this$getDependentModules");
        Set<Module> dependents = ModuleIndexCacheKt.getDependents($this$getDependentModules.getModule());
        switch (ModuleIndexCacheKt$WhenMappings.$EnumSwitchMapping$0[IdeaModuleInfosKt.getSourceType($this$getDependentModules).ordinal()]) {
            case 1: {
                void $this$mapNotNullTo$iv;
                Iterable iterable = dependents;
                Collection destination$iv = new HashSet();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv = $this$mapNotNullTo$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv.iterator();
                while (iterator.hasNext()) {
                    ModuleTestSourceInfo moduleTestSourceInfo;
                    Object element$iv$iv;
                    Object element$iv = element$iv$iv = iterator.next();
                    boolean bl = false;
                    Module p1 = (Module)element$iv;
                    boolean bl2 = false;
                    if (IdeaModuleInfosKt.testSourceInfo(p1) == null) continue;
                    boolean bl3 = false;
                    boolean bl4 = false;
                    ModuleTestSourceInfo it$iv = moduleTestSourceInfo;
                    boolean bl5 = false;
                    destination$iv.add(it$iv);
                }
                set2 = (Set)destination$iv;
                break;
            }
            case 2: {
                void var3_5;
                void $this$flatMapTo$iv;
                Iterable $this$mapNotNullTo$iv = dependents;
                Collection destination$iv = new HashSet();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv : $this$flatMapTo$iv) {
                    Module it = (Module)element$iv;
                    boolean bl = false;
                    Iterable list$iv = IdeaModuleInfosKt.correspondingModuleInfos(it);
                    CollectionsKt.addAll((Collection)destination$iv, (Iterable)list$iv);
                }
                set2 = (Set)var3_5;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return set2;
    }

    private static final Set<Module> getDependents(Module module2) {
        THashSet result2 = new THashSet();
        result2.add((Object)module2);
        THashSet processedExporting = new THashSet();
        Project project2 = module2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"module.project");
        ModuleIndex index2 = ModuleIndexCacheKt.getModuleIndex(project2);
        Queue walkingQueue = new Queue(10);
        walkingQueue.addLast((Object)module2);
        while (!walkingQueue.isEmpty()) {
            Module current;
            Module module3 = current = (Module)walkingQueue.pullFirst();
            Intrinsics.checkNotNull((Object)module3);
            processedExporting.add((Object)module3);
            result2.addAll(index2.getPlainUsages().get((Object)current));
            for (Module dependent : index2.getExportingUsages().get((Object)current)) {
                result2.add((Object)dependent);
                if (!processedExporting.add((Object)dependent)) continue;
                walkingQueue.addLast((Object)dependent);
            }
        }
        return (Set)result2;
    }

    private static final ModuleIndex getModuleIndex(Project project2) {
        Object object = CachedValuesManager.getManager((Project)project2).getCachedValue((UserDataHolder)project2, new CachedValueProvider(project2){
            final /* synthetic */ Project $project;

            @Nullable
            public final CachedValueProvider.Result<ModuleIndex> compute() {
                ModuleIndex index2 = new ModuleIndex();
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                for (Module module2 : moduleManager.getModules()) {
                    ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
                    Intrinsics.checkNotNullExpressionValue((Object)moduleRootManager, (String)"ModuleRootManager.getInstance(module)");
                    for (OrderEntry orderEntry : moduleRootManager.getOrderEntries()) {
                        Module referenced;
                        if (!(orderEntry instanceof ModuleOrderEntry) || (referenced = ((ModuleOrderEntry)orderEntry).getModule()) == null) continue;
                        MultiMap<Module, Module> map2 = ((ModuleOrderEntry)orderEntry).isExported() ? index2.getExportingUsages() : index2.getPlainUsages();
                        map2.putValue((Object)referenced, (Object)module2);
                    }
                }
                return new CachedValueProvider.Result((Object)index2, new Object[]{ProjectRootModificationTracker.getInstance((Project)this.$project)});
            }
            {
                this.$project = project2;
            }
        });
        Intrinsics.checkNotNull((Object)object);
        return (ModuleIndex)object;
    }
}

