/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mpp.debugger;

import com.jetbrains.cidr.ArchitectureType;
import com.jetbrains.cidr.CidrPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverConfiguration;
import com.jetbrains.kotlin.commonNative.KonanHelper;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.konan.target.HostManager;
import org.jetbrains.kotlin.konan.target.KonanTarget;
import org.jetbrains.kotlin.konan.target.TargetSupportException;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0014J\u0010\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\rH\u0014J\b\u0010\u0011\u001a\u00020\u0012H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/jetbrains/mpp/debugger/GradleLLDBDriverConfiguration;", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriverConfiguration;", "lldbHome", "Ljava/io/File;", "(Ljava/io/File;)V", "framework", "", "frontend", "createDriver", "Lcom/jetbrains/cidr/execution/debugger/backend/lldb/LLDBDriver;", "handler", "Lcom/jetbrains/cidr/execution/debugger/backend/DebuggerDriver$Handler;", "architectureType", "Lcom/jetbrains/cidr/ArchitectureType;", "getLLDBFrameworkFile", "architecture", "getLLDBFrontendFile", "useSTLRenderers", "", "kotlin-ultimate.ultimate-native"})
public final class GradleLLDBDriverConfiguration
extends LLDBDriverConfiguration {
    private final String framework;
    private final String frontend;
    private final File lldbHome;

    @NotNull
    protected File getLLDBFrameworkFile(@NotNull ArchitectureType architecture) {
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        return FilesKt.resolve((File)this.lldbHome, (String)this.framework);
    }

    @NotNull
    protected File getLLDBFrontendFile(@NotNull ArchitectureType architecture) {
        Intrinsics.checkNotNullParameter((Object)architecture, (String)"architecture");
        File file2 = CidrPathManager.getBinFile(GradleLLDBDriverConfiguration.class, (String)"../out/artifacts/KotlinPlugin/bin", (String)this.frontend, null);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"CidrPathManager.getBinFi\u2026           null\n        )");
        File binaryInPlugin = file2;
        KonanTarget konanTarget = HostManager.Companion.getHost();
        if (!(Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE) || Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE))) {
            throw (Throwable)new TargetSupportException("Unsupported host target: " + HostManager.Companion.host_os() + ' ' + HostManager.Companion.host_arch(), null, 2, null);
        }
        return binaryInPlugin;
    }

    @NotNull
    public LLDBDriver createDriver(@NotNull DebuggerDriver.Handler handler, @NotNull ArchitectureType architectureType) {
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Intrinsics.checkNotNullParameter((Object)architectureType, (String)"architectureType");
        LLDBDriver lLDBDriver = super.createDriver(handler, architectureType);
        Intrinsics.checkNotNullExpressionValue((Object)lLDBDriver, (String)"super.createDriver(handler, architectureType)");
        LLDBDriver driver = lLDBDriver;
        driver.setAutorunScriptName(KonanHelper.INSTANCE.getPythonHelpersPath());
        return driver;
    }

    public boolean useSTLRenderers() {
        return false;
    }

    public GradleLLDBDriverConfiguration(@NotNull File lldbHome) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)lldbHome, (String)"lldbHome");
        this.lldbHome = lldbHome;
        KonanTarget konanTarget = HostManager.Companion.getHost();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE)) {
            string2 = "LLDB.framework";
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
            string2 = "lib/liblldb.so";
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE)) {
            string2 = "bin/liblldb.dll";
        } else {
            throw (Throwable)new TargetSupportException("Unsupported host target: " + HostManager.Companion.host_os() + ' ' + HostManager.Companion.host_arch(), null, 2, null);
        }
        this.framework = string2;
        konanTarget = HostManager.Companion.getHost();
        if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MACOS_X64.INSTANCE)) {
            string = "macos/LLDBFrontend";
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.LINUX_X64.INSTANCE)) {
            string = "linux/LLDBFrontend";
        } else if (Intrinsics.areEqual((Object)konanTarget, (Object)KonanTarget.MINGW_X64.INSTANCE)) {
            string = "windows/LLDBFrontend.exe";
        } else {
            throw (Throwable)new TargetSupportException("Unsupported host target: " + HostManager.Companion.host_os() + ' ' + HostManager.Companion.host_arch(), null, 2, null);
        }
        this.frontend = string;
    }
}

