/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.ui.LinkedValuesMapping;
import com.intellij.debugger.streams.ui.TraceContainer;
import com.intellij.debugger.streams.ui.TraceController;
import com.intellij.debugger.streams.ui.ValueWithPosition;
import com.intellij.debugger.streams.ui.ValuesPositionsListener;
import com.intellij.debugger.streams.ui.impl.CollectionTree;
import com.intellij.debugger.streams.ui.impl.CollectionView;
import com.intellij.debugger.streams.ui.impl.FlatView;
import com.intellij.debugger.streams.ui.impl.MappingPane;
import com.intellij.debugger.streams.ui.impl.PositionsAwareCollectionView;
import com.intellij.debugger.streams.ui.impl.SingleElementTree;
import com.intellij.debugger.streams.ui.impl.ValueWithPositionImpl;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.debugger.streams.wrapper.TerminatorStreamCall;
import com.intellij.debugger.streams.wrapper.TraceUtil;
import com.sun.jdi.Value;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001:\u0001\u0014B\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\nH\u0002J\u0014\u0010\u0011\u001a\u00020\u0012*\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u0004H\u0002R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/debugger/streams/ui/impl/FlatView;", "Ljavax/swing/JPanel;", "controllers", "", "Lcom/intellij/debugger/streams/ui/TraceController;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "(Ljava/util/List;Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;)V", "myPool", "", "Lcom/intellij/debugger/streams/trace/TraceElement;", "Lcom/intellij/debugger/streams/ui/impl/ValueWithPositionImpl;", "add", "Ljava/awt/Component;", "component", "getValue", "element", "resolve", "Lcom/intellij/debugger/streams/ui/impl/FlatView$LinkedValuesWithPositions;", "nextController", "LinkedValuesWithPositions", "intellij.java.debugger.streams"})
public class FlatView
extends JPanel {
    private final Map<TraceElement, ValueWithPositionImpl> myPool;

    @Override
    @NotNull
    public final Component add(@NotNull Component component) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Component component2 = super.add(component);
        Intrinsics.checkNotNullExpressionValue((Object)component2, (String)"super.add(component)");
        return component2;
    }

    private final ValueWithPositionImpl getValue(TraceElement element) {
        Object object = getValue.1.INSTANCE;
        if (object != null) {
            Function1 function1 = object;
            object = new Function(function1){
                private final /* synthetic */ Function1 function;
                {
                    this.function = function1;
                }

                public final /* synthetic */ Object apply(Object p0) {
                    return this.function.invoke(p0);
                }
            };
        }
        ValueWithPositionImpl valueWithPositionImpl = this.myPool.computeIfAbsent(element, (Function)object);
        Intrinsics.checkNotNullExpressionValue((Object)valueWithPositionImpl, (String)"myPool.computeIfAbsent(e\u2026 ::ValueWithPositionImpl)");
        return valueWithPositionImpl;
    }

    /*
     * WARNING - void declaration
     */
    private final LinkedValuesWithPositions resolve(TraceController $this$resolve, TraceController nextController) {
        Collection<ValueWithPositionImpl> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        TraceElement nextElement;
        boolean bl = false;
        List prevValues = new ArrayList();
        boolean bl2 = false;
        Map mapping = new LinkedHashMap();
        Iterator<TraceElement> iterator = $this$resolve.getTrace().iterator();
        while (iterator.hasNext()) {
            TraceElement element;
            TraceElement traceElement = element = iterator.next();
            Intrinsics.checkNotNullExpressionValue((Object)traceElement, (String)"element");
            ValueWithPositionImpl prevValue = this.getValue(traceElement);
            Collection collection2 = prevValues;
            boolean bl3 = false;
            collection2.add(prevValue);
            Iterator<TraceElement> iterator2 = $this$resolve.getNextValues(element).iterator();
            while (iterator2.hasNext()) {
                TraceElement traceElement2 = nextElement = iterator2.next();
                Intrinsics.checkNotNullExpressionValue((Object)traceElement2, (String)"nextElement");
                ValueWithPositionImpl nextValue = this.getValue(traceElement2);
                Object object = (Set)mapping.computeIfAbsent(prevValue, resolve.1.INSTANCE);
                boolean bl4 = false;
                object.add(nextValue);
                object = (Set)mapping.computeIfAbsent(nextValue, resolve.2.INSTANCE);
                bl4 = false;
                object.add(prevValue);
            }
        }
        boolean bl5 = false;
        Map resultMapping = new LinkedHashMap();
        for (ValueWithPositionImpl key : mapping.keySet()) {
            Object v = mapping.get(key);
            Intrinsics.checkNotNull(v);
            resultMapping.put(key, CollectionsKt.toList((Iterable)((Iterable)v)));
        }
        List<TraceElement> list2 = nextController.getTrace();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"nextController.trace");
        Iterable key = list2;
        List list3 = prevValues;
        boolean $i$f$map = false;
        nextElement = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            TraceElement traceElement = (TraceElement)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl6 = false;
            void v4 = it;
            Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"it");
            ValueWithPositionImpl valueWithPositionImpl = this.getValue((TraceElement)v4);
            collection.add(valueWithPositionImpl);
        }
        collection = (List)destination$iv$iv;
        LinkedValuesMapping linkedValuesMapping = new LinkedValuesMapping(resultMapping){
            final /* synthetic */ Map $resultMapping;

            @Nullable
            public List<ValueWithPosition> getLinkedValues(@NotNull ValueWithPosition value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                return (List)this.$resultMapping.get(value);
            }
            {
                this.$resultMapping = $captured_local_variable$0;
            }
        };
        List list4 = collection;
        List list5 = list3;
        return new LinkedValuesWithPositions(list5, list4, linkedValuesMapping);
    }

    /*
     * WARNING - void declaration
     */
    public FlatView(@NotNull List<? extends TraceController> controllers, @NotNull EvaluationContextImpl evaluationContext) {
        void prevMappingPane;
        Object view;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(controllers, (String)"controllers");
        Intrinsics.checkNotNullParameter((Object)evaluationContext, (String)"evaluationContext");
        super(new GridLayout(1, 2 * controllers.size() - 1));
        boolean bl = false;
        this.myPool = new LinkedHashMap();
        Collection collection = controllers;
        boolean bl2 = false;
        boolean bl3 = !collection.isEmpty();
        bl2 = false;
        boolean bl4 = false;
        if (_Assertions.ENABLED && !bl3) {
            boolean bl5 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = null;
        List lastValues = null;
        bl4 = false;
        for (TraceController controller : (Iterable)controllers.subList(0, controllers.size() - 1)) {
            void valuesAfter;
            Collection<TraceElement> collection2;
            void $this$mapTo$iv$iv;
            void valuesBefore;
            StreamCall nextCall;
            void index;
            LinkedValuesWithPositions linkedValuesWithPositions = this.resolve(controller, controllers.get((int)(index + true)));
            List<ValueWithPositionImpl> list2 = linkedValuesWithPositions.component1();
            List<ValueWithPositionImpl> list3 = linkedValuesWithPositions.component2();
            LinkedValuesMapping mapping = linkedValuesWithPositions.component3();
            if (controller.getNextCall() == null) {
                String string = "intermediate state should know about next call";
                boolean bl6 = false;
                throw (Throwable)new IllegalStateException(string.toString());
            }
            Intrinsics.checkNotNullExpressionValue((Object)nextCall, (String)"controller.nextCall ?: e\u2026ld know about next call\")");
            String string = nextCall.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextCall.name");
            String string2 = TraceUtil.formatWithArguments(nextCall);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TraceUtil.formatWithArguments(nextCall)");
            final MappingPane mappingPane = new MappingPane(string, string2, (List<? extends ValueWithPosition>)valuesBefore, mapping, controller);
            Iterable iterable = (Iterable)valuesBefore;
            List<Value> list4 = controller.getValues();
            boolean $i$f$map = false;
            void var16_34 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ValueWithPositionImpl valueWithPositionImpl = (ValueWithPositionImpl)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl7 = false;
                TraceElement traceElement = it.getTraceElement();
                collection2.add(traceElement);
            }
            collection2 = (List)destination$iv$iv;
            EvaluationContextImpl evaluationContextImpl = evaluationContext;
            List list5 = collection2;
            List<Value> list6 = list4;
            CollectionTree tree = new CollectionTree(list6, list5, evaluationContextImpl);
            view = new PositionsAwareCollectionView(tree, (List<ValueWithPositionImpl>)valuesBefore);
            controller.register((TraceContainer)view);
            ((PositionsAwareCollectionView)view).addValuesPositionsListener(new ValuesPositionsListener(){

                @Override
                public void valuesPositionsChanged() {
                    mappingPane.repaint();
                }
            });
            final MappingPane prevMapping = (MappingPane)prevMappingPane.element;
            if (prevMapping != null) {
                ((PositionsAwareCollectionView)view).addValuesPositionsListener(new ValuesPositionsListener(){

                    @Override
                    public void valuesPositionsChanged() {
                        prevMapping.repaint();
                    }
                });
                prevMapping.addMouseWheelListener(new MouseWheelListener((PositionsAwareCollectionView)view){
                    final /* synthetic */ PositionsAwareCollectionView $view;

                    @Override
                    public final void mouseWheelMoved(MouseWheelEvent e) {
                        this.$view.getInstancesTree().dispatchEvent(e);
                    }
                    {
                        this.$view = positionsAwareCollectionView;
                    }
                });
            }
            mappingPane.addMouseWheelListener(new MouseWheelListener((PositionsAwareCollectionView)view){
                final /* synthetic */ PositionsAwareCollectionView $view;

                @Override
                public final void mouseWheelMoved(MouseWheelEvent e) {
                    this.$view.getInstancesTree().dispatchEvent(e);
                }
                {
                    this.$view = positionsAwareCollectionView;
                }
            });
            this.add((Component)view);
            this.add(mappingPane);
            prevMappingPane.element = mappingPane;
            lastValues = valuesAfter;
            ++index;
        }
        List list7 = lastValues;
        if (list7 != null) {
            CollectionTree collectionTree;
            TraceElement traceElement;
            Collection<TraceElement> collection3;
            ValueWithPositionImpl item$iv$iv;
            Object object;
            List<Value> values;
            List index = list7;
            boolean controller = false;
            boolean bl8 = false;
            List it = index;
            boolean bl9 = false;
            TraceController lastController = (TraceController)CollectionsKt.last(controllers);
            StreamCall prevCall = lastController.getPrevCall();
            CollectionTree tree = null;
            if (prevCall != null && prevCall instanceof TerminatorStreamCall) {
                void $this$mapTo$iv$iv;
                List<Value> list8 = lastController.getValues();
                Intrinsics.checkNotNullExpressionValue(list8, (String)"lastController.values");
                values = list8;
                view = it;
                object = (Value)CollectionsKt.first(values);
                boolean $i$f$map2 = false;
                Iterator iterator = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                Iterator bl7 = $this$mapTo$iv$iv.iterator();
                while (bl7.hasNext()) {
                    void it2;
                    ValueWithPositionImpl valueWithPositionImpl = item$iv$iv = bl7.next();
                    collection3 = destination$iv$iv;
                    boolean bl10 = false;
                    traceElement = it2.getTraceElement();
                    collection3.add(traceElement);
                }
                collection3 = (List)destination$iv$iv;
                EvaluationContextImpl evaluationContextImpl = evaluationContext;
                Collection<TraceElement> collection4 = collection3;
                Object object2 = object;
                collectionTree = new SingleElementTree((Value)object2, (List<TraceElement>)collection4, evaluationContextImpl);
            } else {
                void $this$mapTo$iv$iv;
                void $this$map$iv2;
                values = it;
                object = lastController.getValues();
                boolean $i$f$map = false;
                void $i$f$map2 = $this$map$iv2;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv) {
                    void it3;
                    item$iv$iv = (ValueWithPositionImpl)item$iv$iv2;
                    collection3 = destination$iv$iv;
                    boolean bl11 = false;
                    traceElement = it3.getTraceElement();
                    collection3.add(traceElement);
                }
                collection3 = (List)destination$iv$iv;
                EvaluationContextImpl evaluationContextImpl = evaluationContext;
                List list9 = collection3;
                Object object3 = object;
                collectionTree = new CollectionTree((List<Value>)object3, list9, evaluationContextImpl);
            }
            tree = collectionTree;
            PositionsAwareCollectionView view2 = new PositionsAwareCollectionView(tree, it);
            lastController.register(view2);
            view2.addValuesPositionsListener(new ValuesPositionsListener(this, controllers, evaluationContext, (Ref.ObjectRef)prevMappingPane){
                final /* synthetic */ FlatView this$0;
                final /* synthetic */ List $controllers$inlined;
                final /* synthetic */ EvaluationContextImpl $evaluationContext$inlined;
                final /* synthetic */ Ref.ObjectRef $prevMappingPane$inlined;
                {
                    this.this$0 = flatView;
                    this.$controllers$inlined = list2;
                    this.$evaluationContext$inlined = evaluationContextImpl;
                    this.$prevMappingPane$inlined = objectRef;
                }

                public void valuesPositionsChanged() {
                    block0: {
                        MappingPane mappingPane = (MappingPane)this.$prevMappingPane$inlined.element;
                        if (mappingPane == null) break block0;
                        mappingPane.repaint();
                    }
                }
            });
            MappingPane mappingPane = (MappingPane)prevMappingPane.element;
            if (mappingPane != null) {
                MappingPane mappingPane2 = mappingPane;
                boolean bl12 = false;
                boolean bl13 = false;
                MappingPane it4 = mappingPane2;
                boolean bl14 = false;
                it4.addMouseWheelListener(new MouseWheelListener(view2){
                    final /* synthetic */ PositionsAwareCollectionView $view$inlined;
                    {
                        this.$view$inlined = positionsAwareCollectionView;
                    }

                    public final void mouseWheelMoved(MouseWheelEvent e) {
                        this.$view$inlined.getInstancesTree().dispatchEvent(e);
                    }
                });
            }
            this.add(view2);
        }
        if (controllers.size() == 1) {
            TraceController controller = controllers.get(0);
            CollectionTree tree = new CollectionTree(controller.getValues(), controller.getTrace(), evaluationContext);
            CollectionView view3 = new CollectionView(tree);
            this.add(view3);
            controller.register(view3);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u000f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0007H\u00c6\u0003J3\u0010\u0011\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u000e\b\u0002\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0019"}, d2={"Lcom/intellij/debugger/streams/ui/impl/FlatView$LinkedValuesWithPositions;", "", "valuesBefore", "", "Lcom/intellij/debugger/streams/ui/impl/ValueWithPositionImpl;", "valuesAfter", "mapping", "Lcom/intellij/debugger/streams/ui/LinkedValuesMapping;", "(Ljava/util/List;Ljava/util/List;Lcom/intellij/debugger/streams/ui/LinkedValuesMapping;)V", "getMapping", "()Lcom/intellij/debugger/streams/ui/LinkedValuesMapping;", "getValuesAfter", "()Ljava/util/List;", "getValuesBefore", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.java.debugger.streams"})
    private static final class LinkedValuesWithPositions {
        @NotNull
        private final List<ValueWithPositionImpl> valuesBefore;
        @NotNull
        private final List<ValueWithPositionImpl> valuesAfter;
        @NotNull
        private final LinkedValuesMapping mapping;

        @NotNull
        public final List<ValueWithPositionImpl> getValuesBefore() {
            return this.valuesBefore;
        }

        @NotNull
        public final List<ValueWithPositionImpl> getValuesAfter() {
            return this.valuesAfter;
        }

        @NotNull
        public final LinkedValuesMapping getMapping() {
            return this.mapping;
        }

        public LinkedValuesWithPositions(@NotNull List<ValueWithPositionImpl> valuesBefore, @NotNull List<ValueWithPositionImpl> valuesAfter, @NotNull LinkedValuesMapping mapping) {
            Intrinsics.checkNotNullParameter(valuesBefore, (String)"valuesBefore");
            Intrinsics.checkNotNullParameter(valuesAfter, (String)"valuesAfter");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            this.valuesBefore = valuesBefore;
            this.valuesAfter = valuesAfter;
            this.mapping = mapping;
        }

        @NotNull
        public final List<ValueWithPositionImpl> component1() {
            return this.valuesBefore;
        }

        @NotNull
        public final List<ValueWithPositionImpl> component2() {
            return this.valuesAfter;
        }

        @NotNull
        public final LinkedValuesMapping component3() {
            return this.mapping;
        }

        @NotNull
        public final LinkedValuesWithPositions copy(@NotNull List<ValueWithPositionImpl> valuesBefore, @NotNull List<ValueWithPositionImpl> valuesAfter, @NotNull LinkedValuesMapping mapping) {
            Intrinsics.checkNotNullParameter(valuesBefore, (String)"valuesBefore");
            Intrinsics.checkNotNullParameter(valuesAfter, (String)"valuesAfter");
            Intrinsics.checkNotNullParameter((Object)mapping, (String)"mapping");
            return new LinkedValuesWithPositions(valuesBefore, valuesAfter, mapping);
        }

        public static /* synthetic */ LinkedValuesWithPositions copy$default(LinkedValuesWithPositions linkedValuesWithPositions, List list2, List list3, LinkedValuesMapping linkedValuesMapping, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = linkedValuesWithPositions.valuesBefore;
            }
            if ((n & 2) != 0) {
                list3 = linkedValuesWithPositions.valuesAfter;
            }
            if ((n & 4) != 0) {
                linkedValuesMapping = linkedValuesWithPositions.mapping;
            }
            return linkedValuesWithPositions.copy(list2, list3, linkedValuesMapping);
        }

        @NotNull
        public String toString() {
            return "LinkedValuesWithPositions(valuesBefore=" + this.valuesBefore + ", valuesAfter=" + this.valuesAfter + ", mapping=" + this.mapping + ")";
        }

        public int hashCode() {
            List<ValueWithPositionImpl> list2 = this.valuesBefore;
            List<ValueWithPositionImpl> list3 = this.valuesAfter;
            LinkedValuesMapping linkedValuesMapping = this.mapping;
            return ((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0)) * 31 + (linkedValuesMapping != null ? linkedValuesMapping.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LinkedValuesWithPositions)) break block3;
                    LinkedValuesWithPositions linkedValuesWithPositions = (LinkedValuesWithPositions)object;
                    if (!Intrinsics.areEqual(this.valuesBefore, linkedValuesWithPositions.valuesBefore) || !Intrinsics.areEqual(this.valuesAfter, linkedValuesWithPositions.valuesAfter) || !Intrinsics.areEqual((Object)this.mapping, (Object)linkedValuesWithPositions.mapping)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

